/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.diff;

import java.io.File;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.modules.versioning.system.cvss.CvsFileNode;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.ResolveConflictsExecutor;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ResolveConflictsAction
extends AbstractSystemAction {
    public ResolveConflictsAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_ResolveConflicts";
    }

    protected boolean enable(Node[] nodes) {
        return CvsVersioningSystem.getInstance().getFileTableModel(Utils.getCurrentContext(nodes), 64).getNodes().length > 0;
    }

    public void performCvsAction(Node[] nodes) {
        CvsFileNode[] fileNodes = CvsVersioningSystem.getInstance().getFileTableModel(this.getContext(nodes), 64).getNodes();
        if (fileNodes.length == 0) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)ResolveConflictsAction.class, (String)"MSG_NoConflicts")));
            return;
        }
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        for (int i = 0; i < fileNodes.length; ++i) {
            File file = fileNodes[i].getFile();
            FileInformation info = cache.getStatus(file);
            Entry entry = info.getEntry(file);
            if (entry == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$actions$diff$ResolveConflictsAction == null ? ResolveConflictsAction.class$("org.netbeans.modules.versioning.system.cvss.ui.actions.diff.ResolveConflictsAction") : class$org$netbeans$modules$versioning$system$cvss$ui$actions$diff$ResolveConflictsAction), (String)"MSG_MoveAwayLocalFileConflict", (Object)file.getName())));
                continue;
            }
            ResolveConflictsExecutor rce = new ResolveConflictsExecutor();
            rce.exec(file);
        }
    }

    protected boolean asynchronous() {
        return false;
    }
}

