/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class XMLUtil {
    private static final ThreadLocal[] builderTL = new ThreadLocal[4];

    XMLUtil() {
    }

    public static Document parse(InputSource input, boolean validate, boolean namespaceAware, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException {
        int index = (validate ? 0 : 1) + (namespaceAware ? 0 : 2);
        DocumentBuilder builder = (DocumentBuilder)builderTL[index].get();
        if (builder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validate);
            factory.setNamespaceAware(namespaceAware);
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                throw new SAXException(ex);
            }
            builderTL[index].set(builder);
        }
        if (errorHandler != null) {
            builder.setErrorHandler(errorHandler);
        }
        if (entityResolver != null) {
            builder.setEntityResolver(entityResolver);
        }
        return builder.parse(input);
    }

    public static Document createDocument(String rootQName) throws DOMException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            return factory.newDocumentBuilder().getDOMImplementation().createDocument(null, rootQName, null);
        }
        catch (ParserConfigurationException ex) {
            throw (DOMException)new DOMException(9, "Cannot create parser").initCause(ex);
        }
    }

    private static DOMImplementation getDOMImplementation() throws DOMException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            return factory.newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException ex) {
            throw (DOMException)new DOMException(9, "Cannot create parser").initCause(ex);
        }
    }

    public static void write(Document doc, OutputStream out) throws IOException {
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            DocumentType dt = doc.getDoctype();
            if (dt != null) {
                String pub = dt.getPublicId();
                if (pub != null) {
                    t.setOutputProperty("doctype-public", pub);
                }
                t.setOutputProperty("doctype-system", dt.getSystemId());
            }
            t.setOutputProperty("encoding", "UTF-8");
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(out);
            t.transform(source, result);
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.toString()).initCause(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw (IOException)new IOException(e.toString()).initCause(e);
        }
    }

    public static Element findElement(Element parent, String name, String namespace) {
        Element result = null;
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (l.item(i).getNodeType() != 1) continue;
            Element el = (Element)l.item(i);
            if ((namespace != null || !name.equals(el.getTagName())) && (namespace == null || !name.equals(el.getLocalName()) || !namespace.equals(el.getNamespaceURI()))) continue;
            if (result == null) {
                result = el;
                continue;
            }
            return null;
        }
        return result;
    }

    static String findText(Element parent) {
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (l.item(i).getNodeType() != 3) continue;
            Text text = (Text)l.item(i);
            return text.getNodeValue();
        }
        return null;
    }

    static List findSubElements(Element parent) throws IllegalArgumentException {
        NodeList l = parent.getChildNodes();
        ArrayList<Element> elements = new ArrayList<Element>(l.getLength());
        for (int i = 0; i < l.getLength(); ++i) {
            Node n = l.item(i);
            if (n.getNodeType() == 1) {
                elements.add((Element)n);
                continue;
            }
            if (n.getNodeType() == 3) {
                String text = ((Text)n).getNodeValue();
                if (text.trim().length() <= 0) continue;
                throw new IllegalArgumentException("non-ws text encountered in " + parent + ": " + text);
            }
            if (n.getNodeType() == 8) continue;
            throw new IllegalArgumentException("unexpected non-element child of " + parent + ": " + n);
        }
        return elements;
    }

    static {
        for (int i = 0; i < 4; ++i) {
            XMLUtil.builderTL[i] = new ThreadLocal();
        }
    }
}

