/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.XpathEvent;
import javax.enterprise.deploy.model.XpathListener;
import javax.enterprise.deploy.shared.ModuleType;
import org.netbeans.modules.j2ee.deployment.config.DDCommon;
import org.netbeans.modules.j2ee.deployment.config.DDLeafBean;
import org.netbeans.modules.j2ee.deployment.config.DDNodeBean;
import org.netbeans.modules.j2ee.deployment.config.DDProxy;
import org.netbeans.modules.j2ee.deployment.config.DDRoot;
import org.netbeans.modules.j2ee.deployment.config.DeployableObjectImpl;
import org.netbeans.modules.j2ee.deployment.config.StandardDDImpl;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BaseProperty;
import org.netbeans.modules.schema2beans.Bean;
import org.netbeans.modules.schema2beans.GraphManager;
import org.openide.ErrorManager;
import org.openide.util.WeakListeners;

public class ModuleDeploymentSupport
implements PropertyChangeListener {
    public static final String SEPARATOR = "/";
    public static final String WEBSERVICES_XML = "webservices.xml";
    private static Map filenameToPathMap = null;
    private final DeployableObjectImpl obj;
    private final Map rootMap = Collections.synchronizedMap(new HashMap(5));
    private final Map beanMap = Collections.synchronizedMap(new IdentityHashMap());
    private final Map leafMap = Collections.synchronizedMap(new IdentityHashMap());
    private final Set xpathListeners = Collections.synchronizedSet(new HashSet());
    private final Map<DDRoot, PropertyChangeListener> propertyChangeListeners = Collections.synchronizedMap(new WeakHashMap());
    private final J2eeModuleProvider provider;
    private final boolean sendEvent;
    private static Map moduleDDlocationMap = new HashMap(10);

    public static String[] getDDPaths(Object type) {
        return (String[])moduleDDlocationMap.get(type);
    }

    public ModuleDeploymentSupport(J2eeModuleProvider provider, boolean sendEvent) {
        this.provider = provider;
        this.sendEvent = sendEvent;
        this.obj = new DeployableObjectImpl(this);
        String[] ddLocs = ModuleDeploymentSupport.getDDPaths(provider.getJ2eeModule().getModuleType());
        for (int i = 0; i < ddLocs.length; ++i) {
            this.createRoot(ddLocs[i]);
        }
    }

    private ModuleType getModuleType() {
        return (ModuleType)this.provider.getJ2eeModule().getModuleType();
    }

    private BaseBean getDeploymentDescriptor(String ddLoc) {
        return this.provider.getJ2eeModule().getDeploymentDescriptor(ddLoc);
    }

    private DDRoot createRoot(String ddLoc) {
        BaseBean bean = this.getDeploymentDescriptor(ddLoc);
        if (bean == null) {
            return null;
        }
        while (!bean.isRoot()) {
            bean = bean.parent();
        }
        DDRoot root = new DDRoot(new DDNodeBean(null, bean, this));
        this.rootMap.put(ddLoc, root);
        this.beanMap.put(bean, root);
        PropertyChangeListener weakListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)root.proxy.bean);
        this.propertyChangeListeners.put(root, weakListener);
        root.proxy.bean.addPropertyChangeListener(weakListener);
        return root;
    }

    public DeployableObjectImpl getDeployableObject() {
        return this.obj;
    }

    public DDRoot getDDBeanRoot() {
        String loc = ((String[])moduleDDlocationMap.get(this.getModuleType()))[0];
        return this.getDDBeanRoot(loc);
    }

    public DDRoot getDDBeanRoot(String loc) {
        DDRoot root = (DDRoot)this.rootMap.get(loc);
        if (root == null && !ModuleDeploymentSupport.isPrimaryDD(loc, this.getType())) {
            root = this.createRoot(loc);
            DDRoot dDRoot = this.getPrimaryDD();
        }
        return root;
    }

    public ModuleType getType() {
        return this.getModuleType();
    }

    public String getVersion() {
        return this.provider.getJ2eeModule().getModuleVersion();
    }

    public Class getClassFromScope(String cls) {
        return null;
    }

    public static boolean isPrimaryDD(String ddLocation, Object type) {
        String[] ddLocs = (String[])moduleDDlocationMap.get(type);
        if (ddLocs.length < 1) {
            return false;
        }
        return ddLocs[0].equals(ddLocation);
    }

    private static Map filenameToPathMap() {
        if (filenameToPathMap == null) {
            filenameToPathMap = new HashMap();
            filenameToPathMap.put(ModuleDeploymentSupport.filename("META-INF/application.xml"), "META-INF/application.xml");
            filenameToPathMap.put(ModuleDeploymentSupport.filename("WEB-INF/web.xml"), "WEB-INF/web.xml");
            filenameToPathMap.put(ModuleDeploymentSupport.filename("META-INF/ejb-jar.xml"), "META-INF/ejb-jar.xml");
            filenameToPathMap.put(ModuleDeploymentSupport.filename("META-INF/ra.xml"), "META-INF/ra.xml");
            filenameToPathMap.put(ModuleDeploymentSupport.filename("META-INF/application-client.xml"), "META-INF/application-client.xml");
            filenameToPathMap.put("META-INF/application.xml", "META-INF/application.xml");
            filenameToPathMap.put("WEB-INF/web.xml", "WEB-INF/web.xml");
            filenameToPathMap.put("META-INF/ejb-jar.xml", "META-INF/ejb-jar.xml");
            filenameToPathMap.put("META-INF/ra.xml", "META-INF/ra.xml");
            filenameToPathMap.put("META-INF/application-client.xml", "META-INF/application-client.xml");
        }
        return filenameToPathMap;
    }

    private static String filename(String path) {
        int i = path.lastIndexOf(SEPARATOR);
        return path.substring(i + 1);
    }

    public static String filenameToPath(String filename, Object type) {
        if (filename.endsWith(WEBSERVICES_XML)) {
            if (J2eeModule.EJB.equals(type)) {
                return "META-INF/webservices.xml";
            }
            return "WEB-INF/webservices.xml";
        }
        String name = (String)ModuleDeploymentSupport.filenameToPathMap().get(filename);
        if (name == null) {
            name = filename;
        }
        return name;
    }

    public DDRoot getPrimaryDD() {
        ModuleType type = this.getType();
        String[] ddLocs = (String[])moduleDDlocationMap.get(type);
        if (ddLocs.length < 1) {
            return null;
        }
        return (DDRoot)this.rootMap.get(ddLocs[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        DDRoot[] roots;
        Map map = this.rootMap;
        synchronized (map) {
            roots = this.rootMap.values().toArray(new DDRoot[this.rootMap.size()]);
        }
        for (DDRoot root : roots) {
            PropertyChangeListener listener = this.propertyChangeListeners.get(root);
            if (listener == null) continue;
            root.proxy.bean.removePropertyChangeListener(listener);
        }
    }

    StandardDDImpl getBean(BaseBean bean) {
        if (bean == null) {
            return null;
        }
        StandardDDImpl ret = (StandardDDImpl)this.beanMap.get(bean);
        if (ret == null && bean.parent() != null) {
            ret = new StandardDDImpl(new DDNodeBean(bean, this));
            this.beanMap.put(bean, ret);
        }
        return ret;
    }

    StandardDDImpl getBean(BaseProperty prop, int index) {
        if (index < 0) {
            return this.getBean(prop);
        }
        if (!this.leafMap.containsKey(prop)) {
            this.leafMap.put(prop, new StandardDDImpl[index + 1]);
        } else if (((StandardDDImpl[])this.leafMap.get(prop)).length <= index) {
            StandardDDImpl[] a = (StandardDDImpl[])this.leafMap.get(prop);
            StandardDDImpl[] b = new StandardDDImpl[index + 1];
            this.leafMap.put(prop, b);
            for (int i = 0; i < a.length; ++i) {
                b[i] = a[i];
            }
        }
        StandardDDImpl[] arr = (StandardDDImpl[])this.leafMap.get(prop);
        StandardDDImpl elem = arr[index];
        if (elem == null) {
            arr[index] = elem = new StandardDDImpl(new DDLeafBean(prop, index, this));
        }
        return elem;
    }

    StandardDDImpl getBean(BaseProperty prop) {
        StandardDDImpl elem = (StandardDDImpl)this.leafMap.get(prop);
        if (elem == null) {
            elem = new StandardDDImpl(new DDLeafBean(prop, this));
            this.leafMap.put(prop, elem);
        }
        return elem;
    }

    StandardDDImpl getBean(String name) {
        return this.getBean(name, this.getDDBeanRoot().proxy.bean);
    }

    StandardDDImpl getBean(String name, BaseBean rootBean) {
        Bean parent = GraphManager.getPropertyParent((Bean)rootBean, (String)name);
        if (parent == null) {
            return this.getDDBeanRoot();
        }
        String shortName = GraphManager.getPropertyName((String)name);
        int index = GraphManager.getPropertyIndex((Bean)rootBean, (String)name);
        BaseProperty prop = parent.getProperty(shortName);
        if (index < 0 && prop.isIndexed()) {
            index = 0;
        }
        StandardDDImpl ret = prop.isBean() ? (prop.isIndexed() ? this.getBean((BaseBean)parent.getValue(shortName, index)) : this.getBean((BaseBean)parent.getValue(shortName))) : (prop.isIndexed() ? this.getBean(prop, index) : this.getBean(prop));
        return ret;
    }

    void addXpathListener(DDCommon bean, String xpath, XpathListener listen) {
        if (this.sendEvent) {
            this.xpathListeners.add(new XpathListenerStorage(bean, xpath, listen));
        }
    }

    void removeXpathListener(DDCommon bean, String xpath, XpathListener listen) {
        if (this.sendEvent) {
            this.xpathListeners.remove(new XpathListenerStorage(bean, xpath, listen));
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        String name = event.getPropertyName();
        try {
            StandardDDImpl eventBean = null;
            if (newValue == null && oldValue instanceof BaseBean) {
                eventBean = this.getBean((BaseBean)oldValue);
            } else {
                Object eventObj;
                Object object = eventObj = oldValue != null ? oldValue : newValue;
                if (!(eventObj instanceof BaseBean)) {
                    eventObj = event.getSource();
                }
                if (eventObj instanceof BaseBean) {
                    BaseBean root = (BaseBean)eventObj;
                    while (!root.isRoot()) {
                        root = root.parent();
                    }
                    boolean rootInCache = false;
                    for (DDRoot ddroot : this.rootMap.values()) {
                        if (ddroot.proxy == null || ddroot.proxy.bean != root) continue;
                        rootInCache = true;
                        break;
                    }
                    if (rootInCache) {
                        eventBean = this.getBean(name, root);
                    }
                }
                if (eventBean == null) {
                    eventBean = this.getBean(name);
                }
            }
            if (eventBean == null && oldValue instanceof Object[]) {
                Object value;
                int i;
                ArrayList<Object> newElements = new ArrayList<Object>();
                if (newValue != null) {
                    Object[] newValues = (Object[])newValue;
                    for (i = 0; i < newValues.length; ++i) {
                        if (newValues[i] == null) continue;
                        newElements.add(newValues[i]);
                    }
                }
                Object[] values = (Object[])oldValue;
                for (i = 0; i < values.length && (value = values[i]) instanceof BaseBean; ++i) {
                    if (newElements.contains(value)) {
                        newElements.remove(value);
                        continue;
                    }
                    StandardDDImpl valueBean = this.getBean((BaseBean)value);
                    if (valueBean == null) continue;
                    this.processEvent(value, null, valueBean.proxy, event);
                }
            }
            if (eventBean == null) {
                return;
            }
            if (oldValue == null && eventBean.proxy.isProxy()) {
                eventBean.setProxy(new DDNodeBean((DDProxy)eventBean.proxy));
                return;
            }
            this.processEvent(oldValue, newValue, eventBean.proxy, event);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    void processEvent(Object oldValue, Object newValue, DDCommon eventBean, PropertyChangeEvent event) {
        String eventDtdPath = eventBean.getXpath();
        Object type = XpathEvent.BEAN_CHANGED;
        if (oldValue == null) {
            type = XpathEvent.BEAN_ADDED;
        }
        if (newValue == null) {
            type = XpathEvent.BEAN_REMOVED;
        }
        XpathEvent xe = new XpathEvent((DDBean)eventBean.container, type);
        xe.setChangeEvent(event);
        Object[] xpathListenerArray = this.xpathListeners.toArray();
        for (int i = 0; i < xpathListenerArray.length; ++i) {
            DDCommon rightBean;
            DDCommon leftBean;
            XpathListenerStorage x = (XpathListenerStorage)xpathListenerArray[i];
            if (x.bean == null) continue;
            String xp = x.getNormalizedPath();
            if (eventDtdPath.startsWith(xp)) {
                leftBean = x.bean;
                rightBean = eventBean;
            } else {
                if (!xp.startsWith(eventDtdPath)) continue;
                leftBean = eventBean;
                rightBean = x.bean;
            }
            while (leftBean != rightBean && rightBean != null) {
                rightBean = rightBean.parent;
            }
            if (leftBean != rightBean) continue;
            x.listen.fireXpathEvent(xe);
        }
    }

    static String normalizePath(String path) {
        boolean absolute = path.startsWith(SEPARATOR);
        StringTokenizer tokens = new StringTokenizer(path, SEPARATOR, false);
        LinkedList<Object> l = new LinkedList<Object>();
        while (tokens.hasMoreElements()) {
            l.addLast(tokens.nextElement());
        }
        int i = 0;
        while (i < l.size()) {
            String tok = (String)l.get(i);
            if (tok.equals(".")) {
                l.remove(i);
                continue;
            }
            if (tok.equals("..") && i > 0 && !l.get(i - 1).equals("..")) {
                l.remove(i);
                l.remove(i - 1);
                --i;
                continue;
            }
            ++i;
        }
        StringBuffer ret = new StringBuffer();
        for (int i2 = 0; i2 < l.size(); ++i2) {
            if (absolute || i2 > 0) {
                ret.append(SEPARATOR);
            }
            ret.append(l.get(i2));
        }
        return ret.toString();
    }

    public J2eeModuleProvider getProvider() {
        return this.provider;
    }

    static {
        moduleDDlocationMap.put(J2eeModule.EAR, new String[]{"META-INF/application.xml"});
        moduleDDlocationMap.put(J2eeModule.WAR, new String[]{"WEB-INF/web.xml", "WEB-INF/webservices.xml"});
        moduleDDlocationMap.put(J2eeModule.EJB, new String[]{"META-INF/ejb-jar.xml", "META-INF/webservices.xml"});
        moduleDDlocationMap.put(J2eeModule.CONN, new String[]{"META-INF/ra.xml"});
        moduleDDlocationMap.put(J2eeModule.CLIENT, new String[]{"META-INF/application-client.xml"});
    }

    private class XpathListenerStorage {
        private DDCommon bean = null;
        private String xpath;
        private boolean xpathRelative;
        private XpathListener listen;
        private String normal = null;

        XpathListenerStorage(DDCommon bean, String xpath, XpathListener listen) {
            this.bean = bean;
            this.xpath = xpath;
            this.listen = listen;
            this.xpathRelative = !xpath.startsWith(ModuleDeploymentSupport.SEPARATOR);
        }

        public String getNormalizedPath() {
            if (this.normal == null) {
                String base = this.xpath;
                if (this.xpathRelative) {
                    base = this.bean.getXpath() + ModuleDeploymentSupport.SEPARATOR + base;
                }
                this.normal = ModuleDeploymentSupport.normalizePath(base);
            }
            return this.normal;
        }

        public String toString() {
            return this.bean + " " + this.xpath + " " + this.listen;
        }

        public int hashCode() {
            return this.listen.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof XpathListenerStorage) {
                XpathListenerStorage x = (XpathListenerStorage)o;
                return x.bean == this.bean && x.xpath == this.xpath && x.listen == this.listen;
            }
            return false;
        }
    }
}

