/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.devmodules.api;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.plugins.api.J2eePlatformImpl;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class J2eePlatform {
    public static final String PROP_DISPLAY_NAME = "displayName";
    public static final String PROP_LIBRARIES = "libraries";
    public static final String PROP_CLASSPATH = "classpath";
    public static final String PROP_PLATFORM_ROOTS = "platformRoots";
    public static final String TOOL_APP_CLIENT_RUNTIME = "appClientRuntime";
    public static final String TOOL_JSR109 = "jsr109";
    public static final String TOOL_WSCOMPILE = "wscompile";
    public static final String TOOL_WSIMPORT = "wsimport";
    public static final String TOOL_WSGEN = "wsgen";
    public static final String TOOL_WSIT = "wsit";
    public static final String TOOL_JWSDP = "jwsdp";
    public static final String TOOL_KEYSTORE = "keystore";
    public static final String TOOL_KEYSTORE_CLIENT = "keystoreClient";
    public static final String TOOL_TRUSTSTORE = "truststore";
    public static final String TOOL_TRUSTSTORE_CLIENT = "truststoreClient";
    public static final String TOOL_PROP_MAIN_CLASS = "main.class";
    public static final String TOOL_PROP_MAIN_CLASS_ARGS = "main.class.args";
    public static final String TOOL_PROP_JVM_OPTS = "jvm.opts";
    public static final String CLIENT_PROP_DIST_ARCHIVE = "client.dist.archive";
    private static final String DEFAULT_ICON = "org/netbeans/modules/j2ee/deployment/impl/ui/resources/Servers.png";
    private J2eePlatformImpl impl;
    private File[] classpathCache;
    private String currentClasspath;
    private ServerInstance serverInstance;
    private PropertyChangeListener librariesChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("content")) {
                J2eePlatform.access$002(J2eePlatform.this, null);
                String newClassPath = J2eePlatform.this.getClasspathAsString();
                if (J2eePlatform.this.currentClasspath == null || !J2eePlatform.this.currentClasspath.equals(newClassPath)) {
                    J2eePlatform.this.currentClasspath = newClassPath;
                    J2eePlatform.this.impl.firePropertyChange(J2eePlatform.PROP_CLASSPATH, null, null);
                }
            }
        }
    };

    private J2eePlatform(ServerInstance aServerInstance, J2eePlatformImpl aImpl) {
        this.impl = aImpl;
        this.serverInstance = aServerInstance;
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals(J2eePlatform.PROP_LIBRARIES)) {
                    LibraryImplementation[] libs = J2eePlatform.this.getLibraries();
                    for (int i = 0; i < libs.length; ++i) {
                        libs[i].removePropertyChangeListener(J2eePlatform.this.librariesChangeListener);
                        libs[i].addPropertyChangeListener(J2eePlatform.this.librariesChangeListener);
                    }
                    J2eePlatform.access$002(J2eePlatform.this, null);
                    String newClassPath = J2eePlatform.this.getClasspathAsString();
                    if (J2eePlatform.this.currentClasspath == null || !J2eePlatform.this.currentClasspath.equals(newClassPath)) {
                        J2eePlatform.this.currentClasspath = newClassPath;
                        J2eePlatform.this.impl.firePropertyChange(J2eePlatform.PROP_CLASSPATH, null, null);
                    }
                }
            }
        });
        LibraryImplementation[] libs = this.getLibraries();
        for (int i = 0; i < libs.length; ++i) {
            libs[i].addPropertyChangeListener(this.librariesChangeListener);
        }
        this.currentClasspath = this.getClasspathAsString();
    }

    static J2eePlatform create(ServerInstance serInst) {
        J2eePlatformImpl platformImpl;
        J2eePlatform result = serInst.getJ2eePlatform();
        if (result == null && (platformImpl = serInst.getJ2eePlatformImpl()) != null) {
            result = new J2eePlatform(serInst, platformImpl);
            serInst.setJ2eePlatform(result);
        }
        return result;
    }

    public File[] getClasspathEntries() {
        if (this.classpathCache == null) {
            LibraryImplementation[] libraries = this.impl.getLibraries();
            ArrayList<File> classpath = new ArrayList<File>();
            for (int i = 0; i < libraries.length; ++i) {
                List classpathList = libraries[i].getContent(PROP_CLASSPATH);
                for (URL url : classpathList) {
                    File f;
                    FileObject fo;
                    if ("jar".equals(url.getProtocol())) {
                        url = FileUtil.getArchiveFile((URL)url);
                    }
                    if ((fo = URLMapper.findFileObject((URL)url)) == null || (f = FileUtil.toFile((FileObject)fo)) == null) continue;
                    classpath.add(f);
                }
            }
            this.classpathCache = classpath.toArray(new File[classpath.size()]);
        }
        return this.classpathCache;
    }

    public File[] getToolClasspathEntries(String toolName) {
        return this.impl.getToolClasspathEntries(toolName);
    }

    public String getToolProperty(String toolName, String propertyName) {
        return this.impl.getToolProperty(toolName, propertyName);
    }

    public boolean isToolSupported(String toolName) {
        return this.impl.isToolSupported(toolName);
    }

    private LibraryImplementation[] getLibraries() {
        return this.impl.getLibraries();
    }

    public String getDisplayName() {
        return this.serverInstance.getDisplayName();
    }

    public Image getIcon() {
        Image result = this.impl.getIcon();
        if (result == null) {
            result = Utilities.loadImage((String)DEFAULT_ICON);
        }
        return result;
    }

    public File[] getPlatformRoots() {
        return this.impl.getPlatformRoots();
    }

    public Set getSupportedSpecVersions() {
        return this.impl.getSupportedSpecVersions();
    }

    public Set<String> getSupportedSpecVersions(Object moduleType) {
        return this.impl.getSupportedSpecVersions(moduleType);
    }

    public Set getSupportedModuleTypes() {
        return this.impl.getSupportedModuleTypes();
    }

    public Set getSupportedJavaPlatformVersions() {
        return this.impl.getSupportedJavaPlatformVersions();
    }

    public boolean supportsProfiling() {
        return true;
    }

    public JavaPlatform getJavaPlatform() {
        return this.impl.getJavaPlatform();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.impl.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.impl.removePropertyChangeListener(l);
    }

    public String toString() {
        return this.impl.getDisplayName() + " [" + this.getClasspathAsString() + "]";
    }

    private String getClasspathAsString() {
        File[] classpathEntr = this.getClasspathEntries();
        StringBuffer classpath = new StringBuffer();
        String PATH_SEPARATOR = System.getProperty("path.separator");
        for (int i = 0; i < classpathEntr.length; ++i) {
            classpath.append(classpathEntr[i].getAbsolutePath());
            if (i + 1 >= classpathEntr.length) continue;
            classpath.append(PATH_SEPARATOR);
        }
        return classpath.toString();
    }

    static /* synthetic */ File[] access$002(J2eePlatform x0, File[] x1) {
        x0.classpathCache = x1;
        return x1;
    }
}

