/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.j2ee.verification.JEEVerificationContextInfo;
import org.netbeans.modules.j2ee.verification.JEEVerificationHint;
import org.netbeans.modules.j2ee.verification.JEEVerificationProblemMark;
import org.openide.ErrorManager;

public class HintsManager {
    private static Map problemToHintsMapping = new Hashtable();

    private HintsManager() {
    }

    public static JEEVerificationHint[] getHintsForProblem(JEEVerificationProblemMark problem) {
        List hintClasses = (List)problemToHintsMapping.get(problem.getProblemId());
        ArrayList<JEEVerificationHint> retunValue = new ArrayList<JEEVerificationHint>();
        if (hintClasses != null) {
            for (String hintClassname : hintClasses) {
                JEEVerificationHint hint = HintsManager.createJEEHint(hintClassname, problem.getProblemContext());
                if (hint == null) continue;
                retunValue.add(hint);
            }
        }
        return retunValue.toArray(new JEEVerificationHint[0]);
    }

    public static void registerHint(String problemId, String hintClass) {
        ArrayList<String> hintsForAProblem = (ArrayList<String>)problemToHintsMapping.get(problemId);
        if (hintsForAProblem == null) {
            hintsForAProblem = new ArrayList<String>();
            problemToHintsMapping.put(problemId, hintsForAProblem);
        }
        hintsForAProblem.add(hintClass);
    }

    private static JEEVerificationHint createJEEHint(String className, JEEVerificationContextInfo problemContext) {
        JEEVerificationHint returnValue = null;
        try {
            Class<?> classDef = Class.forName(className);
            Class[] constrArgs = new Class[]{JEEVerificationContextInfo.class};
            Constructor<?> constr = classDef.getConstructor(constrArgs);
            returnValue = (JEEVerificationHint)((Object)constr.newInstance(problemContext));
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
        return returnValue;
    }
}

