/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.persistence.rules.field;

import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.persistence.BeanAccessType;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIHelper;
import org.netbeans.modules.j2ee.verification.persistence.predicates.clazz.AnnotatedAsIdClassPred;
import org.netbeans.modules.j2ee.verification.persistence.predicates.member.AnnotatedAsIdPred;

public class CorrespondingFieldMappedAsIdInEntity
extends AbstractRule {
    public String getId() {
        return "CorrespondingFieldMappedAsIdInEntity";
    }

    protected String getMessageKey() {
        return "MSG_FieldNotMappedAsId";
    }

    protected boolean isApplicable(Element subject, ProblemFinderContext ctx) {
        return (ctx.isIsEntityClass() || ctx.isMappedSuperclass()) && ctx.getBeanAccessType() == BeanAccessType.FIELD && new AnnotatedAsIdClassPred().evaluate((Object)ctx.getMainJavaClass()) && super.isApplicable(subject, ctx);
    }

    public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (this.isApplicable(subject, ctx)) {
            Field field = (Field)Field.class.cast(subject);
            JavaClass javaClass = ctx.getMainJavaClass();
            JavaClass idClass = PersistenceAPIHelper.getIdClass(javaClass);
            if (idClass == null) {
                return null;
            }
            Field idField = idClass.getField(field.getName(), false);
            if (idField != null && !new AnnotatedAsIdPred().evaluate(field)) {
                return this.createProblem(ctx, subject);
            }
        }
        return null;
    }
}

