/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.Utilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class BaseAction
extends TextAction {
    public static final String POPUP_MENU_TEXT = "PopupMenuText";
    public static final String LOCALE_DESC_PREFIX = "desc-";
    public static final String LOCALE_POPUP_PREFIX = "popup-";
    public static final String ICON_RESOURCE_PROPERTY = "IconResource";
    public static final int SELECTION_REMOVE = 1;
    public static final int MAGIC_POSITION_RESET = 2;
    public static final int ABBREV_RESET = 4;
    public static final int UNDO_MERGE_RESET = 8;
    public static final int WORD_MATCH_RESET = 16;
    public static final int CLEAR_STATUS_TEXT = 32;
    public static final int NO_RECORDING = 64;
    public static final int SAVE_POSITION = 128;
    public static final String NO_KEYBINDING = "no-keybinding";
    private static Logger UILOG = Logger.getLogger("org.netbeans.ui.actions.editor");
    protected int updateMask;
    private static boolean recording;
    private static StringBuffer macroBuffer;
    private static StringBuffer textBuffer;
    static final long serialVersionUID = -4255521122272110786L;

    public BaseAction(String name) {
        this(name, 0);
    }

    public BaseAction(String name, int updateMask) {
        super(name);
        this.updateMask = updateMask;
    }

    protected Object findValue(String key) {
        return LocaleSupport.getString(key);
    }

    public Object getValue(String key) {
        Object obj = super.getValue(key);
        if (obj == null && (obj = this.createDefaultValue(key)) != null) {
            this.putValue(key, obj);
        }
        return obj;
    }

    protected Object createDefaultValue(String key) {
        String bundleKey;
        Object ret = null;
        if ("ShortDescription".equals(key)) {
            Class bundleClass = this.getShortDescriptionBundleClass();
            if (bundleClass != null) {
                String bundleKey2 = (String)this.getValue("Name");
                ret = NbBundle.getBundle((Class)bundleClass).getString(bundleKey2);
            } else {
                ret = this.getDefaultShortDescription();
            }
        } else if (POPUP_MENU_TEXT.equals(key) && (ret = this.findValue(bundleKey = LOCALE_POPUP_PREFIX + this.getValue("Name"))) == null) {
            ret = this.getValue("ShortDescription");
        }
        return ret;
    }

    protected Class getShortDescriptionBundleClass() {
        return null;
    }

    protected Object getDefaultShortDescription() {
        String actionName = (String)this.getValue("Name");
        String localizerKey = LOCALE_DESC_PREFIX + actionName;
        Object obj = this.findValue(localizerKey);
        if (obj == null && (obj = this.findValue(actionName)) == null) {
            obj = actionName;
        }
        return obj;
    }

    protected void settingsChange(SettingsChangeEvent evt, Class kitClass) {
    }

    public final void actionPerformed(final ActionEvent evt) {
        final JTextComponent target = this.getTextComponent(evt);
        if (recording && 0 == (this.updateMask & 0x40)) {
            this.recordAction(target, evt);
        }
        this.updateComponent(target);
        if (UILOG.isLoggable(Level.FINE)) {
            String actionName;
            String string = actionName = this.getValue("Name") != null ? this.getValue("Name").toString().toLowerCase() : null;
            if (actionName != null && !"default-typed".equals(actionName) && -1 == actionName.indexOf("caret") && -1 == actionName.indexOf("delete") && -1 == actionName.indexOf("selection")) {
                LogRecord r = new LogRecord(Level.FINE, "UI_ACTION_EDITOR");
                r.setResourceBundle(NbBundle.getBundle((Class)BaseAction.class));
                r.setParameters(new Object[]{evt, evt.toString(), this, this.toString(), this.getValue("Name")});
                r.setLoggerName(UILOG.getName());
                UILOG.log(r);
            }
        }
        if (this.asynchonous()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    BaseAction.this.actionPerformed(evt, target);
                }
            });
        } else {
            this.actionPerformed(evt, target);
        }
    }

    private void recordAction(JTextComponent target, ActionEvent evt) {
        if (this == target.getKeymap().getDefaultAction()) {
            textBuffer.append(this.getFilteredActionCommand(evt.getActionCommand()));
        } else {
            if (textBuffer.length() > 0) {
                if (macroBuffer.length() > 0) {
                    macroBuffer.append(' ');
                }
                macroBuffer.append(this.encodeText(textBuffer.toString()));
                textBuffer.setLength(0);
            }
            if (macroBuffer.length() > 0) {
                macroBuffer.append(' ');
            }
            String name = (String)this.getValue("Name");
            macroBuffer.append(this.encodeActionName(name));
        }
    }

    private String getFilteredActionCommand(String cmd) {
        if (cmd == null || cmd.length() == 0) {
            return "";
        }
        char ch = cmd.charAt(0);
        if (ch >= ' ' && ch != '\u007f') {
            return cmd;
        }
        return "";
    }

    boolean startRecording(JTextComponent target) {
        if (recording) {
            return false;
        }
        recording = true;
        macroBuffer.setLength(0);
        textBuffer.setLength(0);
        Utilities.setStatusText(target, NbBundle.getBundle((Class)BaseAction.class).getString("macro-recording"));
        return true;
    }

    String stopRecording(JTextComponent target) {
        if (!recording) {
            return null;
        }
        if (textBuffer.length() > 0) {
            if (macroBuffer.length() > 0) {
                macroBuffer.append(' ');
            }
            macroBuffer.append(this.encodeText(textBuffer.toString()));
        }
        String retVal = macroBuffer.toString();
        recording = false;
        Utilities.setStatusText(target, "");
        return retVal;
    }

    private String encodeText(String s) {
        char[] text = s.toCharArray();
        StringBuffer encoded = new StringBuffer("\"");
        for (int i = 0; i < text.length; ++i) {
            char c = text[i];
            if (c == '\"' || c == '\\') {
                encoded.append('\\');
            }
            encoded.append(c);
        }
        return encoded.append('\"').toString();
    }

    private String encodeActionName(String s) {
        char[] actionName = s.toCharArray();
        StringBuffer encoded = new StringBuffer();
        for (int i = 0; i < actionName.length; ++i) {
            char c = actionName[i];
            if (Character.isWhitespace(c) || c == '\\') {
                encoded.append('\\');
            }
            encoded.append(c);
        }
        return encoded.toString();
    }

    public abstract void actionPerformed(ActionEvent var1, JTextComponent var2);

    protected boolean asynchonous() {
        return false;
    }

    public JMenuItem getPopupMenuItem(JTextComponent target) {
        return null;
    }

    public String getPopupMenuText(JTextComponent target) {
        String txt = (String)this.getValue(POPUP_MENU_TEXT);
        if (txt == null) {
            txt = (String)this.getValue("Name");
        }
        return txt;
    }

    public void updateComponent(JTextComponent target) {
        this.updateComponent(target, this.updateMask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateComponent(JTextComponent target, int updateMask) {
        if (target != null && target.getDocument() instanceof BaseDocument) {
            BaseDocument doc = (BaseDocument)target.getDocument();
            boolean writeLocked = false;
            try {
                if ((updateMask & 1) != 0) {
                    writeLocked = true;
                    doc.extWriteLock();
                    Caret caret = target.getCaret();
                    if (caret != null && caret.isSelectionVisible()) {
                        int markPos;
                        int dot = caret.getDot();
                        if (dot < (markPos = caret.getMark())) {
                            int tmpPos = dot;
                            dot = markPos;
                            markPos = tmpPos;
                        }
                        try {
                            target.getDocument().remove(markPos, dot - markPos);
                        }
                        catch (BadLocationException e) {
                            Utilities.annotateLoggable(e);
                        }
                    }
                }
                if ((updateMask & 2) != 0 && target.getCaret() != null) {
                    target.getCaret().setMagicCaretPosition(null);
                }
                if ((updateMask & 4) != 0) {
                    ((BaseTextUI)target.getUI()).getEditorUI().getAbbrev().reset();
                }
                if ((updateMask & 8) != 0) {
                    doc.resetUndoMerge();
                }
                if ((updateMask & 0x10) != 0) {
                    ((BaseTextUI)target.getUI()).getEditorUI().getWordMatch().clear();
                }
                if (!recording && (updateMask & 0x20) != 0) {
                    Utilities.clearStatusText(target);
                }
                if ((updateMask & 0x80) != 0) {
                    JumpList.checkAddEntry(target);
                }
            }
            finally {
                if (writeLocked) {
                    doc.extWriteUnlock();
                }
            }
        }
    }

    static {
        macroBuffer = new StringBuffer();
        textBuffer = new StringBuffer();
    }
}

