/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.common;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openide.util.NbBundle;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ParseUtils {
    public static final String EXCEPTION_PREFIX = "version:";

    public static String getVersion(InputStream is, DefaultHandler versionHandler, EntityResolver ddResolver) throws IOException, SAXException {
        SAXParserFactory fact = SAXParserFactory.newInstance();
        fact.setValidating(false);
        try {
            SAXParser parser = fact.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setContentHandler(versionHandler);
            reader.setEntityResolver(ddResolver);
            try {
                reader.parse(new InputSource(is));
            }
            catch (SAXException ex) {
                is.close();
                String message = ex.getMessage();
                if (message != null && message.startsWith(EXCEPTION_PREFIX)) {
                    return message.substring(EXCEPTION_PREFIX.length());
                }
                throw new SAXException(NbBundle.getMessage(ParseUtils.class, (String)"MSG_cannotParse"), ex);
            }
            is.close();
            throw new SAXException(NbBundle.getMessage(ParseUtils.class, (String)"MSG_cannotFindRoot"));
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException(NbBundle.getMessage(ParseUtils.class, (String)"MSG_parserProblem"), ex);
        }
    }

    public static String getVersion(InputSource is, DefaultHandler versionHandler, EntityResolver ddResolver) throws IOException, SAXException {
        SAXParserFactory fact = SAXParserFactory.newInstance();
        fact.setValidating(false);
        try {
            SAXParser parser = fact.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setContentHandler(versionHandler);
            reader.setEntityResolver(ddResolver);
            try {
                reader.parse(is);
            }
            catch (SAXException ex) {
                String message = ex.getMessage();
                if (message != null && message.startsWith(EXCEPTION_PREFIX)) {
                    return message.substring(EXCEPTION_PREFIX.length());
                }
                throw new SAXException(NbBundle.getMessage(ParseUtils.class, (String)"MSG_cannotParse"), ex);
            }
            throw new SAXException(NbBundle.getMessage(ParseUtils.class, (String)"MSG_cannotFindRoot"));
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException(NbBundle.getMessage(ParseUtils.class, (String)"MSG_parserProblem"), ex);
        }
    }

    public static SAXParseException parseDD(InputSource is, EntityResolver ddResolver) throws SAXException, IOException {
        ErrorHandler errorHandler = new ErrorHandler();
        try {
            SAXParser parser = ParseUtils.createSAXParserFactory().newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setErrorHandler(errorHandler);
            reader.setEntityResolver(ddResolver);
            reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            reader.setFeature("http://xml.org/sax/features/validation", true);
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            reader.parse(is);
            SAXParseException error = errorHandler.getError();
            if (error != null) {
                return error;
            }
        }
        catch (ParserConfigurationException ex) {
            SAXException sax = new SAXException(ex.getMessage(), ex);
            sax.initCause(ex);
            throw sax;
        }
        catch (SAXException ex) {
            throw ex;
        }
        catch (IllegalArgumentException ex) {
            SAXException sax = new SAXException(ex.getMessage(), ex);
            sax.initCause(ex);
            throw sax;
        }
        return null;
    }

    private static SAXParserFactory createSAXParserFactory() throws ParserConfigurationException {
        try {
            SAXParserFactory fact = SAXParserFactory.newInstance();
            if (fact != null) {
                try {
                    fact.getClass().getMethod("getSchema", new Class[0]);
                    return fact;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return (SAXParserFactory)Class.forName("org.apache.xerces.jaxp.SAXParserFactoryImpl").newInstance();
        }
        catch (Exception ex) {
            throw new ParserConfigurationException(ex.getMessage());
        }
    }

    private static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        private int errorType = -1;
        SAXParseException error;

        private ErrorHandler() {
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 0) {
                this.errorType = 0;
                this.error = sAXParseException;
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 1) {
                this.errorType = 1;
                this.error = sAXParseException;
            }
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.errorType = 2;
            throw sAXParseException;
        }

        public int getErrorType() {
            return this.errorType;
        }

        public SAXParseException getError() {
            return this.error;
        }
    }
}

