/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry.ui;

import com.sun.xml.rpc.processor.model.java.JavaArrayType;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationType;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import com.sun.xml.rpc.processor.model.java.JavaSimpleType;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.websvc.registry.model.WebServiceData;
import org.netbeans.modules.websvc.registry.ui.ArrayTypeTreeNode;
import org.netbeans.modules.websvc.registry.ui.MethodExceptionDialog;
import org.netbeans.modules.websvc.registry.ui.NodeData;
import org.netbeans.modules.websvc.registry.ui.ReflectionHelper;
import org.netbeans.modules.websvc.registry.ui.ResultCellEditor;
import org.netbeans.modules.websvc.registry.ui.ResultNodeData;
import org.netbeans.modules.websvc.registry.ui.ResultRowModel;
import org.netbeans.modules.websvc.registry.ui.StructureTypeTreeNode;
import org.netbeans.modules.websvc.registry.ui.TypeCellEditor;
import org.netbeans.modules.websvc.registry.ui.TypeDataProvider;
import org.netbeans.modules.websvc.registry.ui.TypeNodeData;
import org.netbeans.modules.websvc.registry.ui.TypeRowModel;
import org.netbeans.modules.websvc.registry.ui.WebServiceReflectionException;
import org.netbeans.modules.websvc.registry.util.Util;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TestWebServiceMethodDlg
extends JPanel {
    private Dialog dialog;
    private DialogDescriptor dlg = null;
    private JavaMethod method;
    private URLClassLoader runtimeClassLoader;
    private String packageName;
    private DefaultMutableTreeNode parameterRootNode = new DefaultMutableTreeNode();
    private DefaultMutableTreeNode resultRootNode = new DefaultMutableTreeNode();
    private WebServiceData wsData;
    public String portName;
    public String modifiedMethodName;
    private JPanel btnPanel;
    private JButton btnSubmit;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel4;
    private JSplitPane jSplitPane1;
    private JLabel lblTitle;
    private JPanel pnlLabel;
    private JPanel pnlParameter;
    private JPanel pnlResults;
    private JScrollPane scrollPaneParameter;
    private JScrollPane scrollPaneResults;
    private Outline outline;

    public TestWebServiceMethodDlg(WebServiceData inWSData, JavaMethod inMethod, String inPortName) {
        this.setJavaMethod(inMethod);
        this.wsData = inWSData;
        this.packageName = inWSData.getPackageName();
        this.portName = inPortName;
        this.modifiedMethodName = Util.getProperPortName(inPortName).toLowerCase() + Util.upperCaseFirstChar(inMethod.getName());
        this.initComponents();
        this.myInitComponents();
        this.lblTitle.setText(NbBundle.getMessage(this.getClass(), (String)"TEST_WEBSVC_LABEL") + " " + this.modifiedMethodName);
    }

    private URLClassLoader getRuntimeClassLoader() {
        if (null == this.runtimeClassLoader) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException pe) {
                ErrorManager.getDefault().notify((Throwable)pe);
                ErrorManager.getDefault().log("ParserConfigurationException=" + pe);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"ERROR_READING_RUNTIMEJARS"));
                return null;
            }
            Document document = null;
            try {
                File runtimeJarsFile = InstalledFileLocator.getDefault().locate("config" + File.separator + "WebServices" + File.separator + "websvc_runtimejars.xml", null, false);
                document = builder.parse(runtimeJarsFile);
            }
            catch (SAXException se) {
                ErrorManager.getDefault().notify((Throwable)se);
                ErrorManager.getDefault().log("SAXException=" + se);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"ERROR_READING_RUNTIMEJARS"));
                return null;
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
                ErrorManager.getDefault().log("IOException=" + ioe);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"ERROR_READING_RUNTIMEJARS"));
                return null;
            }
            NodeList list = document.getElementsByTagName("Jar");
            ArrayList<URL> urlList = new ArrayList<URL>();
            try {
                urlList.add(new URL("file:" + this.getWebServiceData().getProxyJarFileName()));
            }
            catch (MalformedURLException mfu) {
                ErrorManager.getDefault().notify((Throwable)mfu);
                ErrorManager.getDefault().log(this.getClass().getName() + ":IOException=" + mfu);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(this.getClass(), (String)"ERROR_READING_RUNTIMEJARS"));
                return null;
            }
            String[] serverInstanceIDs = Deployment.getDefault().getServerInstanceIDs();
            J2eePlatform platform = null;
            for (int i = 0; i < serverInstanceIDs.length; ++i) {
                J2eePlatform p = Deployment.getDefault().getJ2eePlatform(serverInstanceIDs[i]);
                if (p == null || !p.isToolSupported("wscompile")) continue;
                platform = p;
                break;
            }
            File appserverRoot = platform == null ? null : platform.getPlatformRoots()[0];
            String asRootPath = appserverRoot != null ? appserverRoot.getAbsolutePath() : "";
            asRootPath = asRootPath.replace('\\', '/');
            Node currentNode = null;
            for (int ii = 0; ii < list.getLength(); ++ii) {
                currentNode = list.item(ii);
                String name = currentNode.getNodeName();
                String localName = currentNode.getLocalName();
                String value = currentNode.getNodeValue();
                NamedNodeMap nodeMap = currentNode.getAttributes();
                Node fileNode = nodeMap.getNamedItem("file");
                String jarString = "";
                try {
                    jarString = fileNode.getNodeValue();
                }
                catch (DOMException de) {
                    ErrorManager.getDefault().notify((Throwable)de);
                    ErrorManager.getDefault().log(this.getClass().getName() + ":IOException=" + de);
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(this.getClass(), (String)"ERROR_READING_RUNTIMEJARS"));
                    return null;
                }
                if (jarString.indexOf("\\{appserv\\.home\\}") > -1) {
                    jarString = jarString.replaceAll("\\{appserv\\.home\\}", asRootPath);
                } else {
                    File f = InstalledFileLocator.getDefault().locate(jarString, null, false);
                    if (f != null) {
                        jarString = f.getPath();
                    }
                }
                if (!jarString.startsWith("file:")) {
                    jarString = jarString.substring(1, 1).equals("/") ? "file:/" + jarString : "file:///" + jarString;
                }
                URL newURL = null;
                try {
                    newURL = new URL(jarString);
                }
                catch (MalformedURLException mfu) {
                    ErrorManager.getDefault().notify((Throwable)mfu);
                    ErrorManager.getDefault().log(this.getClass().getName() + ":IOException=" + mfu);
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(this.getClass(), (String)"ERROR_READING_RUNTIMEJARS"));
                    return null;
                }
                urlList.add(newURL);
            }
            URL[] urls = urlList.toArray(new URL[0]);
            this.runtimeClassLoader = new URLClassLoader(urls, null);
        }
        return this.runtimeClassLoader;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public WebServiceData getWebServiceData() {
        return this.wsData;
    }

    public void displayDialog() {
        this.dlg = new DialogDescriptor((Object)this, NbBundle.getMessage(this.getClass(), (String)"TEST_WEB_SERVICE_METHOD"), false, new Object[]{NotifyDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, this.getHelpCtx(), null);
        this.dialog = DialogDisplayer.getDefault().createDialog(this.dlg);
        final TestWebServiceMethodDlg thisPanel = this;
        final Dialog thisDialog = this.dialog;
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TestWebServiceMethodDlg.this.btnSubmit.requestFocus();
                        thisPanel.getRootPane().setDefaultButton(TestWebServiceMethodDlg.this.btnSubmit);
                    }
                });
            }

            public void windowClosing(WindowEvent e) {
                thisDialog.dispose();
            }
        });
        this.dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"ACSD_TEST_WEB_SERVICE_DLG"));
        this.dialog.show();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(TestWebServiceMethodDlg.class);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.pnlParameter = new JPanel();
        this.btnPanel = new JPanel();
        this.btnSubmit = new JButton();
        this.scrollPaneParameter = new JScrollPane();
        this.pnlLabel = new JPanel();
        this.lblTitle = new JLabel();
        this.jLabel1 = new JLabel();
        this.pnlResults = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel2 = new JLabel();
        this.scrollPaneResults = new JScrollPane();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.jSplitPane1.setDividerLocation(400);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(1.0);
        this.pnlParameter.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.btnSubmit, (String)NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"BUTTON_SUBMIT"));
        this.btnSubmit.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"ACSD_BUTTON_SUBMIT"));
        this.btnSubmit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestWebServiceMethodDlg.this.btnSubmitActionPerformed(evt);
            }
        });
        this.btnPanel.add(this.btnSubmit);
        this.pnlParameter.add((Component)this.btnPanel, "South");
        this.pnlParameter.add((Component)this.scrollPaneParameter, "Center");
        this.pnlLabel.setLayout(new GridLayout(2, 0, 10, 10));
        this.pnlLabel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.lblTitle.setFont(new Font(this.getFont().getName(), this.getFont().getStyle(), this.getFont().getSize() + 2));
        this.lblTitle.setText(ResourceBundle.getBundle("org/netbeans/modules/websvc/registry/ui/Bundle").getString("TEST_WEBSVC_LABEL"));
        this.lblTitle.setHorizontalTextPosition(0);
        this.pnlLabel.add(this.lblTitle);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"PARAMETERS"));
        this.jLabel1.setToolTipText(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TEST_WEBSVC_INSTRUCTIONS"));
        this.jLabel1.setHorizontalTextPosition(0);
        this.pnlLabel.add(this.jLabel1);
        this.pnlParameter.add((Component)this.pnlLabel, "North");
        this.jSplitPane1.setTopComponent(this.pnlParameter);
        this.pnlResults.setLayout(new BorderLayout());
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel4.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"RESULTS"));
        this.jLabel2.setToolTipText(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"ACSD_RESULT_TABLE"));
        this.jPanel4.add((Component)this.jLabel2, "North");
        this.jPanel4.add((Component)this.scrollPaneResults, "Center");
        this.pnlResults.add((Component)this.jPanel4, "Center");
        this.jSplitPane1.setBottomComponent(this.pnlResults);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void btnSubmitActionPerformed(ActionEvent evt) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                Cursor normalCursor = TestWebServiceMethodDlg.this.dialog.getCursor();
                TestWebServiceMethodDlg.this.dialog.setCursor(new Cursor(3));
                TestWebServiceMethodDlg.this.invokeMethod();
                TestWebServiceMethodDlg.this.dialog.setCursor(normalCursor);
            }
        });
    }

    private void invokeMethod() {
        LinkedList<Object> paramList = new LinkedList<Object>();
        for (int ii = 0; null != this.getParamterRootNode() && ii < this.getParamterRootNode().getChildCount(); ++ii) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)this.getParamterRootNode().getChildAt(ii);
            TypeNodeData nodeData = (TypeNodeData)childNode.getUserObject();
            Object parameterValue = nodeData.getParameterValue();
            if (parameterValue instanceof ArrayList) {
                try {
                    parameterValue = ReflectionHelper.getTypedParameterArray((ArrayList)parameterValue, nodeData.getParameterType(), this.getRuntimeClassLoader(), this.getPackageName());
                }
                catch (WebServiceReflectionException wsre) {
                    Throwable cause = wsre.getCause();
                    ErrorManager.getDefault().notify(cause);
                    ErrorManager.getDefault().log(this.getClass().getName() + ": Error trying to create a typed parameter array for type:" + nodeData.getParameterType() + "WebServiceReflectionException=" + cause);
                    return;
                }
            }
            paramList.add(parameterValue);
        }
        String clientClassName = this.wsData.getPackageName() + "." + this.wsData.getDisplayName() + "Client";
        Object returnObject = null;
        try {
            returnObject = ReflectionHelper.callMethodWithParams(clientClassName, paramList, this.getJavaMethod(), this.getRuntimeClassLoader(), this.modifiedMethodName);
        }
        catch (WebServiceReflectionException wsre) {
            MethodExceptionDialog errorDialog = new MethodExceptionDialog(wsre);
            errorDialog.show();
            return;
        }
        this.showResults(returnObject);
    }

    private void showResults(Object inResultObject) {
        this.outline = this.loadResultTreeTable(this.getJavaMethod(), inResultObject);
        this.scrollPaneResults.setViewportView(this.outline);
        this.jLabel2.setLabelFor(this.outline);
    }

    private void myInitComponents() {
        if (null == this.getJavaMethod()) {
            return;
        }
        this.outline = this.loadParameterTreeTable(this.getJavaMethod());
        this.scrollPaneParameter.setViewportView(this.outline);
        this.jLabel1.setLabelFor(this.outline);
    }

    private DefaultMutableTreeNode getParamterRootNode() {
        return this.parameterRootNode;
    }

    private void setParameterRootNode(DefaultMutableTreeNode inNode) {
        this.parameterRootNode = inNode;
    }

    private DefaultMutableTreeNode getResultRootNode() {
        return this.resultRootNode;
    }

    private void setResultRootNode(DefaultMutableTreeNode inNode) {
        this.resultRootNode = inNode;
    }

    private JavaMethod getJavaMethod() {
        return this.method;
    }

    private void setJavaMethod(JavaMethod inMethod) {
        this.method = inMethod;
    }

    private Outline loadResultTreeTable(JavaMethod inMethod, Object inResultObject) {
        if (null == inMethod) {
            return null;
        }
        JavaType currentType = inMethod.getReturnType();
        ResultNodeData data = new ResultNodeData(currentType, inResultObject);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(data);
        if (currentType instanceof JavaArrayType) {
            this.addResultArrayInstances(node);
        } else if (currentType instanceof JavaStructureType) {
            this.traverseResultType(node);
        }
        this.setResultRootNode(new DefaultMutableTreeNode());
        this.getResultRootNode().add(node);
        DefaultTreeModel treeModel = new DefaultTreeModel(this.getResultRootNode());
        ResultRowModel rowModel = new ResultRowModel();
        OutlineModel outlineModel = DefaultOutlineModel.createOutlineModel(treeModel, rowModel, false);
        outlineModel.setNodeColumnName(NbBundle.getMessage(this.getClass(), (String)"TYPE_COLUMN_NAME"));
        Outline returnOutline = new Outline(outlineModel);
        ResultCellEditor cellEditor = new ResultCellEditor();
        returnOutline.setDefaultEditor(Object.class, cellEditor);
        returnOutline.setRootVisible(false);
        returnOutline.setRenderDataProvider(new TypeDataProvider());
        returnOutline.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"ACSN_RESULT_TABLE"));
        return returnOutline;
    }

    private Outline loadParameterTreeTable(JavaMethod inMethod) {
        if (null == inMethod) {
            return null;
        }
        Iterator paramIterator = inMethod.getParameters();
        JavaParameter currentParameter = null;
        while (paramIterator.hasNext()) {
            currentParameter = (JavaParameter)paramIterator.next();
            JavaType currentType = currentParameter.getType();
            Object value = null;
            value = this.getParameterDefaultValue(currentType);
            TypeNodeData data = new TypeNodeData(currentType, currentParameter.getName(), value);
            DefaultMutableTreeNode node = null;
            if (currentType instanceof JavaArrayType) {
                node = new ArrayTypeTreeNode(data);
                JavaType elementType = ((JavaArrayType)currentType).getElementType();
                this.addParameterArrayInstances(elementType, node);
            } else if (currentType instanceof JavaStructureType) {
                node = new StructureTypeTreeNode(data, this.getRuntimeClassLoader(), this.getPackageName());
                this.traverseType(node);
            } else {
                node = new DefaultMutableTreeNode(data);
            }
            this.getParamterRootNode().add(node);
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(this.getParamterRootNode());
        TypeRowModel rowModel = new TypeRowModel(this.getRuntimeClassLoader(), this.getPackageName());
        OutlineModel outlineModel = DefaultOutlineModel.createOutlineModel(treeModel, rowModel, false);
        outlineModel.setNodeColumnName(NbBundle.getMessage(this.getClass(), (String)"TYPE_COLUMN_NAME"));
        Outline returnOutline = new Outline(outlineModel);
        TypeCellEditor cellEditor = new TypeCellEditor();
        returnOutline.setDefaultEditor(Object.class, cellEditor);
        returnOutline.setRootVisible(false);
        returnOutline.setRenderDataProvider(new TypeDataProvider());
        returnOutline.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        returnOutline.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"ACSN_PARAMETER_TABLE"));
        returnOutline.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"ACSD_PARAMETER_TABLE"));
        return returnOutline;
    }

    private void traverseType(DefaultMutableTreeNode inNode) {
        if (null == inNode) {
            return;
        }
        JavaType inType = ((NodeData)inNode.getUserObject()).getNodeType();
        if (!(inType instanceof JavaStructureType)) {
            return;
        }
        JavaStructureType type = (JavaStructureType)inType;
        Iterator typeIterator = type.getMembers();
        while (null != typeIterator && typeIterator.hasNext()) {
            DefaultMutableTreeNode node;
            TypeNodeData data;
            JavaStructureMember entry = (JavaStructureMember)typeIterator.next();
            JavaType entryType = entry.getType();
            if (entryType instanceof JavaEnumerationType || entryType instanceof JavaSimpleType) {
                data = new TypeNodeData(entryType, entry.getName(), this.getParameterDefaultValue(entryType));
                node = new DefaultMutableTreeNode(data);
                inNode.add(node);
                continue;
            }
            if (entryType instanceof JavaArrayType) {
                data = new TypeNodeData(entryType, entry.getName(), this.getParameterDefaultValue(entryType));
                node = new ArrayTypeTreeNode(data);
                inNode.add(node);
                JavaType elementType = ((JavaArrayType)entryType).getElementType();
                this.addParameterArrayInstances(elementType, node);
                continue;
            }
            if (!(entryType instanceof JavaStructureType)) continue;
            data = new TypeNodeData(entryType, entry.getName(), this.getParameterDefaultValue(entryType));
            node = new StructureTypeTreeNode(data, this.getRuntimeClassLoader(), this.getPackageName());
            inNode.add(node);
            this.traverseType(node);
        }
    }

    private void traverseResultType(DefaultMutableTreeNode inParentNode) {
        if (null == inParentNode) {
            return;
        }
        ResultNodeData parentData = (ResultNodeData)inParentNode.getUserObject();
        JavaType parentType = parentData.getResultType();
        Object parentValue = parentData.getResultValue();
        if (!(parentType instanceof JavaStructureType)) {
            return;
        }
        JavaStructureType type = (JavaStructureType)parentType;
        Iterator typeIterator = type.getMembers();
        while (null != typeIterator && typeIterator.hasNext()) {
            JavaStructureMember member = (JavaStructureMember)typeIterator.next();
            JavaType memberType = member.getType();
            String memberName = member.getName();
            Object subTypeValue = null;
            if (null != parentValue) {
                try {
                    subTypeValue = ReflectionHelper.getStructureValue(parentData, member, this.getRuntimeClassLoader(), this.getPackageName());
                }
                catch (WebServiceReflectionException wsfe) {
                    // empty catch block
                }
            }
            ResultNodeData data = new ResultNodeData(memberType, subTypeValue);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(data);
            inParentNode.add(node);
            if (memberType instanceof JavaArrayType) {
                this.addResultArrayInstances(node);
                continue;
            }
            if (!(memberType instanceof JavaStructureType)) continue;
            this.traverseResultType(node);
        }
    }

    private void addParameterArrayInstances(JavaType inType, DefaultMutableTreeNode parentNode) {
        DefaultMutableTreeNode childNode = null;
        TypeNodeData data = null;
        for (int ii = 0; ii < 9; ++ii) {
            data = new TypeNodeData(inType, "[" + ii + "]", this.getParameterDefaultValue(inType));
            childNode = new DefaultMutableTreeNode(data);
            parentNode.add(childNode);
            if (!(inType instanceof JavaStructureType)) continue;
            this.traverseType(childNode);
        }
    }

    private void addResultArrayInstances(DefaultMutableTreeNode parentNode) {
        DefaultMutableTreeNode childNode = null;
        ResultNodeData parentData = (ResultNodeData)parentNode.getUserObject();
        JavaType parentType = parentData.getResultType();
        if (!(parentType instanceof JavaArrayType)) {
            return;
        }
        JavaType valueType = ((JavaArrayType)parentType).getElementType();
        Object resultValue = parentData.getResultValue();
        if (null == resultValue) {
            return;
        }
        ResultNodeData childData = null;
        int length = Array.getLength(resultValue);
        for (int i = 0; i < length; ++i) {
            childData = new ResultNodeData(valueType, Array.get(resultValue, i));
            childNode = new DefaultMutableTreeNode(childData);
            parentNode.add(childNode);
            if (!(valueType instanceof JavaStructureType)) continue;
            this.traverseResultType(childNode);
        }
    }

    private Object getParameterDefaultValue(JavaType type) {
        Object value = null;
        if (null == type) {
            return null;
        }
        if (type instanceof JavaStructureType) {
            Object returnValue = null;
            try {
                returnValue = ReflectionHelper.makeStructureType((JavaStructureType)type, this.getRuntimeClassLoader(), this.getPackageName());
            }
            catch (WebServiceReflectionException wsre) {
                Throwable cause = wsre.getCause();
                ErrorManager.getDefault().notify(cause);
                ErrorManager.getDefault().log(this.getClass().getName() + ": Error trying to do Class.forName on: " + this.packageName + "." + type.getFormalName() + "WebServiceReflectionException=" + cause);
                return null;
            }
            return returnValue;
        }
        if (type instanceof JavaEnumerationType) {
            Object returnValue = null;
            try {
                returnValue = ReflectionHelper.makeEnumerationType((JavaEnumerationType)type, this.getRuntimeClassLoader(), this.getPackageName());
            }
            catch (WebServiceReflectionException wsre) {
                Throwable cause = wsre.getCause();
                ErrorManager.getDefault().notify(cause);
                ErrorManager.getDefault().log(this.getClass().getName() + ": Error trying to create an Enumeration Type: " + this.packageName + "." + type.getFormalName() + "ClassNWebServiceReflectionExceptionotFoundException=" + cause);
                return null;
            }
            return returnValue;
        }
        if (type instanceof JavaArrayType) {
            return new ArrayList();
        }
        String currentType = type.getRealName();
        if (currentType.equals(Integer.TYPE.getName()) || currentType.equals(Integer.class.getName())) {
            value = new Integer(0);
        } else if (currentType.equals(Byte.TYPE.getName()) || currentType.equals(Byte.class.getName())) {
            value = new Byte("0");
        } else if ("byte[]".equals(currentType)) {
            value = new Byte[]{};
        } else if (currentType.equals(Boolean.TYPE.getName()) || currentType.equals(Boolean.class.getName())) {
            value = new Boolean(false);
        } else if (currentType.equals(Float.TYPE.getName()) || currentType.equals(Float.class.getName())) {
            value = new Float(0.0f);
        } else if (currentType.equals(Double.TYPE.getName()) || currentType.equals(Double.class.getName())) {
            value = new Double(0.0);
        } else if (currentType.equals(Long.TYPE.getName()) || currentType.equals(Long.class.getName())) {
            value = new Long(0L);
        } else if (currentType.equals(Short.TYPE.getName()) || currentType.equals(Short.class.getName())) {
            value = new Short("0");
        } else if (currentType.equals(String.class.getName())) {
            value = "";
        } else if (currentType.equals(BigDecimal.class.getName())) {
            value = new BigDecimal("0");
        } else if (currentType.equals(BigInteger.class.getName())) {
            value = new BigInteger("0");
        } else if (currentType.equals(URI.class.getName())) {
            try {
                value = new URI("http://java.sun.com");
            }
            catch (URISyntaxException uri) {}
        } else if (currentType.equals(Calendar.class.getName())) {
            value = Calendar.getInstance();
        } else if (currentType.equalsIgnoreCase(Date.class.getName())) {
            value = new Date();
        }
        return value;
    }
}

