/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.io.IOException;
import java.io.Writer;
import org.netbeans.core.output2.AbstractLines;
import org.netbeans.core.output2.NbWriter;
import org.netbeans.core.output2.OutWriter;
import org.openide.ErrorManager;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

class ErrWriter
extends OutputWriter {
    private OutWriter wrapped;
    private NbWriter parent;
    boolean closed = true;

    ErrWriter(OutWriter wrapped, NbWriter parent) {
        super((Writer)new OutWriter.DummyWriter());
        this.wrapped = wrapped;
        this.parent = parent;
    }

    synchronized void setWrapped(OutWriter wrapped) {
        this.wrapped = wrapped;
        this.closed = true;
    }

    public void println(String s, OutputListener l) throws IOException {
        this.println(s, l, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String s, OutputListener l, boolean important) throws IOException {
        this.closed = false;
        OutWriter outWriter = this.wrapped;
        synchronized (outWriter) {
            this.wrapped.println(s, l, important);
            ((AbstractLines)this.wrapped.getLines()).markErr();
        }
    }

    public void reset() throws IOException {
        ErrorManager.getDefault().log("Do not call reset() on the error io, only on the output IO.  Reset on the error io does nothing.");
        this.closed = false;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.parent.notifyErrClosed();
        }
    }

    boolean isClosed() {
        return this.closed;
    }

    public void flush() {
        this.wrapped.flush();
    }

    public boolean checkError() {
        return this.wrapped.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c) {
        this.closed = false;
        OutWriter outWriter = this.wrapped;
        synchronized (outWriter) {
            this.wrapped.write(c);
            ((AbstractLines)this.wrapped.getLines()).markErr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buf, int off, int len) {
        this.closed = false;
        OutWriter outWriter = this.wrapped;
        synchronized (outWriter) {
            this.wrapped.write(buf, off, len);
            ((AbstractLines)this.wrapped.getLines()).markErr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s, int off, int len) {
        this.closed = false;
        OutWriter outWriter = this.wrapped;
        synchronized (outWriter) {
            this.wrapped.write(s, off, len);
            ((AbstractLines)this.wrapped.getLines()).markErr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean x) {
        this.closed = false;
        OutWriter outWriter = this.wrapped;
        synchronized (outWriter) {
            this.wrapped.println(x);
            ((AbstractLines)this.wrapped.getLines()).markErr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int x) {
        this.closed = false;
        OutWriter outWriter = this.wrapped;
        synchronized (outWriter) {
            this.wrapped.println(x);
            ((AbstractLines)this.wrapped.getLines()).markErr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char x) {
        this.closed = false;
        OutWriter outWriter = this.wrapped;
        synchronized (outWriter) {
            this.wrapped.println(x);
            ((AbstractLines)this.wrapped.getLines()).markErr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long x) {
        this.closed = false;
        OutWriter outWriter = this.wrapped;
        synchronized (outWriter) {
            this.wrapped.println(x);
            ((AbstractLines)this.wrapped.getLines()).markErr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float x) {
        this.closed = false;
        OutWriter outWriter = this.wrapped;
        synchronized (outWriter) {
            this.wrapped.println(x);
            ((AbstractLines)this.wrapped.getLines()).markErr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double x) {
        this.closed = false;
        OutWriter outWriter = this.wrapped;
        synchronized (outWriter) {
            this.wrapped.println(x);
            ((AbstractLines)this.wrapped.getLines()).markErr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] x) {
        this.closed = false;
        OutWriter outWriter = this.wrapped;
        synchronized (outWriter) {
            this.wrapped.println(x);
            ((AbstractLines)this.wrapped.getLines()).markErr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String x) {
        this.closed = false;
        OutWriter outWriter = this.wrapped;
        synchronized (outWriter) {
            this.wrapped.println(x);
            ((AbstractLines)this.wrapped.getLines()).markErr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object x) {
        this.closed = false;
        OutWriter outWriter = this.wrapped;
        synchronized (outWriter) {
            this.wrapped.println(x);
            ((AbstractLines)this.wrapped.getLines()).markErr();
        }
    }
}

