/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.Version;
import oracle.toplink.essentials.descriptors.TimestampLockingPolicy;
import oracle.toplink.essentials.descriptors.VersionLockingPolicy;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.NonRelationshipAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.sequencing.MetadataGeneratedValue;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.mappings.DirectToFieldMapping;
import oracle.toplink.essentials.mappings.converters.EnumTypeConverter;
import oracle.toplink.essentials.mappings.converters.SerializedObjectConverter;
import oracle.toplink.essentials.mappings.converters.TypeConversionConverter;

public class BasicAccessor
extends NonRelationshipAccessor {
    public BasicAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
    }

    protected MetadataColumn getColumn() {
        Column column = (Column)this.getAnnotation(Column.class);
        return new MetadataColumn(column, this);
    }

    public DatabaseField getDatabaseField() {
        MetadataColumn column = this.m_descriptor.hasAttributeOverrideFor(this.getAttributeName()) ? this.m_descriptor.getAttributeOverrideFor(this.getAttributeName()) : this.getColumn();
        DatabaseField field = column.getDatabaseField();
        field.setName(this.getName(field.getName(), column.getUpperCaseAttributeName(), "metadata_default_column"));
        if (field.getTableName().equals("")) {
            field.setTableName(this.m_descriptor.getPrimaryTableName());
        }
        return field;
    }

    public String getEnumeratedType() {
        Enumerated enumerated = (Enumerated)this.getAnnotation(Enumerated.class);
        if (enumerated == null) {
            return EnumType.ORDINAL.name();
        }
        return enumerated.value().name();
    }

    public String getTemporalType() {
        Temporal temporal = (Temporal)this.getAnnotation(Temporal.class);
        return temporal.value().name();
    }

    public boolean hasEnumerated() {
        return this.isAnnotationPresent(Enumerated.class);
    }

    public boolean hasTemporal() {
        return this.isAnnotationPresent(Temporal.class);
    }

    public boolean isBasic() {
        return true;
    }

    public boolean isEnumerated() {
        return this.hasEnumerated() || MetadataHelper.isValidEnumeratedType(this.getReferenceClass());
    }

    public boolean isId() {
        return this.isAnnotationPresent(Id.class);
    }

    public boolean isLob() {
        return this.isAnnotationPresent(Lob.class);
    }

    public boolean isSerialized() {
        return MetadataHelper.isValidSerializedType(this.getReferenceClass());
    }

    public boolean isTemporal() {
        return this.hasTemporal() || MetadataHelper.isValidTemporalType(this.getReferenceClass());
    }

    public boolean isVersion() {
        return this.isAnnotationPresent(Version.class);
    }

    public void process() {
        DatabaseField field = this.getDatabaseField();
        if (this.isVersion()) {
            if (this.m_descriptor.usesOptimisticLocking()) {
                this.m_logger.logWarningMessage(MetadataLogger.IGNORE_VERSION_LOCKING, this);
            } else {
                this.processVersion(field);
            }
        } else if (this.isId()) {
            this.processId(field);
        }
        if (this.m_descriptor.hasMappingForAttributeName(this.getAttributeName())) {
            this.m_logger.logWarningMessage(MetadataLogger.IGNORE_MAPPING, this);
        } else {
            this.processDirectToFieldMapping(field);
        }
    }

    protected void processDirectToFieldMapping(DatabaseField field) {
        DirectToFieldMapping mapping = new DirectToFieldMapping();
        mapping.setField(field);
        mapping.setIsReadOnly(field.isReadOnly());
        mapping.setAttributeName(this.getAttributeName());
        mapping.setIsOptional(this.isOptional());
        if (this.usesIndirection()) {
            this.m_logger.logWarningMessage("annotation_warning_ignore_basic_fetch_lazy", this);
        }
        this.setAccessorMethods(mapping);
        if (this.isEnumerated()) {
            this.processEnumerated(mapping);
        } else if (this.isLob()) {
            this.processLob(mapping);
        } else if (this.isTemporal()) {
            this.processTemporal(mapping);
        } else if (this.isSerialized()) {
            this.processSerialized(mapping);
        }
        this.m_descriptor.addMapping(mapping);
    }

    protected void processEnumerated(DirectToFieldMapping mapping) {
        if (this.hasEnumerated() && !MetadataHelper.isValidEnumeratedType(this.getReferenceClass())) {
            this.m_validator.throwInvalidTypeForEnumeratedAttribute(this.getJavaClass(), mapping.getAttributeName(), this.getReferenceClass());
        }
        mapping.setConverter(new EnumTypeConverter(mapping, this.getReferenceClassName(), this.getEnumeratedType().equals(EnumType.ORDINAL.name())));
    }

    protected void processGeneratedValue(DatabaseField field) {
        GeneratedValue generatedValue = (GeneratedValue)this.getAnnotation(GeneratedValue.class);
        if (generatedValue != null) {
            this.processGeneratedValue(new MetadataGeneratedValue(generatedValue), field);
        }
    }

    protected void processGeneratedValue(MetadataGeneratedValue generatedValue, DatabaseField sequenceNumberField) {
        DatabaseField existingSequenceNumberField = this.m_descriptor.getSequenceNumberField();
        if (existingSequenceNumberField == null) {
            this.m_descriptor.setSequenceNumberField(sequenceNumberField);
            this.getProject().addGeneratedValue(generatedValue, this.getJavaClass());
        } else {
            this.m_validator.throwOnlyOneGeneratedValueIsAllowed(this.getJavaClass(), existingSequenceNumberField.getQualifiedName(), sequenceNumberField.getQualifiedName());
        }
    }

    protected void processId(DatabaseField field) {
        if (this.m_descriptor.ignoreIDs()) {
            this.m_logger.logWarningMessage(MetadataLogger.IGNORE_PRIMARY_KEY, this);
        } else {
            String attributeName = this.getAttributeName();
            if (this.m_descriptor.hasEmbeddedIdAttribute()) {
                this.m_validator.throwEmbeddedIdAndIdFound(this.getJavaClass(), this.m_descriptor.getEmbeddedIdAttributeName(), attributeName);
            }
            this.m_descriptor.validatePKClassId(attributeName, this.getReferenceClass());
            this.m_descriptor.addIdAttributeName(attributeName);
            this.m_descriptor.addPrimaryKeyField(field);
            this.processGeneratedValue(field);
            this.processTableGenerator();
            this.processSequenceGenerator();
        }
    }

    protected void processLob(DirectToFieldMapping mapping) {
        if (MetadataHelper.isValidClobType(this.getReferenceClass())) {
            mapping.setFieldClassification(Clob.class);
        } else if (MetadataHelper.isValidBlobType(this.getReferenceClass())) {
            mapping.setFieldClassification(Blob.class);
        } else {
            this.m_validator.throwInvalidTypeForLOBAttribute(this.getJavaClass(), mapping.getAttributeName(), this.getReferenceClass());
        }
        mapping.setConverter(new TypeConversionConverter(mapping));
    }

    protected void processSerialized(DirectToFieldMapping mapping) {
        if (Helper.classImplementsInterface(this.getReferenceClass(), Serializable.class)) {
            mapping.setConverter(new SerializedObjectConverter(mapping));
        } else {
            this.m_validator.throwInvalidTypeForSerializedAttribute(this.getJavaClass(), mapping.getAttributeName(), this.getReferenceClass());
        }
    }

    protected void processTemporal(DirectToFieldMapping mapping) {
        if (this.hasTemporal()) {
            if (MetadataHelper.isValidTemporalType(this.getReferenceClass())) {
                mapping.setConverter(new TypeConversionConverter(mapping));
                mapping.setFieldClassification(MetadataHelper.getFieldClassification(this.getTemporalType()));
            } else {
                this.m_validator.throwInvalidTypeForTemporalAttribute(this.getJavaClass(), this.getAttributeName(), this.getReferenceClass());
            }
        } else {
            this.m_validator.throwNoTemporalTypeSpecified(this.getJavaClass(), this.getAttributeName());
        }
    }

    protected void processVersion(DatabaseField field) {
        Class lockType = this.getRawClass();
        field.setType(lockType);
        if (MetadataHelper.isValidVersionLockingType(lockType)) {
            this.m_descriptor.setOptimisticLockingPolicy(new VersionLockingPolicy(field));
        } else if (MetadataHelper.isValidTimstampVersionLockingType(lockType)) {
            this.m_descriptor.setOptimisticLockingPolicy(new TimestampLockingPolicy(field));
        } else {
            this.m_validator.throwInvalidTypeForVersionAttribute(this.getJavaClass(), this.getAttributeName(), lockType);
        }
    }
}

