/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.mappings;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.ConversionException;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.exceptions.OptimisticLockException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.indirection.ValueHolderInterface;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.NonSynchronizedVector;
import oracle.toplink.essentials.internal.queryframework.ContainerPolicy;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.CollectionMapping;
import oracle.toplink.essentials.mappings.RelationalMapping;
import oracle.toplink.essentials.queryframework.DeleteAllQuery;
import oracle.toplink.essentials.queryframework.DeleteObjectQuery;
import oracle.toplink.essentials.queryframework.InsertObjectQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.essentials.queryframework.WriteObjectQuery;

public class OneToManyMapping
extends CollectionMapping
implements RelationalMapping {
    protected transient Vector targetForeignKeyFields;
    protected transient Vector sourceKeyFields;
    protected transient Map targetForeignKeysToSourceKeys = new HashMap(2);
    protected transient Map sourceKeysToTargetForeignKeys = new HashMap(2);

    public OneToManyMapping() {
        this.sourceKeyFields = NonSynchronizedVector.newInstance(1);
        this.targetForeignKeyFields = NonSynchronizedVector.newInstance(1);
        this.deleteAllQuery = new DeleteAllQuery();
    }

    public boolean isRelationalMapping() {
        return true;
    }

    public void addTargetForeignKeyField(DatabaseField targetForeignKeyField, DatabaseField sourceKeyField) {
        this.getTargetForeignKeyFields().addElement(targetForeignKeyField);
        this.getSourceKeyFields().addElement(sourceKeyField);
    }

    public void addTargetForeignKeyFieldName(String targetForeignKeyFieldName, String sourceKeyFieldName) {
        this.addTargetForeignKeyField(new DatabaseField(targetForeignKeyFieldName), new DatabaseField(sourceKeyFieldName));
    }

    protected Expression buildDefaultSelectionCriteria() {
        Expression selectionCriteria = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        for (DatabaseField targetForeignKey : this.getTargetForeignKeysToSourceKeys().keySet()) {
            DatabaseField sourceKey = (DatabaseField)this.getTargetForeignKeysToSourceKeys().get(targetForeignKey);
            Expression partialSelectionCriteria = ((Expression)builder).getField(targetForeignKey).equal(builder.getParameter(sourceKey));
            selectionCriteria = partialSelectionCriteria.and(selectionCriteria);
        }
        return selectionCriteria;
    }

    public Expression buildSelectionCriteria() {
        Expression selectionCriteria = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        Enumeration sourceKeys = this.getSourceKeyFields().elements();
        Enumeration targetForeignKeys = this.getTargetForeignKeyFields().elements();
        while (targetForeignKeys.hasMoreElements()) {
            DatabaseField targetForeignKey = (DatabaseField)targetForeignKeys.nextElement();
            DatabaseField sourceKey = (DatabaseField)sourceKeys.nextElement();
            Expression partialSelectionCriteria = ((Expression)builder).getField(targetForeignKey).equal(builder.getParameter(sourceKey));
            selectionCriteria = partialSelectionCriteria.and(selectionCriteria);
        }
        return selectionCriteria;
    }

    public Object clone() {
        OneToManyMapping clone = (OneToManyMapping)super.clone();
        clone.setTargetForeignKeysToSourceKeys(new HashMap(this.getTargetForeignKeysToSourceKeys()));
        return clone;
    }

    protected void deleteAll(DeleteObjectQuery query) throws DatabaseException {
        Object attribute;
        Vector referenceObjects = null;
        if (this.usesIndirection() && ((attribute = this.getAttributeAccessor().getAttributeValueFromObject(query.getObject())) == null || !((ValueHolderInterface)attribute).isInstantiated())) {
            referenceObjects = new Vector(0);
        }
        if (referenceObjects == null) {
            referenceObjects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        }
        ((DeleteAllQuery)this.getDeleteAllQuery()).executeDeleteAll(query.getSession().getSessionForClass(this.getReferenceClass()), query.getTranslationRow(), this.getContainerPolicy().vectorFor(referenceObjects, query.getSession()));
    }

    protected void deleteReferenceObjectsLeftOnDatabase(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        Object objects = this.readPrivateOwnedForObject(query);
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            query.getSession().deleteObject(cp.next(iter, query.getSession()));
        }
    }

    protected Vector extractForeignKeyFromReferenceObject(Object object, AbstractSession session) {
        Vector<Object> foreignKey = new Vector<Object>(this.getTargetForeignKeysToSourceKeys().size());
        for (Map.Entry entry : this.getTargetForeignKeysToSourceKeys().entrySet()) {
            DatabaseField targetField = (DatabaseField)entry.getKey();
            DatabaseField sourceField = (DatabaseField)entry.getValue();
            if (object == null) {
                foreignKey.addElement(null);
                continue;
            }
            Object value = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, targetField, session);
            try {
                value = session.getDatasourcePlatform().convertObject(value, this.getDescriptor().getObjectBuilder().getFieldClassification(sourceField));
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
            foreignKey.addElement(value);
        }
        return foreignKey;
    }

    protected Vector extractKeyFromRow(AbstractRecord row, AbstractSession session) {
        Vector<Object> key = new Vector<Object>(this.getTargetForeignKeysToSourceKeys().size());
        for (DatabaseField field : this.getTargetForeignKeysToSourceKeys().values()) {
            Object value = row.get(field);
            try {
                value = session.getDatasourcePlatform().convertObject(value, this.getDescriptor().getObjectBuilder().getFieldClassification(field));
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
            key.addElement(value);
        }
        return key;
    }

    public Vector getSourceKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getSourceKeyFields().size());
        Enumeration fieldsEnum = this.getSourceKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(((DatabaseField)fieldsEnum.nextElement()).getQualifiedName());
        }
        return fieldNames;
    }

    public Vector getSourceKeyFields() {
        return this.sourceKeyFields;
    }

    public Map getSourceKeysToTargetForeignKeys() {
        return this.sourceKeysToTargetForeignKeys;
    }

    public Vector getTargetForeignKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getTargetForeignKeyFields().size());
        Enumeration fieldsEnum = this.getTargetForeignKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(((DatabaseField)fieldsEnum.nextElement()).getQualifiedName());
        }
        return fieldNames;
    }

    public Vector getTargetForeignKeyFields() {
        return this.targetForeignKeyFields;
    }

    public Map getTargetForeignKeysToSourceKeys() {
        return this.targetForeignKeysToSourceKeys;
    }

    public Map getTargetForeignKeyToSourceKeys() {
        return this.getTargetForeignKeysToSourceKeys();
    }

    public boolean hasInverseConstraintDependency() {
        return true;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (!this.isSourceKeySpecified()) {
            this.setSourceKeyFields(NonSynchronizedVector.newInstance(this.getDescriptor().getPrimaryKeyFields()));
        }
        this.initializeTargetForeignKeysToSourceKeys();
        if (this.shouldInitializeSelectionCriteria()) {
            this.setSelectionCriteria(this.buildDefaultSelectionCriteria());
        }
        this.initializeDeleteAllQuery();
    }

    protected void initializeDeleteAllQuery() {
        ((DeleteAllQuery)this.getDeleteAllQuery()).setReferenceClass(this.getReferenceClass());
        if (!this.hasCustomDeleteAllQuery()) {
            if (this.getSelectionCriteria() == null) {
                this.getDeleteAllQuery().setSelectionCriteria(this.buildDefaultSelectionCriteria());
            } else {
                this.getDeleteAllQuery().setSelectionCriteria(this.getSelectionCriteria());
            }
        }
    }

    protected void initializeTargetForeignKeysToSourceKeys() throws DescriptorException {
        if (this.getTargetForeignKeyFields().isEmpty()) {
            if (this.shouldInitializeSelectionCriteria()) {
                throw DescriptorException.noTargetForeignKeysSpecified(this);
            }
            return;
        }
        if (this.getTargetForeignKeyFields().size() != this.getSourceKeyFields().size()) {
            throw DescriptorException.targetForeignKeysSizeMismatch(this);
        }
        Enumeration stream = this.getTargetForeignKeyFields().elements();
        while (stream.hasMoreElements()) {
            this.getReferenceDescriptor().buildField((DatabaseField)stream.nextElement());
        }
        Enumeration keys = this.getSourceKeyFields().elements();
        while (keys.hasMoreElements()) {
            this.getDescriptor().buildField((DatabaseField)keys.nextElement());
        }
        Enumeration targetForeignKeys = this.getTargetForeignKeyFields().elements();
        Enumeration sourceKeys = this.getSourceKeyFields().elements();
        while (targetForeignKeys.hasMoreElements()) {
            Object targetForeignKey = targetForeignKeys.nextElement();
            Object sourcePrimaryKey = sourceKeys.nextElement();
            this.getTargetForeignKeysToSourceKeys().put(targetForeignKey, sourcePrimaryKey);
            this.getSourceKeysToTargetForeignKeys().put(sourcePrimaryKey, targetForeignKey);
        }
    }

    public boolean isOneToManyMapping() {
        return true;
    }

    protected boolean isSourceKeySpecified() {
        return !this.getSourceKeyFields().isEmpty();
    }

    protected boolean mustDeleteReferenceObjectsOneByOne() {
        ClassDescriptor referenceDescriptor = this.getReferenceDescriptor();
        return referenceDescriptor.hasDependencyOnParts() || referenceDescriptor.usesOptimisticLocking() || referenceDescriptor.hasInheritance() && referenceDescriptor.getInheritancePolicy().shouldReadSubclasses() || referenceDescriptor.hasMultipleTables();
    }

    public void postInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (query.shouldCascadeOnlyDependentParts()) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            Object object = cp.next(iter, query.getSession());
            if (this.isPrivateOwned()) {
                InsertObjectQuery insertQuery = new InsertObjectQuery();
                insertQuery.setObject(object);
                insertQuery.setCascadePolicy(query.getCascadePolicy());
                query.getSession().executeQuery(insertQuery);
                continue;
            }
            if (query.getSession().getCommitManager().isCommitInPreModify(object)) continue;
            ObjectChangeSet changeSet = null;
            UnitOfWorkChangeSet uowChangeSet = null;
            if (query.getSession().isUnitOfWork() && ((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet() != null) {
                uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet();
                changeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(object);
            }
            WriteObjectQuery writeQuery = new WriteObjectQuery();
            writeQuery.setObject(object);
            writeQuery.setCascadePolicy(query.getCascadePolicy());
            query.getSession().executeQuery(writeQuery);
        }
    }

    public void postUpdate(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (!this.isAttributeValueInstantiated(query.getObject())) {
            return;
        }
        Object objectsInMemory = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        Object objectsInDB = this.readPrivateOwnedForObject(query);
        this.compareObjectsAndWrite(objectsInDB, objectsInMemory, query);
    }

    public void preDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (this.mustDeleteReferenceObjectsOneByOne()) {
            Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
            ContainerPolicy cp = this.getContainerPolicy();
            Object iter = cp.iteratorFor(objects);
            while (cp.hasNext(iter)) {
                DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
                deleteQuery.setObject(cp.next(iter, query.getSession()));
                deleteQuery.setCascadePolicy(query.getCascadePolicy());
                query.getSession().executeQuery(deleteQuery);
            }
            if (!query.getSession().isUnitOfWork()) {
                this.deleteReferenceObjectsLeftOnDatabase(query);
            }
        } else {
            this.deleteAll(query);
        }
    }

    public void setDeleteAllSQLString(String sqlString) {
        DeleteAllQuery query = new DeleteAllQuery();
        query.setSQLString(sqlString);
        this.setCustomDeleteAllQuery(query);
    }

    public void setSourceKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setSourceKeyFields(fields);
    }

    public void setSourceKeyFields(Vector sourceKeyFields) {
        this.sourceKeyFields = sourceKeyFields;
    }

    public void setTargetForeignKeyFieldName(String targetForeignKeyFieldName) {
        this.getTargetForeignKeyFields().addElement(new DatabaseField(targetForeignKeyFieldName));
    }

    public void setTargetForeignKeyFieldNames(String[] targetForeignKeyFieldNames, String[] sourceKeyFieldNames) {
        if (targetForeignKeyFieldNames.length != sourceKeyFieldNames.length) {
            throw DescriptorException.targetForeignKeysSizeMismatch(this);
        }
        for (int i = 0; i < targetForeignKeyFieldNames.length; ++i) {
            this.addTargetForeignKeyFieldName(targetForeignKeyFieldNames[i], sourceKeyFieldNames[i]);
        }
    }

    public void setTargetForeignKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setTargetForeignKeyFields(fields);
    }

    public void setTargetForeignKeyFields(Vector targetForeignKeyFields) {
        this.targetForeignKeyFields = targetForeignKeyFields;
    }

    protected void setTargetForeignKeysToSourceKeys(Map targetForeignKeysToSourceKeys) {
        this.targetForeignKeysToSourceKeys = targetForeignKeysToSourceKeys;
    }

    protected boolean shouldObjectModifyCascadeToParts(ObjectLevelModifyQuery query) {
        if (this.isReadOnly()) {
            return false;
        }
        if (this.isPrivateOwned()) {
            return true;
        }
        return query.shouldCascadeAllParts();
    }

    public boolean isCascadedLockingSupported() {
        return true;
    }

    public boolean isJoiningSupported() {
        return true;
    }

    public boolean verifyDelete(Object object, AbstractSession session) throws DatabaseException {
        if (this.isPrivateOwned()) {
            Object objects = this.getRealCollectionAttributeValueFromObject(object, session);
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object iter = containerPolicy.iteratorFor(objects);
            while (containerPolicy.hasNext(iter)) {
                if (session.verifyDelete(containerPolicy.next(iter, session))) continue;
                return false;
            }
        }
        return true;
    }
}

