/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.JTextComponent;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.SheetTable;
import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;

class ComboInplaceEditor
extends JComboBox
implements InplaceEditor,
FocusListener,
AncestorListener {
    static final KeyStroke[] cbKeyStrokes = new KeyStroke[]{KeyStroke.getKeyStroke(40, 0, false), KeyStroke.getKeyStroke(38, 0, false), KeyStroke.getKeyStroke(40, 0, true), KeyStroke.getKeyStroke(38, 0, true), KeyStroke.getKeyStroke(34, 0, false), KeyStroke.getKeyStroke(33, 0, false), KeyStroke.getKeyStroke(34, 0, true), KeyStroke.getKeyStroke(33, 0, true)};
    private static PopupChecker checker = null;
    protected PropertyEditor editor;
    protected PropertyEnv env;
    protected PropertyModel mdl;
    boolean inSetUI = false;
    private boolean tableUI;
    private boolean connecting = false;
    private boolean hasBeenEditable = false;
    private boolean needLayout = false;

    public ComboInplaceEditor(boolean tableUI) {
        if (tableUI) {
            this.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        }
        if (Boolean.getBoolean("netbeans.ps.combohack")) {
            this.setLightWeightPopupEnabled(false);
        }
        if (this.getClass() == ComboInplaceEditor.class) {
            this.enableEvents(4L);
        }
        this.tableUI = tableUI;
        if (tableUI) {
            this.updateUI();
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.isEditable() && this.getClass() == ComboInplaceEditor.class) {
            this.getEditor().getEditorComponent().addFocusListener(this);
        }
        this.getLayout().layoutContainer(this);
    }

    public void setEditable(boolean val) {
        boolean hadBeenEditable = this.hasBeenEditable;
        this.hasBeenEditable |= val;
        super.setEditable(val);
        if (hadBeenEditable != this.hasBeenEditable) {
            this.log("Combo editor for " + this.editor + " setEditable (" + val + ")");
            this.needLayout = true;
        }
    }

    public void removeNotify() {
        this.log("Combo editor for " + this.editor + " removeNotify forcing popup close");
        this.setPopupVisible(false);
        super.removeNotify();
        this.getEditor().getEditorComponent().removeFocusListener(this);
    }

    public Insets getInsets() {
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            return new Insets(0, 0, 0, 0);
        }
        return super.getInsets();
    }

    public void clear() {
        this.editor = null;
        this.env = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(PropertyEditor pe, PropertyEnv env) {
        this.connecting = true;
        try {
            this.log("Combo editor connect to " + pe + " env=" + env);
            this.env = env;
            this.editor = pe;
            this.setModel(new DefaultComboBoxModel<String>(pe.getTags()));
            boolean editable = this.editor instanceof EnhancedPropertyEditor ? ((EnhancedPropertyEditor)this.editor).supportsEditingTaggedValues() : env != null && Boolean.TRUE.equals(env.getFeatureDescriptor().getValue("canEditAsText"));
            this.setEditable(editable);
            this.setActionCommand("success");
            this.reset();
        }
        finally {
            this.connecting = false;
        }
    }

    private void log(String s) {
        if (PropUtils.isLoggable(ComboInplaceEditor.class) && this.getClass() == ComboInplaceEditor.class) {
            PropUtils.log(ComboInplaceEditor.class, s);
        }
    }

    public void setSelectedItem(Object o) {
        if (o == null && this.editor != null && this.editor.getTags() != null && this.editor.getTags().length > 0) {
            o = this.editor.getTags()[0];
        }
        if (o != null) {
            super.setSelectedItem(o);
        }
    }

    public void fireActionEvent() {
        if (this.connecting || this.editor == null) {
            return;
        }
        if (this.editor == null) {
            return;
        }
        if ("comboBoxEdited".equals(this.getActionCommand())) {
            this.log("Translating comboBoxEdited action command to COMMAND_SUCCESS");
            this.setActionCommand("success");
        }
        this.log("Combo editor firing ActionPerformed command=" + this.getActionCommand());
        super.fireActionEvent();
    }

    public void reset() {
        String initialEditValue;
        String targetValue = null;
        if (this.editor != null) {
            this.log("Combo editor reset setting selected item to " + this.editor.getAsText());
            targetValue = this.editor.getAsText();
        }
        if (this.getClass() == ComboInplaceEditor.class && this.env != null && this.env.getFeatureDescriptor() != null && (initialEditValue = (String)this.env.getFeatureDescriptor().getValue("initialEditValue")) != null) {
            targetValue = initialEditValue;
        }
        this.setSelectedItem(targetValue);
    }

    public Object getValue() {
        if (this.isEditable()) {
            return this.getEditor().getItem();
        }
        return this.getSelectedItem();
    }

    public PropertyEditor getPropertyEditor() {
        return this.editor;
    }

    public PropertyModel getPropertyModel() {
        return this.mdl;
    }

    public void setPropertyModel(PropertyModel pm) {
        this.log("Combo editor set property model to " + pm);
        this.mdl = pm;
    }

    public JComponent getComponent() {
        return this;
    }

    public KeyStroke[] getKeyStrokes() {
        return cbKeyStrokes;
    }

    public void handleInitialInputEvent(InputEvent e) {
    }

    public void updateUI() {
        boolean useClean;
        LookAndFeel lf = UIManager.getLookAndFeel();
        String id = lf.getID();
        boolean bl = useClean = this.tableUI && (lf instanceof MetalLookAndFeel || "GTK".equals(id) || "Kunststoff".equals(id));
        if (useClean) {
            super.setUI(PropUtils.createComboUI(this, this.tableUI));
        } else {
            super.updateUI();
        }
        if (this.tableUI & this.getEditor().getEditorComponent() instanceof JComponent) {
            ((JComponent)this.getEditor().getEditorComponent()).setBorder(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUI(ComboBoxUI ui) {
        this.inSetUI = true;
        try {
            super.setUI(ui);
        }
        finally {
            this.inSetUI = false;
        }
    }

    public void showPopup() {
        try {
            this.log(" Combo editor show popup");
            super.showPopup();
        }
        catch (NullPointerException e) {
            this.log(" Combo editor show popup later due to npe");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ComboInplaceEditor.super.showPopup();
                }
            });
        }
    }

    private void prepareEditor() {
        Component c = this.getEditor().getEditorComponent();
        if (c instanceof JTextComponent) {
            JTextComponent jtc = (JTextComponent)c;
            String s = jtc.getText();
            if (s != null && s.length() > 0) {
                jtc.setSelectionStart(0);
                jtc.setSelectionEnd(s.length());
            }
            if (this.tableUI) {
                jtc.setBackground(this.getBackground());
            } else {
                jtc.setBackground(PropUtils.getTextFieldBackground());
            }
        }
        if (this.getLayout() != null) {
            this.getLayout().layoutContainer(this);
        }
        this.repaint();
    }

    /*
     * Unable to fully structure code
     */
    public void processFocusEvent(FocusEvent fe) {
        super.processFocusEvent(fe);
        if (PropUtils.isLoggable(ComboInplaceEditor.class)) {
            PropUtils.log(ComboInplaceEditor.class, "Focus event on combo editor");
            PropUtils.log(ComboInplaceEditor.class, fe);
        }
        focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (!this.isDisplayable()) ** GOTO lbl-1000
        if (fe.getID() == 1004 && focusOwner == this && !this.isPopupVisible()) {
            if (this.isEditable()) {
                this.prepareEditor();
            } else if (this.tableUI) {
                this.showPopup();
                SwingUtilities.invokeLater(new PopupChecker());
            }
            this.repaint();
        } else if (fe.getID() == 1005 && this.isPopupVisible() && !this.isDisplayable()) {
            if (!PropUtils.psCommitOnFocusLoss) {
                this.setActionCommand("failure");
                this.fireActionEvent();
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!ComboInplaceEditor.this.isDisplayable()) {
                        ComboInplaceEditor.this.hidePopup();
                    }
                }
            });
        }
        this.repaint();
    }

    public boolean isKnownComponent(Component c) {
        return c == this.getEditor().getEditorComponent();
    }

    public void setValue(Object o) {
        this.setSelectedItem(o);
    }

    public boolean supportsTextEntry() {
        return this.isEditable();
    }

    protected void installAncestorListener() {
        if (this.tableUI) {
            this.addAncestorListener(this);
        } else {
            super.installAncestorListener();
        }
    }

    public void addFocusListener(FocusListener fl) {
        if (!this.inSetUI || !this.tableUI) {
            super.addFocusListener(fl);
        }
    }

    public void focusGained(FocusEvent e) {
        this.prepareEditor();
    }

    public void focusLost(FocusEvent e) {
        Component c = e.getOppositeComponent();
        if (!this.isAncestorOf(c) && c != this.getEditor().getEditorComponent()) {
            if (c == this || c instanceof SheetTable && ((SheetTable)c).isAncestorOf(this)) {
                return;
            }
            this.setActionCommand("failure");
            this.log(" Combo editor lost focus - setting action command to failure");
            this.getEditor().getEditorComponent().removeFocusListener(this);
            if (checker == null) {
                this.log("No active popup checker, firing action event");
                this.fireActionEvent();
            }
        }
    }

    public void firePopupMenuCanceled() {
        super.firePopupMenuCanceled();
        if (this.isEditable()) {
            Component focus = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (this.isDisplayable() && focus == this) {
                this.log("combo editor popup menu canceled.  Requesting focus on editor component");
                this.getEditor().getEditorComponent().requestFocus();
            }
        }
    }

    public void processKeyEvent(KeyEvent ke) {
        super.processKeyEvent(ke);
        if (ke.getID() == 401) {
            if (ke.getKeyCode() == 27) {
                this.setActionCommand("failure");
                this.fireActionEvent();
            }
        }
    }

    public void ancestorAdded(AncestorEvent event) {
        checker = new PopupChecker();
        SwingUtilities.invokeLater(checker);
    }

    public void ancestorMoved(AncestorEvent event) {
        if (this.needLayout && this.getLayout() != null) {
            this.getLayout().layoutContainer(this);
        }
    }

    public void ancestorRemoved(AncestorEvent event) {
    }

    public void paintChildren(Graphics g) {
        if (this.editor != null && !this.hasFocus() && this.editor.isPaintable()) {
            return;
        }
        super.paintChildren(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g) {
        if (this.editor != null && !this.hasFocus() && this.editor.isPaintable()) {
            Insets ins = this.getInsets();
            Color c = g.getColor();
            try {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            finally {
                g.setColor(c);
            }
            ins.left += PropUtils.getTextMargin();
            this.editor.paintValue(g, new Rectangle(ins.left, ins.top, this.getWidth() - (ins.right + ins.left), this.getHeight() - (ins.top + ins.bottom)));
        } else {
            super.paintComponent(g);
        }
    }

    private class Renderer
    extends DefaultListCellRenderer {
        private boolean sel = false;

        private Renderer() {
        }

        public Color getBackground() {
            if (ComboInplaceEditor.this == null) {
                return null;
            }
            if (!this.sel && this.getText() != null && ComboInplaceEditor.this.getSelectedItem() != null && this.getText().equals(ComboInplaceEditor.this.getSelectedItem())) {
                return ComboInplaceEditor.this.getBackground();
            }
            return super.getBackground();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.sel = isSelected;
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private class PopupChecker
    implements Runnable {
        private PopupChecker() {
        }

        public void run() {
            Window w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            if (null != w && w.isAncestorOf(ComboInplaceEditor.this)) {
                if (ComboInplaceEditor.this.isShowing() && !ComboInplaceEditor.this.isPopupVisible()) {
                    ComboInplaceEditor.this.log("Popup checker ensuring editor prepared or popup visible");
                    if (ComboInplaceEditor.this.isEditable()) {
                        ComboInplaceEditor.this.prepareEditor();
                    } else {
                        ComboInplaceEditor.this.showPopup();
                    }
                }
                checker = null;
            }
        }
    }
}

