/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import org.netbeans.modules.welcome.WelcomeOptions;
import org.netbeans.modules.welcome.content.ContentFactory;
import org.netbeans.modules.welcome.content.ContentPanel;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class WelcomeComponent
extends TopComponent {
    static final long serialVersionUID = 6021472310161712674L;
    private static WeakReference component = new WeakReference<Object>(null);
    private JComponent content;
    private boolean initialized = false;
    private static boolean firstTimeOpen = true;

    private WelcomeComponent() {
        this.setLayout(new BorderLayout());
        this.setName(NbBundle.getMessage((Class)WelcomeComponent.class, (String)"LBL_Tab_Title"));
        this.content = null;
        this.initialized = false;
    }

    protected String preferredID() {
        return "WelcomeComponent";
    }

    private void doInitialize() {
        this.initAccessibility();
        this.content = ContentFactory.createContentPane();
        if (null == this.content) {
            return;
        }
        this.add(this.content, "Center");
        this.setFocusable(false);
    }

    public static WelcomeComponent findComp() {
        WelcomeComponent wc = (WelcomeComponent)((Object)component.get());
        if (wc == null) {
            TopComponent tc = WindowManager.getDefault().findTopComponent("Welcome");
            if (tc != null) {
                if (tc instanceof WelcomeComponent) {
                    wc = (WelcomeComponent)tc;
                    component = new WeakReference<WelcomeComponent>(wc);
                } else {
                    IllegalStateException exc = new IllegalStateException("Incorrect settings file. Unexpected class returned. Expected:" + WelcomeComponent.class.getName() + " Returned:" + tc.getClass().getName());
                    ErrorManager.getDefault().notify(1, (Throwable)exc);
                    wc = WelcomeComponent.createComp();
                }
            } else {
                wc = WelcomeComponent.createComp();
            }
        }
        return wc;
    }

    public static WelcomeComponent createComp() {
        WelcomeComponent wc = (WelcomeComponent)((Object)component.get());
        if (wc == null) {
            wc = new WelcomeComponent();
            component = new WeakReference<WelcomeComponent>(wc);
        }
        return wc;
    }

    public int getPersistenceType() {
        return 2;
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)WelcomeComponent.class, (String)"ACS_Welcome_DESC"));
    }

    public void addNotify() {
        if (!this.initialized) {
            this.initialized = true;
            this.doInitialize();
        }
        super.addNotify();
    }

    protected void componentShowing() {
        if (!this.initialized) {
            this.initialized = true;
            this.doInitialize();
        }
        super.componentShowing();
        this.setActivatedNodes(new Node[0]);
    }

    protected void componentOpened() {
        super.componentOpened();
        if (firstTimeOpen) {
            firstTimeOpen = false;
            if (!WelcomeOptions.getDefault().isShowOnStartup()) {
                this.close();
            }
        }
    }

    protected void componentActivated() {
        super.componentActivated();
        this.focusAnyContentPanel(this.content);
    }

    private boolean focusAnyContentPanel(Container comp) {
        Component[] children = comp.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] instanceof ContentPanel) {
                ((ContentPanel)children[i]).switchFocus();
                return true;
            }
            if (!(children[i] instanceof Container) || !this.focusAnyContentPanel((Container)children[i])) continue;
            return true;
        }
        return false;
    }
}

