/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.status;

import java.util.Iterator;
import java.util.List;
import org.apache.catalina.ant.BaseRedirectorHelperTask;
import org.apache.jk.status.JkBalancer;
import org.apache.jk.status.JkBalancerMapping;
import org.apache.jk.status.JkBalancerMember;
import org.apache.jk.status.JkServer;
import org.apache.jk.status.JkStatus;
import org.apache.jk.status.JkStatusAccessor;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tools.ant.BuildException;

public class JkStatusTask
extends BaseRedirectorHelperTask {
    protected String resultproperty;
    protected boolean echo = false;
    protected String password = null;
    protected String url = "http://localhost:80/jkstatus";
    protected String username = null;
    private String errorProperty;
    private String worker;
    private String loadbalancer;

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isEcho() {
        return this.echo;
    }

    public void setEcho(boolean echo) {
        this.echo = echo;
    }

    public String getResultproperty() {
        return this.resultproperty;
    }

    public void setResultproperty(String resultproperty) {
        this.resultproperty = resultproperty;
    }

    public String getLoadbalancer() {
        return this.loadbalancer;
    }

    public void setLoadbalancer(String loadbalancer) {
        this.loadbalancer = loadbalancer;
    }

    public String getWorker() {
        return this.worker;
    }

    public void setWorker(String worker) {
        this.worker = worker;
    }

    public void execute() throws BuildException {
        if (this.url == null) {
            throw new BuildException("Must specify an 'url'");
        }
        boolean isWorkerOnly = this.worker != null && !"".equals(this.worker);
        boolean isLoadbalancerOnly = this.loadbalancer != null && !"".equals(this.loadbalancer);
        StringBuffer error = new StringBuffer();
        try {
            JkStatusAccessor accessor = new JkStatusAccessor();
            JkStatus status = accessor.status(this.url, this.username, this.password);
            if (!isWorkerOnly && !isLoadbalancerOnly) {
                JkServer server = status.getServer();
                if (this.resultproperty != null) {
                    this.createProperty(server, "name");
                    this.createProperty(server, "port");
                    this.createProperty(server, "version");
                    this.createProperty(server, "software");
                }
                if (this.isEcho()) {
                    this.handleOutput("server name=" + server.getName() + "." + server.getPort() + " - " + server.getSoftware());
                }
            }
            List balancers = status.getBalancers();
            Iterator iter = balancers.iterator();
            while (iter.hasNext()) {
                JkBalancer balancer = (JkBalancer)iter.next();
                String balancerIndex = null;
                if (isLoadbalancerOnly) {
                    if (!this.loadbalancer.equals(balancer.getName())) continue;
                    if (this.resultproperty != null) {
                        this.setPropertyBalancerOnly(balancer);
                    }
                    this.echoBalancer(balancer);
                    return;
                }
                if (!isWorkerOnly) {
                    if (this.resultproperty != null) {
                        balancerIndex = Integer.toString(balancer.getId());
                        this.setPropertyBalancer(balancer, balancerIndex);
                    }
                    this.echoBalancer(balancer);
                }
                List members = balancer.getBalancerMembers();
                Iterator iterator = members.iterator();
                while (iterator.hasNext()) {
                    JkBalancerMember member = (JkBalancerMember)iterator.next();
                    if (isWorkerOnly) {
                        if (!this.worker.equals(member.getName())) continue;
                        if (this.resultproperty != null) {
                            this.setPropertyWorkerOnly(balancer, member);
                        }
                        this.echoWorker(member);
                        return;
                    }
                    if (this.resultproperty != null) {
                        this.setPropertyWorker(balancerIndex, member);
                    }
                    this.echoWorker(member);
                    if ("OK".equals(member.getStatus())) continue;
                    error.append(" worker name=" + member.getName() + " status=" + member.getStatus() + " host=" + member.getAddress());
                }
                if (isWorkerOnly) continue;
                if (this.resultproperty != null && members.size() > 0) {
                    this.getProject().setNewProperty(this.resultproperty + ".balancer." + balancerIndex + ".member.length", Integer.toString(members.size()));
                }
                List mappings = balancer.getBalancerMappings();
                int j = 0;
                Iterator iterator2 = mappings.iterator();
                while (iterator2.hasNext()) {
                    JkBalancerMapping mapping = (JkBalancerMapping)iterator2.next();
                    if (this.resultproperty != null) {
                        String stringIndex2 = Integer.toString(j);
                        this.createProperty(mapping, balancerIndex, stringIndex2, "type");
                        this.createProperty(mapping, balancerIndex, stringIndex2, "uri");
                        this.createProperty(mapping, balancerIndex, stringIndex2, "context");
                    }
                    if (this.isEcho()) {
                        this.handleOutput("balancer name=" + balancer.getName() + " mappingtype=" + mapping.getType() + " uri=" + mapping.getUri() + " context=" + mapping.getContext());
                    }
                    ++j;
                }
                if (this.resultproperty == null || mappings.size() <= 0) continue;
                this.getProject().setNewProperty(this.resultproperty + ".balancer." + balancerIndex + ".map.length", Integer.toString(mappings.size()));
            }
            if (!isWorkerOnly && !isLoadbalancerOnly && this.resultproperty != null && balancers.size() > 0) {
                this.getProject().setNewProperty(this.resultproperty + ".balancer.length", Integer.toString(balancers.size()));
            }
        }
        catch (Throwable t) {
            error.append(t.getMessage());
            if (this.getErrorProperty() != null) {
                this.getProject().setNewProperty(this.errorProperty, error.toString());
            }
            if (this.isFailOnError()) {
                throw new BuildException(t);
            }
            this.handleErrorOutput(t.getMessage());
            return;
        }
        if (error.length() != 0) {
            if (this.getErrorProperty() != null) {
                this.getProject().setNewProperty(this.errorProperty, error.toString());
            }
            if (this.isFailOnError()) {
                throw new BuildException(error.toString());
            }
        }
    }

    private void echoWorker(JkBalancerMember member) {
        if (this.isEcho()) {
            this.handleOutput("worker name=" + member.getName() + " status=" + member.getStatus() + " host=" + member.getAddress());
        }
    }

    private void echoBalancer(JkBalancer balancer) {
        if (this.isEcho()) {
            this.handleOutput("balancer name=" + balancer.getName() + " type=" + balancer.getType());
        }
    }

    private void setPropertyBalancerOnly(JkBalancer balancer) {
        String prefix = this.resultproperty + "." + balancer.getName();
        this.getProject().setNewProperty(prefix + ".id", Integer.toString(balancer.getId()));
        this.getProject().setNewProperty(prefix + ".type", balancer.getType());
        this.getProject().setNewProperty(prefix + ".sticky", Boolean.toString(balancer.isSticky()));
        this.getProject().setNewProperty(prefix + ".stickyforce", Boolean.toString(balancer.isStickyforce()));
        this.getProject().setNewProperty(prefix + ".retries", Integer.toString(balancer.getRetries()));
        this.getProject().setNewProperty(prefix + ".recover", Integer.toString(balancer.getRecover()));
    }

    private void setPropertyBalancer(JkBalancer balancer, String balancerIndex) {
        this.createProperty(balancer, balancerIndex, "id");
        this.createProperty(balancer, balancerIndex, "name");
        this.createProperty(balancer, balancerIndex, "type");
        this.createProperty(balancer, balancerIndex, "sticky");
        this.createProperty(balancer, balancerIndex, "stickyforce");
        this.createProperty(balancer, balancerIndex, "retries");
        this.createProperty(balancer, balancerIndex, "recover");
    }

    private void setPropertyWorker(String balancerIndex, JkBalancerMember member) {
        String workerIndex = Integer.toString(member.getId());
        this.createProperty(member, balancerIndex, workerIndex, "id");
        this.createProperty(member, balancerIndex, workerIndex, "name");
        this.createProperty(member, balancerIndex, workerIndex, "type");
        this.createProperty(member, balancerIndex, workerIndex, "host");
        this.createProperty(member, balancerIndex, workerIndex, "port");
        this.createProperty(member, balancerIndex, workerIndex, "address");
        this.createProperty(member, balancerIndex, workerIndex, "status");
        this.createProperty(member, balancerIndex, workerIndex, "lbfactor");
        this.createProperty(member, balancerIndex, workerIndex, "lbvalue");
        this.createProperty(member, balancerIndex, workerIndex, "elected");
        this.createProperty(member, balancerIndex, workerIndex, "readed");
        this.createProperty(member, balancerIndex, workerIndex, "busy");
        this.createProperty(member, balancerIndex, workerIndex, "transferred");
        this.createProperty(member, balancerIndex, workerIndex, "errors");
        if (member.getDomain() != null) {
            this.createProperty(member, balancerIndex, workerIndex, "domain");
        } else {
            this.getProject().setNewProperty(this.resultproperty + ".balancer." + balancerIndex + ".member." + workerIndex + ".domain", "");
        }
        if (member.getRedirect() != null) {
            this.createProperty(member, balancerIndex, workerIndex, "redirect");
        } else {
            this.getProject().setNewProperty(this.resultproperty + ".balancer." + balancerIndex + ".member." + workerIndex + ".redirect", "");
        }
    }

    private void setPropertyWorkerOnly(JkBalancer balancer, JkBalancerMember member) {
        String prefix = this.resultproperty + "." + member.getName();
        this.getProject().setNewProperty(prefix + ".lb.id", Integer.toString(balancer.getId()));
        this.getProject().setNewProperty(prefix + ".lb.name", balancer.getName());
        this.getProject().setNewProperty(prefix + ".id", Integer.toString(member.getId()));
        this.getProject().setNewProperty(prefix + ".type", member.getType());
        this.getProject().setNewProperty(prefix + ".status", member.getStatus());
        this.getProject().setNewProperty(prefix + ".host", member.getHost());
        this.getProject().setNewProperty(prefix + ".address", member.getAddress());
        this.getProject().setNewProperty(prefix + ".port", Integer.toString(member.getPort()));
        this.getProject().setNewProperty(prefix + ".lbfactor", Integer.toString(member.getLbfactor()));
        this.getProject().setNewProperty(prefix + ".lbvalue", Long.toString(member.getLbvalue()));
        this.getProject().setNewProperty(prefix + ".elected", Long.toString(member.getElected()));
        this.getProject().setNewProperty(prefix + ".readed", Long.toString(member.getReaded()));
        this.getProject().setNewProperty(prefix + ".transferred", Long.toString(member.getTransferred()));
        this.getProject().setNewProperty(prefix + ".busy", Integer.toString(member.getBusy()));
        this.getProject().setNewProperty(prefix + ".errors", Long.toString(member.getErrors()));
        if (member.getDomain() != null) {
            this.getProject().setNewProperty(prefix + ".domain", member.getDomain());
        } else {
            this.getProject().setNewProperty(prefix + ".domain", "");
        }
        if (member.getRedirect() != null) {
            this.getProject().setNewProperty(prefix + ".redirect", member.getRedirect());
        } else {
            this.getProject().setNewProperty(prefix + ".redirect", "");
        }
    }

    public void setErrorProperty(String arg0) {
        this.errorProperty = arg0;
        super.setErrorProperty(arg0);
    }

    public String getErrorProperty() {
        return this.errorProperty;
    }

    protected void createProperty(Object result, String attribute) {
        this.createProperty(result, null, null, attribute);
    }

    protected void createProperty(Object result, String arraymark, String attribute) {
        this.createProperty(result, arraymark, null, attribute);
    }

    protected void createProperty(Object result, String arraymark, String arraymark2, String attribute) {
        Object value;
        if (this.resultproperty != null && (value = IntrospectionUtils.getProperty((Object)result, (String)attribute)) != null) {
            StringBuffer propertyname = new StringBuffer(this.resultproperty);
            if (result instanceof JkServer) {
                propertyname.append(".server");
            } else if (result instanceof JkBalancer) {
                propertyname.append(".balancer");
                if (arraymark != null) {
                    propertyname.append(".");
                    propertyname.append(arraymark);
                }
            } else if (result instanceof JkBalancerMember) {
                propertyname.append(".balancer");
                if (arraymark != null) {
                    propertyname.append(".");
                    propertyname.append(arraymark);
                }
                propertyname.append(".member");
                if (arraymark2 != null) {
                    propertyname.append(".");
                    propertyname.append(arraymark2);
                }
            } else if (result instanceof JkBalancerMapping) {
                propertyname.append(".balancer");
                if (arraymark != null) {
                    propertyname.append(".");
                    propertyname.append(arraymark);
                }
                propertyname.append(".map");
                if (arraymark2 != null) {
                    propertyname.append(".");
                    propertyname.append(arraymark2);
                }
            }
            propertyname.append(".");
            propertyname.append(attribute);
            this.getProject().setNewProperty(propertyname.toString(), value.toString());
        }
    }
}

