/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.colors;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.netbeans.modules.options.colors.AnnotationsPanel;
import org.netbeans.modules.options.colors.ColorModel;
import org.netbeans.modules.options.colors.HighlightingPanel;
import org.netbeans.modules.options.colors.SyntaxColoringPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class FontAndColorsPanel
extends JPanel
implements ActionListener {
    private JComboBox cbProfiles = new JComboBox();
    private JButton bDelete = new JButton();
    private JButton bClone = new JButton();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private SyntaxColoringPanel syntaxColoringPanel;
    private HighlightingPanel highlightingPanel;
    private AnnotationsPanel annotationsPanel;
    private ColorModel colorModel;
    private String currentProfile;
    private boolean listen = false;

    public FontAndColorsPanel() {
        this.cbProfiles.getAccessibleContext().setAccessibleName(FontAndColorsPanel.loc("AN_Profiles"));
        this.cbProfiles.getAccessibleContext().setAccessibleDescription(FontAndColorsPanel.loc("AD_Profiles"));
        this.bDelete.getAccessibleContext().setAccessibleName(FontAndColorsPanel.loc("AN_Delete"));
        this.bDelete.getAccessibleContext().setAccessibleDescription(FontAndColorsPanel.loc("AD_Delete"));
        this.bClone.getAccessibleContext().setAccessibleName(FontAndColorsPanel.loc("AN_Clone"));
        this.bClone.getAccessibleContext().setAccessibleDescription(FontAndColorsPanel.loc("AD_Clone"));
        this.tabbedPane.getAccessibleContext().setAccessibleName(FontAndColorsPanel.loc("AN_Categories"));
        this.tabbedPane.getAccessibleContext().setAccessibleDescription(FontAndColorsPanel.loc("AD_Categories"));
        this.syntaxColoringPanel = new SyntaxColoringPanel(this);
        this.highlightingPanel = new HighlightingPanel(this);
        this.annotationsPanel = new AnnotationsPanel(this);
        this.cbProfiles.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                if (!FontAndColorsPanel.this.listen) {
                    return;
                }
                FontAndColorsPanel.this.setCurrentProfile((String)FontAndColorsPanel.this.cbProfiles.getSelectedItem());
            }
        });
        JPanel pButtons = new JPanel(new GridLayout(1, 2, 3, 3));
        FontAndColorsPanel.loc(this.bClone, "CTL_Create_New");
        this.bClone.addActionListener(this);
        pButtons.add(this.bClone);
        FontAndColorsPanel.loc(this.bDelete, "CTL_Delete");
        this.bDelete.addActionListener(this);
        pButtons.add(this.bDelete);
        FormLayout layout = new FormLayout("p, 3dlu, p:g, 5dlu, p", "p, 5dlu, f:p:g");
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        CellConstraints cc = new CellConstraints();
        CellConstraints lc = new CellConstraints();
        builder.addLabel(FontAndColorsPanel.loc("CTL_Color_Profile_Name"), lc.xy(1, 1), (Component)this.cbProfiles, cc.xy(3, 1));
        builder.add((Component)pButtons, cc.xy(5, 1, "l,d"));
        builder.add((Component)this.tabbedPane, cc.xyw(1, 3, 5));
        this.tabbedPane.addTab(FontAndColorsPanel.loc("Syntax_coloring_tab"), this.syntaxColoringPanel);
        this.tabbedPane.addTab(FontAndColorsPanel.loc("Editor_tab"), this.highlightingPanel);
        this.tabbedPane.addTab(FontAndColorsPanel.loc("Annotations_tab"), this.annotationsPanel);
        this.tabbedPane.setMnemonicAt(0, FontAndColorsPanel.loc("Syntax_coloring_tab_mnemonic").charAt(0));
        this.tabbedPane.setMnemonicAt(1, FontAndColorsPanel.loc("Editor_tab_mnemonic").charAt(0));
        this.tabbedPane.setMnemonicAt(2, FontAndColorsPanel.loc("Annotations_tab_mnemonic").charAt(0));
    }

    private void setCurrentProfile(String profile) {
        if (this.colorModel.isCustomProfile(profile)) {
            FontAndColorsPanel.loc(this.bDelete, "CTL_Delete");
        } else {
            FontAndColorsPanel.loc(this.bDelete, "CTL_Restore");
        }
        this.currentProfile = profile;
        this.highlightingPanel.setCurrentProfile(this.currentProfile);
        this.syntaxColoringPanel.setCurrentProfile(this.currentProfile);
        this.annotationsPanel.setCurrentProfile(this.currentProfile);
    }

    private void deleteCurrentProfile() {
        String currentProfile = (String)this.cbProfiles.getSelectedItem();
        this.highlightingPanel.deleteProfile(currentProfile);
        this.syntaxColoringPanel.deleteProfile(currentProfile);
        this.annotationsPanel.deleteProfile(currentProfile);
        if (this.colorModel.isCustomProfile(currentProfile)) {
            this.cbProfiles.removeItem(currentProfile);
            this.cbProfiles.setSelectedIndex(0);
        }
    }

    void update() {
        if (this.colorModel == null) {
            this.colorModel = new ColorModel();
        }
        this.highlightingPanel.update(this.colorModel);
        this.syntaxColoringPanel.update(this.colorModel);
        this.annotationsPanel.update(this.colorModel);
        this.currentProfile = this.colorModel.getCurrentProfile();
        this.listen = false;
        Iterator it = this.colorModel.getProfiles().iterator();
        this.cbProfiles.removeAllItems();
        while (it.hasNext()) {
            this.cbProfiles.addItem(it.next());
        }
        this.listen = true;
        this.cbProfiles.setSelectedItem(this.currentProfile);
    }

    void applyChanges() {
        this.highlightingPanel.applyChanges();
        this.syntaxColoringPanel.applyChanges();
        this.annotationsPanel.applyChanges();
        if (this.colorModel == null) {
            return;
        }
        this.colorModel.setCurrentProfile(this.currentProfile);
    }

    void cancel() {
        this.highlightingPanel.cancel();
        this.syntaxColoringPanel.cancel();
        this.annotationsPanel.cancel();
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        if (this.currentProfile != null && this.colorModel != null && !this.currentProfile.equals(this.colorModel.getCurrentProfile())) {
            return true;
        }
        if (this.highlightingPanel.isChanged()) {
            return true;
        }
        if (this.syntaxColoringPanel.isChanged()) {
            return true;
        }
        return this.annotationsPanel.isChanged();
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.listen) {
            return;
        }
        if (e.getSource() == this.bClone) {
            NotifyDescriptor.InputLine il = new NotifyDescriptor.InputLine(FontAndColorsPanel.loc("CTL_Create_New_Profile_Message"), FontAndColorsPanel.loc("CTL_Create_New_Profile_Title"));
            il.setInputText(this.currentProfile);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)il);
            if (il.getValue() == NotifyDescriptor.OK_OPTION) {
                String newScheme = il.getInputText();
                Iterator it = this.colorModel.getProfiles().iterator();
                while (it.hasNext()) {
                    if (!newScheme.equals(it.next())) continue;
                    NotifyDescriptor.Message md = new NotifyDescriptor.Message((Object)FontAndColorsPanel.loc("CTL_Duplicate_Profile_Name"), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)md);
                    return;
                }
                this.setCurrentProfile(newScheme);
                this.listen = false;
                this.cbProfiles.addItem(il.getInputText());
                this.cbProfiles.setSelectedItem(il.getInputText());
                this.listen = true;
            }
            return;
        }
        if (e.getSource() == this.bDelete) {
            this.deleteCurrentProfile();
            return;
        }
    }

    Collection getDefaults() {
        return this.syntaxColoringPanel.getAllLanguages();
    }

    Collection getHighlights() {
        return this.highlightingPanel.getHighlightings();
    }

    Collection getSyntaxColorings() {
        return this.syntaxColoringPanel.getSyntaxColorings();
    }

    private static String loc(String key) {
        return NbBundle.getMessage((Class)FontAndColorsPanel.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)FontAndColorsPanel.loc(key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)FontAndColorsPanel.loc(key));
        }
    }
}

