/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.ui;

import java.awt.Component;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.AddInstanceVisualDirectoryPanel;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.Util;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class AddDomainDirectoryPanel
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    private AddInstanceVisualDirectoryPanel component;
    private WizardDescriptor wiz;
    private boolean creatingPersonalInstance;
    private final Set listeners = new HashSet(1);

    AddDomainDirectoryPanel(boolean creatingPersonalInstance) {
        this.creatingPersonalInstance = creatingPersonalInstance;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new AddInstanceVisualDirectoryPanel(this.creatingPersonalInstance);
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        if (this.creatingPersonalInstance) {
            return new HelpCtx("AS_RegServ_EnterPIDir");
        }
        return new HelpCtx("AS_RegServ_EnterDomainDir");
    }

    public boolean isValid() {
        File domainDir = new File(this.component.getInstanceDirectory());
        if (!this.creatingPersonalInstance) {
            if (this.component.getInstanceDirectory().length() < 1) {
                this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainDirectoryPanel.class, (String)"Msg_EneterValidDomainDir", (Object)this.component.getInstanceDirectory()));
                this.component.setAdminPort("");
                return false;
            }
            if (!Util.rootOfUsableDomain(domainDir)) {
                this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainDirectoryPanel.class, (String)"Msg_InValidDomainDir", (Object)this.component.getInstanceDirectory()));
                this.component.setAdminPort("");
                return false;
            }
            Util.fillDescriptorFromDomainXml(this.wiz, domainDir);
            String port = (String)this.wiz.getProperty("port");
            this.component.setAdminPort(port);
            if ("".equals(port)) {
                this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainDirectoryPanel.class, (String)"Msg_UnsupportedDomain", (Object)this.component.getInstanceDirectory()));
                return false;
            }
            return true;
        }
        File parent = domainDir.getParentFile();
        if (domainDir.exists()) {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainDirectoryPanel.class, (String)"Msg_ExistingDomainDir", (Object)domainDir.getAbsolutePath()));
            return false;
        }
        if (null == parent) {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainDirectoryPanel.class, (String)"Msg_InValidDomainDir", (Object)this.component.getInstanceDirectory()));
            return false;
        }
        if (!parent.exists()) {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainDirectoryPanel.class, (String)"Msg_InValidDomainDirParent", (Object)parent.getAbsolutePath()));
            return false;
        }
        if (!parent.canWrite()) {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainDirectoryPanel.class, (String)"Msg_InValidDomainDirParent", (Object)parent.getAbsolutePath()));
            return false;
        }
        this.wiz.putProperty("domain", (Object)domainDir.getName());
        this.wiz.putProperty("install_location", (Object)domainDir.getParentFile().getAbsolutePath());
        this.wiz.putProperty("WizardPanel_errorMessage", null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    public void readSettings(Object settings) {
        this.wiz = (WizardDescriptor)settings;
    }

    public void storeSettings(Object settings) {
    }

    public void stateChanged(ChangeEvent e) {
        this.fireChangeEvent();
    }

    public boolean isFinishPanel() {
        return !this.creatingPersonalInstance;
    }
}

