/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xsd;

import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.xml.api.model.GrammarEnvironment;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.api.model.HintContext;
import org.netbeans.modules.xml.xsd.Namespace;
import org.netbeans.modules.xml.xsd.XSDGrammar;
import org.netbeans.modules.xml.xsd.XSDParser;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class XSDGrammarResolver
implements GrammarQuery {
    private final Map prefix2Namespace;
    private final Map uri2Namespace = new HashMap();
    private Namespace defaultNamespace = null;
    private Node target = null;
    private FileObject document = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    private XSDGrammarResolver() {
        this.prefix2Namespace = new HashMap();
    }

    public static XSDGrammarResolver createResolver(GrammarEnvironment ctx) {
        XSDGrammarResolver ret = null;
        Enumeration en = ctx.getDocumentChildren();
        while (en.hasMoreElements()) {
            Node next = (Node)en.nextElement();
            if (next.getNodeType() != 1) continue;
            Element element = (Element)next;
            NamedNodeMap atts = element.getAttributes();
            String eprefix = Namespace.getPrefix(element.getNodeName());
            for (int i = 0; i < atts.getLength(); ++i) {
                Node attribute = atts.item(i);
                String name = attribute.getNodeName();
                if (!name.startsWith("xmlns")) continue;
                String uri = attribute.getNodeValue();
                String prefix = Namespace.getSufix(name);
                Namespace ns = new Namespace(uri, prefix);
                if (ret == null) {
                    ret = new XSDGrammarResolver();
                }
                ret.addNamespace(ns);
                if (prefix != null && !prefix.equals(eprefix)) continue;
                ret.defaultNamespace = ns;
            }
            if (ret == null) continue;
            if (!$assertionsDisabled && ret.defaultNamespace == null) {
                throw new AssertionError();
            }
            super.resolveSchemaLocation(element);
            if (ret.defaultNamespace.getSchemaLocation() == null) {
                ErrorManager.getDefault().log(16, "SCHEMA is null: " + element.getLocalName());
            }
            ret.setTarget(next);
            ret.setDocument(ctx.getFileObject());
            System.err.println("create resolver - success");
            return ret;
        }
        return null;
    }

    private void resolveSchemaLocation(Element element) {
        Namespace ns = this.findNamespaceByURI("http://www.w3.org/2001/XMLSchema-instance");
        String prefix = ns.getPrefix().concat(":");
        String schema = element.getAttribute(prefix.concat("schemaLocation"));
        if (schema == null) {
            schema = element.getAttribute(prefix.concat("noNamespaceSchemaLocation"));
        }
        System.err.println("SCHEMA LOC: " + schema);
        this.defaultNamespace.setSchemaLocation(schema);
    }

    private void setDocument(FileObject fileObject) {
        this.document = fileObject;
    }

    private XSDGrammar findGrammar(HintContext virtualElementCtx) throws IOException {
        Namespace ns = this.findNamespace((Node)virtualElementCtx);
        XSDGrammar grammar = ns.getGrammar();
        if (grammar == null) {
            grammar = this.createGrammar(ns);
            ns.setGrammar(grammar);
            grammar.setNamespace(ns);
        }
        return grammar;
    }

    private XSDGrammar createGrammar(Namespace ns) throws IOException {
        String uri = ns.getSchemaLocation();
        if (uri == null) {
            uri = ns.getURI();
        }
        System.err.println("findSchema: " + uri);
        int idx = uri.indexOf(32);
        if (idx >= 0) {
            uri = uri.substring(idx + 1);
        }
        try {
            InputSource inputSource;
            EntityResolver resolver;
            UserCatalog catalog = UserCatalog.getDefault();
            if (catalog != null && (resolver = catalog.getEntityResolver()) != null && (inputSource = resolver.resolveEntity(uri, null)) != null) {
                return new XSDParser().parse(inputSource);
            }
        }
        catch (SAXException e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
        try {
            URL url = new URL(uri);
            return new XSDParser().parse(new InputSource(url.openStream()));
        }
        catch (MalformedURLException e) {
            if (this.document == null) {
                return null;
            }
            FileObject fo = this.document.getParent().getFileObject(uri);
            if (fo == null) {
                return null;
            }
            return new XSDParser().parse(new InputSource(fo.getInputStream()));
        }
    }

    private void addNamespace(Namespace ns) {
        if (ns.getPrefix() != null) {
            this.prefix2Namespace.put(ns.getPrefix(), ns);
        }
        this.uri2Namespace.put(ns.getURI(), ns);
    }

    private Namespace findNamespaceByURI(String uri) {
        return (Namespace)this.uri2Namespace.get(uri);
    }

    private Namespace findNamespaceByPrefix(String prefix) {
        return (Namespace)this.prefix2Namespace.get(prefix);
    }

    private Namespace findNamespace(Node node) {
        System.err.println("find namespace");
        System.err.println("PARENT: " + node.getParentNode().getNodeName());
        return this.defaultNamespace;
    }

    public boolean isAllowed(Enumeration en) {
        return true;
    }

    public Enumeration queryAttributes(HintContext ownerElementCtx) {
        Thread.dumpStack();
        return Collections.enumeration(new ArrayList());
    }

    public GrammarResult queryDefault(HintContext parentNodeCtx) {
        Thread.dumpStack();
        return null;
    }

    public Enumeration queryElements(HintContext virtualElementCtx) {
        try {
            XSDGrammar grammar = this.findGrammar(virtualElementCtx);
            return grammar.queryElements(virtualElementCtx);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
            return Collections.enumeration(new ArrayList(0));
        }
    }

    public Enumeration queryEntities(String prefix) {
        Thread.dumpStack();
        return Collections.enumeration(new ArrayList());
    }

    public Enumeration queryNotations(String prefix) {
        Thread.dumpStack();
        return Collections.enumeration(new ArrayList());
    }

    public Enumeration queryValues(HintContext virtualTextCtx) {
        Thread.dumpStack();
        return Collections.enumeration(new ArrayList());
    }

    public Component getCustomizer(HintContext nodeCtx) {
        return null;
    }

    public Node.Property[] getProperties(HintContext nodeCtx) {
        return null;
    }

    public boolean hasCustomizer(HintContext nodeCtx) {
        return false;
    }

    public Node getTarget() {
        return this.target;
    }

    public void setTarget(Node target) {
        this.target = target;
    }

    static {
        $assertionsDisabled = !XSDGrammarResolver.class.desiredAssertionStatus();
    }
}

