/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleTypeProvider;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NbModuleProjectGenerator {
    public static final String PLATFORM_PROPERTIES_PATH = "nbproject/platform.properties";
    static final /* synthetic */ boolean $assertionsDisabled;

    private NbModuleProjectGenerator() {
    }

    public static void createStandAloneModule(final File projectDir, final String cnb, final String name, final String bundlePath, final String layerPath, final String platformID) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    FileObject dirFO = NbModuleProjectGenerator.createProjectDir(projectDir);
                    if (ProjectManager.getDefault().findProject(dirFO) != null) {
                        throw new IllegalArgumentException("Already a project in " + dirFO);
                    }
                    NbModuleProjectGenerator.createProjectXML(dirFO, cnb, NbModuleTypeProvider.STANDALONE);
                    NbModuleProjectGenerator.createPlatformProperties(dirFO, platformID);
                    NbModuleProjectGenerator.createManifest(dirFO, cnb, bundlePath, layerPath);
                    if (bundlePath != null) {
                        NbModuleProjectGenerator.createBundle(dirFO, bundlePath, name);
                    }
                    if (layerPath != null) {
                        NbModuleProjectGenerator.createLayerInSrc(dirFO, layerPath);
                    }
                    NbModuleProjectGenerator.createEmptyTestDir(dirFO);
                    ModuleList.refresh();
                    ProjectManager.getDefault().clearNonProjectCache();
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public static void createSuiteComponentModule(final File projectDir, final String cnb, final String name, final String bundlePath, final String layerPath, final File suiteDir) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    FileObject dirFO = NbModuleProjectGenerator.createProjectDir(projectDir);
                    if (ProjectManager.getDefault().findProject(dirFO) != null) {
                        throw new IllegalArgumentException("Already a project in " + dirFO);
                    }
                    NbModuleProjectGenerator.createProjectXML(dirFO, cnb, NbModuleTypeProvider.SUITE_COMPONENT);
                    NbModuleProjectGenerator.createSuiteProperties(dirFO, suiteDir);
                    NbModuleProjectGenerator.createManifest(dirFO, cnb, bundlePath, layerPath);
                    if (bundlePath != null) {
                        NbModuleProjectGenerator.createBundle(dirFO, bundlePath, name);
                    }
                    if (layerPath != null) {
                        NbModuleProjectGenerator.createLayerInSrc(dirFO, layerPath);
                    }
                    NbModuleProjectGenerator.createEmptyTestDir(dirFO);
                    ModuleList.refresh();
                    ProjectManager.getDefault().clearNonProjectCache();
                    NbModuleProjectGenerator.appendToSuite(cnb, dirFO, suiteDir);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public static void createSuiteLibraryModule(final File projectDir, final String cnb, final String name, final String bundlePath, final File suiteDir, final File license, final File[] jars) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException {
                    FileObject dirFO = NbModuleProjectGenerator.createProjectDir(projectDir);
                    if (ProjectManager.getDefault().findProject(dirFO) != null) {
                        throw new IllegalArgumentException("Already a project in " + dirFO);
                    }
                    EditableProperties props = new EditableProperties(true);
                    props.put((Object)"is.autoload", (Object)"true");
                    TreeSet<String> packageList = new TreeSet<String>();
                    HashMap<String, String> classPathExtensions = new HashMap<String, String>();
                    File releaseDir = new File(projectDir, "release/modules/ext");
                    if (!releaseDir.mkdirs()) {
                        Util.err.log("cannot create release directory.");
                    }
                    FileObject relDirFo = FileUtil.toFileObject((File)releaseDir);
                    for (int i = 0; i < jars.length; ++i) {
                        FileObject orig = FileUtil.toFileObject((File)jars[i]);
                        if (orig == null) continue;
                        ZipFile jf = null;
                        try {
                            FileUtil.copyFile((FileObject)orig, (FileObject)relDirFo, (String)orig.getName());
                            jf = new JarFile(jars[i]);
                            Enumeration<JarEntry> en = ((JarFile)jf).entries();
                            while (en.hasMoreElements()) {
                                int index;
                                String nm;
                                JarEntry entry = en.nextElement();
                                if (entry.isDirectory() || !entry.getName().endsWith(".class") || !Util.isValidJavaFQN((nm = entry.getName()).substring(0, nm.length() - 6).replace('/', '.')) || (index = nm.lastIndexOf(47)) <= -1) continue;
                                String path = nm.substring(0, index);
                                packageList.add(path.replace('/', '.'));
                            }
                            classPathExtensions.put("ext/" + orig.getNameExt(), "release/modules/ext/" + orig.getNameExt());
                            continue;
                        }
                        catch (IOException e) {
                            Util.err.notify((Throwable)e);
                            continue;
                        }
                        finally {
                            if (jf != null) {
                                try {
                                    jf.close();
                                }
                                catch (IOException e) {
                                    Util.err.notify(1, (Throwable)e);
                                }
                            }
                        }
                    }
                    if (license != null && license.exists()) {
                        FileObject fo = FileUtil.toFileObject((File)license);
                        try {
                            FileUtil.copyFile((FileObject)fo, (FileObject)dirFO, (String)fo.getName());
                            props.put((Object)"license.file", (Object)("${basedir}/" + fo.getNameExt()));
                        }
                        catch (IOException e) {
                            Util.err.notify((Throwable)e);
                        }
                    }
                    ProjectXMLManager.generateLibraryModuleTemplate(NbModuleProjectGenerator.createFileObject(dirFO, "nbproject/project.xml"), cnb, NbModuleTypeProvider.SUITE_COMPONENT, packageList, classPathExtensions);
                    NbModuleProjectGenerator.createSuiteProperties(dirFO, suiteDir);
                    NbModuleProjectGenerator.createManifest(dirFO, cnb, bundlePath, null);
                    NbModuleProjectGenerator.createBundle(dirFO, bundlePath, name);
                    FileObject bundleFO = NbModuleProjectGenerator.createFileObject(dirFO, "nbproject/project.properties");
                    Util.storeProperties(bundleFO, props);
                    ModuleList.refresh();
                    ProjectManager.getDefault().clearNonProjectCache();
                    NbModuleProjectGenerator.appendToSuite(cnb, dirFO, suiteDir);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public static void createNetBeansOrgModule(final File projectDir, final String cnb, final String name, final String bundlePath, final String layerPath) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    File nborg = ModuleList.findNetBeansOrg(projectDir);
                    if (nborg == null) {
                        throw new IllegalArgumentException(projectDir + " doesn't " + "point to directory within the netbeans.org CVS tree");
                    }
                    FileObject dirFO = NbModuleProjectGenerator.createProjectDir(projectDir);
                    if (ProjectManager.getDefault().findProject(dirFO) != null) {
                        throw new IllegalArgumentException("Already a project in " + dirFO);
                    }
                    NbModuleProjectGenerator.createNetBeansOrgBuildXML(dirFO, cnb, nborg);
                    NbModuleProjectGenerator.createProjectXML(dirFO, cnb, NbModuleTypeProvider.NETBEANS_ORG);
                    NbModuleProjectGenerator.createManifest(dirFO, cnb, bundlePath, layerPath);
                    NbModuleProjectGenerator.createBundle(dirFO, bundlePath, name);
                    NbModuleProjectGenerator.createLayerInSrc(dirFO, layerPath);
                    NbModuleProjectGenerator.createEmptyTestDir(dirFO);
                    ModuleList.refresh();
                    ProjectManager.getDefault().clearNonProjectCache();
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    private static void createProjectXML(FileObject projectDir, String cnb, NbModuleTypeProvider.NbModuleType type) throws IOException {
        ProjectXMLManager.generateEmptyModuleTemplate(NbModuleProjectGenerator.createFileObject(projectDir, "nbproject/project.xml"), cnb, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createNetBeansOrgBuildXML(FileObject projectDir, String cnb, File nborg) throws IOException {
        FileObject buildScript = NbModuleProjectGenerator.createFileObject(projectDir, "build.xml");
        Document prjDoc = XMLUtil.createDocument((String)"project", null, null, null);
        Element prjEl = prjDoc.getDocumentElement();
        prjEl.setAttribute("name", PropertyUtils.relativizeFile((File)nborg, (File)FileUtil.toFile((FileObject)projectDir)));
        prjEl.setAttribute("default", "netbeans");
        prjEl.setAttribute("basedir", ".");
        Element el = prjDoc.createElement("description");
        el.appendChild(prjDoc.createTextNode("Builds, tests, and runs the project " + cnb));
        prjEl.appendChild(el);
        el = prjDoc.createElement("import");
        el.setAttribute("file", PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)projectDir), (File)new File(nborg, "nbbuild/templates/projectized.xml")));
        prjEl.appendChild(el);
        FileLock lock = buildScript.lock();
        try {
            OutputStream os = buildScript.getOutputStream(lock);
            try {
                XMLUtil.write((Document)prjDoc, (OutputStream)os, (String)"UTF-8");
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    public static void createSuiteProperties(FileObject projectDir, File suiteDir) throws IOException {
        String suitePropertiesLocation;
        String suiteLocation;
        File projectDirF = FileUtil.toFile((FileObject)projectDir);
        if (CollocationQuery.areCollocated((File)projectDirF, (File)suiteDir)) {
            suiteLocation = "${basedir}/" + PropertyUtils.relativizeFile((File)projectDirF, (File)suiteDir);
            suitePropertiesLocation = "nbproject/suite.properties";
        } else {
            suiteLocation = suiteDir.getAbsolutePath();
            suitePropertiesLocation = "nbproject/private/suite-private.properties";
        }
        EditableProperties props = new EditableProperties(true);
        props.setProperty("suite.dir", suiteLocation);
        FileObject suiteProperties = NbModuleProjectGenerator.createFileObject(projectDir, suitePropertiesLocation);
        Util.storeProperties(suiteProperties, props);
    }

    private static void appendToSuite(String cnb, FileObject projectDir, File suiteDir) throws IOException {
        File projectDirF = FileUtil.toFile((FileObject)projectDir);
        File suiteGlobalPropsFile = new File(suiteDir, "nbproject/project.properties");
        FileObject suiteGlobalPropFO = suiteGlobalPropsFile.exists() ? FileUtil.toFileObject((File)suiteGlobalPropsFile) : NbModuleProjectGenerator.createFileObject(suiteGlobalPropsFile);
        EditableProperties globalProps = Util.loadProperties(suiteGlobalPropFO);
        String projectPropKey = "project." + cnb;
        if (CollocationQuery.areCollocated((File)projectDirF, (File)suiteDir)) {
            globalProps.setProperty(projectPropKey, PropertyUtils.relativizeFile((File)suiteDir, (File)projectDirF));
        } else {
            File suitePrivPropsFile = new File(suiteDir, "nbproject/private/private.properties");
            FileObject suitePrivPropFO = suitePrivPropsFile.exists() ? FileUtil.toFileObject((File)suitePrivPropsFile) : NbModuleProjectGenerator.createFileObject(suitePrivPropsFile);
            EditableProperties privProps = Util.loadProperties(suitePrivPropFO);
            privProps.setProperty(projectPropKey, projectDirF.getAbsolutePath());
            Util.storeProperties(suitePrivPropFO, privProps);
        }
        String modulesProp = globalProps.getProperty("modules");
        if (modulesProp == null) {
            modulesProp = "";
        }
        if (modulesProp.length() > 0) {
            modulesProp = modulesProp + ":";
        }
        modulesProp = modulesProp + "${" + projectPropKey + "}";
        globalProps.setProperty("modules", modulesProp.split("(?<=:)", -1));
        Util.storeProperties(suiteGlobalPropFO, globalProps);
    }

    private static void createPlatformProperties(FileObject projectDir, String platformID) throws IOException {
        FileObject plafPropsFO = NbModuleProjectGenerator.createFileObject(projectDir, PLATFORM_PROPERTIES_PATH);
        EditableProperties props = new EditableProperties(true);
        props.put((Object)"nbplatform.active", (Object)platformID);
        Util.storeProperties(plafPropsFO, props);
    }

    private static void createManifest(FileObject projectDir, String cnb, String bundlePath, String layerPath) throws IOException {
        FileObject manifestFO = NbModuleProjectGenerator.createFileObject(projectDir, "manifest.mf");
        ManifestManager.createManifest(manifestFO, cnb, "1.0", bundlePath, layerPath);
    }

    private static void createBundle(FileObject projectDir, String bundlePath, String name) throws IOException {
        String pathToBundle = "src/" + bundlePath.replace('\\', '/');
        FileObject bundleFO = NbModuleProjectGenerator.createFileObject(projectDir, pathToBundle);
        EditableProperties props = new EditableProperties(true);
        props.put((Object)"OpenIDE-Module-Name", (Object)name);
        Util.storeProperties(bundleFO, props);
    }

    private static void createLayerInSrc(FileObject projectDir, String layerPath) throws IOException {
        NbModuleProjectGenerator.createLayer(projectDir, "src/" + layerPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject createLayer(FileObject projectDir, String layerPath) throws IOException {
        FileObject layerFO = NbModuleProjectGenerator.createFileObject(projectDir, layerPath);
        FileLock lock = layerFO.lock();
        try {
            InputStream is = NbModuleProjectGenerator.class.getResourceAsStream("ui/resources/layer_template.xml");
            try {
                OutputStream os = layerFO.getOutputStream(lock);
                try {
                    FileUtil.copy((InputStream)is, (OutputStream)os);
                }
                finally {
                    os.close();
                }
            }
            finally {
                is.close();
            }
        }
        finally {
            lock.releaseLock();
        }
        return layerFO;
    }

    private static void createEmptyTestDir(FileObject projectDir) throws IOException {
        FileUtil.createFolder((FileObject)projectDir, (String)"test/unit/src");
    }

    private static FileObject createProjectDir(File dir) throws IOException {
        FileObject dirFO;
        if (!dir.exists()) {
            NbModuleProjectGenerator.refreshFolder(dir);
            if (!dir.mkdirs()) {
                throw new IOException("Can not create project folder \"" + dir.getAbsolutePath() + "\"");
            }
            NbModuleProjectGenerator.refreshFileSystem(dir);
        }
        if ((dirFO = FileUtil.toFileObject((File)dir)) == null) {
            throw new IOException("No such dir on disk: " + dir);
        }
        if (!$assertionsDisabled && !dirFO.isFolder()) {
            throw new AssertionError((Object)("Not really a dir: " + dir));
        }
        return dirFO;
    }

    private static void refreshFolder(File dir) {
        while (!dir.exists()) {
            if ((dir = dir.getParentFile()) != null) continue;
            return;
        }
        FileObject fo = FileUtil.toFileObject((File)dir);
        if (fo != null) {
            fo.refresh(false);
        }
    }

    private static void refreshFileSystem(File dir) throws FileStateInvalidException {
        File root = dir;
        while (root.getParentFile() != null) {
            root = root.getParentFile();
        }
        FileObject rootFO = FileUtil.toFileObject((File)root);
        if (rootFO != null) {
            rootFO.getFileSystem().refresh(false);
        } else {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)("At least disk roots must be mounted! " + root));
            }
            Util.err.log(16, "Cannot resolvefile object for " + root.getAbsolutePath());
        }
    }

    private static FileObject createFileObject(FileObject dir, String relToDir) throws IOException {
        FileObject createdFO = dir.getFileObject(relToDir);
        if (createdFO != null) {
            throw new IllegalArgumentException("File " + createdFO + " already exists.");
        }
        createdFO = FileUtil.createData((FileObject)dir, (String)relToDir);
        return createdFO;
    }

    private static FileObject createFileObject(File fileToCreate) throws IOException {
        File parent = fileToCreate.getParentFile();
        if (parent == null) {
            throw new IllegalArgumentException("Cannot create: " + fileToCreate);
        }
        if (!parent.exists()) {
            parent.mkdirs();
        }
        return NbModuleProjectGenerator.createFileObject(FileUtil.toFileObject((File)parent), fileToCreate.getName());
    }

    static {
        $assertionsDisabled = !NbModuleProjectGenerator.class.desiredAssertionStatus();
    }
}

