/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;

public final class GlobalJavadocForBinaryImpl
implements JavadocForBinaryQueryImplementation {
    public JavadocForBinaryQuery.Result findJavadoc(URL binaryRoot) {
        try {
            File f;
            if (!binaryRoot.getProtocol().equals("jar")) {
                Util.err.log(binaryRoot + " is not an archive file.");
                return null;
            }
            URL jar = FileUtil.getArchiveFile((URL)binaryRoot);
            if (!jar.getProtocol().equals("file")) {
                Util.err.log(binaryRoot + " is not an archive file.");
                return null;
            }
            if (jar.toExternalForm().endsWith("/xtest/lib/junit.jar") && (f = InstalledFileLocator.getDefault().locate("modules/ext/junit-3.8.1.jar", "org.netbeans.modules.junit", false)) != null) {
                return JavadocForBinaryQuery.findJavadoc((URL)FileUtil.getArchiveRoot((URL)f.toURI().toURL()));
            }
            File binaryRootF = new File(URI.create(jar.toExternalForm()));
            NbPlatform supposedPlaf = null;
            Iterator it = NbPlatform.getPlatforms().iterator();
            while (it.hasNext()) {
                NbPlatform plaf = (NbPlatform)it.next();
                if (!binaryRootF.getAbsolutePath().startsWith(plaf.getDestDir().getAbsolutePath())) continue;
                supposedPlaf = plaf;
                break;
            }
            if (supposedPlaf == null) {
                Util.err.log(binaryRootF + " does not correspond to a known platform");
                return null;
            }
            String n = binaryRootF.getName();
            if (!n.endsWith(".jar")) {
                Util.err.log(binaryRootF + " is not a *.jar");
                return null;
            }
            String cnbdashes = n.substring(0, n.length() - 4);
            final ArrayList<URL> candidates = new ArrayList<URL>();
            URL[] roots = supposedPlaf.getJavadocRoots();
            Util.err.log("Platform in " + supposedPlaf.getDestDir() + " claimed to have Javadoc roots " + Arrays.asList(roots));
            for (int i = 0; i < roots.length; ++i) {
                candidates.add(roots[i]);
                candidates.add(new URL(roots[i], cnbdashes + '/'));
            }
            Iterator it2 = candidates.iterator();
            while (it2.hasNext()) {
                URL u = (URL)it2.next();
                if (URLMapper.findFileObject((URL)u) != null) continue;
                Util.err.log("No such Javadoc candidate URL " + u);
                it2.remove();
            }
            return new JavadocForBinaryQuery.Result(){

                public URL[] getRoots() {
                    return candidates.toArray(new URL[candidates.size()]);
                }

                public void addChangeListener(ChangeListener l) {
                }

                public void removeChangeListener(ChangeListener l) {
                }
            };
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }
}

