/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleTypeProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.ui.wizard.NewNbModuleWizardIterator;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class UIUtil {
    private static final String ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.icon";
    private static final String OPENED_ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.openedIcon";
    private static final String ICON_PATH = "org/netbeans/modules/apisupport/project/resources/defaultFolder.gif";
    private static final String OPENED_ICON_PATH = "org/netbeans/modules/apisupport/project/resources/defaultFolderOpen.gif";
    private static WeakReference iconChooser;
    static final /* synthetic */ boolean $assertionsDisabled;

    private UIUtil() {
    }

    public static String keyToLogicalString(KeyStroke keyStroke) {
        String keyDesc = Utilities.keyToString((KeyStroke)keyStroke);
        int dash = keyDesc.indexOf(45);
        return dash == -1 ? keyDesc : keyDesc.substring(0, dash).replace('C', 'D').replace('A', 'O') + keyDesc.substring(dash);
    }

    public static String keyStrokeToString(KeyStroke keyStroke) {
        int modifiers = keyStroke.getModifiers();
        StringBuffer sb = new StringBuffer();
        if ((modifiers & 0x80) > 0) {
            sb.append("Ctrl+");
        }
        if ((modifiers & 0x200) > 0) {
            sb.append("Alt+");
        }
        if ((modifiers & 0x40) > 0) {
            sb.append("Shift+");
        }
        if ((modifiers & 0x100) > 0) {
            sb.append("Meta+");
        }
        if (keyStroke.getKeyCode() != 16 && keyStroke.getKeyCode() != 17 && keyStroke.getKeyCode() != 157 && keyStroke.getKeyCode() != 18 && keyStroke.getKeyCode() != 65406) {
            sb.append(Utilities.keyToString((KeyStroke)KeyStroke.getKeyStroke(keyStroke.getKeyCode(), 0)));
        }
        return sb.toString();
    }

    public static KeyStroke stringToKeyStroke(String keyStroke) {
        KeyStroke ks;
        int modifiers = 0;
        if (keyStroke.startsWith("Ctrl+")) {
            modifiers |= 0x80;
            keyStroke = keyStroke.substring(5);
        }
        if (keyStroke.startsWith("Alt+")) {
            modifiers |= 0x200;
            keyStroke = keyStroke.substring(4);
        }
        if (keyStroke.startsWith("Shift+")) {
            modifiers |= 0x40;
            keyStroke = keyStroke.substring(6);
        }
        if (keyStroke.startsWith("Meta+")) {
            modifiers |= 0x100;
            keyStroke = keyStroke.substring(5);
        }
        if ((ks = Utilities.stringToKey((String)keyStroke)) == null) {
            return null;
        }
        KeyStroke result = KeyStroke.getKeyStroke(ks.getKeyCode(), modifiers);
        return result;
    }

    public static KeyStroke[] stringToKeyStrokes(String keyStrokes) {
        String delim = " ";
        if (keyStrokes.length() == 0) {
            return new KeyStroke[0];
        }
        StringTokenizer st = new StringTokenizer(keyStrokes, delim);
        ArrayList<KeyStroke> result = new ArrayList<KeyStroke>();
        while (st.hasMoreTokens()) {
            String ks = st.nextToken().trim();
            KeyStroke keyStroke = UIUtil.stringToKeyStroke(ks);
            if (keyStroke == null) {
                return null;
            }
            result.add(keyStroke);
        }
        return result.toArray(new KeyStroke[result.size()]);
    }

    public static String keyStrokesToString(KeyStroke[] keyStrokes) {
        StringBuffer sb = new StringBuffer(UIUtil.keyStrokeToString(keyStrokes[0]));
        int k = keyStrokes.length;
        for (int i = 1; i < k; ++i) {
            sb.append(' ').append(UIUtil.keyStrokeToString(keyStrokes[i]));
        }
        String newShortcut = sb.toString();
        return newShortcut;
    }

    public static String keyStrokesToLogicalString(KeyStroke[] keyStrokes) {
        StringBuffer sb = new StringBuffer(UIUtil.keyToLogicalString(keyStrokes[0]));
        int k = keyStrokes.length;
        for (int i = 1; i < k; ++i) {
            sb.append(' ').append(UIUtil.keyToLogicalString(keyStrokes[i]));
        }
        String newShortcut = sb.toString();
        return newShortcut;
    }

    public static void setProjectChooserDir(File folder) {
        if (folder == null || !folder.isDirectory()) {
            return;
        }
        ProjectChooser.setProjectsFolder((File)folder);
    }

    public static void setProjectChooserDirParent(File fileOrFolder) {
        if (fileOrFolder == null) {
            return;
        }
        File parent = fileOrFolder.getParentFile();
        UIUtil.setProjectChooserDir(parent != null ? parent : (fileOrFolder.isDirectory() ? fileOrFolder : null));
    }

    public static void setText(JTextComponent textComp, String text) {
        textComp.setText(text);
        textComp.setCaretPosition(text == null ? 0 : text.length());
    }

    public static String getIconDimensionWarning(File icon, int expectedWidth, int expectedHeight) {
        Dimension real = new Dimension(UIUtil.getIconDimension(icon));
        if (real.height == expectedHeight && real.width == expectedWidth) {
            return "";
        }
        return NbBundle.getMessage((Class)UIUtil.class, (String)"MSG_WrongIconSize", (Object[])new Object[]{Integer.toString(real.width), Integer.toString(real.height), Integer.toString(expectedWidth), Integer.toString(expectedHeight)});
    }

    public static String getNoIconSelectedWarning(int expectedWidth, int expectedHeight) {
        return NbBundle.getMessage((Class)UIUtil.class, (String)"MSG_NoIconSelected", (Object[])new Object[]{Integer.toString(expectedWidth), Integer.toString(expectedHeight)});
    }

    public static boolean isValidIcon(File icon, int expectedWidth, int expectedHeight) {
        Dimension iconDimension = UIUtil.getIconDimension(icon);
        return (double)expectedWidth == iconDimension.getWidth() && (double)expectedHeight == iconDimension.getHeight();
    }

    public static Dimension getIconDimension(File icon) {
        try {
            ImageIcon imc = new ImageIcon(icon.toURI().toURL());
            return new Dimension(imc.getIconWidth(), imc.getIconHeight());
        }
        catch (MalformedURLException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return new Dimension(-1, -1);
        }
    }

    public static JFileChooser getIconFileChooser() {
        JFileChooser choose;
        if (iconChooser != null && (choose = (JFileChooser)iconChooser.get()) != null) {
            return choose;
        }
        IconFileChooser chooser = new IconFileChooser();
        iconChooser = new WeakReference<IconFileChooser>(chooser);
        return chooser;
    }

    public static JFileChooser getIconFileChooser(String oldValue) {
        File fil;
        JFileChooser chooser = UIUtil.getIconFileChooser();
        String iconText = oldValue.trim();
        if (iconText.length() > 0 && (fil = new File(iconText)).exists()) {
            chooser.setSelectedFile(fil);
        }
        return chooser;
    }

    public static JComboBox createPackageComboBox(SourceGroup srcRoot) {
        JComboBox packagesComboBox = new JComboBox(PackageView.createListView((SourceGroup)srcRoot));
        packagesComboBox.setRenderer(PackageView.listRenderer());
        return packagesComboBox;
    }

    public static boolean isValidPackageName(String str) {
        if (str.length() > 0 && str.charAt(0) == '.') {
            return false;
        }
        StringTokenizer tukac = new StringTokenizer(str, ".");
        while (tukac.hasMoreTokens()) {
            String token = tukac.nextToken();
            if ("".equals(token)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)token)) continue;
            return false;
        }
        return true;
    }

    public static String generateTextAreaContent(String[] relPaths) {
        StringBuffer sb = new StringBuffer();
        if (relPaths.length > 0) {
            for (int i = 0; i < relPaths.length; ++i) {
                if (i > 0) {
                    sb.append('\n');
                }
                sb.append(relPaths[i]);
            }
        }
        return sb.toString();
    }

    public static ComboBoxModel createLayerPresenterComboModel(Project project, String sfsRoot) {
        return UIUtil.createLayerPresenterComboModel(project, sfsRoot, Collections.EMPTY_MAP);
    }

    public static ComboBoxModel createLayerPresenterComboModel(Project project, String sfsRoot, Map excludeAttrs) {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        try {
            FileSystem sfs = LayerUtils.getEffectiveSystemFilesystem(project);
            FileObject root = sfs.getRoot().getFileObject(sfsRoot);
            if (root != null) {
                Collection subFolders = UIUtil.getFolders(root, excludeAttrs);
                TreeSet<LayerItemPresenter> presenters = new TreeSet<LayerItemPresenter>();
                Iterator it = subFolders.iterator();
                while (it.hasNext()) {
                    presenters.add(new LayerItemPresenter((FileObject)it.next(), root));
                }
                it = presenters.iterator();
                while (it.hasNext()) {
                    model.addElement(it.next());
                }
            }
        }
        catch (IOException exc) {
            Util.err.notify((Throwable)exc);
        }
        return model;
    }

    public static String getSFSPath(JComboBox lpCombo, String supposedRoot) {
        String editorItemS;
        Object editorItem = lpCombo.getEditor().getItem();
        String path = null;
        if (editorItem instanceof LayerItemPresenter) {
            path = ((LayerItemPresenter)editorItem).getFullPath();
        } else if (editorItem instanceof String && (editorItemS = ((String)editorItem).trim()).length() > 0 && (path = UIUtil.searchLIPCategoryCombo(lpCombo, editorItemS)) == null) {
            path = editorItemS.startsWith(supposedRoot) ? editorItemS : supposedRoot + '/' + editorItemS;
        }
        return path;
    }

    public static NbModuleProject chooseSuiteComponent(Component parent, SuiteProject suite) {
        NbModuleProject suiteComponent = null;
        Project project = UIUtil.chooseProject(parent);
        if (project != null) {
            if (SuiteUtils.getSubProjects(suite).contains(project)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)UIUtil.class, (String)"MSG_SuiteAlreadyContainsProject", (Object)ProjectUtils.getInformation((Project)suite).getDisplayName(), (Object)ProjectUtils.getInformation((Project)project).getDisplayName())));
                return null;
            }
            NbModuleTypeProvider nmtp = (NbModuleTypeProvider)project.getLookup().lookup(NbModuleTypeProvider.class);
            if (nmtp == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)UIUtil.class, (String)"MSG_TryingToAddNonNBModule", (Object)ProjectUtils.getInformation((Project)project).getDisplayName())));
            } else if (nmtp.getModuleType() == NbModuleTypeProvider.SUITE_COMPONENT) {
                Object[] params = new Object[]{ProjectUtils.getInformation((Project)project).getDisplayName(), UIUtil.getSuiteProjectName(project), UIUtil.getSuiteProjectDirectory(project), ProjectUtils.getInformation((Project)suite).getDisplayName()};
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)UIUtil.class, (String)"MSG_MoveFromSuiteToSuite", (Object[])params), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (confirmation.getValue() == NotifyDescriptor.OK_OPTION) {
                    suiteComponent = (NbModuleProject)project;
                }
            } else if (nmtp.getModuleType() == NbModuleTypeProvider.STANDALONE) {
                suiteComponent = (NbModuleProject)project;
            } else if (nmtp.getModuleType() == NbModuleTypeProvider.NETBEANS_ORG) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)UIUtil.class, (String)"MSG_TryingToAddNBORGModule", (Object)ProjectUtils.getInformation((Project)project).getDisplayName())));
            }
        }
        return suiteComponent;
    }

    public static ListCellRenderer createProjectRenderer() {
        return new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (!(value instanceof Project)) {
                    return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                }
                ProjectInformation pi = ProjectUtils.getInformation((Project)((Project)value));
                JLabel c = (JLabel)super.getListCellRendererComponent((JList<?>)list, pi.getDisplayName(), index, isSelected, cellHasFocus);
                c.setIcon(pi.getIcon());
                return this;
            }
        };
    }

    public static Image getTreeFolderIcon(boolean opened) {
        Image base = (Image)UIManager.get(opened ? OPENED_ICON_KEY_UIMANAGER_NB : ICON_KEY_UIMANAGER_NB);
        if (base == null) {
            base = Utilities.loadImage((String)(opened ? OPENED_ICON_PATH : ICON_PATH), (boolean)true);
        }
        if (!$assertionsDisabled && base == null) {
            throw new AssertionError();
        }
        return base;
    }

    public static Image convertToImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        BufferedImage bImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics g = bImage.getGraphics();
        icon.paintIcon(new JLabel(), g, 0, 0);
        g.dispose();
        return bImage;
    }

    public static NbModuleProject runLibraryWrapperWizard(Project suiteProvider) {
        NewNbModuleWizardIterator iterator = NewNbModuleWizardIterator.createLibraryModuleIterator(suiteProvider);
        return UIUtil.runProjectWizard(iterator, "CTL_NewLibraryWrapperProject");
    }

    public static NbModuleProject runProjectWizard(NewNbModuleWizardIterator iterator, String titleBundleKey) {
        boolean cancelled;
        WizardDescriptor wd = new WizardDescriptor((WizardDescriptor.Iterator)iterator);
        wd.setTitleFormat(new MessageFormat("{0}"));
        wd.setTitle(NbBundle.getMessage((Class)UIUtil.class, (String)titleBundleKey));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wd);
        dialog.setVisible(true);
        dialog.toFront();
        NbModuleProject project = null;
        boolean bl = cancelled = wd.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!cancelled) {
            FileObject folder = iterator.getCreateProjectFolder();
            try {
                project = (NbModuleProject)ProjectManager.getDefault().findProject(folder);
                OpenProjects.getDefault().open(new Project[]{project}, false);
                if (wd.getProperty("setAsMain") == Boolean.TRUE) {
                    OpenProjects.getDefault().setMainProject((Project)project);
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return project;
    }

    private static String searchLIPCategoryCombo(JComboBox lpCombo, String displayName) {
        String path = null;
        for (int i = 0; i < lpCombo.getItemCount(); ++i) {
            LayerItemPresenter presenter;
            Object item = lpCombo.getItemAt(i);
            if (!(item instanceof LayerItemPresenter) || !displayName.equals((presenter = (LayerItemPresenter)lpCombo.getItemAt(i)).getDisplayName())) continue;
            path = presenter.getFullPath();
            break;
        }
        return path;
    }

    private static Project chooseProject(Component parent) {
        JFileChooser chooser = ProjectChooser.projectChooser();
        int option = chooser.showOpenDialog(parent);
        Project project = null;
        if (option == 0) {
            File projectDir = chooser.getSelectedFile();
            UIUtil.setProjectChooserDirParent(projectDir);
            try {
                project = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)projectDir));
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
            }
        }
        return project;
    }

    private static File getSuiteDirectory(Project suiteComp) {
        File suiteDir = SuiteUtils.getSuiteDirectory(suiteComp);
        if (!$assertionsDisabled && suiteDir == null) {
            throw new AssertionError((Object)("Invalid suite provider for: " + suiteComp.getProjectDirectory()));
        }
        return suiteDir;
    }

    private static String getSuiteProjectDirectory(Project suiteComp) {
        return UIUtil.getSuiteDirectory(suiteComp).getAbsolutePath();
    }

    private static String getSuiteProjectName(Project suiteComp) {
        return Util.getDisplayName(FileUtil.toFileObject((File)UIUtil.getSuiteDirectory(suiteComp)));
    }

    private static Collection getFolders(FileObject root, Map excludeAttrs) {
        HashSet<FileObject> folders = new HashSet<FileObject>();
        Enumeration subFolders = root.getFolders(false);
        block0: while (subFolders.hasMoreElements()) {
            FileObject subFolder = (FileObject)subFolders.nextElement();
            Iterator it = excludeAttrs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                if (!me.getValue().equals(subFolder.getAttribute((String)me.getKey()))) continue;
                continue block0;
            }
            folders.add(subFolder);
            folders.addAll(UIUtil.getFolders(subFolder, excludeAttrs));
        }
        return folders;
    }

    public static boolean showAcceptCancelDialog(String title, String message, String acceptButton, String cancelButton, int messageType) {
        DialogDescriptor d = new DialogDescriptor((Object)message, title);
        d.setModal(true);
        JButton accept = new JButton(acceptButton);
        accept.setDefaultCapable(true);
        d.setOptions(new Object[]{accept, cancelButton != null ? new JButton(cancelButton) : NotifyDescriptor.CANCEL_OPTION});
        d.setMessageType(messageType);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)d).equals(accept);
    }

    static {
        $assertionsDisabled = !UIUtil.class.desiredAssertionStatus();
    }

    private static class IconFileChooser
    extends JFileChooser {
        private final JTextField iconInfo = new JTextField();

        private IconFileChooser() {
            JPanel accessoryPanel = IconFileChooser.getAccesoryPanel(this.iconInfo);
            this.setDialogTitle(NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$UIUtil == null ? (class$org$netbeans$modules$apisupport$project$ui$UIUtil = UIUtil.class$("org.netbeans.modules.apisupport.project.ui.UIUtil")) : class$org$netbeans$modules$apisupport$project$ui$UIUtil), (String)"TITLE_IconDialog"));
            this.setAccessory(accessoryPanel);
            this.setAcceptAllFileFilterUsed(false);
            this.setFileSelectionMode(0);
            this.setMultiSelectionEnabled(false);
            this.addChoosableFileFilter(new IconFilter());
            this.setFileView(new FileView(){

                public Icon getIcon(File f) {
                    ImageIcon icon;
                    if ((f.getName().endsWith(".gif") || f.getName().endsWith(".png")) && (icon = new ImageIcon(f.getAbsolutePath())).getIconWidth() == 16 && icon.getIconHeight() == 16) {
                        return icon;
                    }
                    return null;
                }

                public String getName(File f) {
                    File f2 = IconFileChooser.this.getSelectedFile();
                    if (f2 != null && (f2.getName().endsWith(".gif") || f2.getName().endsWith(".png"))) {
                        ImageIcon icon = new ImageIcon(f2.getAbsolutePath());
                        StringBuffer sb = new StringBuffer();
                        sb.append(f2.getName()).append(" [");
                        sb.append(icon.getIconWidth()).append("x").append(icon.getIconHeight());
                        sb.append("]");
                        IconFileChooser.this.setApproveButtonToolTipText(sb.toString());
                        IconFileChooser.this.iconInfo.setText(sb.toString());
                    } else {
                        IconFileChooser.this.iconInfo.setText("");
                    }
                    return super.getName(f);
                }
            });
        }

        private static JPanel getAccesoryPanel(JTextField iconInfo) {
            iconInfo.setColumns(15);
            iconInfo.setEditable(false);
            JPanel accessoryPanel = new JPanel();
            JPanel inner = new JPanel();
            JLabel iconInfoLabel = new JLabel();
            accessoryPanel.setLayout(new FlowLayout(0, 6, 0));
            inner.setLayout(new GridLayout(2, 1, 0, 6));
            iconInfoLabel.setLabelFor(iconInfo);
            Mnemonics.setLocalizedText((JLabel)iconInfoLabel, (String)NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$UIUtil == null ? (class$org$netbeans$modules$apisupport$project$ui$UIUtil = UIUtil.class$("org.netbeans.modules.apisupport.project.ui.UIUtil")) : class$org$netbeans$modules$apisupport$project$ui$UIUtil), (String)"LBL_IconInfo"));
            inner.add(iconInfoLabel);
            inner.add(iconInfo);
            accessoryPanel.add(inner);
            return accessoryPanel;
        }
    }

    private static final class IconFilter
    extends FileFilter {
        private IconFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().toLowerCase(Locale.ENGLISH).endsWith("gif") || pathname.getName().toLowerCase(Locale.ENGLISH).endsWith("png");
        }

        public String getDescription() {
            return "*.gif, *.png";
        }
    }

    public static class LayerItemPresenter
    implements Comparable {
        private String displayName;
        private FileObject item;
        private FileObject root;
        private boolean contentType;

        public LayerItemPresenter(FileObject item, FileObject root, boolean contentType) {
            this.item = item;
            this.root = root;
            this.contentType = contentType;
        }

        public LayerItemPresenter(FileObject item, FileObject root) {
            this(item, root, false);
        }

        public FileObject getFileObject() {
            return this.item;
        }

        public String getFullPath() {
            return this.item.getPath();
        }

        public String getDisplayName() {
            if (this.displayName == null) {
                this.displayName = this.computeDisplayName();
            }
            return this.displayName;
        }

        public String toString() {
            return this.getDisplayName();
        }

        public int compareTo(Object o) {
            int res = Collator.getInstance().compare(this.getDisplayName(), ((LayerItemPresenter)o).getDisplayName());
            if (res != 0) {
                return res;
            }
            return this.getFullPath().compareTo(((LayerItemPresenter)o).getFullPath());
        }

        private static String getFileObjectName(FileObject fo) {
            String name = null;
            try {
                name = fo.getFileSystem().getStatus().annotateName(fo.getNameExt(), Collections.singleton(fo));
            }
            catch (FileStateInvalidException ex) {
                name = fo.getName();
            }
            return name;
        }

        private String computeDisplayName() {
            FileObject displayItem = this.contentType ? this.item.getParent() : this.item;
            String displaySeparator = this.contentType ? "/" : " | ";
            Stack<String> s = new Stack<String>();
            s.push(LayerItemPresenter.getFileObjectName(displayItem));
            FileObject parent = displayItem.getParent();
            while (!this.root.getPath().equals(parent.getPath())) {
                s.push(LayerItemPresenter.getFileObjectName(parent));
                parent = parent.getParent();
            }
            StringBuffer sb = new StringBuffer();
            sb.append(s.pop());
            while (!s.empty()) {
                sb.append(displaySeparator + s.pop());
            }
            return sb.toString();
        }
    }

    public static abstract class DocumentAdapter
    implements DocumentListener {
        public void removeUpdate(DocumentEvent e) {
            this.insertUpdate(null);
        }

        public void changedUpdate(DocumentEvent e) {
            this.insertUpdate(null);
        }
    }
}

