/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.options.NewOptionsIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class OptionsPanel0
extends BasicWizardIterator.Panel {
    private NewOptionsIterator.DataModel data;
    private DocumentListener fieldsDL;
    private JRadioButton advancedButton;
    private ButtonGroup buttonGroup1;
    private JTextField categoryNameField;
    private JLabel categoryNameLbl;
    private JTextField displayNameField1;
    private JLabel displayNameLbl1;
    private JPanel dummyPanel;
    private JButton iconButton;
    private JTextField iconField;
    private JLabel iconLbl;
    private JRadioButton optionsCategoryButton;
    private JTextField titleField;
    private JLabel titleLbl;
    private JTextField tooltipField1;
    private JLabel tooltipLbl1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public OptionsPanel0(WizardDescriptor setting, NewOptionsIterator.DataModel data) {
        super(setting);
        this.data = data;
        this.initComponents();
        this.initAccessibility();
        this.putClientProperty("NewFileWizard_Title", NbBundle.getMessage((Class)OptionsPanel0.class, (String)"LBL_OptionsWizardTitle"));
    }

    private void addListeners() {
        if (this.fieldsDL == null) {
            this.fieldsDL = new UIUtil.DocumentAdapter(){

                public void insertUpdate(DocumentEvent e) {
                    OptionsPanel0.this.updateData();
                }
            };
            this.categoryNameField.getDocument().addDocumentListener(this.fieldsDL);
            this.displayNameField1.getDocument().addDocumentListener(this.fieldsDL);
            this.iconField.getDocument().addDocumentListener(this.fieldsDL);
            this.titleField.getDocument().addDocumentListener(this.fieldsDL);
            this.tooltipField1.getDocument().addDocumentListener(this.fieldsDL);
        }
    }

    private void removeListeners() {
        if (this.fieldsDL != null) {
            this.categoryNameField.getDocument().removeDocumentListener(this.fieldsDL);
            this.displayNameField1.getDocument().removeDocumentListener(this.fieldsDL);
            this.iconField.getDocument().removeDocumentListener(this.fieldsDL);
            this.titleField.getDocument().removeDocumentListener(this.fieldsDL);
            this.tooltipField1.getDocument().removeDocumentListener(this.fieldsDL);
            this.fieldsDL = null;
        }
    }

    protected void storeToDataModel() {
        this.removeListeners();
        this.updateData();
    }

    protected void readFromDataModel() {
        this.addListeners();
    }

    private void updateData() {
        int retCode = 0;
        if (this.advancedButton.isSelected()) {
            if (!$assertionsDisabled && this.optionsCategoryButton.isSelected()) {
                throw new AssertionError();
            }
            retCode = this.data.setDataForAdvanced(this.displayNameField1.getText(), this.tooltipField1.getText());
        } else {
            if (!$assertionsDisabled && !this.optionsCategoryButton.isSelected()) {
                throw new AssertionError();
            }
            retCode = this.data.setDataForOptionCategory(this.titleField.getText(), this.categoryNameField.getText(), this.iconField.getText());
        }
        if (NewOptionsIterator.DataModel.isSuccessCode(retCode)) {
            this.markValid();
        } else if (NewOptionsIterator.DataModel.isErrorCode(retCode)) {
            this.setError(this.data.getErrorMessage(retCode));
        } else if (NewOptionsIterator.DataModel.isWarningCode(retCode)) {
            this.setWarning(this.data.getWarningMessage(retCode));
        } else if (!$assertionsDisabled) {
            throw new AssertionError(retCode);
        }
    }

    protected String getPanelName() {
        return NbBundle.getMessage((Class)OptionsPanel0.class, (String)"LBL_OptionsPanel0_Title");
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(OptionsPanel0.class);
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage((Class)OptionsPanel0.class, (String)key);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_OptionsPanel0"));
        this.advancedButton.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_LBL_Advanced"));
        this.optionsCategoryButton.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_LBL_OptionsCategory"));
        this.titleField.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_Title"));
        this.tooltipField1.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_Tooltip"));
        this.displayNameField1.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_DisplayName"));
        this.categoryNameField.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_CategoryName"));
        this.iconField.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_IconPath"));
        this.iconButton.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_IconButton"));
    }

    public void addNotify() {
        super.addNotify();
        this.addListeners();
        this.updateData();
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeListeners();
    }

    private void enableDisable() {
        boolean advancedEnabled = this.advancedButton.isSelected();
        if (!$assertionsDisabled && advancedEnabled == this.optionsCategoryButton.isSelected()) {
            throw new AssertionError();
        }
        this.categoryNameField.setEnabled(!advancedEnabled);
        this.categoryNameLbl.setEnabled(!advancedEnabled);
        this.iconButton.setEnabled(!advancedEnabled);
        this.iconField.setEnabled(!advancedEnabled);
        this.iconLbl.setEnabled(!advancedEnabled);
        this.titleField.setEnabled(!advancedEnabled);
        this.titleLbl.setEnabled(!advancedEnabled);
        this.displayNameField1.setEnabled(advancedEnabled);
        this.displayNameLbl1.setEnabled(advancedEnabled);
        this.tooltipField1.setEnabled(advancedEnabled);
        this.tooltipLbl1.setEnabled(advancedEnabled);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.advancedButton = new JRadioButton();
        this.optionsCategoryButton = new JRadioButton();
        this.dummyPanel = new JPanel();
        this.categoryNameLbl = new JLabel();
        this.categoryNameField = new JTextField();
        this.displayNameLbl1 = new JLabel();
        this.displayNameField1 = new JTextField();
        this.tooltipLbl1 = new JLabel();
        this.tooltipField1 = new JTextField();
        this.titleLbl = new JLabel();
        this.titleField = new JTextField();
        this.iconLbl = new JLabel();
        this.iconField = new JTextField();
        this.iconButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.advancedButton);
        this.advancedButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.advancedButton, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/options/Bundle").getString("LBL_Advanced"));
        this.advancedButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.advancedButton.setMargin(new Insets(0, 0, 0, 0));
        this.advancedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsPanel0.this.advancedButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.advancedButton, gridBagConstraints);
        this.buttonGroup1.add(this.optionsCategoryButton);
        Mnemonics.setLocalizedText((AbstractButton)this.optionsCategoryButton, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/options/Bundle").getString("LBL_OptionsCategory"));
        this.optionsCategoryButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.optionsCategoryButton.setMargin(new Insets(0, 0, 0, 0));
        this.optionsCategoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsPanel0.this.optionsCategoryButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.add((Component)this.optionsCategoryButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.dummyPanel, gridBagConstraints);
        this.categoryNameLbl.setLabelFor(this.categoryNameField);
        Mnemonics.setLocalizedText((JLabel)this.categoryNameLbl, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/options/Bundle").getString("LBL_CategoryName"));
        this.categoryNameLbl.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 18, 6, 12);
        this.add((Component)this.categoryNameLbl, gridBagConstraints);
        this.categoryNameField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.categoryNameField, gridBagConstraints);
        this.displayNameLbl1.setLabelFor(this.displayNameField1);
        Mnemonics.setLocalizedText((JLabel)this.displayNameLbl1, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/options/Bundle").getString("LBL_DisplaName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 18, 6, 12);
        this.add((Component)this.displayNameLbl1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.displayNameField1, gridBagConstraints);
        this.tooltipLbl1.setLabelFor(this.tooltipField1);
        Mnemonics.setLocalizedText((JLabel)this.tooltipLbl1, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/options/Bundle").getString("LBL_Tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 18, 6, 12);
        this.add((Component)this.tooltipLbl1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tooltipField1, gridBagConstraints);
        this.titleLbl.setLabelFor(this.titleField);
        Mnemonics.setLocalizedText((JLabel)this.titleLbl, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/options/Bundle").getString("LBL_Title"));
        this.titleLbl.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 18, 6, 12);
        this.add((Component)this.titleLbl, gridBagConstraints);
        this.titleField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.titleField, gridBagConstraints);
        this.iconLbl.setLabelFor(this.iconField);
        Mnemonics.setLocalizedText((JLabel)this.iconLbl, (String)NbBundle.getMessage((Class)OptionsPanel0.class, (String)"LBL_Icon"));
        this.iconLbl.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 18, 0, 0);
        this.add((Component)this.iconLbl, gridBagConstraints);
        this.iconField.setEditable(false);
        this.iconField.setText(NbBundle.getMessage((Class)OptionsPanel0.class, (String)"CTL_None"));
        this.iconField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.iconField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.iconButton, (String)NbBundle.getMessage((Class)OptionsPanel0.class, (String)"LBL_Icon_Browse"));
        this.iconButton.setEnabled(false);
        this.iconButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsPanel0.this.iconButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.iconButton, gridBagConstraints);
    }

    private void optionsCategoryButtonActionPerformed(ActionEvent evt) {
        this.enableDisable();
        this.updateData();
    }

    private void advancedButtonActionPerformed(ActionEvent evt) {
        this.enableDisable();
        this.updateData();
    }

    private void iconButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = UIUtil.getIconFileChooser(this.iconField.getText());
        int ret = chooser.showDialog(this, OptionsPanel0.getMessage("LBL_Select"));
        if (ret == 0) {
            File iconFile = chooser.getSelectedFile();
            this.iconField.setText(iconFile.getAbsolutePath());
        }
    }

    static {
        $assertionsDisabled = !OptionsPanel0.class.desiredAssertionStatus();
    }
}

