/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.netbeans.api.debugger.ActionsManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Lookup;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.debugger.ActionsProviderListener;
import org.openide.util.Task;

public final class ActionsManager {
    public static final Object ACTION_STEP_OVER = "stepOver";
    public static final Object ACTION_RUN_INTO_METHOD = "runIntoMethod";
    public static final Object ACTION_STEP_INTO = "stepInto";
    public static final Object ACTION_STEP_OUT = "stepOut";
    public static final Object ACTION_CONTINUE = "continue";
    public static final Object ACTION_START = "start";
    public static final Object ACTION_KILL = "kill";
    public static final Object ACTION_MAKE_CALLER_CURRENT = "makeCallerCurrent";
    public static final Object ACTION_MAKE_CALLEE_CURRENT = "makeCalleeCurrent";
    public static final Object ACTION_PAUSE = "pause";
    public static final Object ACTION_RUN_TO_CURSOR = "runToCursor";
    public static final Object ACTION_POP_TOPMOST_CALL = "popTopmostCall";
    public static final Object ACTION_FIX = "fix";
    public static final Object ACTION_RESTART = "restart";
    public static final Object ACTION_TOGGLE_BREAKPOINT = "toggleBreakpoint";
    private Vector listener = new Vector();
    private HashMap listeners = new HashMap();
    private HashMap actionProviders;
    private Object actionProvidersLock = new Object();
    private MyActionListener actionListener = new MyActionListener();
    private Lookup lookup;
    private boolean doiingDo = false;
    private boolean destroy = false;
    private boolean listerersLoaded = false;
    private List lazyListeners;

    ActionsManager(Lookup lookup) {
        this.lookup = lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doAction(Object action) {
        ArrayList l;
        this.doiingDo = true;
        Object object = this.actionProvidersLock;
        synchronized (object) {
            if (this.actionProviders == null) {
                this.initActionImpls();
            }
            if ((l = (ArrayList)this.actionProviders.get(action)) != null) {
                l = (ArrayList)l.clone();
            }
        }
        boolean done = false;
        if (l != null) {
            int k = l.size();
            for (int i = 0; i < k; ++i) {
                if (!((ActionsProvider)l.get(i)).isEnabled(action)) continue;
                done = true;
                ((ActionsProvider)l.get(i)).doAction(action);
            }
        }
        if (done) {
            this.fireActionDone(action);
        }
        this.doiingDo = false;
        if (this.destroy) {
            this.destroyIn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Task postAction(final Object action) {
        ArrayList l;
        this.doiingDo = true;
        Object object = this.actionProvidersLock;
        synchronized (object) {
            if (this.actionProviders == null) {
                this.initActionImpls();
            }
            if ((l = (ArrayList)this.actionProviders.get(action)) != null) {
                l = (ArrayList)l.clone();
            }
        }
        boolean posted = false;
        final AsynchActionTask task = new AsynchActionTask();
        if (l != null) {
            int i;
            int k = l.size();
            ArrayList<ActionsProvider> postedActions = new ArrayList<ActionsProvider>(k);
            for (i = 0; i < k; ++i) {
                ActionsProvider ap = (ActionsProvider)l.get(i);
                if (!ap.isEnabled(action)) continue;
                postedActions.add(ap);
                posted = true;
            }
            if (posted) {
                final int[] count = new int[]{0};
                Runnable notifier = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        int[] nArray = count;
                        synchronized (count) {
                            count[0] = count[0] - 1;
                            if (count[0] == 0) {
                                task.actionDone();
                                ActionsManager.this.fireActionDone(action);
                                ActionsManager.this.doiingDo = false;
                                if (ActionsManager.this.destroy) {
                                    ActionsManager.this.destroyIn();
                                }
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                };
                count[0] = k = postedActions.size();
                for (i = 0; i < k; ++i) {
                    ((ActionsProvider)postedActions.get(i)).postAction(action, notifier);
                }
            }
        }
        if (!posted) {
            this.doiingDo = false;
            if (this.destroy) {
                this.destroyIn();
            }
            task.actionDone();
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEnabled(Object action) {
        ArrayList l;
        Object object = this.actionProvidersLock;
        synchronized (object) {
            if (this.actionProviders == null) {
                this.initActionImpls();
            }
            if ((l = (ArrayList)this.actionProviders.get(action)) != null) {
                l = (ArrayList)l.clone();
            }
        }
        if (l != null) {
            int k = l.size();
            for (int i = 0; i < k; ++i) {
                if (!((ActionsProvider)l.get(i)).isEnabled(action)) continue;
                return true;
            }
        }
        return false;
    }

    public void destroy() {
        if (!this.doiingDo) {
            this.destroyIn();
        }
        this.destroy = true;
    }

    public void addActionsManagerListener(ActionsManagerListener l) {
        this.listener.addElement(l);
    }

    public void removeActionsManagerListener(ActionsManagerListener l) {
        this.listener.removeElement(l);
    }

    public void addActionsManagerListener(String propertyName, ActionsManagerListener l) {
        Vector<ActionsManagerListener> listener = (Vector<ActionsManagerListener>)this.listeners.get(propertyName);
        if (listener == null) {
            listener = new Vector<ActionsManagerListener>();
            this.listeners.put(propertyName, listener);
        }
        listener.addElement(l);
    }

    public void removeActionsManagerListener(String propertyName, ActionsManagerListener l) {
        Vector listener = (Vector)this.listeners.get(propertyName);
        if (listener == null) {
            return;
        }
        listener.removeElement(l);
        if (listener.size() == 0) {
            this.listeners.remove(propertyName);
        }
    }

    private void fireActionDone(Object action) {
        int i;
        this.initListeners();
        Vector l = (Vector)this.listener.clone();
        Vector l1 = (Vector)this.listeners.get("actionPerformed");
        if (l1 != null) {
            l1 = (Vector)l1.clone();
        }
        int k = l.size();
        for (i = 0; i < k; ++i) {
            ((ActionsManagerListener)l.elementAt(i)).actionPerformed(action);
        }
        if (l1 != null) {
            k = l1.size();
            for (i = 0; i < k; ++i) {
                ((ActionsManagerListener)l1.elementAt(i)).actionPerformed(action);
            }
        }
    }

    private void fireActionStateChanged(Object action) {
        int i;
        boolean enabled = this.isEnabled(action);
        this.initListeners();
        Vector l = (Vector)this.listener.clone();
        Vector l1 = (Vector)this.listeners.get("actionStateChanged");
        if (l1 != null) {
            l1 = (Vector)l1.clone();
        }
        int k = l.size();
        for (i = 0; i < k; ++i) {
            ((ActionsManagerListener)l.elementAt(i)).actionStateChanged(action, enabled);
        }
        if (l1 != null) {
            k = l1.size();
            for (i = 0; i < k; ++i) {
                ((ActionsManagerListener)l1.elementAt(i)).actionStateChanged(action, enabled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerActionsProvider(Object action, ActionsProvider p) {
        Object object = this.actionProvidersLock;
        synchronized (object) {
            ArrayList<ActionsProvider> l = (ArrayList<ActionsProvider>)this.actionProviders.get(action);
            if (l == null) {
                l = new ArrayList<ActionsProvider>();
                this.actionProviders.put(action, l);
            }
            l.add(p);
        }
        this.fireActionStateChanged(action);
        p.addActionsProviderListener(this.actionListener);
    }

    private void initActionImpls() {
        this.actionProviders = new HashMap();
        Iterator i = this.lookup.lookup(null, ActionsProvider.class).iterator();
        while (i.hasNext()) {
            ActionsProvider ap = (ActionsProvider)i.next();
            Iterator ii = ap.getActions().iterator();
            while (ii.hasNext()) {
                this.registerActionsProvider(ii.next(), ap);
            }
        }
    }

    private void initListeners() {
        if (this.listerersLoaded) {
            return;
        }
        this.listerersLoaded = true;
        this.lazyListeners = this.lookup.lookup(null, LazyActionsManagerListener.class);
        int k = this.lazyListeners.size();
        for (int i = 0; i < k; ++i) {
            LazyActionsManagerListener l = (LazyActionsManagerListener)this.lazyListeners.get(i);
            String[] props = l.getProperties();
            if (props == null) {
                this.addActionsManagerListener(l);
                continue;
            }
            int jj = props.length;
            for (int j = 0; j < jj; ++j) {
                this.addActionsManagerListener(props[j], l);
            }
        }
    }

    private synchronized void destroyIn() {
        int k = this.lazyListeners.size();
        for (int i = 0; i < k; ++i) {
            LazyActionsManagerListener l = (LazyActionsManagerListener)this.lazyListeners.get(i);
            String[] props = l.getProperties();
            if (props == null) {
                this.removeActionsManagerListener(l);
                continue;
            }
            int jj = props.length;
            for (int j = 0; j < jj; ++j) {
                this.removeActionsManagerListener(props[j], l);
            }
            l.destroy();
        }
        this.lazyListeners = new ArrayList();
    }

    class MyActionListener
    implements ActionsProviderListener {
        MyActionListener() {
        }

        public void actionStateChange(Object action, boolean enabled) {
            ActionsManager.this.fireActionStateChanged(action);
        }
    }

    private static class AsynchActionTask
    extends Task {
        private AsynchActionTask() {
        }

        void actionDone() {
            this.notifyFinished();
        }
    }
}

