/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.jdbcimpl.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.support.DatabaseExplorerUIs;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.DBSchemaWizardData;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class DBSchemaConnectionPanel
extends JPanel
implements ListDataListener {
    static final long serialVersionUID = 5364628520334696421L;
    private ArrayList list;
    private DBSchemaWizardData data;
    private Node dbNode;
    private Node[] drvNodes;
    private JTextArea descriptionTextArea;
    private JComboBox existingConnComboBox;
    private final ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.dbschema.jdbcimpl.resources.Bundle");

    public DBSchemaConnectionPanel(DBSchemaWizardData data, ArrayList list) {
        DataFolder df;
        this.list = list;
        this.data = data;
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(1));
        this.setName(this.bundle.getString("ConnectionChooser"));
        this.initComponents();
        this.initAccessibility();
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("UI/Runtime");
        try {
            df = (DataFolder)DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException exc) {
            return;
        }
        this.dbNode = df.getNodeDelegate().getChildren().findChild("Databases");
        DatabaseExplorerUIs.connect((JComboBox)this.existingConnComboBox, (ConnectionManager)ConnectionManager.getDefault());
        this.existingConnComboBox.getModel().addListDataListener(this);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_ConnectionPanelA11yDesc"));
        this.descriptionTextArea.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_DescriptionA11yName"));
        this.descriptionTextArea.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_DescriptionA11yDesc"));
        this.existingConnComboBox.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_ExistingConnectionA11yName"));
        this.existingConnComboBox.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_ExistingConnectionA11yDesc"));
    }

    private void initComponents() {
        this.descriptionTextArea = new JTextArea();
        this.existingConnComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setFont(UIManager.getFont("Label.font"));
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setText(this.bundle.getString("Description"));
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.descriptionTextArea.setEnabled(false);
        this.descriptionTextArea.setOpaque(false);
        this.descriptionTextArea.setRequestFocusEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.descriptionTextArea, gridBagConstraints);
        this.existingConnComboBox.setToolTipText(this.bundle.getString("ACS_ExistingConnectionComboBoxA11yDesc"));
        this.existingConnComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DBSchemaConnectionPanel.this.existingConnComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 5);
        this.add((Component)this.existingConnComboBox, gridBagConstraints);
    }

    private void existingConnComboBoxActionPerformed(ActionEvent evt) {
        Object selectedItem = this.existingConnComboBox.getSelectedItem();
        if (selectedItem instanceof DatabaseConnection) {
            this.data.setDatabaseConnection((DatabaseConnection)selectedItem);
        }
        this.fireChange(this);
    }

    public boolean isValid() {
        return this.existingConnComboBox.getSelectedItem() instanceof DatabaseConnection;
    }

    public void intervalAdded(ListDataEvent p1) {
        this.fireChange(this);
    }

    public void intervalRemoved(ListDataEvent p1) {
        this.fireChange(this);
    }

    public void contentsChanged(ListDataEvent p1) {
        this.fireChange(this);
    }

    public void initData() {
        this.data.setExistingConn(true);
        Object selectedItem = this.existingConnComboBox.getSelectedItem();
        if (selectedItem instanceof DatabaseConnection) {
            this.data.setDatabaseConnection((DatabaseConnection)selectedItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChange(Object source) {
        ArrayList lst;
        DBSchemaConnectionPanel dBSchemaConnectionPanel = this;
        synchronized (dBSchemaConnectionPanel) {
            lst = (ArrayList)this.list.clone();
        }
        ChangeEvent event = new ChangeEvent(source);
        for (int i = 0; i < lst.size(); ++i) {
            ChangeListener listener = (ChangeListener)lst.get(i);
            listener.stateChanged(event);
        }
    }
}

