/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.HandleLayer;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.openide.ErrorManager;

class ComponentDragger {
    private FormDesigner formDesigner;
    private HandleLayer handleLayer;
    private RADVisualComponent[] selectedComponents;
    private Rectangle[] originalBounds;
    private Point hotspot;
    private Point mousePosition;
    private int resizeType;
    private RADVisualContainer targetMetaContainer;
    private Container targetContainer;
    private Container targetContainerDel;
    static Stroke dashedStroke1 = new BasicStroke(2.0f, 2, 0, 10.0f, new float[]{1.0f, 4.0f}, 0.0f);
    static Stroke dashedStroke2 = new BasicStroke(2.0f, 2, 0, 10.0f, new float[]{2.0f, 8.0f}, 0.0f);

    ComponentDragger(FormDesigner formDesigner, HandleLayer handleLayer, RADVisualComponent[] selectedComponents, Rectangle[] originalBounds, Point hotspot, RADVisualContainer fixedTargetMetaContainer) {
        this.formDesigner = formDesigner;
        this.handleLayer = handleLayer;
        this.selectedComponents = selectedComponents;
        this.originalBounds = originalBounds;
        this.hotspot = hotspot;
        this.mousePosition = hotspot;
        this.resizeType = 0;
        if (fixedTargetMetaContainer != null) {
            this.targetMetaContainer = fixedTargetMetaContainer;
        }
    }

    ComponentDragger(FormDesigner formDesigner, HandleLayer handleLayer, RADVisualComponent[] selectedComponents, Rectangle[] originalBounds, Point hotspot, int resizeType) {
        this.formDesigner = formDesigner;
        this.handleLayer = handleLayer;
        this.selectedComponents = selectedComponents;
        this.originalBounds = originalBounds;
        this.hotspot = hotspot;
        this.mousePosition = hotspot;
        this.resizeType = resizeType;
    }

    void drag(Point p, RADVisualContainer target) {
        this.targetMetaContainer = target;
        this.mousePosition = p;
    }

    void paintDragFeedback(Graphics2D g) {
        Stroke oldStroke = g.getStroke();
        g.setStroke(dashedStroke1);
        Color oldColor = g.getColor();
        g.setColor(FormLoaderSettings.getInstance().getSelectionBorderColor());
        ArrayList constraints = new ArrayList(this.selectedComponents.length);
        ArrayList indices = new ArrayList(this.selectedComponents.length);
        boolean constraintsOK = this.computeConstraints(this.mousePosition, constraints, indices);
        Point contPos = null;
        LayoutSupportManager layoutSupport = null;
        if (constraintsOK) {
            contPos = SwingUtilities.convertPoint(this.targetContainerDel, 0, 0, this.handleLayer);
            layoutSupport = this.targetMetaContainer.getLayoutSupport();
            if (this.resizeType == 0) {
                this.paintTargetContainerFeedback(g, this.targetContainerDel);
            }
        }
        for (int i = 0; i < this.selectedComponents.length; ++i) {
            RADVisualComponent metacomp = this.selectedComponents[i];
            boolean drawn = false;
            if (constraintsOK) {
                Component comp = (Component)this.formDesigner.getComponent(metacomp);
                LayoutConstraints constr = (LayoutConstraints)constraints.get(i);
                int index = (Integer)indices.get(i);
                if (constr != null || index >= 0) {
                    g.translate(contPos.x, contPos.y);
                    drawn = layoutSupport.paintDragFeedback(this.targetContainer, this.targetContainerDel, comp, constr, index, g);
                    g.translate(-contPos.x, -contPos.y);
                }
            }
            if (drawn) continue;
            this.paintDragFeedback(g, metacomp);
        }
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }

    void dropComponents(Point point, RADVisualContainer target) {
        RADVisualComponent[] compsMovedWithinTarget;
        RADVisualComponent[] compsMovedFromOutside;
        int i;
        int i2;
        int index;
        ArrayList<LayoutConstraints> constraints = null;
        ArrayList indices = null;
        this.targetMetaContainer = target;
        if (this.targetMetaContainer != null) {
            constraints = new ArrayList<LayoutConstraints>(this.selectedComponents.length);
            indices = new ArrayList(this.selectedComponents.length);
            this.computeConstraints(point, constraints, indices);
        }
        if (this.targetMetaContainer == null) {
            indices = null;
            constraints = null;
        }
        FormModel formModel = this.formDesigner.getFormModel();
        LayoutSupportManager layoutSupport = null;
        RADVisualComponent[] originalComponents = null;
        LayoutConstraints[] originalConstraints = null;
        ArrayList<Integer> movedFromOutside = null;
        ArrayList<RADVisualComponent> movedWithinTarget = null;
        if (this.targetMetaContainer != null) {
            layoutSupport = this.targetMetaContainer.getLayoutSupport();
            originalComponents = this.targetMetaContainer.getSubComponents();
            originalConstraints = new LayoutConstraints[originalComponents.length];
            this.adjustIndices(indices);
            for (int i3 = 0; i3 < this.selectedComponents.length; ++i3) {
                if (this.selectedComponents[i3].getParentContainer() != this.targetMetaContainer) {
                    if (movedFromOutside == null) {
                        movedFromOutside = new ArrayList<Integer>(this.selectedComponents.length);
                    }
                    movedFromOutside.add(new Integer(i3));
                    continue;
                }
                if (movedWithinTarget == null) {
                    movedWithinTarget = new ArrayList<RADVisualComponent>(this.selectedComponents.length);
                }
                movedWithinTarget.add(this.selectedComponents[i3]);
            }
            if (movedFromOutside != null && movedFromOutside.size() > 0) {
                int count = movedFromOutside.size();
                RADVisualComponent[] newComps = new RADVisualComponent[count];
                LayoutConstraints[] newConstr = new LayoutConstraints[count];
                for (int i4 = 0; i4 < count; ++i4) {
                    int index2 = (Integer)movedFromOutside.get(i4);
                    newComps[i4] = this.selectedComponents[index2];
                    newConstr[i4] = (LayoutConstraints)constraints.get(index2);
                }
                int j = (Integer)movedFromOutside.get(0);
                int jj = (Integer)indices.get(j);
                try {
                    layoutSupport.acceptNewComponents(newComps, newConstr, jj);
                }
                catch (RuntimeException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                    return;
                }
                for (int i5 = 0; i5 < count; ++i5) {
                    index = (Integer)movedFromOutside.get(i5);
                    constraints.set(index, newConstr[i5]);
                }
                movedFromOutside.clear();
            }
        }
        int n = this.selectedComponents.length + (originalComponents != null ? originalComponents.length : 0);
        ArrayList<RADVisualComponent> newComponents = new ArrayList<RADVisualComponent>(n);
        ArrayList<LayoutConstraints> newConstraints = new ArrayList<LayoutConstraints>(n);
        int newI = 0;
        for (i2 = 0; i2 < n; ++i2) {
            newComponents.add(null);
            newConstraints.add(null);
        }
        if (this.targetMetaContainer != null) {
            for (i2 = 0; i2 < this.selectedComponents.length; ++i2) {
                int index3 = (Integer)indices.get(i2);
                if (index3 < 0 || index3 >= n || !this.checkTarget(this.selectedComponents[i2])) continue;
                while (newComponents.get(index3) != null) {
                    if (++index3 != n) continue;
                    index3 = 0;
                }
                newComponents.set(index3, this.selectedComponents[i2]);
            }
            for (i2 = 0; i2 < originalComponents.length; ++i2) {
                RADVisualComponent metacomp = originalComponents[i2];
                originalConstraints[i2] = layoutSupport.getConstraints(metacomp);
                index = newComponents.indexOf(metacomp);
                if (index >= 0) continue;
                while (newComponents.get(newI) != null) {
                    ++newI;
                }
                newComponents.set(newI, metacomp);
                newConstraints.set(newI, originalConstraints[i2]);
            }
        }
        for (i2 = 0; i2 < this.selectedComponents.length; ++i2) {
            RADVisualComponent metacomp = this.selectedComponents[i2];
            index = newComponents.indexOf(metacomp);
            if (index >= 0) {
                newConstraints.set(index, (LayoutConstraints)(constraints != null ? (Object)constraints.get(i2) : null));
                continue;
            }
            if (!this.checkTarget(metacomp)) continue;
            while (newComponents.get(newI) != null) {
                ++newI;
            }
            newComponents.set(newI, metacomp);
            newConstraints.set(newI, (LayoutConstraints)(constraints != null ? (Object)constraints.get(i2) : null));
        }
        for (i2 = 0; i2 < n; ++i2) {
            RADVisualComponent metacomp = (RADVisualComponent)newComponents.get(i2);
            if (metacomp != null) {
                RADVisualContainer parentCont = metacomp.getParentContainer();
                if (parentCont == this.targetMetaContainer) continue;
                if (movedFromOutside == null) {
                    movedFromOutside = new ArrayList(this.selectedComponents.length);
                }
                movedFromOutside.add((Integer)((Object)metacomp));
                formModel.removeComponent(metacomp, false);
                continue;
            }
            newComponents.remove(i2);
            newConstraints.remove(i2);
            --i2;
            --n;
        }
        if (n == 0) {
            return;
        }
        boolean undoRedoOn = formModel.isUndoRedoRecording();
        if (undoRedoOn) {
            formModel.setUndoRedoRecording(false);
        }
        RADComponent[] newCompsArray = new RADVisualComponent[n];
        LayoutConstraints[] newConstrArray = new LayoutConstraints[n];
        if (this.targetMetaContainer != null) {
            for (int i6 = 0; i6 < n; ++i6) {
                newCompsArray[i6] = (RADVisualComponent)newComponents.get(i6);
                newConstrArray[i6] = (LayoutConstraints)newConstraints.get(i6);
            }
            layoutSupport.removeAll();
            this.targetMetaContainer.initSubComponents(newCompsArray);
            layoutSupport.addComponents((RADVisualComponent[])newCompsArray, newConstrArray, 0);
        } else {
            ComponentContainer othersMetaCont = formModel.getModelContainer();
            for (i = 0; i < n; ++i) {
                newCompsArray[i] = (RADVisualComponent)newComponents.get(i);
                othersMetaCont.add(newCompsArray[i]);
            }
        }
        if (movedFromOutside != null) {
            n = movedFromOutside.size();
            compsMovedFromOutside = new RADVisualComponent[n];
            for (i = 0; i < n; ++i) {
                compsMovedFromOutside[i] = (RADVisualComponent)movedFromOutside.get(i);
                formModel.fireComponentAdded(compsMovedFromOutside[i], false);
            }
        } else {
            compsMovedFromOutside = new RADVisualComponent[]{};
            formModel.fireComponentsReordered(this.targetMetaContainer, new int[0]);
        }
        if (movedWithinTarget != null) {
            n = movedWithinTarget.size();
            compsMovedWithinTarget = new RADVisualComponent[n];
            for (int i7 = 0; i7 < n; ++i7) {
                compsMovedWithinTarget[i7] = (RADVisualComponent)movedWithinTarget.get(i7);
                formModel.fireComponentLayoutChanged(compsMovedWithinTarget[i7], null, null, null);
            }
        } else {
            compsMovedWithinTarget = new RADVisualComponent[]{};
        }
        if (undoRedoOn) {
            DropUndoableEdit dropUndo = new DropUndoableEdit();
            dropUndo.formModel = formModel;
            dropUndo.targetContainer = this.targetMetaContainer;
            dropUndo.targetComponentsBeforeMove = originalComponents;
            dropUndo.targetConstraintsBeforeMove = originalConstraints;
            dropUndo.targetComponentsAfterMove = newCompsArray;
            dropUndo.targetConstraintsAfterMove = newConstrArray;
            dropUndo.componentsMovedFromOutside = compsMovedFromOutside;
            dropUndo.componentsMovedWithinTarget = compsMovedWithinTarget;
            formModel.addUndoableEdit(dropUndo);
        }
        if (undoRedoOn) {
            formModel.setUndoRedoRecording(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ComponentDragger.this.formDesigner.setSelectedComponents(ComponentDragger.this.selectedComponents);
            }
        });
    }

    private boolean computeConstraints(Point p, List constraints, List indices) {
        if (this.selectedComponents == null || this.selectedComponents.length == 0) {
            return false;
        }
        if (this.targetMetaContainer == null) {
            return false;
        }
        RADVisualContainer fixTargetContainer = null;
        block0: do {
            if (fixTargetContainer != null) {
                this.targetMetaContainer = fixTargetContainer;
                fixTargetContainer = null;
            }
            LayoutSupportManager layoutSupport = this.targetMetaContainer.getLayoutSupport();
            this.targetContainer = (Container)this.formDesigner.getComponent(this.targetMetaContainer);
            if (this.targetContainer == null) {
                return false;
            }
            this.targetContainerDel = this.targetMetaContainer.getContainerDelegate(this.targetContainer);
            if (this.targetContainerDel == null) {
                return false;
            }
            Point posInCont = SwingUtilities.convertPoint(this.handleLayer, p, this.targetContainerDel);
            for (int i = 0; i < this.selectedComponents.length; ++i) {
                LayoutConstraints constr = null;
                int index = -1;
                RADVisualComponent metacomp = this.selectedComponents[i];
                Component comp = (Component)this.formDesigner.getComponent(metacomp);
                if (comp != null) {
                    if (!this.checkTarget(metacomp)) {
                        fixTargetContainer = metacomp.getParentContainer();
                        constraints.clear();
                        indices.clear();
                        if (fixTargetContainer != null) continue block0;
                        return false;
                    }
                    if (this.resizeType == 0) {
                        Point posInComp = new Point(this.hotspot.x - this.originalBounds[i].x, this.hotspot.y - this.originalBounds[i].y);
                        index = layoutSupport.getNewIndex(this.targetContainer, this.targetContainerDel, comp, metacomp.getComponentIndex(), posInCont, posInComp);
                        constr = layoutSupport.getNewConstraints(this.targetContainer, this.targetContainerDel, comp, metacomp.getComponentIndex(), posInCont, posInComp);
                        if (constr == null && index >= 0) {
                            LayoutSupportManager.storeConstraints(metacomp);
                            constr = layoutSupport.getStoredConstraints(metacomp);
                        }
                    } else {
                        int up = 0;
                        int down = 0;
                        int left = 0;
                        int right = 0;
                        if ((this.resizeType & 2) != 0) {
                            down = p.y - this.hotspot.y;
                        } else if ((this.resizeType & 1) != 0) {
                            up = this.hotspot.y - p.y;
                        }
                        if ((this.resizeType & 8) != 0) {
                            right = p.x - this.hotspot.x;
                        } else if ((this.resizeType & 4) != 0) {
                            left = this.hotspot.x - p.x;
                        }
                        Insets sizeChanges = new Insets(up, left, down, right);
                        constr = layoutSupport.getResizedConstraints(this.targetContainer, this.targetContainerDel, comp, metacomp.getComponentIndex(), this.handleLayer.convertRectangleToComponent(new Rectangle(this.originalBounds[i]), this.targetContainerDel), sizeChanges, posInCont);
                    }
                }
                constraints.add(constr);
                indices.add(new Integer(index));
            }
        } while (fixTargetContainer != null);
        return true;
    }

    private boolean checkTarget(RADVisualComponent metacomp) {
        if (!(metacomp instanceof RADVisualContainer)) {
            return true;
        }
        for (RADComponent targetCont = this.targetMetaContainer; targetCont != null; targetCont = targetCont.getParentComponent()) {
            if (targetCont != metacomp) continue;
            return false;
        }
        return true;
    }

    private void adjustIndices(List indices) {
        int prevIndex = -1;
        int prevCorrection = 0;
        for (int i = 0; i < indices.size(); ++i) {
            int correction;
            int index = (Integer)indices.get(i);
            if (index < 0) continue;
            if (index == prevIndex) {
                correction = prevCorrection;
            } else {
                correction = 0;
                RADVisualComponent[] targetComps = this.targetMetaContainer.getSubComponents();
                for (int j = 0; j < index; ++j) {
                    RADVisualComponent tComp = targetComps[j];
                    boolean isSelected = false;
                    for (int k = 0; k < this.selectedComponents.length; ++k) {
                        if (tComp != this.selectedComponents[k]) continue;
                        isSelected = true;
                        break;
                    }
                    if (!isSelected) continue;
                    ++correction;
                }
                prevIndex = index;
                prevCorrection = correction;
            }
            if (correction == 0) continue;
            indices.set(i, new Integer(index -= correction));
        }
    }

    private void paintDragFeedback(Graphics2D g, RADVisualComponent metacomp) {
        Object comp = this.formDesigner.getComponent(metacomp);
        if (!(comp instanceof Component) || !((Component)comp).isShowing()) {
            return;
        }
        Component component = (Component)comp;
        Rectangle rect = component.getBounds();
        rect = SwingUtilities.convertRectangle(component.getParent(), rect, this.handleLayer);
        rect.translate(this.mousePosition.x - this.hotspot.x, this.mousePosition.y - this.hotspot.y);
        g.draw(new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height));
        if (metacomp instanceof RADVisualContainer) {
            RADVisualComponent[] children = ((RADVisualContainer)metacomp).getSubComponents();
            for (int i = 0; i < children.length; ++i) {
                this.paintDragFeedback(g, children[i]);
            }
        }
    }

    private void paintTargetContainerFeedback(Graphics2D g, Container cont) {
        Stroke oldStroke = g.getStroke();
        g.setStroke(dashedStroke2);
        Color oldColor = g.getColor();
        g.setColor(FormLoaderSettings.getInstance().getDragBorderColor());
        Rectangle rect = new Rectangle(new Point(0, 0), cont.getSize());
        rect = SwingUtilities.convertRectangle(cont, rect, this.handleLayer);
        g.draw(new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height));
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }

    private static class DropUndoableEdit
    extends AbstractUndoableEdit {
        FormModel formModel;
        RADVisualContainer targetContainer;
        RADVisualComponent[] targetComponentsBeforeMove;
        LayoutConstraints[] targetConstraintsBeforeMove;
        RADVisualComponent[] targetComponentsAfterMove;
        LayoutConstraints[] targetConstraintsAfterMove;
        RADVisualComponent[] componentsMovedFromOutside;
        RADVisualComponent[] componentsMovedWithinTarget;

        private DropUndoableEdit() {
        }

        public void undo() throws CannotUndoException {
            super.undo();
            boolean undoRedoOn = this.formModel.isUndoRedoRecording();
            if (undoRedoOn) {
                this.formModel.setUndoRedoRecording(false);
            }
            for (int i = 0; i < this.componentsMovedFromOutside.length; ++i) {
                this.formModel.removeComponentImpl(this.componentsMovedFromOutside[i], false);
            }
            if (this.targetContainer != null) {
                LayoutSupportManager layoutSupport = this.targetContainer.getLayoutSupport();
                layoutSupport.removeAll();
                this.targetContainer.initSubComponents(this.targetComponentsBeforeMove);
                layoutSupport.addComponents(this.targetComponentsBeforeMove, this.targetConstraintsBeforeMove, 0);
                for (int i = 0; i < this.componentsMovedWithinTarget.length; ++i) {
                    this.formModel.fireComponentLayoutChanged(this.componentsMovedWithinTarget[i], null, null, null);
                }
            }
            if (undoRedoOn) {
                this.formModel.setUndoRedoRecording(true);
            }
        }

        public void redo() throws CannotRedoException {
            int i;
            super.redo();
            boolean undoRedoOn = this.formModel.isUndoRedoRecording();
            if (undoRedoOn) {
                this.formModel.setUndoRedoRecording(false);
            }
            if (this.targetContainer != null) {
                LayoutSupportManager layoutSupport = this.targetContainer.getLayoutSupport();
                layoutSupport.removeAll();
                this.targetContainer.initSubComponents(this.targetComponentsAfterMove);
                layoutSupport.addComponents(this.targetComponentsAfterMove, this.targetConstraintsAfterMove, 0);
            } else {
                ComponentContainer othersMetaCont = this.formModel.getModelContainer();
                for (int i2 = 0; i2 < this.targetComponentsAfterMove.length; ++i2) {
                    othersMetaCont.add(this.targetComponentsAfterMove[i2]);
                }
            }
            for (i = 0; i < this.componentsMovedFromOutside.length; ++i) {
                this.formModel.fireComponentAdded(this.componentsMovedFromOutside[i], false);
            }
            for (i = 0; i < this.componentsMovedWithinTarget.length; ++i) {
                this.formModel.fireComponentLayoutChanged(this.componentsMovedWithinTarget[i], null, null, null);
            }
            if (undoRedoOn) {
                this.formModel.setUndoRedoRecording(true);
            }
        }

        public String getUndoPresentationName() {
            return "";
        }

        public String getRedoPresentationName() {
            return "";
        }
    }
}

