/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentCookie;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.netbeans.modules.form.layoutsupport.delegates.NullLayoutSupport;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.awt.JMenuPlus;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public class SelectLayoutAction
extends CallableSystemAction {
    private static String name;

    public String getName() {
        if (name == null) {
            name = NbBundle.getBundle(SelectLayoutAction.class).getString("ACT_SelectLayout");
        }
        return name;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isEnabled() {
        Node[] nodes = SelectLayoutAction.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            RADVisualContainer container = SelectLayoutAction.getContainer(nodes[i]);
            if (container != null && !container.hasDedicatedLayoutSupport()) continue;
            return false;
        }
        return true;
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        LayoutMenu layoutMenu = new LayoutMenu(this.getName());
        ((JMenuItem)((Object)layoutMenu)).setEnabled(this.isEnabled());
        HelpCtx.setHelpIDString((JComponent)((Object)layoutMenu), (String)SelectLayoutAction.class.getName());
        return layoutMenu;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction() {
    }

    private static Node[] getNodes() {
        return ComponentInspector.getInstance().getExplorerManager().getSelectedNodes();
    }

    private static RADVisualContainer getContainer(Node node) {
        RADComponent metacomp;
        RADComponentCookie radCookie = (RADComponentCookie)node.getCookie(RADComponentCookie.class);
        if (radCookie != null && (metacomp = radCookie.getRADComponent()) instanceof RADVisualContainer) {
            return (RADVisualContainer)metacomp;
        }
        return null;
    }

    private static PaletteItem[] getAllLayouts() {
        PaletteItem[] allItems = PaletteUtils.getAllItems();
        ArrayList<PaletteItem> layoutsList = new ArrayList<PaletteItem>();
        for (int i = 0; i < allItems.length; ++i) {
            if (!allItems[i].isLayout()) continue;
            layoutsList.add(allItems[i]);
        }
        PaletteItem[] layouts = new PaletteItem[layoutsList.size()];
        layoutsList.toArray(layouts);
        return layouts;
    }

    private static class LayoutActionListener
    implements ActionListener {
        private PaletteItem paletteItem;

        LayoutActionListener(PaletteItem paletteItem) {
            this.paletteItem = paletteItem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt) {
            Node[] nodes = SelectLayoutAction.getNodes();
            for (int i = 0; i < nodes.length; ++i) {
                Object var18_17;
                RADVisualContainer container = SelectLayoutAction.getContainer(nodes[i]);
                if (container == null) continue;
                FormModel formModel = container.getFormModel();
                if (this.paletteItem != null) {
                    formModel.getComponentCreator().createComponent(this.paletteItem.getComponentClassSource(), container, null);
                    continue;
                }
                LayoutSupportManager currentLS = container.getLayoutSupport();
                boolean convertToNew = currentLS != null && currentLS.getLayoutDelegate() != null;
                LayoutModel layoutModel = formModel.getLayoutModel();
                Object layoutUndoMark = layoutModel.getChangeMark();
                UndoableEdit ue = layoutModel.getUndoableEdit();
                boolean autoUndo = true;
                try {
                    formModel.setNaturalContainerLayout(container);
                    if (convertToNew) {
                        RADVisualComponent[] components = container.getSubComponents();
                        HashMap<String, Component> idToComponent = new HashMap<String, Component>();
                        FormDesigner formDesigner = FormEditor.getFormDesigner(formModel);
                        for (int j = 0; j < components.length; ++j) {
                            Component comp = (Component)formDesigner.getComponent(components[j]);
                            if (comp == null) {
                                comp = (Component)components[j].getBeanInstance();
                            }
                            idToComponent.put(components[j].getId(), comp);
                        }
                        layoutModel.createModel(container.getId(), (Container)formDesigner.getComponent(container), idToComponent);
                    }
                    autoUndo = false;
                    var18_17 = null;
                    if (!layoutUndoMark.equals(layoutModel.getChangeMark())) {
                        formModel.addUndoableEdit(ue);
                    }
                    if (autoUndo) {
                        formModel.forceUndoOfCompoundEdit();
                    }
                }
                catch (Throwable throwable) {
                    var18_17 = null;
                    if (!layoutUndoMark.equals(layoutModel.getChangeMark())) {
                        formModel.addUndoableEdit(ue);
                    }
                    if (autoUndo) {
                        formModel.forceUndoOfCompoundEdit();
                    }
                    throw throwable;
                }
                FormEditor.getFormEditor(formModel).updateProjectForNaturalLayout();
            }
        }
    }

    private static class LayoutMenu
    extends JMenuPlus {
        private boolean initialized = false;

        private LayoutMenu(String name) {
            super(name);
        }

        public JPopupMenu getPopupMenu() {
            JPopupMenu popup = super.getPopupMenu();
            Node[] nodes = SelectLayoutAction.getNodes();
            if (nodes.length != 0 && !this.initialized) {
                popup.removeAll();
                JMenuItem mi = new JMenuItem(NbBundle.getMessage(SelectLayoutAction.class, (String)"NAME_FreeDesign"));
                popup.add(mi);
                mi.addActionListener(new LayoutActionListener(null));
                popup.addSeparator();
                RADVisualContainer container = SelectLayoutAction.getContainer(nodes[0]);
                boolean hasFreeDesignSupport = this.hasFreeDesignSupport(container);
                if (hasFreeDesignSupport) {
                    LayoutMenu.setBoldFontForMenuText(mi);
                }
                PaletteItem[] layouts = SelectLayoutAction.getAllLayouts();
                for (int i = 0; i < layouts.length; ++i) {
                    mi = new JMenuItem(layouts[i].getNode().getDisplayName());
                    HelpCtx.setHelpIDString((JComponent)mi, (String)SelectLayoutAction.class.getName());
                    LayoutMenu.addSortedMenuItem(popup, mi);
                    mi.addActionListener(new LayoutActionListener(layouts[i]));
                    if (hasFreeDesignSupport || !this.isContainersLayout(container, layouts[i])) continue;
                    LayoutMenu.setBoldFontForMenuText(mi);
                }
                this.initialized = true;
            }
            return popup;
        }

        private boolean hasFreeDesignSupport(RADVisualContainer container) {
            return container != null && container.getLayoutSupport() == null;
        }

        private boolean isContainersLayout(RADVisualContainer container, PaletteItem layout) {
            return container != null && (container.getLayoutSupport().getLayoutDelegate().getSupportedClass() == layout.getComponentClass() || container.getLayoutSupport().getLayoutDelegate().getClass() == NullLayoutSupport.class && layout.getComponentClass() == NullLayoutSupport.class);
        }

        private static void addSortedMenuItem(JPopupMenu menu, JMenuItem menuItem) {
            int n = menu.getComponentCount();
            String text = menuItem.getText();
            for (int i = 2; i < n; ++i) {
                String tx;
                if (!(menu.getComponent(i) instanceof JMenuItem) || text.compareTo(tx = ((JMenuItem)menu.getComponent(i)).getText()) >= 0) continue;
                menu.add((Component)menuItem, i);
                return;
            }
            menu.add(menuItem);
        }

        private static void setBoldFontForMenuText(JMenuItem mi) {
            Font font = mi.getFont();
            mi.setFont(font.deriveFont(font.getStyle() | 1));
        }
    }
}

