/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.fakepeer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextComponent;
import java.awt.im.InputMethodRequests;
import org.netbeans.modules.form.fakepeer.FakeComponentPeer;
import org.netbeans.modules.form.fakepeer.FakePeerUtils;

class FakeTextComponentPeer
extends FakeComponentPeer {
    private String _text;
    private int _caretPosition = 0;
    private int selStart = -1;
    private int selEnd = -1;

    FakeTextComponentPeer(TextComponent target) {
        super(target);
    }

    Component createDelegate() {
        return new Delegate();
    }

    void initDelegate() {
        this._text = ((TextComponent)this._target).getText();
        super.initDelegate();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void setEditable(boolean editable) {
        this.repaint();
    }

    public String getText() {
        return this._text;
    }

    public void setText(String text) {
        this._text = text;
        this.repaint();
    }

    public int getSelectionStart() {
        return this.selStart;
    }

    public int getSelectionEnd() {
        return this.selEnd;
    }

    public void select(int selStart, int selEnd) {
        this.selStart = selStart;
        this.selEnd = selEnd;
    }

    public void setCaretPosition(int pos) {
        if (pos == 0 || this._text != null && this._text.length() > pos) {
            this._caretPosition = pos;
        }
    }

    public int getCaretPosition() {
        return this._caretPosition;
    }

    public int getIndexAtPoint(int x, int y) {
        return 0;
    }

    public Rectangle getCharacterBounds(int i) {
        return null;
    }

    public long filterEvents(long mask) {
        return 0L;
    }

    public InputMethodRequests getInputMethodRequests() {
        return null;
    }

    protected class Delegate
    extends Component {
        Delegate() {
            this.setBackground(SystemColor.window);
            this.setForeground(SystemColor.windowText);
        }

        public void paint(Graphics g) {
            Dimension sz = FakeTextComponentPeer.this._target.getSize();
            int w = sz.width;
            int h = sz.height;
            g.setColor(FakeTextComponentPeer.this._target.getBackground());
            FakePeerUtils.drawLoweredBox(g, 0, 0, w, h);
            Rectangle r = g.getClipBounds();
            if (r.x < 1) {
                r.x = 1;
            }
            if (r.y < 1) {
                r.y = 1;
            }
            if (r.width > w - 3) {
                r.width = w - 3;
            }
            if (r.height > h - 3) {
                r.height = h - 3;
            }
            g.setClip(r);
            if (FakeTextComponentPeer.this._target.isEnabled()) {
                g.setColor(FakeTextComponentPeer.this._target.getForeground());
            } else {
                g.setColor(SystemColor.controlShadow);
            }
        }
    }
}

