# ex: set ro:
# DO NOT EDIT THIS FILE
# Generated by Parrot::Configure::Compiler from config/gen/config_pm/config_pir.in

# $Id: config_pir.in 37201 2009-03-08 12:07:48Z fperrad $

=head1 TITLE

config.pir - Access Parrot configuration data

=head1 SYNOPSIS

  .sub _some
  ...
  # store the config data into $P0
  $P0 = _config()
  # Retrieve and print a key
  $P1 = $P0["cc"]
  print "Your C compiler is "
  print $P1
  print "\n"
  ...

 .end
 .include "library/config.pir"

=head1 DESCRIPTION

config.pir is a mechanism for accessing most of the data collected by
Configure.  It's roughly equivalent to Perl5's C<Config.pm> module.

At the end of a successful C<make> of Parrot, a PASM file generated by
Configure is run to put a file, F<config.fpmc>, into the library with a
frozen Hash of the configuration data.  This library provides a
function, C<_config>, to unpack and return that file's data.

C<_config> does not take any parameters.  It returns a single Hash
containing the data.  Keys that were C<undef> in Configure contain a
C<None> PMC; otherwise they contain a C<String>.

Note that the behavior of that hash when writing to any value (especially
undefined values) is undefined, and may be rather funky.

=cut

.include "interpinfo.pasm"
.include "stat.pasm"

.sub _config
    .local string prefix, conf_file
    prefix = interpinfo .INTERPINFO_RUNTIME_PREFIX

    $S0 = concat prefix, "/runtime"
    $I0 = stat $S0, .STAT_EXISTS
    if $I0 goto L1
    conf_file = prefix . "/lib/parrot/include/config.fpmc"
    goto L2
  L1:
    conf_file = prefix . "/runtime/parrot/include/config.fpmc"
  L2:

    .local pmc CONF
    CONF = new 'FileHandle'
    push_eh error
    .local string image
    image = CONF.'readall'(conf_file)
    pop_eh

    .local pmc conf_hash
    thaw conf_hash, image

    .local pmc one
    one = new 'Integer'
    one = 1
    setprop conf_hash, '_ro', one

    .return( conf_hash )

error:
    .local pmc ex
    .get_results (ex)
    $S0 = "Can't read '"
    $S0 .= conf_file
    $S0 .= "' : "
    $S1 = err
    $S0 .= $S1
    ex = $S0
    rethrow ex
.end

=head1 AUTHOR

Brent Royal-Gordon E<lt>brent@brentdax.comE<gt> is the author and maintainer.
Please send patches and suggestions to the Parrot porters mailing list.

=head1 COPYRIGHT

Copyright (C) 2004-2009, Parrot Foundation.

=cut

# Local Variables:
#   mode: pir
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4 ft=pir:
