'''OpenGL extension ARB.fragment_program

Overview (from the spec)
	
	Unextended OpenGL mandates a certain set of configurable per-
	fragment computations defining texture application, texture 
	environment, color sum, and fog operations.  Several extensions have 
	added further per-fragment computations to OpenGL.  For example, 
	extensions have defined new texture environment capabilities 
	(ARB_texture_env_add, ARB_texture_env_combine, ARB_texture_env_dot3,
	ARB_texture_env_crossbar), per-fragment depth comparisons 
	(ARB_depth_texture, ARB_shadow, ARB_shadow_ambient, 
	EXT_shadow_funcs), per-fragment lighting (EXT_fragment_lighting, 
	EXT_light_texture), and environment mapped bump mapping 
	(ATI_envmap_bumpmap).  
	
	Each such extension adds a small set of relatively inflexible per-
	fragment computations.
	
	This inflexibility is in contrast to the typical flexibility 
	provided by the underlying programmable floating point engines 
	(whether micro-coded fragment engines, DSPs, or CPUs) that are 
	traditionally used to implement OpenGL's texturing computations.  
	The purpose of this extension is to expose to the OpenGL application 
	writer a significant degree of per-fragment programmability for 
	computing fragment parameters.
	
	For the purposes of discussing this extension, a fragment program is 
	a sequence of floating-point 4-component vector operations that 
	determines how a set of program parameters (not specific to an
	individual fragment) and an input set of per-fragment parameters are 
	transformed to a set of per-fragment result parameters.
	
	The per-fragment computations for standard OpenGL given a particular 
	set of texture and fog application modes (along with any state for 
	extensions defining per-fragment computations) is, in essence, a 
	fragment program.  However, the sequence of operations is defined 
	implicitly by the current OpenGL state settings rather than defined 
	explicitly as a sequence of instructions.
	
	This extension provides an explicit mechanism for defining fragment 
	program instruction sequences for application-defined fragment 
	programs.  In order to define such fragment programs, this extension 
	defines a fragment programming model including a floating-point
	4-component vector instruction set and a relatively large set of 
	floating-point 4-component registers.
	
	The extension's fragment programming model is designed for efficient
	hardware implementation and to support a wide variety of fragment 
	programs.  By design, the entire set of existing fragment programs 
	defined by existing OpenGL per-fragment computation extensions can 
	be implemented using the extension's fragment programming model.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/ARB/fragment_program.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_ARB_fragment_program'
GL_FRAGMENT_PROGRAM_ARB = constant.Constant( 'GL_FRAGMENT_PROGRAM_ARB', 0x8804 )
glget.addGLGetConstant( GL_FRAGMENT_PROGRAM_ARB, (1,) )
GL_PROGRAM_ALU_INSTRUCTIONS_ARB = constant.Constant( 'GL_PROGRAM_ALU_INSTRUCTIONS_ARB', 0x8805 )
GL_PROGRAM_TEX_INSTRUCTIONS_ARB = constant.Constant( 'GL_PROGRAM_TEX_INSTRUCTIONS_ARB', 0x8806 )
GL_PROGRAM_TEX_INDIRECTIONS_ARB = constant.Constant( 'GL_PROGRAM_TEX_INDIRECTIONS_ARB', 0x8807 )
GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = constant.Constant( 'GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB', 0x8808 )
GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = constant.Constant( 'GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB', 0x8809 )
GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = constant.Constant( 'GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB', 0x880A )
GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB = constant.Constant( 'GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB', 0x880B )
GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB = constant.Constant( 'GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB', 0x880C )
GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB = constant.Constant( 'GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB', 0x880D )
GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = constant.Constant( 'GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB', 0x880E )
GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = constant.Constant( 'GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB', 0x880F )
GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = constant.Constant( 'GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB', 0x8810 )
GL_MAX_TEXTURE_COORDS_ARB = constant.Constant( 'GL_MAX_TEXTURE_COORDS_ARB', 0x8871 )
glget.addGLGetConstant( GL_MAX_TEXTURE_COORDS_ARB, (1,) )
GL_MAX_TEXTURE_IMAGE_UNITS_ARB = constant.Constant( 'GL_MAX_TEXTURE_IMAGE_UNITS_ARB', 0x8872 )
glget.addGLGetConstant( GL_MAX_TEXTURE_IMAGE_UNITS_ARB, (1,) )


def glInitFragmentProgramARB():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
