'\"
'\" Generated from file '/usr/obj/i386/tcllib-1.11.1/tcllib-1.11.1/modules/amazon-s3/S3.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) Copyright 2006,2008 Darren New. All Rights Reserved. See LICENSE.TXT for terms.
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "S3" n 1.0.0 amazon-s3 "Amazon S3 Web Service Interface"
.BS
.SH NAME
S3 \- Amazon S3 Web Service Interface
.SH SYNOPSIS
package require \fBTcl  8.5\fR
.sp
package require \fBsha1  1.0\fR
.sp
package require \fBmd5  2.0\fR
.sp
package require \fBbase64  2.3\fR
.sp
package require \fBxsxp  1.0\fR
.sp
\fBS3::Configure\fR ?\fB-reset\fR \fIboolean\fR? ?\fB-retries\fR \fIinteger\fR? ?\fB-accesskeyid\fR \fIidstring\fR? ?\fB-secretaccesskey\fR \fIidstring\fR? ?\fB-service-access-point\fR \fIFQDN\fR? ?\fB-use-tls\fR \fIboolean\fR? ?\fB-default-compare\fR \fIalways|never|exists|missing|newer|date|checksum|different\fR? ?\fB-default-separator\fR \fIstring\fR? ?\fB-default-acl\fR \fIprivate|public-read|public-read-write|authenticated-read|keep|calc\fR? ?\fB-default-bucket\fR \fIbucketname\fR?
.sp
\fBS3::SuggestBucket\fR ?\fIname\fR?
.sp
\fBS3::REST\fR \fIdict\fR
.sp
\fBS3::ListAllMyBuckets\fR ?\fB-blocking\fR \fIboolean\fR? ?\fB-parse-xml\fR \fIxmlstring\fR? ?\fB-result-type\fR \fIREST|xml|pxml|dict|names|owner\fR?
.sp
\fBS3::PutBucket\fR ?\fB-bucket\fR \fIbucketname\fR? ?\fB-blocking\fR \fIboolean\fR? ?\fB-acl\fR \fI{}|private|public-read|public-read-write|authenticated-read\fR?
.sp
\fBS3::DeleteBucket\fR ?\fB-bucket\fR \fIbucketname\fR? ?\fB-blocking\fR \fIboolean\fR?
.sp
\fBS3::GetBucket\fR ?\fB-bucket\fR \fIbucketname\fR? ?\fB-blocking\fR \fIboolean\fR? ?\fB-parse-xml\fR \fIxmlstring\fR? ?\fB-max-count\fR \fIinteger\fR? ?\fB-prefix\fR \fIprefixstring\fR? ?\fB-delimiter\fR \fIdelimiterstring\fR? ?\fB-result-type\fR \fIREST|xml|pxml|names|dict\fR?
.sp
\fBS3::Put\fR ?\fB-bucket\fR \fIbucketname\fR? \fB-resource\fR \fIresourcename\fR ?\fB-blocking\fR \fIboolean\fR? ?\fB-file\fR \fIfilename\fR? ?\fB-content\fR \fIcontentstring\fR? ?\fB-acl\fR \fIprivate|public-read|public-read-write|authenticated-read|calc|keep\fR? ?\fB-content-type\fR \fIcontenttypestring\fR? ?\fB-x-amz-meta-*\fR \fImetadatatext\fR? ?\fB-compare\fR \fIcomparemode\fR?
.sp
\fBS3::Get\fR ?\fB-bucket\fR \fIbucketname\fR? \fB-resource\fR \fIresourcename\fR ?\fB-blocking\fR \fIboolean\fR? ?\fB-compare\fR \fIcomparemode\fR? ?\fB-file\fR \fIfilename\fR? ?\fB-content\fR \fIcontentvarname\fR? ?\fB-timestamp\fR \fIaws|now\fR? ?\fB-headers\fR \fIheadervarname\fR?
.sp
\fBS3::Head\fR ?\fB-bucket\fR \fIbucketname\fR? \fB-resource\fR \fIresourcename\fR ?\fB-blocking\fR \fIboolean\fR? ?\fB-dict\fR \fIdictvarname\fR? ?\fB-headers\fR \fIheadersvarname\fR? ?\fB-status\fR \fIstatusvarname\fR?
.sp
\fBS3::GetAcl\fR ?\fB-blocking\fR \fIboolean\fR? ?\fB-bucket\fR \fIbucketname\fR? \fB-resource\fR \fIresourcename\fR ?\fB-result-type\fR \fIREST|xml|pxml\fR?
.sp
\fBS3::PutAcl\fR ?\fB-blocking\fR \fIboolean\fR? ?\fB-bucket\fR \fIbucketname\fR? \fB-resource\fR \fIresourcename\fR ?\fB-acl\fR \fInew-acl\fR?
.sp
\fBS3::Delete\fR ?\fB-bucket\fR \fIbucketname\fR? \fB-resource\fR \fIresourcename\fR ?\fB-blocking\fR \fIboolean\fR? ?\fB-status\fR \fIstatusvar\fR?
.sp
\fBS3::Push\fR ?\fB-bucket\fR \fIbucketname\fR? \fB-directory\fR \fIdirectoryname\fR ?\fB-prefix\fR \fIprefixstring\fR? ?\fB-compare\fR \fIcomparemode\fR? ?\fB-x-amz-meta-*\fR \fImetastring\fR? ?\fB-acl\fR \fIaclcode\fR? ?\fB-delete\fR \fIboolean\fR? ?\fB-error\fR \fIthrow|break|continue\fR? ?\fB-progress\fR \fIscriptprefix\fR?
.sp
\fBS3::Pull\fR ?\fB-bucket\fR \fIbucketname\fR? \fB-directory\fR \fIdirectoryname\fR ?\fB-prefix\fR \fIprefixstring\fR? ?\fB-blocking\fR \fIboolean\fR? ?\fB-compare\fR \fIcomparemode\fR? ?\fB-delete\fR \fIboolean\fR? ?\fB-timestamp\fR \fIaws|now\fR? ?\fB-error\fR \fIthrow|break|continue\fR? ?\fB-progress\fR \fIscriptprefix\fR?
.sp
\fBS3::Toss\fR ?\fB-bucket\fR \fIbucketname\fR? \fB-prefix\fR \fIprefixstring\fR ?\fB-blocking\fR \fIboolean\fR? ?\fB-error\fR \fIthrow|break|continue\fR? ?\fB-progress\fR \fIscriptprefix\fR?
.sp
.BE
.SH DESCRIPTION
This package provides access to Amazon's Simple Storage Solution web service.
.PP
As a quick summary, Amazon Simple Storage Solution
provides a for-fee web service allowing the storage of arbitrary data as
"resources" within "buckets" online.
See \fIhttp://www.amazonaws.com/\fR for details on that system.
Access to the service is via HTTP (SOAP or REST).  Much of this
documentation will not make sense if you're not familiar with
the terms and functionality of the Amazon S3 service.
.PP
This package provides services for reading and writing
the data items via the REST interface.  It also provides some
higher-level operations.  Other packages in the same distribution
provide for even more functionality.
.PP
Copyright 2006 Darren New. All Rights Reserved.
NO WARRANTIES OF ANY TYPE ARE PROVIDED.
COPYING OR USE INDEMNIFIES THE AUTHOR IN ALL WAYS.
This software is licensed under essentially the same
terms as Tcl. See LICENSE.txt for the terms.
.SH "ERROR REPORTING"
The error reporting from this package makes use of $errorCode to
provide more details on what happened than simply throwing an error.
Any error caught by the S3 package (and we try to catch them all)
will return with an $errorCode being a list having at least three
elements. In all cases, the first element will be "S3". The second
element will take on one of six values, with that element defining
the value of the third and subsequent elements. S3::REST does not
throw an error, but rather returns a dictionary with the keys "error",
"errorInfo", and "errorCode" set. This allows for reliable background
use. The possible second elements are these:
.TP
usage
The usage of the package is incorrect. For example,
a command has been invoked which requires the library to be configured
before the library has been configured, or an invalid combination of
options has been specified. The third element of $errorCode supplies
the name of the parameter that was wrong. The fourth usually provides
the arguments that were actually supplied to the throwing proc, unless
the usage error isn't confined to a single proc.
.TP
local
Something happened on the local system which threw
an error. For example, a request to upload or download a file was made
and the file permissions denied that sort of access. The third element
of $errorCode is the original $errorCode.
.TP
socket
Something happened with the socket. It closed
prematurely, or some other condition of failure-to-communicate-with-Amazon
was detected. The third element of $errorCode is the original $errorCode,
or sometimes the message from fcopy, or ...?
.TP
remote
The Amazon web service returned an error code outside
the 2xx range in the HTTP header. In other words, everything went as
documented, except this particular case was documented not to work.
The third element is the dictionary returned from \fB::S3::REST\fR.
Note that S3::REST itself never throws this error, but just returns
the dictionary. Most of the higher-level commands throw for convenience,
unless an argument indicates they should not. If something is documented
as "not throwing an S3 remote error", it means a status return is set
rather than throwing an error if Amazon returns a non-2XX HTTP result code.
.TP
notyet
The user obeyed the documentation, but the author
has not yet gotten around to implementing this feature. (Right now,
only TLS support and sophisticated permissions fall into this category,
as well as the S3::Acl command.)
.TP
xml
The service has returned invalid XML, or XML whose
schema is unexpected. For the high-level commands that accept
service XML as input for parsing, this may also be thrown.
.PP
.SH COMMANDS
This package provides several separate levels of complexity.
.IP \(bu
The lowest level simply takes arguments to be sent to the service,
sends them, retrieves the result, and provides it to the caller.
\fINote:\fR This layer allows both synchronous and event-driven
processing. It depends on the MD5 and SHA1 and base64 packages
from Tcllib (available at \fIhttp://tcllib.sourceforge.net/\fR).
Note that \fBS3::Configure\fR is required for \fBS3::REST\fR to
work due to the authentication portion, so we put that in the "lowest level."
.IP \(bu
The next layer parses the results of calls, allowing for functionality
such as uploading only changed files, synchronizing directories,
and so on.  This layer depends on the \fBTclXML\fR package as well as the
included \fBxsxp\fR package. These packages are package required when
these more-sophisticated routines are called, so nothing breaks if
they are not correctly installed.
.IP \(bu
Also included is a separate program that uses the library.
It provides code to parse $argv0 and $argv from the
command line, allowing invocation as a tclkit, etc.
(Not yet implmented.)
.IP \(bu
Another separate program provides a GUI interface allowing drag-and-drop
and other such functionality. (Not yet implemented.)
.IP \(bu
Also built on this package is the OddJob program. It is
a separate program designed to allow distribution of
computational work units over Amazon's Elastic Compute
Cloud web service.
.PP
.PP
The goal is to have at least the bottom-most layers implemented in
pure Tcl using only that which comes from widely-available sources,
such as Tcllib.
.SH "LOW LEVEL COMMANDS"
These commands do not require any packages not listed above.
They talk directly to the service, or they are utility or
configuration routines. Note that the "xsxp" package was
written to support this package, so it should be available
wherever you got this package.
.TP
\fBS3::Configure\fR ?\fB-reset\fR \fIboolean\fR? ?\fB-retries\fR \fIinteger\fR? ?\fB-accesskeyid\fR \fIidstring\fR? ?\fB-secretaccesskey\fR \fIidstring\fR? ?\fB-service-access-point\fR \fIFQDN\fR? ?\fB-use-tls\fR \fIboolean\fR? ?\fB-default-compare\fR \fIalways|never|exists|missing|newer|date|checksum|different\fR? ?\fB-default-separator\fR \fIstring\fR? ?\fB-default-acl\fR \fIprivate|public-read|public-read-write|authenticated-read|keep|calc\fR? ?\fB-default-bucket\fR \fIbucketname\fR?
There is one command for configuration, and that is \fBS3::Configure\fR.
If called with no arguments, it returns a
dictionary of key/value pairs listing all current settings.  If called
with one argument, it returns the value of that single argument.  If
called with two or more arguments, it must be called with pairs of
arguments, and it applies the changes in order.  There is only one set
of configuration information per interpreter.
.sp
The following options are accepted:
.RS
.TP
\fB-reset\fR \fIboolean\fR
By default, false.  If true, any previous changes and any changes on the
same call before the reset option will be returned to default values.
.TP
\fB-retries\fR \fIinteger\fR
Default value is 3.
If Amazon returns a 500 error, a retry after an exponential
backoff delay will be tried this many times before finally
throwing the 500 error. This applies to each call to \fBS3::REST\fR
from the higher-level commands, but not to \fBS3::REST\fR itself.
That is, \fBS3::REST\fR will always return httpstatus 500 if that's
what it receives. Functions like \fBS3::Put\fR will retry the PUT call,
and will also retry the GET and HEAD calls used to do content comparison.
Changing this to 0 will prevent retries and their associated delays.
In addition, socket errors (i.e., errors whose errorCode starts with
"S3 socket") will be similarly retried after backoffs.
.TP
\fB-accesskeyid\fR \fIidstring\fR
.TP
\fB-secretaccesskey\fR \fIidstring\fR
Each defaults to an empty string.
These must be set before any calls are made. This is your S3 ID.
Once you sign up for an account, go to \fIhttp://www.amazonaws.com/\fR,
sign in, go to the "Your Web Services Account" button, pick "AWS
Access Identifiers", and your access key ID and secret access keys
will be available. All \fBS3::REST\fR calls are authenticated.
Blame Amazon for the poor choice of names.
.TP
\fB-service-access-point\fR \fIFQDN\fR
Defaults to "s3.amazonaws.com". This is the fully-qualified domain
name of the server to contact for \fBS3::REST\fR calls. You should
probably never need to touch this, unless someone else implements
a compatible service, or you wish to test something by pointing
the library at your own service.
.TP
\fB-slop-seconds\fR \fIinteger\fR
When comparing dates between Amazon and the local machine,
two dates within this many seconds of each other are considered
the same. Useful for clock drift correction, processing overhead
time, and so on.
.TP
\fB-use-tls\fR \fIboolean\fR
Defaults to false. This is not yet implemented. If true, \fBS3::REST\fR will
negotiate a TLS connection to Amazon. If false, unencrypted connections
are used.
.TP
\fB-bucket-prefix\fR \fIstring\fR
Defaults to "TclS3".  This string is used by \fBS3::SuggestBucketName\fR
if that command is passed an empty string as an argument. It is used
to distinguish different applications using the Amazon service.
Your application should always set this to keep from interfering with
the buckets of other users of Amazon S3 or with other buckets of the
same user.
.TP
\fB-default-compare\fR \fIalways|never|exists|missing|newer|date|checksum|different\fR
Defaults to "always." If no -compare is specified on
\fBS3::Put\fR, \fBS3::Get\fR, or \fBS3::Delete\fR, this comparison is used.
See those commands for a description of the meaning.
.TP
\fB-default-separator\fR \fIstring\fR
Defaults to "/". This is currently unused. It might make sense to use
this for \fBS3::Push\fR and \fBS3::Pull\fR, but allowing resources to
have slashes in their names that aren't marking directories would be
problematic. Hence, this currently does nothing.
.TP
\fB-default-acl\fR \fIprivate|public-read|public-read-write|authenticated-read|keep|calc\fR
Defaults to an empty string. If no -acl argument is provided to \fBS3::Put\fR or
\fBS3::Push\fR, this string is used
(given as the x-amz-acl header if not keep or calc). If this is also
empty, no x-amz-acl header is generated.
This is \fInot\fR used by \fBS3::REST\fR.
.TP
\fB-default-bucket\fR \fIbucketname\fR
If no bucket is given to \fBS3::GetBucket\fR, \fBS3::PutBucket\fR,
\fBS3::Get\fR, \fBS3::Put\fR,
\fBS3::Head\fR, \fBS3::Acl\fR,
\fBS3::Delete\fR, \fBS3::Push\fR,
\fBS3::Pull\fR, or \fBS3::Toss\fR, and if this configuration variable
is not an empty string (and not simply "/"), then this value
will be used for the bucket. This is useful if one program does
a large amount of resource manipulation within a single bucket.
.RE
.sp
.TP
\fBS3::SuggestBucket\fR ?\fIname\fR?
The \fBS3::SuggestBucket\fR command accepts an optional string as
a prefix and returns a valid bucket containing the \fIname\fR argument
and the Access Key ID. This makes the name unique to the owner and
to the application (assuming the application picks a good \fIname\fR argument).
If no name is provided,
the name from \fBS3::Configure\fR \fI-bucket-prefix\fR is used.
If that too is empty (which is not the default), an error is thrown.
.TP
\fBS3::REST\fR \fIdict\fR
The \fBS3::REST\fR command takes as an argument a dictionary and
returns a dictionary.  The return dictionary has the same keys
as the input dictionary, and includes additional keys as the result.
The presence or absence of keys in the input dictionary can control
the behavior of the routine.  It never throws an error directly, but
includes keys "error", "errorInfo", and "errorCode" if necessary.
Some keys are required, some optional. The routine can run either
in blocking or non-blocking mode, based on the presense
of \fBresultvar\fR in the input dictionary. This requires
the \fI-accesskeyid\fR and \fI-secretaccesskey\fR to be configured via
\fBS3::Configure\fR before being called.
.sp
The possible input keys are these:
.RS
.TP
\fBverb\fR \fIGET|PUT|DELETE|HEAD\fR
This required item indicates the verb to be used.
.TP
\fBresource\fR \fIstring\fR
This required item indicates the resource to be accessed.
A leading / is added if not there already. It will
be URL-encoded for you if necessary. Do not supply a
resource name that is already URL-encoded.
.TP
?\fBrtype\fR \fItorrent|acl\fR?
This indicates a torrent or acl resource is being manipulated.
Do not include this in the \fBresource\fR key, or the
"?" separator will get URL-encoded.
.TP
?\fBparameters\fR \fIdict\fR?
This optional dictionary provides parameters added to the URL
for the transaction. The keys must be in the correct case
(which is confusing in the Amazon documentation) and the
values must be valid. This can be an empty dictionary or
omitted entirely if no parameters are desired. No other
error checking on parameters is performed.
.TP
?\fBheaders\fR \fIdict\fR?
This optional dictionary provides headers to be added
to the HTTP request. The keys must be in \fIlower case\fR
for the authentication to work. The values must not contain
embedded newlines or carriage returns. This is primarily
useful for adding x-amz-* headers. Since authentication
is calculated by \fBS3::REST\fR, do not add that header here.
Since content-type gets its own key, also do not add
that header here.
.TP
?\fBinbody\fR \fIcontentstring\fR?
This optional item, if provided, gives the content that will
be sent. It is sent with a tranfer encoding of binary, and
only the low bytes are used, so use [encoding convertto utf-8]
if the string is a utf-8 string. This is written all in one blast,
so if you are using non-blocking mode and the \fBinbody\fR is
especially large, you may wind up blocking on the write socket.
.TP
?\fBinfile\fR \fIfilename\fR?
This optional item, if provided, and if \fBinbody\fR is not provided,
names the file from which the body of the HTTP message will be
constructed. The file is opened for reading and sent progressively
by [fcopy], so it should not block in non-blocking mode
even if the file is very large. The file is transfered in
binary mode, so the bytes on your disk will match the bytes
in your resource. Due to HTTP restrictions, it must be possible to
use [file size] on this file to determine the size at the
start of the transaction.
.TP
?\fBS3chan\fR \fIchannel\fR?
This optional item, if provided, indicates the already-open socket
over which the transaction should be conducted. If not provided,
a connection is made to the service access point specified via
\fBS3::Configure\fR, which is normally s3.amazonaws.com. If this
is provided, the channel is not closed at the end of the transaction.
.TP
?\fBoutchan\fR \fIchannel\fR?
This optional item, if provided, indicates the already-open channel
to which the body returned from S3 should be written. That is,
to retrieve a large resource, open a file, set the translation mode,
and pass the channel as the value of the key outchan. Output
will be written to the channel in pieces so memory does not fill
up unnecessarily. The channel is not closed at the end of the transaction.
.TP
?\fBresultvar\fR \fIvarname\fR?
This optional item, if provided, indicates that \fBS3::REST\fR should
run in non-blocking mode. The \fIvarname\fR should be fully qualified
with respect to namespaces and cannot be local to a proc. If provided,
the result of the \fBS3::REST\fR call is assigned to this variable once
everything has completed; use trace or vwait to know when this has happened.
If this key is not provided, the result is simply returned from the
call to \fBS3::REST\fR and no calls to the eventloop are invoked from
within this call.
.TP
?\fBthrowsocket\fR \fIthrow|return\fR?
This optional item, if provided, indicates that \fBS3::REST\fR should
throw an error if throwmode is throw and a socket error is encountered.
It indicates that \fBS3::REST\fR should return the error code in the
returned dictionary if a socket error is encountered and this is
set to return. If \fBthrowsocket\fR is set to \fIreturn\fR or
if the call is not blocking, then a socket error (i.e., an error
whose error code starts with "S3 socket" will be returned in the
dictionary as \fBerror\fR, \fBerrorInfo\fR, and \fBerrorCode\fR.
If a foreground call is made (i.e., \fBresultvar\fR is not provided),
and this option is not provided or is set to \fIthrow\fR, then
\fBerror\fR will be invoked instead.
.RE
.sp
Once the call to \fBS3::REST\fR completes, a new dict is returned,
either in the \fIresultvar\fR or as the result of execution. This dict is
a copy of the original dict with the results added as new keys. The possible
new keys are these:
.RS
.TP
\fBerror\fR \fIerrorstring\fR
.TP
\fBerrorInfo\fR \fIerrorstring\fR
.TP
\fBerrorCode\fR \fIerrorstring\fR
If an error is caught, these three keys will be set in the result.
Note that \fBS3::REST\fR does \fInot\fR consider a non-2XX HTTP
return code as an error. The \fBerrorCode\fR value will be
formatted according to the \fBERROR REPORTING\fR description.
If these are present, other keys described here might not be.
.TP
\fBhttpstatus\fR \fIthreedigits\fR
The three-digit code from the HTTP transaction. 2XX for good,
5XX for server error, etc.
.TP
\fBhttpmessage\fR \fItext\fR
The textual result after the status code. "OK" or "Forbidden"
or etc.
.TP
\fBoutbody\fR \fIcontentstring\fR
If \fIoutchan\fR was not specified, this key will hold a
reference to the (unencoded) contents of the body returned.
If Amazon returned an error (a la the httpstatus not a 2XX value),
the error message will be in \fBoutbody\fR or written to
\fBoutchan\fR as appropriate.
.TP
\fBoutheaders\fR \fIdict\fR
This contains a dictionary of headers returned by Amazon.
The keys are always lower case. It's mainly useful for
finding the x-amz-meta-* headers, if any, although things
like last-modified and content-type are also useful.
The keys of this dictionary are always lower case.
Both keys and values are trimmed of extraneous whitespace.
.RE
.PP
.SH "HIGH LEVEL COMMANDS"
The routines in this section all make use of one or more calls
to \fBS3::REST\fR to do their work, then parse and manage the data
in a convenient way.  All these commands throw errors
as described in \fBERROR REPORTING\fR unless otherwise noted.
.PP
In all these commands, all arguments are presented as name/value pairs,
in any order. All the argument names start with a hyphen.
.PP
There are a few options that are common to many
of the commands, and those common options are documented here.
.TP
\fB-blocking\fR \fIboolean\fR
If provided and specified as false,
then any calls to \fBS3:REST\fR will be non-blocking,
and internally these routines will call [vwait] to get
the results. In other words, these routines will return the
same value, but they'll have event loops running while waiting
for Amazon.
.TP
\fB-parse-xml\fR \fIxmlstring\fR
If provided, the routine skips actually communicating with
Amazon, and instead behaves as if the XML string provided
was returned as the body of the call. Since several of
these routines allow the return of data in various formats,
this argument can be used to parse existing XML to extract
the bits of information that are needed. It's also helpful
for testing.
.TP
\fB-bucket\fR \fIbucketname\fR
Almost every high-level command needs to know what bucket
the resources are in. This option specifies that. (Only the
command to list available buckets does not require this parameter.)
This does not need to be URL-encoded, even if it contains
special or non-ASCII characters. May or may not contain leading
or trailing spaces - commands normalize the bucket. If this is
not supplied, the value is taken from \fBS3::Configure -default-bucket\fR
if that string isn't empty. Note that spaces and slashes are
always trimmed from both ends and the rest must leave a valid bucket.
.TP
\fB-resource\fR \fIresourcename\fR
This specifies the resource of interest within the bucket.
It may or may not start with a slash - both cases are handled.
This does not need to be URL-encoded, even if it contains
special or non-ASCII characters.
.TP
\fB-compare\fR \fIalways|never|exists|missing|newer|date|checksum|different\fR
When commands copy resources to files or files to resources, the caller may specify that the copy should be skipped if the contents are the same. This argument specifies the conditions under which the files should be copied. If it is not passed, the result of \fBS3::Configure -default-compare\fR is used, which in turn defaults to "always." The meanings of the various values are these:
.RS
.TP
\fIalways\fR
Always copy the data. This is the default.
.TP
\fInever\fR
Never copy the data. This is essentially a no-op, except in \fBS3::Push\fR and \fBS3::Pull\fR where the -delete flag might make a difference.
.TP
\fIexists\fR
Copy the data only if the destination already exists.
.TP
\fImissing\fR
Copy the data only if the destination does not already exist.
.TP
\fInewer\fR
Copy the data if the destination is missing, or if the date on the source is
newer than the date on the destination by at
least \fBS3::Configure -slop-seconds\fR seconds. If the source is
Amazon, the date is taken from the Last-Modified header. If the
source is local, it is taken as the mtime of the file. If the source data
is specified in a string rather than a file, it is taken as right now,
via [clock seconds].
.TP
\fIdate\fR
Like \fInewer\fR, except copy if the date is newer \fIor\fR older.
.TP
\fIchecksum\fR
Calculate the MD5 checksum on the local file or string, ask Amazon for the eTag
of the resource, and copy the data if they're different. Copy the data
also if the destination is missing. Note that this can be slow with
large local files unless the C version of the MD5 support is available.
.TP
\fIdifferent\fR
Copy the data if the destination does not exist.
If the destination exists and an actual file name was specified
(rather than a content string),
and the date on the file differs from the date on the resource,
copy the data.
If the data is provided as a content string, the "date" is treated
as "right now", so it will likely always differ unless slop-seconds is large.
If the dates are the same, the MD5 checksums are compared, and the
data is copied if the checksums differ.
.RE
.sp
Note that "newer" and "date" don't care about the contents, and "checksum" doesn't care about the dates, but "different" checks both.
.TP
\fBS3::ListAllMyBuckets\fR ?\fB-blocking\fR \fIboolean\fR? ?\fB-parse-xml\fR \fIxmlstring\fR? ?\fB-result-type\fR \fIREST|xml|pxml|dict|names|owner\fR?
This routine performs a GET on the Amazon S3 service, which is
defined to return a list of buckets owned by the account identified
by the authorization header. (Blame Amazon for the dumb names.)
.RS
.TP
\fB-blocking\fR \fIboolean\fR
See above for standard definition.
.TP
\fB-parse-xml\fR \fIxmlstring\fR
See above for standard definition.
.TP
\fB-result-type\fR \fIREST\fR
The dictionary returned by \fBS3::REST\fR is the return value of \fBS3::ListAllMyBuckets\fR. In this case, a non-2XX httpstatus will not throw an error. You may not combine this with \fI-parse-xml\fR.
.TP
\fB-result-type\fR \fIxml\fR
The raw XML of the body is returned as the result (with no encoding applied).
.TP
\fB-result-type\fR \fIpxml\fR
The XML of the body as parsed by \fBxsxp::parse\fR is returned.
.TP
\fB-result-type\fR \fIdict\fR
A dictionary of interesting portions of the XML is returned. The dictionary contains the following keys:
.RS
.TP
Owner/ID
The Amazon AWS ID (in hex) of the owner of the bucket.
.TP
Owner/DisplayName
The Amazon AWS ID's Display Name.
.TP
Bucket/Name
A list of names, one for each bucket.
.TP
Bucket/CreationDate
A list of dates, one for each bucket,
in the same order as Bucket/Name, in ISO format (as returned by Amazon).
.RE
.sp
.TP
\fB-result-type\fR \fInames\fR
A list of bucket names is returned with all other information stripped out.
This is the default result type for this command.
.TP
\fB-result-type\fR \fIowner\fR
A list containing two elements is returned. The first element is
the owner's ID, and the second is the owner's display name.
.RE
.sp
.TP
\fBS3::PutBucket\fR ?\fB-bucket\fR \fIbucketname\fR? ?\fB-blocking\fR \fIboolean\fR? ?\fB-acl\fR \fI{}|private|public-read|public-read-write|authenticated-read\fR?
This command creates a bucket if it does not already exist. Bucket names are
globally unique, so you may get a "Forbidden" error from Amazon even if you
cannot see the bucket in \fBS3::ListAllMyBuckets\fR. See \fBS3::SuggestBucket\fR for ways to minimize this risk. The x-amz-acl header comes from the \fB-acl\fR option, or from \fBS3::Configure -default-acl\fR if not specified.
.TP
\fBS3::DeleteBucket\fR ?\fB-bucket\fR \fIbucketname\fR? ?\fB-blocking\fR \fIboolean\fR?
This command deletes a bucket if it is empty and you have such permission.
Note that Amazon's list of buckets is a global resource, requiring
far-flung synchronization. If you delete a bucket, it may be quite
a few minutes (or hours) before you can recreate it, yielding "Conflict"
errors until then.
.TP
\fBS3::GetBucket\fR ?\fB-bucket\fR \fIbucketname\fR? ?\fB-blocking\fR \fIboolean\fR? ?\fB-parse-xml\fR \fIxmlstring\fR? ?\fB-max-count\fR \fIinteger\fR? ?\fB-prefix\fR \fIprefixstring\fR? ?\fB-delimiter\fR \fIdelimiterstring\fR? ?\fB-result-type\fR \fIREST|xml|pxml|names|dict\fR?
This lists the contents of a bucket. That is, it returns a directory
listing of resources within a bucket, rather than transfering any
user data.
.RS
.TP
\fB-bucket\fR \fIbucketname\fR
The standard bucket argument.
.TP
\fB-blocking\fR \fIboolean\fR
The standard blocking argument.
.TP
\fB-parse-xml\fR \fIxmlstring\fR
The standard parse-xml argument.
.TP
\fB-max-count\fR \fIinteger\fR
If supplied, this is the most number of records to be returned.
If not supplied, the code will iterate until all records have been found.
Not compatible with -parse-xml. Note that if this is supplied, only
one call to \fBS3::REST\fR will be made. Otherwise, enough calls
will be made to exhaust the listing, buffering results in memory,
so take care if you may have huge buckets.
.TP
\fB-prefix\fR \fIprefixstring\fR
If present, restricts listing to resources with a particular prefix. One
leading / is stripped if present.
.TP
\fB-delimiter\fR \fIdelimiterstring\fR
If present, specifies a delimiter for the listing.
The presence of this will summarize multiple resources
into one entry, as if S3 supported directories. See the
Amazon documentation for details.
.TP
\fB-result-type\fR \fIREST|xml|pxml|names|dict\fR
This indicates the format of the return result of the command.
.RS
.TP
REST
If \fI-max-count\fR is specified, the dictionary returned
from \fBS3::REST\fR is returned. If \fI-max-count\fR is
not specified, a list of all the dictionaries returned from
the one or more calls to \fBS3::REST\fR is returned.
.TP
xml
If \fI-max-count\fR is specified, the body returned
from \fBS3::REST\fR is returned. If \fI-max-count\fR is
not specified, a list of all the bodies returned from
the one or more calls to \fBS3::REST\fR is returned.
.TP
pxml
If \fI-max-count\fR is specified, the body returned
from \fBS3::REST\fR is passed throught \fBxsxp::parse\fR and then returned.
If \fI-max-count\fR is
not specified, a list of all the bodies returned from
the one or more calls to \fBS3::REST\fR are each passed through
\fBxsxp::parse\fR and then returned.
.TP
names
Returns a list of all names found in either the Contents/Key fields or
the CommonPrefixes/Prefix fields. If no \fI-delimiter\fR is specified
and no \fI-max-count\fR is specified, this returns a list of all
resources with the specified \fI-prefix\fR.
.TP
dict
Returns a dictionary. (Returns only one dictionary even if \fI-max-count\fR
wasn't specified.) The keys of the dictionary are as follows:
.RS
.TP
Name
The name of the bucket (from the final call to \fBS3::REST\fR).
.TP
Prefix
From the final call to \fBS3::REST\fR.
.TP
Marker
From the final call to \fBS3::REST\fR.
.TP
MaxKeys
From the final call to \fBS3::REST\fR.
.TP
IsTruncated
From the final call to \fBS3::REST\fR, so
always false if \fI-max-count\fR is not specified.
.TP
NextMarker
Always provided if IsTruncated is true, and
calculated of Amazon does not provide it. May be empty if IsTruncated is false.
.TP
Key
A list of names of resources in the bucket matching the \fI-prefix\fR and \fI-delimiter\fR restrictions.
.TP
LastModified
A list of times of resources in the bucket, in the same
order as Key, in the format returned by Amazon. (I.e., it is not parsed into
a seconds-from-epoch.)
.TP
ETag
A list of entity tags (a.k.a. MD5 checksums) in the same order as Key.
.TP
Size
A list of sizes in bytes of the resources, in the same order as Key.
.TP
Owner/ID
A list of owners of the resources in the bucket, in the same order as Key.
.TP
Owner/DisplayName
A list of owners of the resources in the bucket, in the same order as Key. These are the display names.
.TP
CommonPrefixes/Prefix
A list of prefixes common to multiple entities. This is present only if \fI-delimiter\fR was supplied.
.RE
.RE
.RE
.TP
\fBS3::Put\fR ?\fB-bucket\fR \fIbucketname\fR? \fB-resource\fR \fIresourcename\fR ?\fB-blocking\fR \fIboolean\fR? ?\fB-file\fR \fIfilename\fR? ?\fB-content\fR \fIcontentstring\fR? ?\fB-acl\fR \fIprivate|public-read|public-read-write|authenticated-read|calc|keep\fR? ?\fB-content-type\fR \fIcontenttypestring\fR? ?\fB-x-amz-meta-*\fR \fImetadatatext\fR? ?\fB-compare\fR \fIcomparemode\fR?
This command sends data to a resource on Amazon's servers for storage,
using the HTTP PUT command. It returns 0 if the \fB-compare\fR mode
prevented the transfer, 1 if the transfer worked, or throws an error
if the transfer was attempted but failed.
Server 5XX errors and S3 socket errors are retried
according to \fBS3:Configure -retries\fR settings before throwing an error;
other errors throw immediately.
.RS
.TP
\fB-bucket\fR
This specifies the bucket into which the resource will be written.
Leading and/or trailing slashes are removed for you, as are spaces.
.TP
\fB-resource\fR
This is the full name of the resource within the bucket. A single
leading slash is removed, but not a trailing slash.
Spaces are not trimmed.
.TP
\fB-blocking\fR
The standard blocking flag.
.TP
\fB-file\fR
If this is specified, the \fIfilename\fR must exist, must be readable,
and must not be a special or directory file. [file size] must
apply to it and must not change for the lifetime of the call.  The
default content-type is calculated based on the name and/or contents
of the file. Specifying this is an error if \fB-content\fR is
also specified, but at least one of \fB-file\fR or \fB-content\fR must
be specified. (The file is allowed to not exist or not be readable if
\fB-compare\fR \fInever\fR is specified.)
.TP
\fB-content\fR
If this is specified, the \fIcontentstring\fR is sent as the body
of the resource. The content-type defaults to "application/octet-string".
Only the low bytes are sent, so non-ASCII should use the appropriate encoding
(such as [encoding convertto utf-8]) before passing it
to this routine, if necessary. Specifying this is an error if \fB-file\fR
is also specified, but at least one of \fB-file\fR or \fB-content\fR must
be specified.
.TP
\fB-acl\fR
This defaults to \fBS3::Configure -default-acl\fR if not specified.
It sets the x-amz-acl header on the PUT operation.
If the value provided is \fIcalc\fR, the x-amz-acl header is
calculated based on the I/O permissions of the file to be uploaded;
it is an error to specify \fIcalc\fR and \fB-content\fR.
If the value provided is \fIkeep\fR, the acl of the resource
is read before the PUT (or the default is used if the
resource does not exist), then set back to what it
was after the PUT (if it existed). An error will occur if
the resource is successfully written but the kept ACL cannot
be then applied. This should never happen.
\fINote:\fR  \fIcalc\fR is not currently fully implemented.
.TP
\fB-x-amz-meta-*\fR
If any header starts with "-x-amz-meta-", its contents are added to the
PUT command to be stored as metadata with the resource. Again, no
encoding is performed, and the metadata should not contain characters
like newlines, carriage returns, and so on. It is best to stick with
simple ASCII strings, or to fix the library in several places.
.TP
\fB-content-type\fR
This overrides the content-type calculated by \fB-file\fR or
sets the content-type for \fB-content\fR.
.TP
\fB-compare\fR
This is the standard compare mode argument. \fBS3::Put\fR returns
1 if the data was copied or 0 if the data was skipped due to
the comparison mode so indicating it should be skipped.
.RE
.sp
.TP
\fBS3::Get\fR ?\fB-bucket\fR \fIbucketname\fR? \fB-resource\fR \fIresourcename\fR ?\fB-blocking\fR \fIboolean\fR? ?\fB-compare\fR \fIcomparemode\fR? ?\fB-file\fR \fIfilename\fR? ?\fB-content\fR \fIcontentvarname\fR? ?\fB-timestamp\fR \fIaws|now\fR? ?\fB-headers\fR \fIheadervarname\fR?
This command retrieves data from a resource on Amazon's S3 servers,
using the HTTP GET command. It returns 0 if the \fB-compare\fR mode
prevented the transfer, 1 if the transfer worked, or throws an error
if the transfer was attempted but failed. Server 5XX errors and S3 socket
errors are are retried
according to \fBS3:Configure\fR settings before throwing an error;
other errors throw immediately. Note that this is always authenticated
as the user configured in via \fBS3::Configure -accesskeyid\fR. Use
the Tcllib http for unauthenticated GETs.
.RS
.TP
\fB-bucket\fR
This specifies the bucket from which the resource will be read.
Leading and/or trailing slashes are removed for you, as are spaces.
.TP
\fB-resource\fR
This is the full name of the resource within the bucket. A single
leading slash is removed, but not a trailing slash.
Spaces are not trimmed.
.TP
\fB-blocking\fR
The standard blocking flag.
.TP
\fB-file\fR
If this is specified, the body of the resource will be read into this file,
incrementally without pulling it entirely into memory first. The parent
directory must already exist. If the file already exists, it must be
writable. If an error is thrown part-way through the process and the
file already existed, it may be clobbered. If an error is thrown part-way
through the process and the file did not already exist, any partial
bits will be deleted. Specifying this is an error if \fB-content\fR
is also specified, but at least one of \fB-file\fR or \fB-content\fR must
be specified.
.TP
\fB-timestamp\fR
This is only valid in conjunction with \fB-file\fR. It may be specified
as \fInow\fR or \fIaws\fR. The default is \fInow\fR. If \fInow\fR, the file's
modification date is left up to the system. If \fIaws\fR, the file's
mtime is set to match the Last-Modified header on the resource, synchronizing
the two appropriately for \fB-compare\fR \fIdate\fR or
\fB-compare\fR \fInewer\fR.
.TP
\fB-content\fR
If this is specified, the \fIcontentvarname\fR is a variable in the caller's
scope (not necessarily global) that receives the value of the body of
the resource. No encoding is done, so if the resource (for example) represents
a UTF-8 byte sequence, use [encoding convertfrom utf-8] to get a valid
UTF-8 string. If this is specified, the \fB-compare\fR is ignored unless
it is \fInever\fR, in which case no assignment to \fIcontentvarname\fR is
performed. Specifying this is an error if \fB-file\fR is also specified,
but at least one of \fB-file\fR or \fB-content\fR must be specified.
.TP
\fB-compare\fR
This is the standard compare mode argument. \fBS3::Get\fR returns
1 if the data was copied or 0 if the data was skipped due to
the comparison mode so indicating it should be skipped.
.TP
\fB-headers\fR
If this is specified, the headers resulting from the fetch are stored
in the provided variable, as a dictionary. This will include content-type
and x-amz-meta-* headers, as well as the usual HTTP headers, the x-amz-id
debugging headers, and so on. If no file is fetched (due to \fB-compare\fR
or other errors), no assignment to this variable is performed.
.RE
.sp
.TP
\fBS3::Head\fR ?\fB-bucket\fR \fIbucketname\fR? \fB-resource\fR \fIresourcename\fR ?\fB-blocking\fR \fIboolean\fR? ?\fB-dict\fR \fIdictvarname\fR? ?\fB-headers\fR \fIheadersvarname\fR? ?\fB-status\fR \fIstatusvarname\fR?
This command requests HEAD from the resource.
It returns whether a 2XX code was returned as a result
of the request, never throwing an S3 remote error.
That is, if this returns 1, the resource exists and is
accessible. If this returns 0, something went wrong, and the
\fB-status\fR result can be consulted for details.
.RS
.TP
\fB-bucket\fR
This specifies the bucket from which the resource will be read.
Leading and/or trailing slashes are removed for you, as are spaces.
.TP
\fB-resource\fR
This is the full name of the resource within the bucket. A single
leading slash is removed, but not a trailing slash.
Spaces are not trimmed.
.TP
\fB-blocking\fR
The standard blocking flag.
.TP
\fB-dict\fR
If specified, the resulting dictionary from the \fBS3::REST\fR
call is assigned to the indicated (not necessarily global) variable
in the caller's scope.
.TP
\fB-headers\fR
If specified, the dictionary of headers from the result are assigned
to the indicated (not necessarily global) variable in the caller's scope.
.TP
\fB-status\fR
If specified, the indicated (not necessarily global) variable in
the caller's scope is assigned a 2-element list. The first element is
the 3-digit HTTP status code, while the second element is
the HTTP message (such as "OK" or "Forbidden").
.RE
.TP
\fBS3::GetAcl\fR ?\fB-blocking\fR \fIboolean\fR? ?\fB-bucket\fR \fIbucketname\fR? \fB-resource\fR \fIresourcename\fR ?\fB-result-type\fR \fIREST|xml|pxml\fR?
This command gets the ACL of the indicated resource or throws an
error if it is unavailable.
.RS
.TP
\fB-blocking\fR \fIboolean\fR
See above for standard definition.
.TP
\fB-bucket\fR
This specifies the bucket from which the resource will be read.
Leading and/or trailing slashes are removed for you, as are spaces.
.TP
\fB-resource\fR
This is the full name of the resource within the bucket. A single
leading slash is removed, but not a trailing slash.
Spaces are not trimmed.
.TP
\fB-parse-xml\fR \fIxml\fR
The XML from a previous GetACL can be passed in to be parsed into
dictionary form.  In this case, -result-type must be pxml or dict.
.TP
\fB-result-type\fR \fIREST\fR
The dictionary returned by \fBS3::REST\fR is the return value of
\fBS3::GetAcl\fR.  In this case, a non-2XX httpstatus will not throw an
error.
.TP
\fB-result-type\fR \fIxml\fR
The raw XML of the body is returned as the result (with no encoding applied).
.TP
\fB-result-type\fR \fIpxml\fR
The XML of the body as parsed by \fBxsxp::parse\fR is returned.
.TP
\fB-result-type\fR \fIdict\fR
This fetches the ACL, parses it, and returns a dictionary of two elements.
.sp
The first element has the key "owner" whose value is the canonical ID of the owner of the resource.
.sp
The second element has the key "acl" whose value is a dictionary.  Each
key in the dictionary is one of Amazon's permissions, namely "READ",
"WRITE", "READ_ACP", "WRITE_ACP", or "FULL_CONTROL".  Each value of each
key is a list of canonical IDs or group URLs that have that permission.
Elements are not in the list in any particular order, and not all keys
are necessarily present.  Display names are not returned, as they are
not especially useful; use pxml to obtain them if necessary.
.RE
.TP
\fBS3::PutAcl\fR ?\fB-blocking\fR \fIboolean\fR? ?\fB-bucket\fR \fIbucketname\fR? \fB-resource\fR \fIresourcename\fR ?\fB-acl\fR \fInew-acl\fR?
This sets the ACL on the indicated resource. It returns the XML written to the ACL, or throws an error if anything went wrong.
.RS
.TP
\fB-blocking\fR \fIboolean\fR
See above for standard definition.
.TP
\fB-bucket\fR
This specifies the bucket from which the resource will be read.
Leading and/or trailing slashes are removed for you, as are spaces.
.TP
\fB-resource\fR
This is the full name of the resource within the bucket. A single
leading slash is removed, but not a trailing slash.
Spaces are not trimmed.
.TP
\fB-owner\fR
If this is provided, it is assumed to match the owner of the resource.
Otherwise, a GET may need to be issued against the resource to find
the owner. If you already have the owner (such as from a call
to \fBS3::GetAcl\fR, you can pass the value of the "owner" key
as the value of this option, and it will be used in the construction
of the XML.
.TP
\fB-acl\fR
If this option is specified, it provides the ACL the caller wishes
to write to the resource. If this is not supplied or is empty,
the value is taken from \fBS3::Configure -default-acl\fR.
The ACL is written with a PUT to the ?acl resource.
.sp
If the value passed to this option
starts with "<", it is taken to be a body to be PUT to the ACL resource.
.sp
If the value matches one of the standard Amazon x-amz-acl headers (i.e.,
a canned access policy), that header is translated to XML and then
applied. The canned access policies are private, public-read,
public-read-write, and authenticated-read (in lower case).
.sp
Otherwise, the value is assumed to be a dictionary formatted as the
"acl" sub-entry within the dict returns by \fBS3::GetAcl -result-type dict\fR.
The proper XML is generated and applied to the resource.  Note that a
value containing "//" is assumed to be a group, a value containing "@"
is assumed to be an AmazonCustomerByEmail, and otherwise the value is
assumed to be a canonical Amazon ID.
.sp
Note that you cannot change the owner, so calling GetAcl on a resource
owned by one user and applying it via PutAcl on a resource owned by
another user may not do exactly what you expect.
.RE
.TP
\fBS3::Delete\fR ?\fB-bucket\fR \fIbucketname\fR? \fB-resource\fR \fIresourcename\fR ?\fB-blocking\fR \fIboolean\fR? ?\fB-status\fR \fIstatusvar\fR?
This command deletes the specified resource from the specified bucket.
It returns 1 if the resource was deleted successfully, 0 otherwise.
It returns 0 rather than throwing an S3 remote error.
.RS
.TP
\fB-bucket\fR
This specifies the bucket from which the resource will be deleted.
Leading and/or trailing slashes are removed for you, as are spaces.
.TP
\fB-resource\fR
This is the full name of the resource within the bucket. A single
leading slash is removed, but not a trailing slash.
Spaces are not trimmed.
.TP
\fB-blocking\fR
The standard blocking flag.
.TP
\fB-status\fR
If specified, the indicated (not necessarily global) variable
in the caller's scope is set to a two-element list. The first
element is the 3-digit HTTP status code. The second element
is the HTTP message (such as "OK" or "Forbidden"). Note that
Amazon's DELETE result is 204 on success, that being the
code indicating no content in the returned body.
.RE
.sp
.TP
\fBS3::Push\fR ?\fB-bucket\fR \fIbucketname\fR? \fB-directory\fR \fIdirectoryname\fR ?\fB-prefix\fR \fIprefixstring\fR? ?\fB-compare\fR \fIcomparemode\fR? ?\fB-x-amz-meta-*\fR \fImetastring\fR? ?\fB-acl\fR \fIaclcode\fR? ?\fB-delete\fR \fIboolean\fR? ?\fB-error\fR \fIthrow|break|continue\fR? ?\fB-progress\fR \fIscriptprefix\fR?
This synchronises a local directory with a remote bucket
by pushing the differences using \fBS3::Put\fR. Note that
if something has changed in the bucket but not locally,
those changes could be lost. Thus, this is not a general
two-way synchronization primitive. (See \fBS3::Sync\fR
for that.) Note too that resource names are case sensitive,
so changing the case of a file on a Windows machine may lead
to otherwise-unnecessary transfers.
Note that only regular files are considered, so devices, pipes, symlinks,
and directories are not copied.
.RS
.TP
\fB-bucket\fR
This names the bucket into which data will be pushed.
.TP
\fB-directory\fR
This names the local directory from which files will be taken.
It must exist, be readable via [glob] and so on. If only
some of the files therein are readable, \fBS3::Push\fR will PUT
those files that are readable and return in its results the list
of files that could not be opened.
.TP
\fB-prefix\fR
This names the prefix that will be added to all resources.
That is, it is the remote equivalent of \fB-directory\fR.
If it is not specified, the root of the bucket will be treated
as the remote directory. An example may clarify.
.nf

S3::Push -bucket test -directory /tmp/xyz -prefix hello/world

.fi
In this example, /tmp/xyz/pdq.html will be stored as
http://s3.amazonaws.com/test/hello/world/pdq.html in Amazon's servers. Also,
/tmp/xyz/abc/def/Hello will be stored as
http://s3.amazonaws.com/test/hello/world/abc/def/Hello in Amazon's servers.
Without the \fB-prefix\fR option, /tmp/xyz/pdq.html would be stored
as http://s3.amazonaws.com/test/pdq.html.
.TP
\fB-blocking\fR
This is the standard blocking option.
.TP
\fB-compare\fR
If present, this is passed to each invocation of \fBS3::Put\fR.
Naturally, \fBS3::Configure -default-compare\fR is used
if this is not specified.
.TP
\fB-x-amz-meta-*\fR
If present, this is passed to each invocation of \fBS3::Put\fR. All copied
files will have the same metadata.
.TP
\fB-acl\fR
If present, this is passed to each invocation of \fBS3::Put\fR.
.TP
\fB-delete\fR
This defaults to false. If true, resources in the destination that
are not in the source directory are deleted with \fBS3::Delete\fR.
Since only regular files are considered, the existance of a symlink,
pipe, device, or directory in the local source will \fInot\fR
prevent the deletion of a remote resource with a corresponding name.
.TP
\fB-error\fR
This controls the behavior of \fBS3::Push\fR in the event that
\fBS3::Put\fR throws an error. Note that
errors encountered on the local file system or in reading the
list of resources in the remote bucket always throw errors.
This option allows control over "partial" errors, when some
files were copied and some were not. \fBS3::Delete\fR is always
finished up, with errors simply recorded in the return result.
.RS
.TP
throw
The error is rethrown with the same errorCode.
.TP
break
Processing stops without throwing an error, the error is recorded
in the return value, and the command returns with a normal return.
The calls to \fBS3::Delete\fR are not started.
.TP
continue
This is the default. Processing continues without throwing,
recording the error in the return result, and resuming with the
next file in the local directory to be copied.
.RE
.TP
\fB-progress\fR
If this is specified and the indicated script prefix is not empty, the
indicated script prefix will be invoked several times in the caller's
context with additional arguments at various points in the processing.
This allows progress reporting without backgrounding.  The provided
prefix will be invoked with additional arguments, with the first
additional argument indicating what part of the process is being
reported on.  The prefix is initially invoked with \fIargs\fR as the
first additional argument and a dictionary representing the normalized
arguments to the \fBS3::Push\fR call as the second additional argument.
Then the prefix is invoked with \fIlocal\fR as the first additional
argument and a list of suffixes of the files to be considered as the
second argument.  Then the prefix is invoked with \fIremote\fR as the
first additional argument and a list of suffixes existing in the remote
bucket as the second additional argument.  Then, for each file in the
local list, the prefix will be invoked with \fIstart\fR as the first
additional argument and the common suffix as the second additional
argument.  When \fBS3::Put\fR returns for that file, the prefix will be
invoked with \fIcopy\fR as the first additional argument, the common
suffix as the second additional argument, and a third argument that will
be "copied" (if \fBS3::Put\fR sent the resource), "skipped" (if
\fBS3::Put\fR decided not to based on \fB-compare\fR), or the errorCode
that \fBS3::Put\fR threw due to unexpected errors (in which case the
third argument is a list that starts with "S3"). When all files have
been transfered, the prefix may be invoked zero or more times with
\fIdelete\fR as the first additional argument and the suffix of the
resource being deleted as the second additional argument, with a third
argument being either an empty string (if the delete worked) or the
errorCode from \fBS3::Delete\fR if it failed. Finally, the prefix
will be invoked with \fIfinished\fR as the first additional argument
and the return value as the second additional argument.
.RE
The return result from this command is a dictionary. They keys are the
suffixes (i.e., the common portion of the path after the \fB-directory\fR
and \fB-prefix\fR), while the values are either "copied", "skipped" (if
\fB-compare\fR indicated not to copy the file), or the errorCode
thrown by \fBS3::Put\fR, as appropriate. If \fB-delete\fR was true,
there may also be entries for suffixes with the value "deleted" or
"notdeleted", indicating whether the attempted \fBS3::Delete\fR
worked or not, respectively. There is one additional pair in the return
result, whose key is the empty string and whose value is a nested dictionary.
The keys of this nested dictionary include "filescopied" (the number of
files successfully copied), "bytescopied" (the number of data bytes in
the files copied, excluding headers, metadata, etc), "compareskipped" (the
number of files not copied due to \fB-compare\fR mode), "errorskipped"
(the number of files not copied due to thrown errors), "filesdeleted"
(the number of resources deleted due to not having corresponding files
locally, or 0 if \fB-delete\fR is false), and "filesnotdeleted"
(the number of resources whose deletion was attempted but failed).
.sp
Note that this is currently implemented somewhat inefficiently.
It fetches the bucket listing (including timestamps and eTags),
then calls \fBS3::Put\fR, which uses HEAD to find the timestamps
and eTags again. Correcting this with no API change
is planned for a future upgrade.
.sp
.TP
\fBS3::Pull\fR ?\fB-bucket\fR \fIbucketname\fR? \fB-directory\fR \fIdirectoryname\fR ?\fB-prefix\fR \fIprefixstring\fR? ?\fB-blocking\fR \fIboolean\fR? ?\fB-compare\fR \fIcomparemode\fR? ?\fB-delete\fR \fIboolean\fR? ?\fB-timestamp\fR \fIaws|now\fR? ?\fB-error\fR \fIthrow|break|continue\fR? ?\fB-progress\fR \fIscriptprefix\fR?
This synchronises a remote bucket with a local directory by pulling the
differences using \fBS3::Get\fR If something has been changed locally but not
in the bucket, those difference may be lost. This is not a general two-way
synchronization mechanism. (See \fBS3::Sync\fR for that.)
This creates directories
if needed; new directories are created with default permissions. Note that
resource names are case sensitive, so changing the case of a file on a
Windows machine may lead to otherwise-unnecessary transfers. Also, try not
to store data in resources that end with a slash, or which are prefixes of
resources that otherwise would start with a slash; i.e., don't use this if
you store data in resources whose names have to be directories locally.
.sp
Note that this is currently implemented somewhat inefficiently.
It fetches the bucket listing (including timestamps and eTags),
then calls \fBS3::Get\fR, which uses HEAD to find the timestamps
and eTags again. Correcting this with no API change
is planned for a future upgrade.
.RS
.TP
\fB-bucket\fR
This names the bucket from which data will be pulled.
.TP
\fB-directory\fR
This names the local directory into which files will be written
It must exist, be readable via [glob], writable for file creation,
and so on. If only some of the files therein are writable,
\fBS3::Pull\fR will GET
those files that are writable and return in its results the list
of files that could not be opened.
.TP
\fB-prefix\fR
The prefix of resources that will be considered for retrieval.
See \fBS3::Push\fR for more details, examples, etc. (Of course,
\fBS3::Pull\fR reads rather than writes, but the prefix is
treated similarly.)
.TP
\fB-blocking\fR
This is the standard blocking option.
.TP
\fB-compare\fR
This is passed to each invocation of \fBS3::Get\fR if provided.
Naturally, \fBS3::Configure -default-compare\fR is
used if this is not provided.
.TP
\fB-timestamp\fR
This is passed to each invocation of \fBS3::Get\fR if provided.
.TP
\fB-delete\fR
If this is specified and true, files that exist in the \fB-directory\fR
that are not in the \fB-prefix\fR will be deleted after all resources
have been copied. In addition, empty directories (other than the
top-level \fB-directory\fR) will be deleted, as
Amazon S3 has no concept of an empty directory.
.TP
\fB-error\fR
See \fBS3::Push\fR for a description of this option.
.TP
\fB-progress\fR
See \fBS3::Push\fR for a description of this option.
It differs slightly in that local directories may be included
with a trailing slash to indicate they are directories.
.RE
The return value from this command is a dictionary. It
is identical in form and meaning to the description of the
return result of \fBS3::Push\fR. It differs only in that
directories may be included, with a trailing slash in their name,
if they are empty and get deleted.
.TP
\fBS3::Toss\fR ?\fB-bucket\fR \fIbucketname\fR? \fB-prefix\fR \fIprefixstring\fR ?\fB-blocking\fR \fIboolean\fR? ?\fB-error\fR \fIthrow|break|continue\fR? ?\fB-progress\fR \fIscriptprefix\fR?
This deletes some or all resources within a bucket. It would be
considered a "recursive delete" had Amazon implemented actual
directories.
.RS
.TP
\fB-bucket\fR
The bucket from which resources will be deleted.
.TP
\fB\fB-blocking\fR\fR
The standard blocking option.
.TP
\fB\fB-prefix\fR\fR
The prefix for resources to be deleted. Any resource that
starts with this string will be deleted. This is required.
To delete everything in the bucket, pass an empty string
for the prefix.
.TP
\fB\fB-error\fR\fR
If this is "throw", \fBS3::Toss\fR rethrows any errors
it encounters.  If this is "break", \fBS3::Toss\fR returns
with a normal return after the first error, recording that
error in the return result. If this is "continue", which is
the default, \fBS3::Toss\fR continues on and lists all
errors in the return result.
.TP
\fB\fB-progress\fR\fR
If this is specified and not an empty string, the script
prefix will be invoked several times in the context of the caller
with additional arguments appended.  Initially, it will be invoked
with the first additional argument being \fIargs\fR and the second
being the processed list of arguments to \fBS3::Toss\fR. Then it
is invoked with \fIremote\fR as the first additional argument and
the list of suffixes in the bucket to be deleted as the second
additional argument. Then it is invoked with the first additional
argument being \fIdelete\fR and the second additional argument being
the suffix deleted and the third additional argument being "deleted"
or "notdeleted" depending on whether \fBS3::Delete\fR threw an error.
Finally, the script prefix is invoked with a first additional argument
of "finished" and a second additional argument of the return value.
.RE
The return value is a dictionary. The keys are the suffixes of files
that \fBS3::Toss\fR attempted to delete, and whose values are either
the string "deleted" or "notdeleted". There is also one additional
pair, whose key is the empty string and whose value is an embedded
dictionary. The keys of this embedded dictionary include
"filesdeleted" and "filesnotdeleted", each of which has integer values.
.PP
.SH LIMITATIONS
.IP \(bu
The pure-Tcl MD5 checking is slow. If you are processing
files in the megabyte range, consider ensuring binary support is available.
.IP \(bu
The commands \fBS3::Pull\fR and \fBS3::Push\fR fetch a
directory listing which includes timestamps and MD5 hashes,
then invoke \fBS3::Get\fR and \fBS3::Put\fR. If
a complex \fB-compare\fR mode is specified, \fBS3::Get\fR and
\fBS3::Put\fR will invoke a HEAD operation for each file to fetch
timestamps and MD5 hashes of each resource again. It is expected that
a future release of this package will solve this without any API changes.
.IP \(bu
The commands \fBS3::Pull\fR and \fBS3::Push\fR fetch a
directory listing without using \fB-max-count\fR. The entire
directory is pulled into memory at once. For very large buckets,
this could be a performance problem. The author, at this time,
does not plan to change this behavior. Welcome to Open Source.
.IP \(bu
\fBS3::Sync\fR is neither designed nor implemented yet.
The intention would be to keep changes synchronised, so changes
could be made to both the bucket and the local directory and
be merged by \fBS3::Sync\fR.
.IP \(bu
Nor is
\fB-compare\fR \fIcalc\fR fully implemented. This is primarily due to
Windows not providing a convenient method for distinguishing between
local files that are "public-read" or "public-read-write". Assistance
figuring out TWAPI for this would be appreciated. The U**X semantics
are difficult to map directly as well. See the source for details.
Note that there are not tests for calc, since it isn't done yet.
.IP \(bu
The HTTP processing is implemented within the library,
rather than using a "real" HTTP package. Hence, multi-line headers
are not (yet) handled correctly. Do not include carriage returns or
linefeeds in x-amz-meta-* headers, content-type values, and so on.
The author does not at this time expect to improve this.
.IP \(bu
Internally, \fBS3::Push\fR and \fBS3::Pull\fR and \fBS3::Toss\fR
are all very similar and should be refactored.
.IP \(bu
The idea of using \fB-compare\fR \fInever\fR
\fB-delete\fR \fItrue\fR to delete files that have been
deleted from one place but not the other yet not copying
changed files is untested.
.PP
.SH "USAGE SUGGESTIONS"
To fetch a "directory" out of a bucket, make changes, and store it back:
.nf

file mkdir ./tempfiles
S3::Pull -bucket sample -prefix of/interest -directory ./tempfiles \\
  -timestamp aws
do_my_process ./tempfiles other arguments
S3::Push -bucket sample -prefix of/interest -directory ./tempfiles \\
  -compare newer -delete true

.fi
.PP
To delete files locally that were deleted off of S3 but not otherwise
update files:
.nf

S3::Pull -bucket sample -prefix of/interest -directory ./myfiles \\
  -compare never -delete true

.fi
.SH "FUTURE DEVELOPMENTS"
The author intends to work on several additional projects related to
this package, in addition to finishing the unfinished features.
.PP
First, a command-line program allowing browsing of buckets and
transfer of files from shell scripts and command prompts is useful.
.PP
Second, a GUI-based program allowing visual manipulation of
bucket and resource trees not unlike Windows Explorer would
be useful.
.PP
Third, a command-line (and perhaps a GUI-based) program called
"OddJob" that will use S3 to synchronize computation amongst
multiple servers running OddJob. An S3 bucket will be set up
with a number of scripts to run, and the OddJob program can
be invoked on multiple machines to run scripts on all the machines,
each moving on to the next unstarted task as it finishes each.
This is still being designed, and it is intended primarily
to be run on Amazon's Elastic Compute Cloud.
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIamazon-s3\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH COPYRIGHT
.nf
Copyright (c) Copyright 2006,2008 Darren New. All Rights Reserved. See LICENSE.TXT for terms.

.fi