'\"
'\" Generated from file '/usr/obj/i386/tcllib-1.11.1/tcllib-1.11.1/modules/doctools/doctools_plugin_apiref.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2007 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "doctools_plugin_apiref" n 1.0 doctools "Documentation tools"
.BS
.SH NAME
doctools_plugin_apiref \- doctools plugin API reference
.SH SYNOPSIS
\fBdt_copyright\fR
.sp
\fBdt_file\fR
.sp
\fBdt_fileid\fR
.sp
\fBdt_fmap\fR \fIsymfname\fR
.sp
\fBdt_format\fR
.sp
\fBdt_lnesting\fR
.sp
\fBdt_module\fR
.sp
\fBdt_read\fR \fIfile\fR
.sp
\fBdt_source\fR \fIfile\fR
.sp
\fBdt_user\fR
.sp
\fBex_cappend\fR \fItext\fR
.sp
\fBex_cget\fR \fIvarname\fR
.sp
\fBex_cis\fR \fIcname\fR
.sp
\fBex_cname\fR
.sp
\fBex_cpop\fR \fIcname\fR
.sp
\fBex_cpush\fR \fIcname\fR
.sp
\fBex_cset\fR \fIvarname\fR \fIvalue\fR
.sp
\fBex_lb\fR ?\fInewbracket\fR?
.sp
\fBex_rb\fR ?\fInewbracket\fR?
.sp
\fBfmt_initialize\fR
.sp
\fBfmt_listvariables\fR
.sp
\fBfmt_numpasses\fR
.sp
\fBfmt_postprocess\fR \fItext\fR
.sp
\fBfmt_setup\fR \fIn\fR
.sp
\fBfmt_shutdown\fR
.sp
\fBfmt_varset\fR \fIvarname\fR \fItext\fR
.sp
\fBfmt_plain_text\fR \fItext\fR
.sp
.BE
.SH DESCRIPTION
.PP
This document is intended for \fIplugin writers\fR, i.e. developers
wishing to write a doctools \fIformatting engine\fR for some output
format X.
.PP
It specifies the interaction between the \fBdoctools\fR package
and its plugins, i.e. the interface any doctools formatting engine has
to comply with.
.PP
This document deals with version 1 of the interface.
.PP
A reader who is on the other hand more interested in the markup
language itself should start with the
\fIdoctools language introduction\fR and proceed from there to the
formal specifications, i.e. the \fIdoctools language syntax\fR and
the \fIdoctools language command reference\fR.
.SH OVERVIEW
The API for a doctools formatting engine consists of two major
sections.
.PP
On the one side we have a set of commands through which the plugin is
able to query the frontend. These commands are provided by the
frontend and linked into the plugin interpreter. Please see section
\fBFRONTEND COMMANDS\fR for their detailed specification.
.PP
And on the other side the plugin has to provide its own set of
commands which will then be called by the frontend in a specific
sequence while processing input. They, again, fall into two
categories, management and formatting.
Please see section \fBPLUGIN COMMANDS\fR and its subsections for
their detailed specification.
.SH "FRONTEND COMMANDS"
This section specifies the set of commands through which a plugin,
also known as a doctools formatting engine, is able to query the
frontend. These commands are provided by the frontend and linked into
the plugin interpreter.
.PP
I.e. a doctools formatting engine can assume that all of the following
commands are present when any of its own commands (as specified in
section \fBPLUGIN COMMANDS\fR) are executed.
.PP
Beyond that it can also assume that it has full access to its own safe
interpreter and thus is not able to damage the other parts of the
processor, nor can it damage the filesystem.
It is however able to either kill or hang the whole process, by
exiting, or running an infinite loop.
.PP
Coming back to the imported commands, all the commands with prefix
\fIdt_\fR provide limited access to specific parts of the frontend,
whereas the commands with prefix \fIex_\fR provide access to the
state of the \fBtextutil::expander\fR object which does the main
parsing of the input within the frontend. These commands should not be
except under very special circumstances.
.PP
.TP
\fBdt_copyright\fR
Query command. It returns a string containing the copyright
information the doctools processor was configured with. The relevant
option is \fB-copyright\fR).
.TP
\fBdt_file\fR
Query command. It returns the full path of the file containing the
input currently processed by the engine.
.TP
\fBdt_fileid\fR
Query command. It returns the name of the file containing the input
currently processed by the engine, without path, nor extension.
.TP
\fBdt_fmap\fR \fIsymfname\fR
Query command. It returns the actual pathname to use in the output in
place of the symbolic filename \fIsymfname\fR. It will return the
unchanged input if no mapping was established for \fIsymfname\fR.
.sp
The required mappings are established with the method \fBmap\fR of
a frontend, as explained in section \fBOBJECT METHODS\fR
of the documentation for the package \fBdoctools\fR.
.TP
\fBdt_format\fR
Query command. It returns the name of the format associated with the
doctools formatting engine.
.TP
\fBdt_lnesting\fR
Query command. It returns the number of lists currently open.
.TP
\fBdt_module\fR
Query command. It returns the name of the module the input currently
processed belongs to.
.TP
\fBdt_read\fR \fIfile\fR
Controlled filesystem access. Appends contents of file to the output.
Only files which are either in the same directory as the file
containing the engine, or below it, can be loaded. Trying to load a
file outside of this directory causes an error.
.TP
\fBdt_source\fR \fIfile\fR
Controlled filesystem access. This command allows the doctools
formatting engine to load additional Tcl code it may need.
Only files which are either in the same directory as the file
containing the engine, or below it, can be loaded. Trying to load a
file outside of this directory causes an error.
.TP
\fBdt_user\fR
Query command. It returns the name of the current user as known to the
tcl interpreter the frontend controlling the formatting engine resides
in.
.TP
\fBex_cappend\fR \fItext\fR
Appends a string to the output in the current context.  This command
should rarely be used by macros or application code.
.TP
\fBex_cget\fR \fIvarname\fR
Retrieves the value of variable \fIvarname\fR, defined in the current
context.
.TP
\fBex_cis\fR \fIcname\fR
Determines whether or not the name of the current context is
\fIcname\fR.
.TP
\fBex_cname\fR
Returns the name of the current context.
.TP
\fBex_cpop\fR \fIcname\fR
Pops a context from the context stack, returning all accumulated
output in that context.  The context must be named \fIcname\fR, or an
error results.
.TP
\fBex_cpush\fR \fIcname\fR
Pushes a context named \fIcname\fR onto the context stack.  The
context must be popped by \fBcpop\fR before expansion ends or an
error results.
.TP
\fBex_cset\fR \fIvarname\fR \fIvalue\fR
Sets variable \fIvarname\fR to \fIvalue\fR in the current context.
.TP
\fBex_lb\fR ?\fInewbracket\fR?
Returns the current value of the left macro expansion bracket; this is
for use as or within a macro, when the bracket needs to be included in
the output text.  If \fInewbracket\fR is specified, it becomes the new
bracket, and is returned.
.TP
\fBex_rb\fR ?\fInewbracket\fR?
Returns the current value of the right macro expansion bracket; this
is for use as or within a macro, when the bracket needs to be included
in the output text.  If \fInewbracket\fR is specified, it becomes the
new bracket, and is returned.
.PP
.SH "PLUGIN COMMANDS"
The plugin has to provide its own set of commands which will then be
called by the frontend in a specific sequence while processing
input. They fall into two categories, management and formatting. Their
expected names, signatures, and responsibilities are specified in the
following two subsections.
.SS "MANAGEMENT COMMANDS"
The management commands a plugin has to provide are used by the
frontend to
.IP [1]
initialize and shutdown the plugin
.IP [2]
determine the number of passes it has
to make over the input
.IP [3]
initialize and shutdown each pass
.IP [4]
query and initialize engine parameters
.PP
.PP
After the plugin has been loaded and the frontend commands are
established the commands will be called in the following sequence:
.nf

    fmt_numpasses -> n
    fmt_listvariables -> vars

    fmt_varset var1 value1
    fmt_varset var2 value2
    ...
    fmt_varset varK valueK
    fmt_initialize
    fmt_setup 1
    ...
    fmt_setup 2
    ...
    ...
    fmt_setup n
    ...
    fmt_postprocess
    fmt_shutdown
    ...

.fi
I.e. first the number of passes and the set of available engine
parameters is established, followed by calls setting the
parameters. That second part is optional.
.PP
After that the plugin is initialized, the specified number of passes
executed, the final result run through a global post processing step
and at last the plugin is shutdown again. This can be followed by more
conversions, restarting the sequence at \fBfmt_varset\fR.
.PP
In each of the passes, i.e. after the calls of \fBfmt_setup\fR the
frontend will process the input and call the formatting commands as
markup is encountered. This means that the sequence of formatting
commands is determined by the grammar of the doctools markup language,
as specified in the \fIdoctools language syntax\fR specification.
.PP
A different way of looking at the sequence is:
.IP \(bu
First some basic parameters are determined.
.IP \(bu
Then everything starting at the first \fBfmt_varset\fR to
\fBfmt_shutdown\fR forms a \fIrun\fR, the formatting of a
single input. Each run can be followed by more.
.IP \(bu
Embedded within each run we have one or more \fIpasses\fR,
each starting with \fBfmt_setup\fR and going until either the next
\fBfmt_setup\fR or \fBfmt_postprocess\fR is reached.
.sp
If more than one pass is required to perform the formatting only the
output of the last pass is relevant. The output of all the previous,
preparatory passes is ignored.
.PP
.PP
The commands, their names, signatures, and responsibilities are, in
detail:
.TP
\fBfmt_initialize\fR
\fIInitialization/Shutdown\fR.
This command is called at the beginning of every conversion run, as
the first command of that run. Note that a run is not a pass, but may
consist of multiple passes.
It has to initialize the general state of the plugin, beyond the
initialization done during the load. No return value is expected, and
any returned value is ignored.
.TP
\fBfmt_listvariables\fR
\fIInitialization/Shutdown\fR and \fIEngine parameters\fR.
Second command is called after the plugin code has been loaded,
i.e. immediately after \fBfmt_numpasses\fR.
It has to return a list containing the names of the parameters the
frontend can set to configure the engine. This list can be empty.
.TP
\fBfmt_numpasses\fR
\fIInitialization/Shutdown\fR and \fIPass management\fR.
First command called after the plugin code has been loaded. No other
command of the engine will be called before it.
It has to return the number of passes this engine requires to fully
process the input document. This value has to be an integer number
greater or equal to one.
.TP
\fBfmt_postprocess\fR \fItext\fR
\fIInitialization/Shutdown\fR.
This command is called immediately after the last pass in a run. Its
argument is the result of the conversion generated by that pass. It is
provided to allow the engine to perform any global modifications of
the generated document. If no post-processing is required for a
specific format the command has to just return the argument.
.sp
Expected to return a value, the final result of formatting the input.
.TP
\fBfmt_setup\fR \fIn\fR
\fIInitialization/Shutdown\fR and \fIPass management\fR.
This command is called at the beginning of each pass over the input in
a run. Its argument is the number of the pass which has begun. Passes
are counted from \fB1\fR upward.
The command has to set up the internal state of the plugin for this
particular pass. No return value is expected, and any returned value
is ignored.
.TP
\fBfmt_shutdown\fR
\fIInitialization/Shutdown\fR.
This command is called at the end of every conversion run. It is the
last command called in a run. It has to clean up of all the
run-specific state in the plugin.
After the call the engine has to be in a state which allows the
initiation of another run without fear that information from the last
run is leaked into this new run.
No return value is expected, and any returned value is ignored.
.TP
\fBfmt_varset\fR \fIvarname\fR \fItext\fR
\fIEngine parameters\fR.
This command is called by the frontend to set an engine parameter to a
particular value.
The parameter to change is specified by \fIvarname\fR, the value to
set in \fItext\fR.
.sp
The command has to throw an error if an unknown \fIvarname\fR is
used. Only the names returned by \fBfmt_listvariables\fR have to be
considered as known.
.sp
The values of all engine parameters have to persist between passes and
runs.
.PP
.SS "FORMATTING COMMANDS"
The formatting commands have to implement the formatting for the
output format, for all the markup commands of the doctools markup
language, except \fBlb\fR, \fBrb\fR, \fBvset\fR, \fBinclude\fR, and
\fBcomment\fR. These exceptions are processed by the frontend and are
never seen by the plugin. In return a command for the formatting of
plain text has to be provided, something which has no markup in the
input at all.
.PP
This means, that each of the 49 markup commands specified in the
\fIdoctools language command reference\fR and outside of the set of
exceptions listed above has an equivalent formatting command which
takes the same arguments as the markup command and whose name is the
name of markup command with the prefix \fIfmt_\fR added to it.
.PP
All commands are expected to format their input in some way per the
semantics specified in the command reference and to return whatever
part of this that they deem necessary as their result, which will be
added to the output.
.PP
To avoid essentially duplicating the command reference we do not list
any of the command here and simply refer the reader to the
\fIdoctools language command reference\fR for their signature and
description. The sole exception is the plain text formatter, which has
no equivalent markup command.
.PP
The calling sequence of formatting commands is not as rigid as for the
management commands, but determined by the grammar of the doctools
markup language, as specified in the \fIdoctools language syntax\fR
specification.
.PP
.TP
\fBfmt_plain_text\fR \fItext\fR
\fINo associated markup command\fR.
.sp
Called by the frontend for any plain text encountered in the
input. It has to perform any and all special processing required for
plain text.
.sp
The formatted text is expected as the result of the command,
and added to the output. If no special processing is required it has
to simply return its argument without change.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, will undoubtedly contain bugs and other problems.
Please report such in the category \fIdoctools\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have.
.SH "SEE ALSO"
doctools, doctools_intro, doctools_lang_cmdref, doctools_lang_faq, doctools_lang_intro, doctools_lang_syntax
.SH KEYWORDS
document, formatter, formatting engine, manpage, markup, semantic markup
.SH COPYRIGHT
.nf
Copyright (c) 2007 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi