'\"
'\" Generated from file '/usr/obj/i386/tcllib-1.11.1/tcllib-1.11.1/modules/struct/pool.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2002, Erik Leunissen <e.leunissen@hccnet.nl>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "struct::pool" n 1.2.1 struct "Tcl Data Structures"
.BS
.SH NAME
struct::pool \- Create and manipulate pool objects (of discrete items)
.SH SYNOPSIS
package require \fBTcl  8.2\fR
.sp
package require \fBstruct::pool  ?1.2.1?\fR
.sp
\fB::struct::pool\fR ?\fIpoolName\fR? ?\fImaxsize\fR?
.sp
\fBpoolName\fR \fIoption\fR ?\fIarg arg ...\fR?
.sp
\fIpoolName\fR \fBadd\fR \fIitemName1\fR ?\fIitemName2 itemName3 ...\fR?
.sp
\fIpoolName\fR \fBclear\fR ?\fB-force\fR?
.sp
\fIpoolName\fR \fBdestroy\fR ?\fB-force\fR?
.sp
\fIpoolName\fR \fBinfo\fR \fItype\fR ?\fIarg\fR?
.sp
\fIpoolName\fR \fBmaxsize\fR ?\fImaxsize\fR?
.sp
\fIpoolName\fR \fBrelease\fR \fIitemName\fR
.sp
\fIpoolName\fR \fBremove\fR \fIitemName\fR ?\fB-force\fR?
.sp
\fIpoolName\fR \fBrequest\fR itemVar ?options?
.sp
.BE
.SH DESCRIPTION
.PP
This package provides pool objects which can be used to manage
finite collections of discrete items.
.TP
\fB::struct::pool\fR ?\fIpoolName\fR? ?\fImaxsize\fR?
Creates a new pool object. If no \fIpoolName\fR is supplied, then the
new pool will be named pool\fBX\fR, where X is a positive integer.
The optional second argument \fImaxsize\fR has to be a positive
integer indicating the maximum size of the pool; this is the maximum
number of items the pool may hold. The default for this value is
\fB10\fR.
.sp
The pool object has an associated global Tcl command whose name is
\fIpoolName\fR. This command may be used to invoke various
configuration operations on the report. It has the following general
form:
.RS
.TP
\fBpoolName\fR \fIoption\fR ?\fIarg arg ...\fR?
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command. See section \fBPOOL OBJECT COMMAND\fR for a detailed
list of options and their behaviour.
.RE
.PP
.PP
.SH "POOLS AND ALLOCATION"
The purpose of the pool command and the pool object command that it
generates, is to manage pools of discrete items.
Examples of a pool of discrete items are:
.IP \(bu
the seats in a cinema, theatre, train etc.. for which visitors/travelers can  make a reservation;
.IP \(bu
the dynamic IP-addresses that an ISP can dole out  to subscribers;
.IP \(bu
a car rental's collection of cars, which can be rented by customers;
.IP \(bu
the class rooms in a school building, which need to be scheduled;
.IP \(bu
the database connections available to client-threads in a web-server application;
.IP \(bu
the books in a library that customers can borrow;
.IP \(bu
etc ...
.PP
.PP
The common denominator in the examples is that there is a more or less
fixed number of items (seats, IP-addresses, cars, ...) that are
supposed to be allocated on a more or less regular basis. An item can
be allocated only once at a time. An item that is allocated, must be
released before it can be re-allocated.  While several items in a pool
are being allocated and released continuously, the total number of
items in the pool remains constant.
.PP
Keeping track of which items are allocated, and by whom, is the
purpose of the pool command and its subordinates.
.PP
\fIPool parlance\fR: If we say that an item is
\fIallocated\fR, it means that the item is \fIbusy\fR,
\fIowned\fR or \fIoccupied\fR; it is not available anymore. If
an item is \fIfree\fR, it is \fIavailable\fR. Deallocating an
item is equivalent to setting free or releasing an item. The person or
entity to which the item has been allotted is said to own the item.
.SH ITEMS
\fIDiscrete items\fR
.PP
The \fBpool\fR command is designed for
\fIdiscrete items only\fR. Note that there are pools where
allocation occurs on a non-discrete basis, for example computer
memory. There are also pools from which the shares that are doled out
are not expected to be returned, for example a charity fund or a pan
of soup from which you may receive a portion. Finally, there are even
pools from which nothing is ever allocated or returned, like a
swimming pool or a cesspool.
.PP
\fIUnique item names\fR
.PP
A pool cannot manage duplicate item names. Therefore, items in a pool
must have unique names.
.PP
\fIItem equivalence\fR
.PP
From the point of view of the manager of a pool, items are
equivalent. The manager of a pool is indifferent about which
entity/person occupies a given item. However, clients may have
preferences for a particular item, based on some item property they
know.
.PP
\fIPreferences\fR
.PP
A future owner may have a preference for a particular item. Preference
based allocation is supported (see the \fB-prefer\fR option to the
request subcommand). A preference for a particular item is most likely
to result from variability among features associated with the
items. Note that the pool commands themselves are not designed to
manage such item properties. If item properties play a role in an
application, they should be managed separately.
.SH "POOL OBJECT COMMAND"
The following subcommands and corresponding arguments are available to
any pool object command.
.TP
\fIpoolName\fR \fBadd\fR \fIitemName1\fR ?\fIitemName2 itemName3 ...\fR?
This command adds the items on the command line to the pool. If
duplicate item names occur on the command line, an error is raised. If
one or more of the items already exist in the pool, this also is
considered an error.
.TP
\fIpoolName\fR \fBclear\fR ?\fB-force\fR?
Removes all items from the pool. If there are any allocated items at
the time when the command is invoked, an error is raised. This
behaviour may be modified through the \fB-force\fR argument. If it
is supplied on the command line, the pool will be cleared regardless
the allocation state of its items.
.TP
\fIpoolName\fR \fBdestroy\fR ?\fB-force\fR?
Destroys the pool data structure, all associated variables and the
associated pool object command. By default, the command checks whether
any items are still allocated and raises an error if such is the
case. This behaviour may be modified through the argument
\fB-force\fR. If it is supplied on the command line, the pool data
structure will be destroyed regardless allocation state of its items.
.TP
\fIpoolName\fR \fBinfo\fR \fItype\fR ?\fIarg\fR?
Returns various information about the pool for further programmatic
use. The \fItype\fR argument indicates the type of information
requested. Only the type \fBallocID\fR uses an additional argument.
.RS
.TP
\fBallocID\fR \fIitemName\fR
returns the allocID of the item whose name is \fIitemName\fR. Free
items have an allocation id of \fB-1\fR.
.TP
\fBallitems\fR
returns a list of all items in the pool.
.TP
\fBallocstate\fR
Returns a list of key-value pairs, where the keys are the items and
the values are the corresponding allocation id's. Free items have an
allocation id of \fB-1\fR.
.TP
\fBcursize\fR
returns the current pool size, i.e. the number of items in the pool.
.TP
\fBfreeitems\fR
returns a list of items that currently are not allocated.
.TP
\fBmaxsize\fR
returns the maximum size of the pool.
.RE
.sp
.TP
\fIpoolName\fR \fBmaxsize\fR ?\fImaxsize\fR?
Sets or queries the maximum size of the pool, depending on whether the
\fImaxsize\fR argument is supplied or not. If \fImaxsize\fR is
supplied, the maximum size of the pool will be set to that value. If
no argument is supplied, the current maximum size of the pool is
returned. In this variant, the command is an alias for:
.sp
\fBpoolName info maxsize\fR.
.sp
The \fImaxsize\fR argument has to be a positive integer.
.TP
\fIpoolName\fR \fBrelease\fR \fIitemName\fR
Releases the item whose name is \fIitemName\fR that was allocated
previously. An error is raised if the item was not allocated at the
time when the command was issued.
.TP
\fIpoolName\fR \fBremove\fR \fIitemName\fR ?\fB-force\fR?
Removes the item whose name is \fIitemName\fR from the pool. If the
item was allocated at the time when the command was invoked, an error
is raised. This behaviour may be modified through the optional
argument \fB-force\fR. If it is supplied on the command line, the
item will be removed regardless its allocation state.
.TP
\fIpoolName\fR \fBrequest\fR itemVar ?options?
Handles a request for an item, taking into account a possible
preference for a particular item. There are two possible outcomes
depending on the availability of items:
.RS
.IP [1]
The request is honoured, an item is allocated and the variable whose
name is passed with the argument \fIitemVar\fR will be set to the name
of the item that was allocated. The command returns 1.
.IP [2]
The request is denied. No item is allocated. The variable whose name
is itemVar is not set.  Attempts to read \fIitemVar\fR may raise an
error if the variable was not defined before issuing the request. The
command returns 0.
.RE
.sp
The return values from this command are meant to be inspected. The
examples below show how to do this. Failure to check the return value
may result in erroneous behaviour. If no preference for a particular
item is supplied through the option \fB-prefer\fR (see below), then
all requests are honoured as long as items are available.
.sp
The following options are supported:
.RS
.TP
\fB-allocID\fR \fIallocID\fR
If the request is honoured, an item will be allocated to the entity
identified by allocID. If the allocation state of an item is queried,
it is this allocation ID that will be returned. If the option
\fB-allocID\fR is not supplied, the item will be given to and owned
by \fBdummyID\fR. Allocation id's may be anything except the value
-1, which is reserved for free items.
.TP
\fB-prefer\fR \fIpreferredItem\fR
This option modifies the allocation strategy as follows: If the item
whose name is \fIpreferredItem\fR is not allocated at the time when
the command is invoked, the request is honoured (return value is
1). If the item was allocated at the time when the command was
invoked, the request is denied (return value is 0).
.RE
.PP
.SH EXAMPLES
Two examples are provided. The first one mimics a step by step
interactive tclsh session, where each step is explained. The second
example shows the usage in a server application that talks to a
back-end application.
.PP
\fIExample 1\fR
.PP
This example presents an interactive tclsh session which considers the
case of a Car rental's collection of cars. Ten steps explain its usage
in chronological order, from the creation of the pool, via the most
important stages in the usage of a pool, to the final destruction.
.PP
\fINote aside:\fR
.PP
In this example, brand names are used to label the various
items. However, a brand name could be regarded as a property of an
item. Because the pool command is not designed to manage properties of
items, they need to be managed separately. In the latter case the
items should be labeled with more neutral names such as: car1, car2,
car3 , etc ... and a separate database or array should hold the brand
names associated with the car labels.
.PP
.nf

     1. Load the package into an interpreter
     % package require pool
     0.1

     2. Create a pool object called `CarPool' with a maximum size of 55 items (cars):
     % pool CarPool 55
     CarPool

     4. Add items to the pool:
     % CarPool add Toyota Trabant Chrysler1 Chrysler2 Volkswagen

     5. Somebody crashed the Toyota. Remove it from the pool as follows:
     % CarPool remove Toyota

     6. Acquired a new car for the pool. Add it as follows:
     % CarPool add Nissan

     7. Check whether the pool was adjusted correctly:
     % CarPool info allitems
     Trabant Chrysler1 Chrysler2 Volkswagen Nissan

.fi
.PP
Suspend the interactive session temporarily, and show the programmatic
use of the request subcommand:
.PP
.nf

     # Mrs. Swift needs a car. She doesn't have a preference for a
     # particular car. We'll issue a request on her behalf as follows:
     if { [CarPool request car -allocID "Mrs. Swift"] }  {
         # request was honoured, process the variable `car'
         puts "$car has been allocated to [CarPool info allocID $car]."
     } else {
         # request was denied
          puts "No car available."
     }

.fi
.PP
Note how the \fBif\fR command uses the value returned by the
\fBrequest\fR subcommand.
.PP
.nf

     # Suppose Mr. Wiggly has a preference for the Trabant:
     if { [CarPool request car -allocID "Mr. Wiggly" -prefer Trabant] }  {
         # request was honoured, process the variable `car'
         puts "$car has been allocated to [CarPool info allocID $car]."
     } else {
         # request was denied
          puts "The Trabant was not available."
     }

.fi
.PP
Resume the interactive session:
.PP
.nf

     8. When the car is returned then you can render it available by:
     % CarPool release Trabant

     9. When done, you delete the pool.
     % CarPool destroy
     Couldn't destroy `CarPool' because some items are still allocated.

     Oops, forgot that Mrs. Swift still occupies a car.

     10. We force the destruction of the pool as follows:
     % CarPool destroy -force

.fi
.PP
\fIExample 2\fR
.PP
This example describes the case from which the author's need for pool
management originated. It is an example of a server application that
receives requests from client applications. The client requests are
dispatched onto a back-end application before being returned to the
client application. In many cases there are a few equivalent instances
of back-end applications to which a client request may be passed
along. The file descriptors that identify the channels to these
back-end instances make up a pool of connections. A particular
connection may be allocated to just one client request at a time.
.PP
.nf

     # Create the pool of connections (pipes)
     set maxpipes 10
     pool Pipes $maxpipes
     for {set i 0} {$i < $maxpipes} {incr i} {
         set fd [open "|backendApplication" w+]
         Pipes add $fd
     }

     # A client request comes in. The request is identified as `clientX'.
     # Dispatch it onto an instance of a back-end application
     if { [Pipes request fd -allocID clientX] } {
         # a connection was allocated
         # communicate to the back-end application via the variable `fd'
         puts $fd "someInstruction"
         # ...... etc.
     } else {
         # all connections are currently occupied
         # store the client request in a queue for later processing,
         # or return a 'Server busy' message to the client.
     }

.fi
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIstruct :: pool\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
discrete items, finite, pool, struct
.SH COPYRIGHT
.nf
Copyright (c) 2002, Erik Leunissen <e.leunissen@hccnet.nl>

.fi