/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Store;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public abstract class StoreBase
implements Lifecycle,
Runnable,
Store {
    protected static String info = "StoreBase/1.0";
    protected int checkInterval = 60;
    protected String threadName = "StoreBase";
    protected static String storeName = "StoreBase";
    protected Thread thread = null;
    protected boolean threadDone = false;
    protected int debug = 0;
    protected boolean started = false;
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected StringManager sm = StringManager.getManager("org.apache.catalina.session");
    protected Manager manager;

    public String getInfo() {
        return info;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setCheckInterval(int checkInterval) {
        int oldCheckInterval = this.checkInterval;
        this.checkInterval = checkInterval;
        this.support.firePropertyChange("checkInterval", new Integer(oldCheckInterval), new Integer(this.checkInterval));
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public void setManager(Manager manager) {
        Manager oldManager = this.manager;
        this.manager = manager;
        this.support.firePropertyChange("manager", oldManager, this.manager);
    }

    public Manager getManager() {
        return this.manager;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    protected void processExpires() {
        long timeNow = System.currentTimeMillis();
        String[] keys = null;
        if (!this.started) {
            return;
        }
        try {
            keys = this.keys();
        }
        catch (IOException e) {
            this.log(e.toString());
            e.printStackTrace();
            return;
        }
        for (int i = 0; i < keys.length; ++i) {
            try {
                int timeIdle;
                int maxInactiveInterval;
                StandardSession session = (StandardSession)this.load(keys[i]);
                if (session == null || !session.isValid() || (maxInactiveInterval = session.getMaxInactiveInterval()) < 0 || (timeIdle = (int)((timeNow - session.getLastUsedTime()) / 1000L)) < maxInactiveInterval) continue;
                if (((PersistentManagerBase)this.manager).isLoaded(keys[i])) {
                    session.recycle();
                } else {
                    session.expire();
                }
                this.remove(session.getId());
                continue;
            }
            catch (Exception e) {
                this.log("Session: " + keys[i] + "; " + e.toString());
                try {
                    this.remove(keys[i]);
                    continue;
                }
                catch (IOException e2) {
                    this.log(e2.toString());
                    e2.printStackTrace();
                }
            }
        }
    }

    protected void log(String message) {
        Logger logger = null;
        Container container = this.manager.getContainer();
        if (container != null) {
            logger = container.getLogger();
        }
        if (logger != null) {
            logger.log(this.getStoreName() + "[" + container.getName() + "]: " + message);
        } else {
            String containerName = null;
            if (container != null) {
                containerName = container.getName();
            }
            System.out.println(this.getStoreName() + "[" + containerName + "]: " + message);
        }
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.processExpires();
        }
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString(this.getStoreName() + ".alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.threadStart();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString(this.getStoreName() + ".notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.threadStop();
    }

    protected void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        this.thread = new Thread((Runnable)this, this.getThreadName());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void threadSleep() {
        try {
            Thread.sleep((long)this.checkInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }
}

