/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.session;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.cluster.ClusterSession;
import org.apache.catalina.cluster.session.DeltaManager;
import org.apache.catalina.cluster.session.DeltaRequest;
import org.apache.catalina.cluster.session.DeltaSessionFacade;
import org.apache.catalina.cluster.session.SerializablePrincipal;
import org.apache.catalina.cluster.session.StandardSessionContext;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeltaSession
implements HttpSession,
Session,
Serializable,
ClusterSession {
    public static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$session$DeltaManager == null ? (class$org$apache$catalina$cluster$session$DeltaManager = DeltaSession.class$("org.apache.catalina.cluster.session.DeltaManager")) : class$org$apache$catalina$cluster$session$DeltaManager));
    protected static StringManager smp = StringManager.getManager((String)"org.apache.catalina.cluster.session");
    protected static final String[] EMPTY_ARRAY = new String[0];
    private static final String NOT_SERIALIZED = "___NOT_SERIALIZABLE_EXCEPTION___";
    private Map attributes = new Hashtable();
    private transient String authType = null;
    private transient Method containerEventMethod = null;
    private static final Class[] containerEventTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DeltaSession.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = DeltaSession.class$("java.lang.Object")) : class$java$lang$Object};
    private long creationTime = 0L;
    private transient boolean expiring = false;
    private transient DeltaSessionFacade facade = null;
    private String id = null;
    private static final String info = "DeltaSession/1.1";
    private long lastAccessedTime = this.creationTime;
    private transient ArrayList listeners = new ArrayList();
    private transient Manager manager = null;
    private int maxInactiveInterval = -1;
    private int expireTolerance = 300;
    private boolean isNew = false;
    protected boolean isValid = false;
    private transient Map notes = new Hashtable();
    private transient Principal principal = null;
    private static StringManager sm = StringManager.getManager((String)"org.apache.catalina.cluster.session");
    private static HttpSessionContext sessionContext = null;
    private transient PropertyChangeSupport support = new PropertyChangeSupport(this);
    private long thisAccessedTime = this.creationTime;
    private transient boolean isPrimarySession = true;
    private transient DeltaRequest deltaRequest = null;
    private transient long lastTimeReplicated = System.currentTimeMillis();
    protected transient int accessCount = 0;
    private Object lock = new Object();
    static /* synthetic */ Class class$org$apache$catalina$cluster$session$DeltaManager;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public DeltaSession(Manager manager) {
        this.manager = manager;
        this.resetDeltaRequest();
    }

    public boolean isPrimarySession() {
        return this.isPrimarySession;
    }

    public void setPrimarySession(boolean primarySession) {
        this.isPrimarySession = primarySession;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        String oldAuthType = this.authType;
        this.authType = authType;
        this.support.firePropertyChange("authType", oldAuthType, this.authType);
    }

    public void setCreationTime(long time) {
        this.creationTime = time;
        this.lastAccessedTime = time;
        this.thisAccessedTime = time;
    }

    public String getId() {
        return this.id;
    }

    public String getIdInternal() {
        return this.id;
    }

    public void setIdInternal(String id) {
        if (this.id != null && this.manager != null) {
            this.manager.remove((Session)this);
        }
        this.id = id;
        if (this.manager != null) {
            this.manager.add((Session)this);
        }
        if (this.deltaRequest == null) {
            this.resetDeltaRequest();
        } else {
            this.deltaRequest.setSessionId(id);
        }
    }

    public void setId(String id) {
        this.setIdInternal(id);
        this.tellNew();
    }

    public void tellNew() {
        Object[] listeners;
        this.fireSessionEvent("createSession", null);
        Context context = (Context)this.manager.getContainer();
        if (context != null && (listeners = context.getApplicationLifecycleListeners()) != null) {
            HttpSessionEvent event = new HttpSessionEvent(this.getSession());
            for (int i = 0; i < listeners.length; ++i) {
                if (!(listeners[i] instanceof HttpSessionListener)) continue;
                HttpSessionListener listener = (HttpSessionListener)listeners[i];
                try {
                    this.fireContainerEvent(context, "beforeSessionCreated", listener);
                    listener.sessionCreated(event);
                    this.fireContainerEvent(context, "afterSessionCreated", listener);
                    continue;
                }
                catch (Throwable t) {
                    try {
                        this.fireContainerEvent(context, "afterSessionCreated", listener);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.sessionEvent"), t);
                }
            }
        }
    }

    public String getInfo() {
        return info;
    }

    public long getLastAccessedTime() {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.getLastAccessedTime.ise"));
        }
        return this.lastAccessedTime;
    }

    public long getLastAccessedTimeInternal() {
        return this.lastAccessedTime;
    }

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int interval) {
        this.setMaxInactiveInterval(interval, true);
    }

    public void setMaxInactiveInterval(int interval, boolean addDeltaRequest) {
        this.maxInactiveInterval = interval;
        if (this.isValid && interval == 0) {
            this.expire();
        } else if (addDeltaRequest && this.deltaRequest != null) {
            this.deltaRequest.setMaxInactiveInterval(interval);
        }
    }

    public void setNew(boolean isNew) {
        this.setNew(isNew, true);
    }

    public void setNew(boolean isNew, boolean addDeltaRequest) {
        this.isNew = isNew;
        if (addDeltaRequest && this.deltaRequest != null) {
            this.deltaRequest.setNew(isNew);
        }
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        this.setPrincipal(principal, true);
    }

    public void setPrincipal(Principal principal, boolean addDeltaRequest) {
        Principal oldPrincipal = this.principal;
        this.principal = principal;
        this.support.firePropertyChange("principal", oldPrincipal, this.principal);
        if (addDeltaRequest && this.deltaRequest != null) {
            this.deltaRequest.setPrincipal(principal);
        }
    }

    public HttpSession getSession() {
        if (this.facade == null) {
            if (System.getSecurityManager() != null) {
                final DeltaSession fsession = this;
                this.facade = (DeltaSessionFacade)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new DeltaSessionFacade(fsession);
                    }
                });
            } else {
                this.facade = new DeltaSessionFacade(this);
            }
        }
        return this.facade;
    }

    public boolean isValid() {
        if (this.expiring) {
            return true;
        }
        if (!this.isValid) {
            return false;
        }
        if (this.accessCount > 0) {
            return true;
        }
        if (this.maxInactiveInterval >= 0) {
            long timeNow = System.currentTimeMillis();
            int timeIdle = (int)((timeNow - this.thisAccessedTime) / 1000L);
            if (this.isPrimarySession()) {
                if (timeIdle >= this.maxInactiveInterval) {
                    this.expire(true);
                }
            } else if (timeIdle >= this.maxInactiveInterval + this.expireTolerance) {
                this.expire(true, false);
            }
        }
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void access() {
        this.lastAccessedTime = this.thisAccessedTime;
        this.thisAccessedTime = System.currentTimeMillis();
        this.evaluateIfValid();
        if (Globals.STRICT_SERVLET_COMPLIANCE) {
            Object object = this.lock;
            synchronized (object) {
                ++this.accessCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endAccess() {
        this.isNew = false;
        if (Globals.STRICT_SERVLET_COMPLIANCE) {
            Object object = this.lock;
            synchronized (object) {
                --this.accessCount;
            }
        }
        if (this.manager instanceof DeltaManager) {
            ((DeltaManager)this.manager).registerSessionAtReplicationValve(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionListener(SessionListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    public void expire() {
        this.expire(true);
    }

    public void expire(boolean notify) {
        this.expire(notify, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(boolean notify, boolean notifyCluster) {
        if (this.expiring) {
            return;
        }
        String expiredId = this.getIdInternal();
        DeltaSession deltaSession = this;
        synchronized (deltaSession) {
            if (this.manager == null) {
                return;
            }
            this.expiring = true;
            Context context = (Context)this.manager.getContainer();
            if (context != null) {
                Object[] listeners = context.getApplicationLifecycleListeners();
                if (notify && listeners != null) {
                    HttpSessionEvent event = new HttpSessionEvent(this.getSession());
                    for (int i = 0; i < listeners.length; ++i) {
                        int j = listeners.length - 1 - i;
                        if (!(listeners[j] instanceof HttpSessionListener)) continue;
                        HttpSessionListener listener = (HttpSessionListener)listeners[j];
                        try {
                            this.fireContainerEvent(context, "beforeSessionDestroyed", listener);
                            listener.sessionDestroyed(event);
                            this.fireContainerEvent(context, "afterSessionDestroyed", listener);
                            continue;
                        }
                        catch (Throwable t) {
                            try {
                                this.fireContainerEvent(context, "afterSessionDestroyed", listener);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.sessionEvent"), t);
                        }
                    }
                }
            }
            this.accessCount = 0;
            this.setValid(false);
            if (this.manager != null) {
                long timeNow = System.currentTimeMillis();
                int timeAlive = (int)((timeNow - this.creationTime) / 1000L);
                Manager manager = this.manager;
                synchronized (manager) {
                    if (timeAlive > this.manager.getSessionMaxAliveTime()) {
                        this.manager.setSessionMaxAliveTime(timeAlive);
                    }
                    int numExpired = this.manager.getExpiredSessions();
                    this.manager.setExpiredSessions(++numExpired);
                    int average = this.manager.getSessionAverageAliveTime();
                    average = (average * (numExpired - 1) + timeAlive) / numExpired;
                    this.manager.setSessionAverageAliveTime(average);
                }
                this.manager.remove((Session)this);
            }
            if (notify) {
                this.fireSessionEvent("destroySession", null);
            }
            this.expiring = false;
            String[] keys = this.keys();
            for (int i = 0; i < keys.length; ++i) {
                this.removeAttributeInternal(keys[i], notify, false);
            }
            if (notifyCluster && this.manager != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)smp.getString("deltaSession.notifying", (Object)((DeltaManager)this.manager).getName(), (Object)new Boolean(this.isPrimarySession()), (Object)expiredId));
                }
                ((DeltaManager)this.manager).sessionExpired(expiredId);
            }
        }
    }

    public Object getNote(String name) {
        return this.notes.get(name);
    }

    public Iterator getNoteNames() {
        return this.notes.keySet().iterator();
    }

    public void recycle() {
        this.attributes.clear();
        this.setAuthType(null);
        this.creationTime = 0L;
        this.expiring = false;
        this.id = null;
        this.lastAccessedTime = 0L;
        this.maxInactiveInterval = -1;
        this.accessCount = 0;
        this.notes.clear();
        this.setPrincipal(null);
        this.isNew = false;
        this.isValid = false;
        this.manager = null;
        this.deltaRequest.clear();
    }

    public void removeNote(String name) {
        this.notes.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionListener(SessionListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    public void setNote(String name, Object value) {
        this.notes.put(name, value);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DeltaSession[");
        sb.append(this.id);
        sb.append("]");
        return sb.toString();
    }

    public void readObjectData(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        this.readObject(stream);
    }

    public void writeObjectData(ObjectOutputStream stream) throws IOException {
        this.writeObject(stream);
    }

    public void resetDeltaRequest() {
        if (this.deltaRequest == null) {
            this.deltaRequest = new DeltaRequest(this.getIdInternal(), false);
        } else {
            this.deltaRequest.reset();
            this.deltaRequest.setSessionId(this.getIdInternal());
        }
    }

    public DeltaRequest getDeltaRequest() {
        if (this.deltaRequest == null) {
            this.resetDeltaRequest();
        }
        return this.deltaRequest;
    }

    public long getCreationTime() {
        if (!this.expiring && !this.isValid) {
            throw new IllegalStateException(sm.getString("standardSession.getCreationTime.ise"));
        }
        return this.creationTime;
    }

    public ServletContext getServletContext() {
        if (this.manager == null) {
            return null;
        }
        Context context = (Context)this.manager.getContainer();
        if (context == null) {
            return null;
        }
        return context.getServletContext();
    }

    public HttpSessionContext getSessionContext() {
        if (sessionContext == null) {
            sessionContext = new StandardSessionContext();
        }
        return sessionContext;
    }

    public Object getAttribute(String name) {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.getAttribute.ise"));
        }
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.getAttributeNames.ise"));
        }
        return new Enumerator(this.attributes.keySet(), true);
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.getValueNames.ise"));
        }
        return this.keys();
    }

    public void invalidate() {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.invalidate.ise"));
        }
        this.expire();
    }

    public boolean isNew() {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.isNew.ise"));
        }
        return this.isNew;
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.removeAttribute(name, true);
    }

    public void removeAttribute(String name, boolean notify) {
        this.removeAttribute(name, notify, true);
    }

    public void removeAttribute(String name, boolean notify, boolean addDeltaRequest) {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.removeAttribute.ise"));
        }
        this.removeAttributeInternal(name, notify, addDeltaRequest);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(name, value, true, true);
    }

    public void setAttribute(String name, Object value, boolean notify, boolean addDeltaRequest) {
        Object unbound;
        Object oldValue;
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("standardSession.setAttribute.namenull"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.setAttribute.ise"));
        }
        if (!(value instanceof Serializable)) {
            throw new IllegalArgumentException("Attribute [" + name + "] is not serializable");
        }
        if (addDeltaRequest && this.deltaRequest != null) {
            this.deltaRequest.setAttribute(name, value);
        }
        HttpSessionBindingEvent event = null;
        if (value instanceof HttpSessionBindingListener && notify && value != (oldValue = this.attributes.get(name))) {
            event = new HttpSessionBindingEvent(this.getSession(), name, value);
            try {
                ((HttpSessionBindingListener)value).valueBound(event);
            }
            catch (Exception x) {
                this.manager.getContainer().getLogger().error((Object)smp.getString("deltaSession.valueBound.ex"), (Throwable)x);
            }
        }
        if ((unbound = this.attributes.put(name, value)) != null && unbound != value && notify && unbound instanceof HttpSessionBindingListener) {
            try {
                ((HttpSessionBindingListener)unbound).valueUnbound(new HttpSessionBindingEvent(this.getSession(), name));
            }
            catch (Exception x) {
                this.manager.getContainer().getLogger().error((Object)smp.getString("deltaSession.valueBinding.ex"), (Throwable)x);
            }
        }
        if (!notify) {
            return;
        }
        Context context = (Context)this.manager.getContainer();
        if (context != null) {
            Object[] listeners = context.getApplicationEventListeners();
            if (listeners == null) {
                return;
            }
            for (int i = 0; i < listeners.length; ++i) {
                if (!(listeners[i] instanceof HttpSessionAttributeListener)) continue;
                HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners[i];
                try {
                    if (unbound != null) {
                        this.fireContainerEvent(context, "beforeSessionAttributeReplaced", listener);
                        if (event == null) {
                            event = new HttpSessionBindingEvent(this.getSession(), name, unbound);
                        }
                        listener.attributeReplaced(event);
                        this.fireContainerEvent(context, "afterSessionAttributeReplaced", listener);
                        continue;
                    }
                    this.fireContainerEvent(context, "beforeSessionAttributeAdded", listener);
                    if (event == null) {
                        event = new HttpSessionBindingEvent(this.getSession(), name, value);
                    }
                    listener.attributeAdded(event);
                    this.fireContainerEvent(context, "afterSessionAttributeAdded", listener);
                    continue;
                }
                catch (Throwable t) {
                    try {
                        if (unbound != null) {
                            this.fireContainerEvent(context, "afterSessionAttributeReplaced", listener);
                        } else {
                            this.fireContainerEvent(context, "afterSessionAttributeAdded", listener);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.attributeEvent"), t);
                }
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        this.authType = null;
        this.creationTime = (Long)stream.readObject();
        this.lastAccessedTime = (Long)stream.readObject();
        this.maxInactiveInterval = (Integer)stream.readObject();
        this.isNew = (Boolean)stream.readObject();
        this.isValid = (Boolean)stream.readObject();
        this.thisAccessedTime = (Long)stream.readObject();
        boolean hasPrincipal = stream.readBoolean();
        this.principal = null;
        if (hasPrincipal) {
            this.principal = SerializablePrincipal.readPrincipal(stream, this.getManager().getContainer().getRealm());
        }
        this.id = (String)stream.readObject();
        Log managerLog = this.manager.getContainer().getLogger();
        if (managerLog.isDebugEnabled()) {
            managerLog.debug((Object)smp.getString("deltaSession.readSession", (Object)this.id));
        }
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        int n = (Integer)stream.readObject();
        boolean isValidSave = this.isValid;
        this.isValid = true;
        for (int i = 0; i < n; ++i) {
            String name = (String)stream.readObject();
            Object value = stream.readObject();
            if (value instanceof String && value.equals(NOT_SERIALIZED)) continue;
            if (managerLog.isDebugEnabled()) {
                managerLog.debug((Object)("  loading attribute '" + name + "' with value '" + value + "'"));
            }
            this.attributes.put(name, value);
        }
        this.isValid = isValidSave;
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (this.notes == null) {
            this.notes = new Hashtable();
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(new Long(this.creationTime));
        stream.writeObject(new Long(this.lastAccessedTime));
        stream.writeObject(new Integer(this.maxInactiveInterval));
        stream.writeObject(new Boolean(this.isNew));
        stream.writeObject(new Boolean(this.isValid));
        stream.writeObject(new Long(this.thisAccessedTime));
        stream.writeBoolean(this.getPrincipal() != null);
        if (this.getPrincipal() != null) {
            SerializablePrincipal.writePrincipal((GenericPrincipal)this.principal, stream);
        }
        stream.writeObject(this.id);
        Log managerLog = this.manager.getContainer().getLogger();
        if (managerLog.isDebugEnabled()) {
            managerLog.debug((Object)smp.getString("deltaSession.writeSession", (Object)this.id));
        }
        String[] keys = this.keys();
        ArrayList<String> saveNames = new ArrayList<String>();
        ArrayList saveValues = new ArrayList();
        for (int i = 0; i < keys.length; ++i) {
            Object value = null;
            value = this.attributes.get(keys[i]);
            if (value == null || !(value instanceof Serializable)) continue;
            saveNames.add(keys[i]);
            saveValues.add(value);
        }
        int n = saveNames.size();
        stream.writeObject(new Integer(n));
        for (int i = 0; i < n; ++i) {
            stream.writeObject((String)saveNames.get(i));
            try {
                stream.writeObject(saveValues.get(i));
                if (!managerLog.isDebugEnabled()) continue;
                managerLog.debug((Object)(" storing attribute '" + saveNames.get(i) + "' with value '" + saveValues.get(i) + "'"));
                continue;
            }
            catch (NotSerializableException e) {
                managerLog.warn((Object)sm.getString("standardSession.notSerializable", saveNames.get(i), (Object)this.id), (Throwable)e);
                stream.writeObject(NOT_SERIALIZED);
                if (!managerLog.isDebugEnabled()) continue;
                managerLog.debug((Object)("  storing attribute '" + saveNames.get(i) + "' with value NOT_SERIALIZED"));
            }
        }
    }

    private void evaluateIfValid() {
        if (!this.isValid || this.expiring || this.maxInactiveInterval < 0) {
            return;
        }
        this.isValid();
    }

    private void fireContainerEvent(Context context, String type, Object data) throws Exception {
        if (!"org.apache.catalina.core.StandardContext".equals(context.getClass().getName())) {
            return;
        }
        if (this.containerEventMethod == null) {
            this.containerEventMethod = context.getClass().getMethod("fireContainerEvent", containerEventTypes);
        }
        Object[] containerEventParams = new Object[]{type, data};
        this.containerEventMethod.invoke((Object)context, containerEventParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSessionEvent(String type, Object data) {
        if (this.listeners.size() < 1) {
            return;
        }
        SessionEvent event = new SessionEvent((Session)this, type, data);
        SessionListener[] list = new SessionListener[]{};
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            list = this.listeners.toArray(list);
        }
        for (int i = 0; i < list.length; ++i) {
            list[i].sessionEvent(event);
        }
    }

    protected String[] keys() {
        return this.attributes.keySet().toArray(EMPTY_ARRAY);
    }

    protected Object getAttributeInternal(String name) {
        return this.attributes.get(name);
    }

    protected void removeAttributeInternal(String name, boolean notify, boolean addDeltaRequest) {
        Context context;
        Object value = this.attributes.remove(name);
        if (value == null) {
            return;
        }
        if (addDeltaRequest && this.deltaRequest != null) {
            this.deltaRequest.removeAttribute(name);
        }
        if (!notify) {
            return;
        }
        HttpSessionBindingEvent event = null;
        if (value instanceof HttpSessionBindingListener) {
            event = new HttpSessionBindingEvent(this.getSession(), name, value);
            try {
                ((HttpSessionBindingListener)value).valueUnbound(event);
            }
            catch (Exception x) {
                this.manager.getContainer().getLogger().error((Object)smp.getString("deltaSession.valueUnbound.ex"), (Throwable)x);
            }
        }
        if ((context = (Context)this.manager.getContainer()) != null) {
            Object[] listeners = context.getApplicationEventListeners();
            if (listeners == null) {
                return;
            }
            for (int i = 0; i < listeners.length; ++i) {
                if (!(listeners[i] instanceof HttpSessionAttributeListener)) continue;
                HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners[i];
                try {
                    this.fireContainerEvent(context, "beforeSessionAttributeRemoved", listener);
                    if (event == null) {
                        event = new HttpSessionBindingEvent(this.getSession(), name, value);
                    }
                    listener.attributeRemoved(event);
                    this.fireContainerEvent(context, "afterSessionAttributeRemoved", listener);
                    continue;
                }
                catch (Throwable t) {
                    try {
                        this.fireContainerEvent(context, "afterSessionAttributeRemoved", listener);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.attributeEvent"), t);
                }
            }
        }
    }

    protected long getLastTimeReplicated() {
        return this.lastTimeReplicated;
    }

    protected void setLastTimeReplicated(long lastTimeReplicated) {
        this.lastTimeReplicated = lastTimeReplicated;
    }

    protected void setAccessCount(int accessCount) {
        this.accessCount = accessCount;
    }

    protected int getAccessCount() {
        return this.accessCount;
    }

    protected void setExpireTolerance(int expireTolerance) {
        this.expireTolerance = expireTolerance;
    }

    protected int getExpireTolerance() {
        return this.expireTolerance;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

