<?php
/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons."
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

?>
<?php

function getModuleName() { 
	return "createmailitemmodule"; 
}
function getModuleType() {
	return "item"; 
}
function getDialogTitle() {
	return _("Create E-Mail"); 
}

function getIncludes(){
	$includes = array(
			"client/modules/".getModuleName().".js",
			"client/widgets/suggestionlist.js",
			"client/modules/suggestemailaddressmodule.js",
			"client/layout/css/suggestionlayer.css",
			"client/layout/js/createmail.js"
	);
	
	if (FCKEDITOR_INSTALLED){
		$includes[] = FCKEDITOR_JS_PATH."/fckeditor.js";
	}
	
	return $includes;
}

function getJavaScript_onload(){ ?>

					window.waitForSaveResponse = false;
					var rootentryid = false;
					var attachNum = false;
					var data = new Object();
					data["storeid"] = <?=get("storeid", "false", "'", ID_REGEX)?>;
					data["parententryid"] = <?=get("parententryid","false", "'", ID_REGEX)?>;
					data["message_action"] = <?=get("message_action", "false", "'", STRING_REGEX)?>;
					data["message_action_entryid"] = <?=(isset($_GET["message_action"]) && isset($_GET["entryid"]))?get("entryid", "false", "'", ID_REGEX):"false"?>;
					data["entryid"] = <?=get("entryid", "false", "'", ID_REGEX)?>;

					// If attachNum is set then it is embedded message
					<? if(isset($_GET["attachNum"]) && is_array($_GET["attachNum"])) { ?>
						rootentryid = <?=get("rootentryid", "false", "'", ID_REGEX)?>;
						attachNum = new Array();
					
						<? foreach($_GET["attachNum"] as $attachNum) { 
							if(preg_match_all(NUMERIC_REGEX, $attachNum, $matches)) {
							?>
								attachNum.push(<?=intval($attachNum)?>);
						<?	}
						} ?>
					<? } ?>

					module.init(moduleID);
					module.setData(data);
					module.open(<?=get("entryid", "false", "'", ID_REGEX)?>, rootentryid, attachNum);

					// Load Suggest Email Address module for the TO, CC and BCC fields
					var suggestEmailModule = webclient.dispatcher.loadModule("suggestEmailAddressModule");
					if(suggestEmailModule != null) {
						var suggestEmailModuleID = webclient.addModule(suggestEmailModule);
						suggestEmailModule.init(suggestEmailModuleID);
						// Setup TO field
						suggestlistTO = new suggestionList("create_email_to_fld", dhtml.getElementById("to"), suggestEmailModule);
						suggestEmailModule.addSuggestionList(suggestlistTO);
						// Setup CC field
						suggestlistCC = new suggestionList("create_email_cc_fld", dhtml.getElementById("cc"), suggestEmailModule);
						suggestEmailModule.addSuggestionList(suggestlistCC);
						// Setup BCC field
						suggestlistBCC = new suggestionList("create_email_bcc_fld", dhtml.getElementById("bcc"), suggestEmailModule);
						suggestEmailModule.addSuggestionList(suggestlistBCC);
					}

					if (FCKEDITOR_INSTALLED && parentWebclient.settings.get("createmail/mailformat","html")=="html"){
<?php
							// check if user language is supported by FCKEditor

							if (isset($_SESSION["lang"])){
								$client_lang = $_SESSION["lang"];
							}else{
								$client_lang = LANG;
							}

							$client_lang = str_replace("_","-",strtolower(substr($client_lang,0,5)));

							if (!file_exists(FCKEDITOR_JS_PATH."/editor/lang/".$client_lang.".js")){
								$client_lang = substr($client_lang,0,2);
								if (!file_exists(FCKEDITOR_JS_PATH."/editor/lang/".$client_lang.".js")){
									$client_lang = "en"; // always fall back to English
								}
							}
?>
						initEditor(true, "<?=FCKEDITOR_JS_PATH?>", "<?=$client_lang?>", <?=FCKEDITOR_SPELLCHECKER_ENABLED?"true":"false"?>);
					}else{
						dhtml.getElementById("use_html").value = "false";
					}

					if(parentWebclient.settings.get("createmail/from", "false") != "false"){
						var settingsFromFieldValue = parentWebclient.settings.get("createmail/from", "false");
						if(settingsFromFieldValue.length > 0){
							var settingsFromFieldValues = settingsFromFieldValue.split(",");
						}else{
							var settingsFromFieldValues = new Array();
						}
						var fromSelect = dhtml.getElementById("from", "select");
						if(fromSelect){
							for(var i=0;i<settingsFromFieldValues.length;i++){
								fromSelect.options[fromSelect.options.length] = new Option(settingsFromFieldValues[i], settingsFromFieldValues[i]);
							}
						}
					}else{
						var fromRow = dhtml.getElementById("from_row", "tr");
						if(fromRow){
							fromRow.style.display = "none";
						}
					}

					if (parentWebclient.settings.get("createmail/always_readreceipt", "false")=="true"){
						dhtml.getElementById("read_receipt_requested").value = "1";
						dhtml.addClassName(dhtml.getElementById('read_receipt_button'), "menubuttonselected");
					}

					if(data["entryid"] === false) {
						// check is this a new message then only set signature in body, 
						// otherwise this will be handled by module
						module.setBody(false, false, false);
					}

					// Fetch all the attributes that are passed in the URL
					<?	if (isset($_GET["to"])){ // for security reasons we need to urlencode this value for javascript?>
							dhtml.getElementById("to").value = decodeURIComponent("<?=rawurlencode(get("to"))?>");
					<?	} ?>

					<? if(isset($_GET["cc"])) { ?>
							dhtml.getElementById("cc").value = decodeURIComponent("<?=rawurlencode(get("cc"))?>");
					<?  } ?>

					<? if(isset($_GET["bcc"])) { ?>
							dhtml.getElementById("bcc").value = decodeURIComponent("<?=rawurlencode(get("bcc"))?>");
					<?  } ?>

					<? if(isset($_GET["subject"])) { ?>
							dhtml.getElementById("subject").value = decodeURIComponent("<?=rawurlencode(get("subject"))?>");
					<?  } ?>

					if(dhtml.getElementById("use_html").value == "false") {
						<? if(isset($_GET["body"])) { ?>
								dhtml.getElementById("html_body").value = decodeURIComponent("<?=rawurlencode(get("body"))?>");
						<?  } ?>
						if (window.BROWSER_IE){
							dhtml.addEvent(-1, dhtml.getElementById("html_body"), "keydown", IE_tracCursorPosition);
							dhtml.addEvent(-1, dhtml.getElementById("html_body"), "click", IE_tracCursorPosition);
						}
					}

					if(dhtml.getElementById("from")){
						dhtml.addEvent(-1, dhtml.getElementById("from"), "change", changeFromAddress);
					}

					setChangeHandlers(dhtml.getElementById("to"));
					setChangeHandlers(dhtml.getElementById("cc"));
					setChangeHandlers(dhtml.getElementById("bcc"));
					setChangeHandlers(dhtml.getElementById("subject"));
					setChangeHandlers(dhtml.getElementById("html_body"));
					setChangeHandlers(dhtml.getElementById("from"));

					resizeBody();

					/**
					 * If setting is enabled to close opening readmail dialog when replying do so. 
					 * This also checks if the user is actually replying/forwarding and has not just
					 * clicked on the email address (hence the message_action check).
					 */
					if (parentWebclient.settings.get("createmail/close_on_reply", "no")=="yes" && opener.parentWebclient && data["message_action"]){
						opener.close();
					}

					dhtml.getElementById("to").focus();
					
					// Specifically enable default action on text fields
					dhtml.addEvent(false, dhtml.getElementById("to"), "contextmenu", forceDefaultActionEvent);
					dhtml.addEvent(false, dhtml.getElementById("cc"), "contextmenu", forceDefaultActionEvent);
					dhtml.addEvent(false, dhtml.getElementById("bcc"), "contextmenu", forceDefaultActionEvent);
					dhtml.addEvent(false, dhtml.getElementById("from"), "contextmenu", forceDefaultActionEvent);
					dhtml.addEvent(false, dhtml.getElementById("subject"), "contextmenu", forceDefaultActionEvent);
					dhtml.addEvent(false, dhtml.getElementById("html_body"), "contextmenu", forceDefaultActionEvent);
					
					// Set flag to take necessary decisions on attachments 
					module.messageAction = data["message_action"];

					// Activate automatic saving to drafts folder
					if(parentWebclient.settings.get("createmail/autosave", "false") != "false"){
						var autosaveIntervalMin = (parentWebclient.settings.get("createmail/autosave_interval", 3));
						setInterval(function(){
							autosave();
						}, 60 * autosaveIntervalMin * 1000);
					}

					// Notify the ZarafaDnD Firefox extension that this dialog accepts dragged files
					allowDnDFiles();
<?php } // getJavaScript_onload

function getJavaScript_other(){
?>		
			var FCKEDITOR_INSTALLED = <?=(FCKEDITOR_INSTALLED?"true":"false")?>;
			var suggestlist;

			window.messageChanged = false;

			window.onbeforeunload = function(){
				if (window.messageChanged){
					return "<?=_("You can lose changes when you continue.")?>";
				}
			}

			function setChangeHandlers(element)
			{
				if (element){
					dhtml.addEvent(-1, element, "change", setMessageChanged);
					dhtml.addEvent(-1, element, "keypress", setMessageChanged);
				}
			}

			function setMessageChanged()
			{
				window.document.title = _("Create E-Mail")+"*";
				window.messageChanged = true;
				window.changedSinceLastAutoSave = true;
			}

			function setFCKMessageChanged(editorInstance)
			{
				setMessageChanged();
				if (window.BROWSER_IE) IE_tracCursorInEditor();
				return false;
			}

			function FCKeditor_OnComplete( editorInstance )
			{
				// Make the editor instance available for the setContentInBodyArea() call.
				document.fckEditor = editorInstance;
				// When the XML data is already available we can set the body.
				if(document.fckEditorContent){
					setContentInBodyArea();
					// This timeout will get the DOM tree of FCKeditor,thus we can add a 'p' element to DOM
					window.setTimeout(function() {
						setCursorPosition(module.messageAction);
					},500);
				}

				editorInstance.Events.AttachEvent( 'OnSelectionChange', setFCKMessageChanged ) ;
				
				// set content of body if it is passed in URL
				<? if(isset($_GET["body"])) { ?>
					editorInstance.SetHTML(decodeURIComponent("<?=rawurlencode($_GET["body"])?>"));
				<? } ?>
				if (module)	{
				
				   /**
					* This settimeout is used to get the usable DOM tree of FCKeditor so that we can 
					* retrieve the image tag from editor Document to built the inline image array which is 
					* send to user while replying the mail.
					*/
					window.setTimeout(function() {
						module.retrieveInlineImagesFromBody(editorInstance.EditorDocument);
					},500);
					
					// Set inline options after message is completely loaded into editor.
					module.setAttachmentbarAttachmentOptions();
				}

				/**
				 * Note: In IE, 'OnSelectionChange' event does not fire on every keystroke,
				 * but only on some random keystrokes.So, add keydown and mousedown event to trac selection in editor.
				 */
				if (window.BROWSER_IE) {
					editorInstance.EditorDocument.attachEvent("onkeydown", IE_tracCursorInEditor);
					editorInstance.EditorDocument.attachEvent("onmousedown", IE_tracCursorInEditor);
					// Blur event in fckEditor creates problem in IE6 and IE8
					if (!window.BROWSER_IE8 && !window.BROWSER_IE6)
						editorInstance.EditorWindow.attachEvent("onblur", IE_tracCursorInEditor);

					// Save initial selection in editor.
					IE_tracCursorInEditor();
				}
			}
			
			var abSelection = "to";
			function abCallBack(recips)
			{
				for(key in recips) {
					if (key!="multiple" && key!="value"){
						dhtml.getElementById(key).value = recips[key].value;
					}
				}

				dhtml.getElementById(abSelection).select();
				dhtml.getElementById(abSelection).focus();
			}

<?php 
}


function getBody(){ 
	?>
		<input id="entryid" type="hidden">
		<input id="parent_entryid" type="hidden">
		<input id="message_class" type="hidden" value="IPM.Note">
		<input id="importance" type="hidden" value="1">
		<input id="use_html" type="hidden" value="true">
		<input id="sensitivity" type="hidden" value="0">
		<input id="read_receipt_requested" type="hidden" value="false">
		<input id="sent_representing_name" type="hidden" value="">
		<input id="sent_representing_email_address" type="hidden" value="">
		<input id="sent_representing_addrtype" type="hidden" value="SMTP">
		
		<div id="conflict"></div>

		<div class="properties">
			<table class="fixed_table_layout" width="100%" border="0" cellpadding="1" cellspacing="0">

				<tr id="from_row">
					<td class="propertynormal propertywidth" align="center"><?=_("From")?>:</td>
					<td>
						<select id="from" class="field from_select">
							<option></option>
						</select>
					</td>
				</tr>

				<?
					$recipients = array("to" => _("To"), "cc" => _("CC"), "bcc" => _("BCC"));

					$fields = "";					
					foreach($recipients as $key => $name) {
						$fields .= "fields[" . urlencode($key) . "]=" . urlencode($name) . "&";
					}
					
					foreach($recipients as $key => $recipient)
					{
				?>
					<tr>
						<td class="propertynormal propertywidth" align="center">
							<input class="button" type="button" value="<?=$recipient?>..." onclick="abSelection='<?=$key?>'; webclient.openModalDialog(module, 'addressbook', DIALOG_URL+'task=addressbook_modal&storeid=' + module.storeid + '&<?=$fields?>dest=<?=$key?>', 550, 410, abCallBack);">
						</td>
						<td>
							<input id="<?=$key?>" class="field" type="text">
						</td>
					</tr>
				<?
					}
				?>
				
				<tr>
					<td class="propertynormal propertywidth" align="center">
						<?=_("Subject")?>:
					</td>
					<td>
						<input id="subject" class="field" type="text">
					</td>
				</tr>
				<tr>
					<td class="propertynormal propertywidth" valign="top">
						<input class="button" type="button" value="<?=_("Attachments")?>:" onclick="webclient.openWindow(module, 'attachments', DIALOG_URL+'task=attachments_modal&store=' + module.storeid + '&entryid=' + (module.messageentryid?module.messageentryid:'') + '&dialog_attachments=' + dhtml.getElementById('dialog_attachments').value, 550, 350, '0');">
					</td>
					<td valign="top">
						<div id="itemattachments">&nbsp;</div>
					</td>
				</tr>
			</table>
		</div>
		
		<textarea id="html_body" cols="60" rows="12"></textarea>
<?php } // getBody


function getMenuButtons(){
	return array(
			array(
				'id'=>"send",
				'name'=>_("Send"),
				'title'=>_("Send new Mail"),
				'callback'=>'function(){submit_createmail(true);}',
				'shortcut'=>"S"
			),
			array(
				'id'=>"seperator",
				'name'=>"",
				'title'=>"",
				'callback'=>""
			),
			array(
				'id'=>"save",
				'name'=>"",
				'title'=>_("Save"),
				'callback'=>'function(){submit_createmail(false);}'
			),
			array(
				'id'=>"attachment",
				'name'=>"",
				'title'=>_("Add Attachments"),
				'callback'=>"function(){setMessageChanged();webclient.openWindow(module, 'attachments', DIALOG_URL+'task=attachments_modal&store=' + module.storeid + '&entryid=' + (module.messageentryid?module.messageentryid:'') + '&dialog_attachments=' + dhtml.getElementById('dialog_attachments').value, 550, 350, '0');}"
			),
			array(
				'id'=>"seperator",
				'name'=>"",
				'title'=>"",
				'callback'=>""
			),
			array(
				'id'=>"addsignature",
				'name'=>"",
				'title'=>_("Add Signature"),
				'callback'=>'eventMenuAddSignature'
			),
			array(
				'id'=>"seperator",
				'name'=>"",
				'title'=>"",
				'callback'=>""
			),
			array(
				'id'=>"checknames",
				'name'=>"",
				'title'=>_("Check Names"),
				'callback'=>'function(){checkNames(checkNamesCallBackCreateMail);}'
			),
			array(
				'id'=>"seperator",
				'name'=>"",
				'title'=>"",
				'callback'=>""
			),
			array(
				'id'=>"priority_high",
				'name'=>"",
				'title'=>_("Priority: High"),
				'callback'=>"function(){setMessageChanged();setImportance(dhtml.getElementById('importance').value!=2?2:1);}"
			),
			array(
				'id'=>"priority_low",
				'name'=>"",
				'title'=>_("Priority: Low"),
				'callback'=>"function(){setMessageChanged();setImportance(dhtml.getElementById('importance').value!=0?0:1);}"
			),
			array(
				'id'=>"seperator",
				'name'=>"",
				'title'=>"",
				'callback'=>""
			),
            array(
				'id'=>"read_receipt_button",
				'name'=>"",
				'title'=>_("Set/Unset Read Receipt"),
				'callback'=>"function(){setMessageChanged();toggleReadReceipt(dhtml.getElementById('read_receipt_requested').value);}"
            ),
            array(
               'id'=>"seperator",
               'name'=>"",
               'title'=>"",
               'callback'=>""
            ),
			array(
				'id'=>"options",
				'name'=>_("Options"),
				'title'=>_("Options"),
				'callback'=>"function(){setMessageChanged();webclient.openModalDialog(module, 'options', DIALOG_URL+'task=mailoptions_modal', 310, 220, mailOptionsCallBack);}"
			)
		);
}  // getMenuButtons
?>
