<?php
/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons."
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

?>
<?php
	/**
	 * Rules Module
	 */
	class RulesListModule extends ListModule
	{	
		/**
		 * Constructor
		 * @param int $id unique id.
		 * @param array $data list of all actions.
		 */
		function RulesListModule($id, $data)
		{
			$this->properties = $GLOBALS["properties"]->getRulesProperties();
		
			// Default Columns
			$this->tablecolumns = array();
			$this->addColumn($this->tablecolumns, "name", true, 0, _("Rule name"), _("Sort on rule name"));
			$this->addColumn($this->tablecolumns, "enabled", true, 1, _("Rule enabled"), _("Sort on rule enabled"));

			parent::ListModule($id, $data, array());

			$this->sort = array();
			$this->sort[$this->properties["rule_name"]] = TABLE_SORT_ASCEND;
		}
		
		/**
		 * Executes all the actions in the $data variable.
		 * @return boolean true on success of false on fialure.
		 */
		function execute()
		{
			$result = false;
			
			foreach($this->data as $action)
			{
				switch($action["attributes"]["type"]) {
				case 'list':
					$store = $this->getActionStore($action);
				
					$rules = $this->ruleList($store, $action);
					
					if($rules) {
						$result = true;

						$rules["attributes"] = array("type" => "list");
						
						$storeProps = mapi_msgstore_getprops($store, array(PR_IPM_WASTEBASKET_ENTRYID));
						$wastebasket_entryid = $storeProps[PR_IPM_WASTEBASKET_ENTRYID];
						$rules["wastebasket_entryid"] = array("attributes"=>array("type"=>"binary"), "_content"=>bin2hex($wastebasket_entryid));

						array_push($this->responseData["action"], $rules);
						$GLOBALS["bus"]->addData($this->responseData);
					};
					break;
				case 'setRules':
					$store = $this->getActionStore($action);

					if (isset($action["rules"])){
						$this->setRules($store, $action["rules"]);
					}
					break;
				}
			}
			
			return $result;
		}
		
		function ruleList($store, $action)
		{
			$rules = $GLOBALS["operations"]->getRules($store, $this->properties);
			
			$data["item"] = $rules;
			
			$data["column"] = array(
								array("id" => "rule_id", "visible" => false, "name" => _("Id"),      "title" => _("Sort on Id"),      "order" => 0 ),
								array("id" => "rule_state", "visible" => true, "title" => _("Sort on Enabled"), "order" => 0, "type" => "checkbox|ST_ENABLED", "length" => 22 ),
								array("id" => "rule_name", "visible" => true, "name" => _("Name"),    "title" => _("Sort on Name"),    "order" => 0, "length" => PERCENTAGE ),
							  );
			
			return $data;
		}
		
		function setRules($store, $rules)
		{
			$result = $GLOBALS["operations"]->updateRules($store, $rules, $this->properties);
		}
	}
?>
