#!/usr/bin/perl
#
# Copyright (c) 2006 Zmanda Inc.  All Rights Reserved.
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 2 as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# Contact information: Zmanda Inc, 505 N Mathlida Ave, Suite 120
# Sunnyvale, CA 94085, USA, or: http://www.zmanda.com
#
#

package ZRM::Replication;

use strict;
use warnings;
use File::Spec::Functions;
use File::Basename;
use File::Path;
use lib '/usr/lib/mysql-zrm';
use ZRM::Common;
use ZRM::MySQL;

require Exporter;

use vars qw(@ISA @EXPORT_OK);
our @ISA = qw(Exporter);

our @EXPORT = qw( &backupReplicationData );

#Backs up the replication related files
sub backupReplicationData()
{

	#Backup <datadir>/master.info
	my $dest = $inputs{"destination"};
	my $filename = catfile( $datadir, "master.info" );
	my @ret;
	my $str = "";
	if( $verbose ) {
		&printLog( "Backing up master.info\n" );
	}
	my $y = &copyOneFileRemote( $filename, $dest );
	if( $y > 0 ) {
		$str .= "replication=master.info";
	} else {
		&printError( "Error backing up master.info\n" );
	}

	#Backup <datadir>/relay-log.info
	$filename = catfile( $datadir, "relay-log.info" );
	if( $verbose ) {
		&printLog( "Backing up relay-log.info\n" );
	}
	$y = &copyOneFileRemote( $filename, $dest );
	if( $y > 0 ) {
		$str .= " relay-log.info";
	} else {
		&printError( "Error backing up relay-log.info\n" );
	}
	$str .= "\n";
	push @ret, $str;

	$str = "";
	# Backup <slave_load_tmpdir>/SQL_LOAD-* files if they exist
	if( $slave_load_tmpdir=~/\s/ ){
                $slave_load_tmpdir = "\"$slave_load_tmpdir\"";
        }
	my $slavetmpfiles=catfile( $slave_load_tmpdir, "SQL_LOAD*" );

	if( $inputs{"copy-plugin"} ){
		my $yy = &copyOneFileRemote( $slavetmpfiles, $dest );
		if( $y > 0 ){
			my @list;
			my $f = catfile( $dest, "SQL_LOAD" );
			$f .= "*";
			@list = glob $f;
			my $n = @list;
			if( $n > 0 ){
				$str = "slave-load-files=";
				foreach( @list ){
					my $r = basename( $_ );
					$str .= "$r ";
				}
				$str .= "\n";
				push @ret, $str;
			}
		}else{
			&printError( "Error backing up ".$_."\n" );
		}
	}else{
		my @y = glob $slavetmpfiles;
        	if( @y ) {
			$str = "slave-load-files=";
                	foreach( @y ) {
                        	my $t = &copyOneFileLocal( $_, $dest );
                        	if( $t > 0 ) {
                                	my( $name, $dir, $suff ) = fileparse( $_, "" );
					$str .= "$name ";
                        	} else {
                                	&printError( "Error backing up ".$_."\n" );
                        	}
                	}
			$str .= "\n";
			push @ret, $str;
        	}
	}
	
	return @ret;
}

1;
