/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.transport;

import br.arca.morcego.Config;
import br.arca.morcego.structure.Graph;
import br.arca.morcego.structure.GraphElementFactory;
import br.arca.morcego.structure.Node;
import br.arca.morcego.transport.Transport;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcAppletClient;
import org.apache.xmlrpc.XmlRpcException;

public class XmlrpcTransport
implements Transport {
    private XmlRpcAppletClient client;
    private String url;
    private static Hashtable availableProperties = new Hashtable();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public void setup() {
        this.setServerUrl(Config.getString("morcego.serverUrl"));
    }

    public void setServerUrl(String server_url) {
        this.url = server_url;
        try {
            this.client = new XmlRpcAppletClient(server_url);
        }
        catch (MalformedURLException e) {
            System.out.println("Bad URL " + this.url);
            e.printStackTrace();
        }
        this.initAvailableProperties();
    }

    private void initAvailableProperties() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.Color");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        availableProperties.put("color", clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.net.URL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        availableProperties.put("actionUrl", clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        availableProperties.put("hierarchy", clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        availableProperties.put("description", clazz4);
    }

    public Graph retrieveData(Node centerNode, Integer depth) {
        Graph graph = new Graph();
        Hashtable result = this.fetchData(centerNode, depth);
        this.fillGraph(graph, result);
        return graph;
    }

    private void fillGraph(Graph graph, Hashtable result) {
        Hashtable nodes = (Hashtable)result.get("graph");
        Enumeration eN = nodes.keys();
        while (eN.hasMoreElements()) {
            String nodeName = (String)eN.nextElement();
            Node node = GraphElementFactory.createNode(nodeName, graph);
            Hashtable nodeData = (Hashtable)nodes.get(nodeName);
            Vector neighbours = (Vector)nodeData.get("neighbours");
            Enumeration eL = neighbours.elements();
            while (eL.hasMoreElements()) {
                String neighbourName = (String)eL.nextElement();
                if (neighbourName.equals(node.getId())) continue;
                node.addLink(neighbourName);
            }
            Enumeration eP = nodeData.keys();
            while (eP.hasMoreElements()) {
                Class type;
                String key = (String)eP.nextElement();
                if (key.equals("neighbours") || (type = (Class)availableProperties.get(key)) == null) continue;
                node.setProperty(key, Config.decode((String)nodeData.get(key), type));
            }
            node.init();
        }
    }

    private Hashtable fetchData(Node centerNode, Integer depth) {
        Vector<Object> params = new Vector<Object>();
        params.add(centerNode.getId());
        params.add(depth);
        Hashtable result = new Hashtable();
        try {
            result = (Hashtable)this.client.execute("getSubGraph", params);
        }
        catch (XmlRpcException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
}

