% TANH TANH Hyperbolic Tangent Function
% 
% Usage
% 
% Computes the hyperbolic tangent of the argument.
% The syntax for its use is
% 
%    y = tanh(x)
% 

% Copyright (c) 2002-2007 Samit Basu
% Licensed under the GPL

function y = tanh(x)
  if (nargin == 0 || ~isnumeric(x))
    error('tanh expects a numeric input');
  end
  y = sinh(x)./cosh(x);
  
  
