/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.image;

import gnu.java.awt.image.ImageDecoder;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;

public class XBMDecoder
extends ImageDecoder {
    BufferedReader reader;
    static final ColorModel cm = ColorModel.getRGBdefault();
    static final int black = -16777216;
    static final int transparent = 0;
    static final int[] masktable = new int[]{1, 2, 4, 8, 16, 32, 64, 128};

    public XBMDecoder(String string) {
        super(string);
    }

    public XBMDecoder(URL uRL) {
        super(uRL);
    }

    public void produce(Vector vector, InputStream inputStream) throws IOException {
        Object object;
        int n;
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < 2; ++n) {
            object = this.reader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer((String)object);
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            if (n == 0) {
                n2 = Integer.parseInt(stringTokenizer.nextToken(), 10);
                continue;
            }
            n3 = Integer.parseInt(stringTokenizer.nextToken(), 10);
        }
        for (n = 0; n < vector.size(); ++n) {
            object = (ImageConsumer)vector.elementAt(n);
            object.setDimensions(n2, n3);
            object.setColorModel(cm);
            object.setHints(30);
        }
        while (this.reader.read() != 123) {
        }
        for (n = 0; n < n3; ++n) {
            object = XBMDecoder.getScanline(this.reader, n2);
            for (int i = 0; i < vector.size(); ++i) {
                ImageConsumer imageConsumer = (ImageConsumer)vector.elementAt(i);
                imageConsumer.setPixels(0, 0 + n, n2, 1, cm, (int[])object, 0, n2);
            }
        }
        for (n = 0; n < vector.size(); ++n) {
            object = (ImageConsumer)vector.elementAt(n);
            object.imageComplete(3);
        }
    }

    public static int[] getScanline(Reader reader, int n) throws IOException {
        char[] cArray = new char[2];
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = reader.read();
            if (n3 != 48) continue;
            reader.read();
            cArray[0] = (char)reader.read();
            cArray[1] = (char)reader.read();
            int n4 = Integer.parseInt(new String(cArray), 16);
            int n5 = 0;
            while (n5 < 8) {
                if (n2 == n) {
                    return nArray;
                }
                nArray[n2] = (n4 & masktable[n5]) != 0 ? -16777216 : 0;
                ++n5;
                ++n2;
            }
        }
        return nArray;
    }
}

