/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.ContentType;
import gnu.javax.net.ssl.provider.MacException;
import gnu.javax.net.ssl.provider.OverflowException;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.SecurityParameters;
import gnu.javax.net.ssl.provider.Util;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.net.ssl.SSLException;

class JCESecurityParameters
implements SecurityParameters {
    private Cipher inCipher;
    private Cipher outCipher;
    private Mac inMac;
    private Mac outMac;
    private Inflater inflater;
    private Deflater deflater;
    private int fragmentLength = 16384;
    private long inSequence = 0L;
    private long outSequence = 0L;
    private ProtocolVersion version;

    JCESecurityParameters() {
    }

    public void reset() {
        this.inCipher = null;
        this.outCipher = null;
        this.inMac = null;
        this.outMac = null;
        this.deflater = null;
        this.inflater = null;
    }

    public void setInCipher(Object object) {
        this.inCipher = (Cipher)object;
    }

    public void setOutCipher(Object object) {
        this.outCipher = (Cipher)object;
    }

    public void setInMac(Object object) {
        this.inMac = (Mac)object;
        this.inSequence = 0L;
    }

    public void setOutMac(Object object) {
        this.outMac = (Mac)object;
        this.outSequence = 0L;
    }

    public void setDeflating(boolean bl) {
        if (bl) {
            if (this.deflater == null) {
                this.deflater = new Deflater();
            }
        } else {
            this.deflater = null;
        }
    }

    public void setInflating(boolean bl) {
        if (bl) {
            if (this.inflater == null) {
                this.inflater = new Inflater();
            }
        } else {
            this.inflater = null;
        }
    }

    public int getFragmentLength() {
        return this.fragmentLength;
    }

    public void setFragmentLength(int n) {
        this.fragmentLength = n;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public void setVersion(ProtocolVersion protocolVersion) {
        this.version = protocolVersion;
    }

    public synchronized byte[] decrypt(byte[] byArray, ProtocolVersion protocolVersion, ContentType contentType) throws MacException, OverflowException, SSLException {
        boolean bl = false;
        if (this.inCipher != null) {
            try {
                byArray = this.inCipher.doFinal(byArray);
            }
            catch (BadPaddingException badPaddingException) {
                bl = true;
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                bl = true;
            }
        }
        if (this.inMac != null) {
            int n = this.inMac.getMacLength();
            int n2 = byArray.length - n;
            byte[] byArray2 = Util.trim(byArray, n2, n);
            byArray = Util.trim(byArray, n2);
            this.inMac.update((byte)(this.inSequence >>> 56));
            this.inMac.update((byte)(this.inSequence >>> 48));
            this.inMac.update((byte)(this.inSequence >>> 40));
            this.inMac.update((byte)(this.inSequence >>> 32));
            this.inMac.update((byte)(this.inSequence >>> 24));
            this.inMac.update((byte)(this.inSequence >>> 16));
            this.inMac.update((byte)(this.inSequence >>> 8));
            this.inMac.update((byte)this.inSequence);
            this.inMac.update((byte)contentType.getValue());
            if (protocolVersion != ProtocolVersion.SSL_3) {
                this.inMac.update((byte)protocolVersion.getMajor());
                this.inMac.update((byte)protocolVersion.getMinor());
            }
            this.inMac.update((byte)(n2 >>> 8));
            this.inMac.update((byte)n2);
            this.inMac.update(byArray);
            if (!Arrays.equals(byArray2, this.inMac.doFinal()) || bl) {
                throw new MacException();
            }
        }
        if (this.inflater != null) {
            byte[] byArray3 = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length << 1);
            this.inflater.setInput(byArray);
            try {
                int n;
                while ((n = this.inflater.inflate(byArray3)) > 0) {
                    byteArrayOutputStream.write(byArray3, 0, n);
                    if (byteArrayOutputStream.size() <= this.fragmentLength + 1024) continue;
                    throw new OverflowException("inflated data too large");
                }
            }
            catch (DataFormatException dataFormatException) {
                throw new SSLException(String.valueOf(dataFormatException));
            }
            byArray = byteArrayOutputStream.toByteArray();
            this.inflater.reset();
        }
        ++this.inSequence;
        return byArray;
    }

    public synchronized byte[] encrypt(byte[] byArray, int n, int n2, ContentType contentType) throws OverflowException, SSLException {
        if (this.deflater != null) {
            byte[] byArray2 = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2 >>> 1);
            this.deflater.setInput(byArray, n, n2);
            this.deflater.finish();
            n2 = 0;
            while ((n2 = this.deflater.deflate(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n2);
            }
            if (byteArrayOutputStream.size() > this.fragmentLength + 1024) {
                throw new OverflowException("deflated data too large");
            }
            byArray = byteArrayOutputStream.toByteArray();
            n = 0;
            n2 = byArray.length;
            this.deflater.reset();
        }
        if (this.outMac != null) {
            this.outMac.update((byte)(this.inSequence >>> 56));
            this.outMac.update((byte)(this.inSequence >>> 48));
            this.outMac.update((byte)(this.inSequence >>> 40));
            this.outMac.update((byte)(this.inSequence >>> 32));
            this.outMac.update((byte)(this.inSequence >>> 24));
            this.outMac.update((byte)(this.inSequence >>> 16));
            this.outMac.update((byte)(this.inSequence >>> 8));
            this.outMac.update((byte)this.inSequence);
            this.outMac.update((byte)contentType.getValue());
            if (this.version != ProtocolVersion.SSL_3) {
                this.outMac.update((byte)this.version.getMajor());
                this.outMac.update((byte)this.version.getMinor());
            }
            this.outMac.update((byte)(n2 >>> 8));
            this.outMac.update((byte)n2);
            this.outMac.update(byArray, n, n2);
            byArray = Util.concat(byArray, this.outMac.doFinal());
            n = 0;
            n2 = byArray.length;
        }
        if (this.outCipher != null) {
            try {
                byArray = this.outCipher.doFinal(byArray, n, n2);
            }
            catch (BadPaddingException badPaddingException) {
                throw new RuntimeException("bad padding thrown while encrypting");
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new RuntimeException("illegal block size thrown while encrypting");
            }
            n = 0;
            n2 = byArray.length;
        }
        ++this.outSequence;
        if (n == 0 && n2 == byArray.length) {
            return byArray;
        }
        return Util.trim(byArray, n, n2);
    }
}

