/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Util;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Arrays;

class Signature
implements Constructed {
    private final Object sigValue;
    private final String sigAlg;

    Signature(Object object, String string) {
        this.sigValue = object;
        this.sigAlg = string;
    }

    static Signature read(InputStream inputStream, CipherSuite cipherSuite, PublicKey publicKey) throws IOException {
        Object[] objectArray = null;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readUnsignedShort();
        objectArray = new byte[n];
        dataInputStream.readFully((byte[])objectArray);
        if (cipherSuite.getSignature() == "DSS") {
            DERReader dERReader = new DERReader(new ByteArrayInputStream((byte[])objectArray));
            if (dERReader.read().getTag() != 16) {
                throw new IOException("expecting DER SEQUENCE");
            }
            BigInteger bigInteger = (BigInteger)dERReader.read().getValue();
            BigInteger bigInteger2 = (BigInteger)dERReader.read().getValue();
            objectArray = new BigInteger[]{bigInteger, bigInteger2};
        }
        return new Signature(objectArray, cipherSuite.getSignature());
    }

    public void write(OutputStream outputStream) throws IOException {
        this.write(outputStream, ProtocolVersion.TLS_1);
    }

    public void write(OutputStream outputStream, ProtocolVersion protocolVersion) throws IOException {
        byte[] byArray = null;
        if (this.sigValue instanceof byte[]) {
            byArray = (byte[])this.sigValue;
        } else {
            DERValue dERValue = new DERValue(2, ((BigInteger[])this.sigValue)[0]);
            DERValue dERValue2 = new DERValue(2, ((BigInteger[])this.sigValue)[1]);
            DERValue dERValue3 = new DERValue(48, Arrays.asList(new Object[]{dERValue, dERValue2}));
            byArray = dERValue3.getEncoded();
        }
        outputStream.write(byArray.length >>> 8 & 0xFF);
        outputStream.write(byArray.length & 0xFF);
        outputStream.write(byArray);
    }

    Object getSigValue() {
        return this.sigValue;
    }

    String getSigAlg() {
        return this.sigAlg;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("struct {");
        if (this.sigAlg.equals("RSA")) {
            printWriter.print(Util.hexDump((byte[])this.sigValue, "  "));
        } else {
            printWriter.println("  r = " + ((BigInteger[])this.sigValue)[0].toString(16) + ";");
            printWriter.println("  s = " + ((BigInteger[])this.sigValue)[1].toString(16) + ";");
        }
        printWriter.println("} Signature;");
        return stringWriter.toString();
    }
}

