/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.LongBufferImpl;

public abstract class LongBuffer
extends Buffer
implements Comparable {
    int array_offset = 0;
    long[] backing_buffer;

    LongBuffer(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public static LongBuffer allocate(int n) {
        return new LongBufferImpl(n);
    }

    public static final LongBuffer wrap(long[] lArray, int n, int n2) {
        return new LongBufferImpl(lArray, 0, lArray.length, n + n2, n, -1, false);
    }

    public static final LongBuffer wrap(long[] lArray) {
        return LongBuffer.wrap(lArray, 0, lArray.length);
    }

    public LongBuffer get(long[] lArray, int n, int n2) {
        Buffer.checkArraySize(lArray.length, n, n2);
        this.checkForUnderflow(n2);
        for (int i = n; i < n + n2; ++i) {
            lArray[i] = this.get();
        }
        return this;
    }

    public LongBuffer get(long[] lArray) {
        return this.get(lArray, 0, lArray.length);
    }

    public LongBuffer put(LongBuffer longBuffer) {
        if (longBuffer == this) {
            throw new IllegalArgumentException();
        }
        this.checkForOverflow(longBuffer.remaining());
        if (longBuffer.remaining() > 0) {
            long[] lArray = new long[longBuffer.remaining()];
            longBuffer.get(lArray);
            this.put(lArray);
        }
        return this;
    }

    public LongBuffer put(long[] lArray, int n, int n2) {
        Buffer.checkArraySize(lArray.length, n, n2);
        this.checkForOverflow(n2);
        for (int i = n; i < n + n2; ++i) {
            this.put(lArray[i]);
        }
        return this;
    }

    public final LongBuffer put(long[] lArray) {
        return this.put(lArray, 0, lArray.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && !this.isReadOnly();
    }

    public final long[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.array_offset;
    }

    public int hashCode() {
        long l = this.get(this.position()) + (long)31;
        long l2 = 1L;
        for (int i = this.position() + 1; i < this.limit(); ++i) {
            l += (this.get(i) + (long)30) * (l2 *= (long)31);
        }
        return (int)l;
    }

    public boolean equals(Object object) {
        if (object instanceof LongBuffer) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    public int compareTo(Object object) {
        LongBuffer longBuffer = (LongBuffer)object;
        int n = Math.min(this.remaining(), longBuffer.remaining());
        int n2 = this.position();
        int n3 = longBuffer.position();
        for (int i = 0; i < n; ++i) {
            long l;
            long l2;
            if ((l2 = this.get(n2++)) == (l = longBuffer.get(n3++))) continue;
            if (l2 < l) {
                return -1;
            }
            return 1;
        }
        return this.remaining() - longBuffer.remaining();
    }

    public abstract ByteOrder order();

    public abstract long get();

    public abstract LongBuffer put(long var1);

    public abstract long get(int var1);

    public abstract LongBuffer put(int var1, long var2);

    public abstract LongBuffer compact();

    public abstract boolean isDirect();

    public abstract LongBuffer slice();

    public abstract LongBuffer duplicate();

    public abstract LongBuffer asReadOnlyBuffer();
}

