/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakHashMap
extends AbstractMap
implements Map {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final Object NULL_KEY = new Object(null){
        private /* synthetic */ WeakHashMap this$0;
        {
            this.this$0 = weakHashMap;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            return object == null || this == object;
        }
    };
    private final ReferenceQueue queue;
    int size;
    private float loadFactor;
    private int threshold;
    int modCount;
    private final WeakEntrySet theEntrySet;
    WeakBucket[] buckets;

    public WeakHashMap() {
        this(11, 0.75f);
    }

    public WeakHashMap(int n) {
        this(n, 0.75f);
    }

    public WeakHashMap(int n, float f) {
        if (n < 0 || !(f > 0.0f)) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n * f);
        this.theEntrySet = new WeakEntrySet(this);
        this.queue = new ReferenceQueue();
        this.buckets = new WeakBucket[n];
    }

    public WeakHashMap(Map map) {
        this(map.size(), 0.75f);
        this.putAll(map);
    }

    private int hash(Object object) {
        return Math.abs(object.hashCode() % this.buckets.length);
    }

    void cleanQueue() {
        Reference reference = this.queue.poll();
        while (reference != null) {
            this.internalRemove((WeakBucket)reference);
            reference = this.queue.poll();
        }
    }

    private void rehash() {
        WeakBucket[] weakBucketArray = this.buckets;
        int n = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)n * this.loadFactor);
        this.buckets = new WeakBucket[n];
        for (int i = 0; i < weakBucketArray.length; ++i) {
            WeakBucket weakBucket = weakBucketArray[i];
            while (weakBucket != null) {
                WeakBucket weakBucket2 = weakBucket.next;
                Object object = weakBucket.get();
                if (object == null) {
                    weakBucket.slot = -1;
                    --this.size;
                } else {
                    int n2;
                    weakBucket.slot = n2 = this.hash(object);
                    weakBucket.next = this.buckets[n2];
                    this.buckets[n2] = weakBucket;
                }
                weakBucket = weakBucket2;
            }
        }
    }

    private WeakBucket.WeakEntry internalGet(Object object) {
        if (object == null) {
            object = NULL_KEY;
        }
        int n = this.hash(object);
        WeakBucket weakBucket = this.buckets[n];
        while (weakBucket != null) {
            WeakBucket.WeakEntry weakEntry = weakBucket.getEntry();
            if (weakEntry != null && AbstractMap.equals(object, weakEntry.key)) {
                return weakEntry;
            }
            weakBucket = weakBucket.next;
        }
        return null;
    }

    private void internalAdd(Object object, Object object2) {
        if (object == null) {
            object = NULL_KEY;
        }
        int n = this.hash(object);
        WeakBucket weakBucket = new WeakBucket(object, this.queue, object2, n);
        weakBucket.next = this.buckets[n];
        this.buckets[n] = weakBucket;
        ++this.size;
    }

    void internalRemove(WeakBucket weakBucket) {
        int n = weakBucket.slot;
        if (n == -1) {
            return;
        }
        weakBucket.slot = -1;
        WeakBucket weakBucket2 = null;
        WeakBucket weakBucket3 = this.buckets[n];
        while (weakBucket3 != weakBucket) {
            if (weakBucket3 == null) {
                throw new InternalError("WeakHashMap in incosistent state");
            }
            weakBucket2 = weakBucket3;
            weakBucket3 = weakBucket2.next;
        }
        if (weakBucket2 == null) {
            this.buckets[n] = weakBucket.next;
        } else {
            weakBucket2.next = weakBucket.next;
        }
        --this.size;
    }

    public int size() {
        this.cleanQueue();
        return this.size;
    }

    public boolean isEmpty() {
        this.cleanQueue();
        return this.size == 0;
    }

    public boolean containsKey(Object object) {
        this.cleanQueue();
        return this.internalGet(object) != null;
    }

    public Object get(Object object) {
        this.cleanQueue();
        WeakBucket.WeakEntry weakEntry = this.internalGet(object);
        if (weakEntry == null) {
            return null;
        }
        return weakEntry.getValue();
    }

    public Object put(Object object, Object object2) {
        this.cleanQueue();
        WeakBucket.WeakEntry weakEntry = this.internalGet(object);
        if (weakEntry != null) {
            return weakEntry.setValue(object2);
        }
        ++this.modCount;
        if (this.size >= this.threshold) {
            this.rehash();
        }
        this.internalAdd(object, object2);
        return null;
    }

    public Object remove(Object object) {
        this.cleanQueue();
        WeakBucket.WeakEntry weakEntry = this.internalGet(object);
        if (weakEntry == null) {
            return null;
        }
        ++this.modCount;
        this.internalRemove(weakEntry.getBucket());
        return weakEntry.getValue();
    }

    public Set entrySet() {
        this.cleanQueue();
        return this.theEntrySet;
    }

    public void clear() {
        super.clear();
    }

    public boolean containsValue(Object object) {
        this.cleanQueue();
        return super.containsValue(object);
    }

    public Set keySet() {
        this.cleanQueue();
        return super.keySet();
    }

    public void putAll(Map map) {
        super.putAll(map);
    }

    public Collection values() {
        this.cleanQueue();
        return super.values();
    }

    private static class WeakBucket
    extends WeakReference {
        Object value;
        WeakBucket next;
        int slot;

        public WeakBucket(Object object, ReferenceQueue referenceQueue, Object object2, int n) {
            super(object, referenceQueue);
            this.value = object2;
            this.slot = n;
        }

        WeakEntry getEntry() {
            Object object = this.get();
            if (object == null) {
                return null;
            }
            return new WeakEntry(this, object);
        }

        class WeakEntry
        implements Map.Entry {
            private /* synthetic */ WeakBucket this$1;
            Object key;

            public WeakEntry(WeakBucket weakBucket, Object object) {
                this.this$1 = weakBucket;
                this.key = object;
            }

            public WeakBucket getBucket() {
                return this.this$1;
            }

            public Object getKey() {
                if (this.key == NULL_KEY) {
                    return null;
                }
                return this.key;
            }

            public Object getValue() {
                return this.this$1.value;
            }

            public Object setValue(Object object) {
                Object object2 = this.this$1.value;
                this.this$1.value = object;
                return object2;
            }

            public int hashCode() {
                return this.key.hashCode() ^ AbstractMap.hashCode(this.this$1.value);
            }

            public boolean equals(Object object) {
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    return AbstractMap.equals(this.getKey(), entry.getKey()) && AbstractMap.equals(this.this$1.value, entry.getValue());
                }
                return false;
            }

            public String toString() {
                return this.getKey() + "=" + this.this$1.value;
            }
        }
    }

    private final class WeakEntrySet
    extends AbstractSet {
        private /* synthetic */ WeakHashMap this$0;

        static /* synthetic */ WeakHashMap access$1(WeakEntrySet weakEntrySet, WeakHashMap weakHashMap) {
            weakEntrySet.this$0 = weakHashMap;
            return weakEntrySet.this$0;
        }

        static WeakHashMap access$0(WeakEntrySet weakEntrySet) {
            return weakEntrySet.this$0;
        }

        WeakEntrySet(WeakHashMap weakHashMap) {
            this.this$0 = weakHashMap;
        }

        public int size() {
            return this.this$0.size;
        }

        public Iterator iterator() {
            return new Iterator(this){
                private /* synthetic */ WeakEntrySet this$1;
                WeakBucket.WeakEntry lastEntry;
                WeakBucket.WeakEntry nextEntry;
                int knownMod;
                {
                    this.this$1 = weakEntrySet;
                    this.finit$();
                }

                private /* synthetic */ void finit$() {
                    this.nextEntry = this.findNext(null);
                    this.knownMod = WeakEntrySet.access$0((WeakEntrySet)this.this$1).modCount;
                }

                private void checkMod() {
                    this.this$1.this$0.cleanQueue();
                    if (this.knownMod != WeakEntrySet.access$0((WeakEntrySet)this.this$1).modCount) {
                        throw new ConcurrentModificationException(this.knownMod + " != " + WeakEntrySet.access$0((WeakEntrySet)this.this$1).modCount);
                    }
                }

                private WeakBucket.WeakEntry findNext(WeakBucket.WeakEntry weakEntry) {
                    int n;
                    WeakBucket weakBucket;
                    if (weakEntry != null) {
                        weakBucket = weakEntry.getBucket().next;
                        n = weakEntry.getBucket().slot;
                    } else {
                        weakBucket = WeakEntrySet.access$0((WeakEntrySet)this.this$1).buckets[0];
                        n = 0;
                    }
                    while (true) {
                        if (weakBucket != null) {
                            WeakBucket.WeakEntry weakEntry2 = weakBucket.getEntry();
                            if (weakEntry2 != null) {
                                return weakEntry2;
                            }
                            weakBucket = weakBucket.next;
                            continue;
                        }
                        if (++n == WeakEntrySet.access$0((WeakEntrySet)this.this$1).buckets.length) {
                            return null;
                        }
                        weakBucket = WeakEntrySet.access$0((WeakEntrySet)this.this$1).buckets[n];
                    }
                }

                public boolean hasNext() {
                    return this.nextEntry != null;
                }

                public Object next() {
                    this.checkMod();
                    if (this.nextEntry == null) {
                        throw new NoSuchElementException();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.findNext(this.lastEntry);
                    return this.lastEntry;
                }

                public void remove() {
                    this.checkMod();
                    if (this.lastEntry == null) {
                        throw new IllegalStateException();
                    }
                    ++WeakEntrySet.access$0((WeakEntrySet)this.this$1).modCount;
                    this.this$1.this$0.internalRemove(this.lastEntry.getBucket());
                    this.lastEntry = null;
                    ++this.knownMod;
                }
            };
        }
    }
}

