/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;

public class UIDefaults
extends Hashtable {
    private LinkedList bundles = new LinkedList();
    private Locale defaultLocale = Locale.getDefault();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private static final long serialVersionUID = 7341222528856548117L;

    public UIDefaults() {
    }

    public UIDefaults(Object[] objectArray) {
        this();
        int n = 0;
        while (2 * n + 1 < objectArray.length) {
            this.put(objectArray[2 * n], objectArray[2 * n + 1]);
            ++n;
        }
    }

    public Object get(Object object) {
        return this.get(object, this.getDefaultLocale());
    }

    public Object get(Object object, Locale locale) {
        Object object2;
        Object object3 = null;
        if (super.containsKey(object)) {
            object3 = super.get(object);
        } else if (object instanceof String) {
            object2 = (String)object;
            ListIterator listIterator = this.bundles.listIterator(0);
            while (listIterator.hasNext()) {
                String string = (String)listIterator.next();
                ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
                if (resourceBundle == null) continue;
                try {
                    object3 = resourceBundle.getObject((String)object2);
                    break;
                }
                catch (MissingResourceException missingResourceException) {
                }
            }
        }
        if (object3 == null) {
            return null;
        }
        if (object3 instanceof LazyValue) {
            object2 = ((LazyValue)object3).createValue(this);
            super.remove(object);
            super.put(object, object2);
            return object2;
        }
        if (object3 instanceof ActiveValue) {
            return ((ActiveValue)object3).createValue(this);
        }
        return object3;
    }

    public Object put(Object object, Object object2) {
        Object object3 = this.checkAndPut(object, object2);
        if (object instanceof String && object3 != object2) {
            this.firePropertyChange((String)object, object3, object2);
        }
        return object3;
    }

    public void putDefaults(Object[] objectArray) {
        int n = 0;
        while (2 * n + 1 < objectArray.length) {
            this.checkAndPut(objectArray[2 * n], objectArray[2 * n + 1]);
            ++n;
        }
        this.firePropertyChange("UIDefaults", null, null);
    }

    private Object checkAndPut(Object object, Object object2) {
        Object object3 = object2 != null ? super.put(object, object2) : super.remove(object);
        return object3;
    }

    public Font getFont(Object object) {
        Object object2 = this.get(object);
        if (object2 instanceof Font) {
            return (Font)object2;
        }
        return null;
    }

    public Font getFont(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        if (object2 instanceof Font) {
            return (Font)object2;
        }
        return null;
    }

    public Color getColor(Object object) {
        Object object2 = this.get(object);
        if (object2 instanceof Color) {
            return (Color)object2;
        }
        return null;
    }

    public Color getColor(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        if (object2 instanceof Color) {
            return (Color)object2;
        }
        return null;
    }

    public Icon getIcon(Object object) {
        Object object2 = this.get(object);
        if (object2 instanceof Icon) {
            return (Icon)object2;
        }
        return null;
    }

    public Icon getIcon(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        if (object2 instanceof Icon) {
            return (Icon)object2;
        }
        return null;
    }

    public Border getBorder(Object object) {
        Object object2 = this.get(object);
        if (object2 instanceof Border) {
            return (Border)object2;
        }
        return null;
    }

    public Border getBorder(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        if (object2 instanceof Border) {
            return (Border)object2;
        }
        return null;
    }

    public String getString(Object object) {
        Object object2 = this.get(object);
        if (object2 instanceof String) {
            return (String)object2;
        }
        return null;
    }

    public String getString(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        if (object2 instanceof String) {
            return (String)object2;
        }
        return null;
    }

    public int getInt(Object object) {
        Object object2 = this.get(object);
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        return 0;
    }

    public int getInt(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        return 0;
    }

    public boolean getBoolean(Object object) {
        return Boolean.TRUE.equals(this.get(object));
    }

    public boolean getBoolean(Object object, Locale locale) {
        return Boolean.TRUE.equals(this.get(object, locale));
    }

    public Insets getInsets(Object object) {
        Object object2 = this.get(object);
        if (object2 instanceof Insets) {
            return (Insets)object2;
        }
        return null;
    }

    public Insets getInsets(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        if (object2 instanceof Insets) {
            return (Insets)object2;
        }
        return null;
    }

    public Dimension getDimension(Object object) {
        Object object2 = this.get(object);
        if (object2 instanceof Dimension) {
            return (Dimension)object2;
        }
        return null;
    }

    public Dimension getDimension(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        if (object2 instanceof Dimension) {
            return (Dimension)object2;
        }
        return null;
    }

    public Class getUIClass(String string, ClassLoader classLoader) {
        String string2 = (String)this.get(string);
        if (string2 == null) {
            return null;
        }
        try {
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            return classLoader.loadClass(string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Class getUIClass(String string) {
        return this.getUIClass(string, null);
    }

    protected void getUIError(String string) {
        System.err.println("UIDefaults.getUIError: " + string);
    }

    public ComponentUI getUI(JComponent jComponent) {
        Method method;
        String string = jComponent.getUIClassID();
        Class clazz = this.getUIClass(string);
        if (clazz == null) {
            this.getUIError("failed to locate UI class:" + string);
            return null;
        }
        try {
            method = clazz.getMethod("createUI", new Class[]{UIDefaults.class$("javax.swing.JComponent")});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.getUIError("failed to locate createUI method on " + clazz.toString());
            return null;
        }
        try {
            return (ComponentUI)method.invoke(null, new Object[]{jComponent});
        }
        catch (InvocationTargetException invocationTargetException) {
            this.getUIError("InvocationTargetException (" + invocationTargetException.getTargetException() + ") calling createUI(...) on " + clazz.toString());
            return null;
        }
        catch (Exception exception) {
            this.getUIError("exception calling createUI(...) on " + clazz.toString());
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    public void addResourceBundle(String string) {
        this.bundles.addFirst(string);
    }

    public void removeResourceBundle(String string) {
        this.bundles.remove(string);
    }

    public void setDefaultLocale(Locale locale) {
        this.defaultLocale = locale;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public static class ProxyLazyValue
    implements LazyValue {
        LazyValue inner;

        public ProxyLazyValue(String string) {
            String string2 = string;
            this.inner = new LazyValue(this, string2){
                private /* synthetic */ ProxyLazyValue this$1;
                private /* synthetic */ String val$className;
                {
                    this.this$1 = proxyLazyValue;
                    this.finit$(string);
                }

                private /* synthetic */ void finit$(String string) {
                    this.val$className = string;
                }

                public Object createValue(UIDefaults uIDefaults) {
                    try {
                        return Class.forName(this.val$className).getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            };
        }

        public ProxyLazyValue(String string, String string2) {
            String string3 = string;
            String string4 = string2;
            this.inner = new LazyValue(this, string4, string3){
                private /* synthetic */ ProxyLazyValue this$1;
                private /* synthetic */ String val$methodName;
                private /* synthetic */ String val$className;
                {
                    this.this$1 = proxyLazyValue;
                    this.finit$(string, string2);
                }

                private /* synthetic */ void finit$(String string, String string2) {
                    this.val$className = string2;
                    this.val$methodName = string;
                }

                public Object createValue(UIDefaults uIDefaults) {
                    try {
                        return Class.forName(this.val$className).getMethod(this.val$methodName, new Class[0]).invoke(null, new Object[0]);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            };
        }

        public ProxyLazyValue(String string, Object[] objectArray) {
            String string2 = string;
            Object[] objectArray2 = objectArray;
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = objectArray2[i].getClass();
            }
            this.inner = new LazyValue(this, classArray, objectArray2, string2){
                private /* synthetic */ ProxyLazyValue this$1;
                private /* synthetic */ Class[] val$clss;
                private /* synthetic */ Object[] val$objs;
                private /* synthetic */ String val$className;
                {
                    this.this$1 = proxyLazyValue;
                    this.finit$(classArray, objectArray, string);
                }

                private /* synthetic */ void finit$(Class[] classArray, Object[] objectArray, String string) {
                    this.val$className = string;
                    this.val$objs = objectArray;
                    this.val$clss = classArray;
                }

                public Object createValue(UIDefaults uIDefaults) {
                    try {
                        return Class.forName(this.val$className).getConstructor(this.val$clss).newInstance(this.val$objs);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            };
        }

        public ProxyLazyValue(String string, String string2, Object[] objectArray) {
            String string3 = string;
            String string4 = string2;
            Object[] objectArray2 = objectArray;
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = objectArray2[i].getClass();
            }
            this.inner = new LazyValue(this, classArray, objectArray2, string4, string3){
                private /* synthetic */ ProxyLazyValue this$1;
                private /* synthetic */ Class[] val$clss;
                private /* synthetic */ Object[] val$objs;
                private /* synthetic */ String val$methodName;
                private /* synthetic */ String val$className;
                {
                    this.this$1 = proxyLazyValue;
                    this.finit$(classArray, objectArray, string, string2);
                }

                private /* synthetic */ void finit$(Class[] classArray, Object[] objectArray, String string, String string2) {
                    this.val$className = string2;
                    this.val$methodName = string;
                    this.val$objs = objectArray;
                    this.val$clss = classArray;
                }

                public Object createValue(UIDefaults uIDefaults) {
                    try {
                        return Class.forName(this.val$className).getMethod(this.val$methodName, this.val$clss).invoke(null, this.val$objs);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            };
        }

        public Object createValue(UIDefaults uIDefaults) {
            return this.inner.createValue(uIDefaults);
        }
    }

    public static interface LazyValue {
        public Object createValue(UIDefaults var1);
    }

    public static class LazyInputMap
    implements LazyValue {
        Object[] bind;

        public LazyInputMap(Object[] objectArray) {
            this.bind = objectArray;
        }

        public Object createValue(UIDefaults uIDefaults) {
            InputMapUIResource inputMapUIResource = new InputMapUIResource();
            int n = 0;
            while (2 * n + 1 < this.bind.length) {
                Object object = this.bind[2 * n];
                if (object instanceof KeyStroke) {
                    inputMapUIResource.put((KeyStroke)object, this.bind[2 * n + 1]);
                } else {
                    inputMapUIResource.put(KeyStroke.getKeyStroke((String)object), this.bind[2 * n + 1]);
                }
                ++n;
            }
            return inputMapUIResource;
        }
    }

    public static interface ActiveValue {
        public Object createValue(UIDefaults var1);
    }
}

