/*
 *      project.h - this file is part of Geany, a fast and lightweight IDE
 *
 *      Copyright 2007-2009 Enrico Tröger <enrico(dot)troeger(at)uvena(dot)de>
 *      Copyright 2007-2009 Nick Treleaven <nick(dot)treleaven(at)btinternet(dot)com>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $Id: project.h 3684 2009-04-05 14:14:29Z eht16 $
 */


#ifndef GEANY_PROJECT_H
#define GEANY_PROJECT_H 1

#define GEANY_PROJECT_EXT				"geany"


/** Structure for representing a project. */
typedef struct GeanyProject
{
	gchar *name; 			/**< The name of the project. */
	gchar *description; 	/**< Short description of the project. */
	gchar *file_name; 		/**< Where the project file is stored (in UTF-8). */
	gchar *base_path;		/**< Base path of the project directory (in UTF-8, maybe relative). */
	gchar *run_cmd; 		/**< Project run command (in UTF-8). */
	/** Identifier whether it is a pure Geany project or modified/extended
	 * by a plugin. */
	gint type;
	gchar **file_patterns;	/**< Array of filename extension patterns. */
	gboolean make_in_base_path;

	struct GeanyProjectPrivate	*priv;	/* must be last, append fields before this item */
}
GeanyProject;


typedef struct ProjectPrefs
{
	gchar *session_file;
	gboolean project_session;
	gboolean project_file_in_basedir;
} ProjectPrefs;

extern ProjectPrefs project_prefs;


void project_init(void);

void project_finalize(void);


void project_new(void);

void project_open(void);

void project_close(gboolean open_default);

void project_properties(void);

gboolean project_ask_close(void);


gboolean project_load_file(const gchar *locale_file_name);

gboolean project_load_file_with_session(const gchar *locale_file_name);

gchar *project_get_base_path(void);

gchar *project_get_make_dir(void);


void project_save_prefs(GKeyFile *config);

void project_load_prefs(GKeyFile *config);

void project_setup_prefs(void);

void project_apply_prefs(void);

#endif
