/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimppalette_pdb.h
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#ifndef __GIMP_PALETTE_PDB_H__
#define __GIMP_PALETTE_PDB_H__

G_BEGIN_DECLS

/* For information look into the C source or the html documentation */


gchar*   gimp_palette_new             (const gchar    *name);
gchar*   gimp_palette_duplicate       (const gchar    *name);
gchar*   gimp_palette_rename          (const gchar    *name,
                                       const gchar    *new_name);
gboolean gimp_palette_delete          (const gchar    *name);
gboolean gimp_palette_is_editable     (const gchar    *name);
gboolean gimp_palette_get_info        (const gchar    *name,
                                       gint           *num_colors);
GimpRGB* gimp_palette_get_colors      (const gchar    *name,
                                       gint           *num_colors);
gint     gimp_palette_get_columns     (const gchar    *name);
gboolean gimp_palette_set_columns     (const gchar    *name,
                                       gint            columns);
gboolean gimp_palette_add_entry       (const gchar    *name,
                                       const gchar    *entry_name,
                                       const GimpRGB  *color,
                                       gint           *entry_num);
gboolean gimp_palette_delete_entry    (const gchar    *name,
                                       gint            entry_num);
gboolean gimp_palette_entry_get_color (const gchar    *name,
                                       gint            entry_num,
                                       GimpRGB        *color);
gboolean gimp_palette_entry_set_color (const gchar    *name,
                                       gint            entry_num,
                                       const GimpRGB  *color);
gboolean gimp_palette_entry_get_name  (const gchar    *name,
                                       gint            entry_num,
                                       gchar         **entry_name);
gboolean gimp_palette_entry_set_name  (const gchar    *name,
                                       gint            entry_num,
                                       const gchar    *entry_name);


G_END_DECLS

#endif /* __GIMP_PALETTE_PDB_H__ */
