/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.utils.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.jgraph.utils.gui.GPFrame;
import org.jgraph.utils.gui.GPInternalFrame;
import org.jgraph.utils.gui.GPSplitPane;
import org.jgraph.utils.gui.PosComponentListener;
import org.jgraph.utils.gui.PosPropertyChangeListener;

public class PositionManager {
    protected static final String FRAME_WIDTH = ".FrameWidth";
    protected static final String FRAME_HEIGHT = ".FrameHeight";
    protected static final String FRAME_STATE = ".FrameState";
    protected static final String FRAME_X = ".FrameX";
    protected static final String FRAME_Y = ".FrameY";
    protected static final String DIVIDER_LOCATION = ".DividerLocation";
    protected static Vector containers = new Vector();
    protected static PosComponentListener posComponentListener = new PosComponentListener();
    protected static PosPropertyChangeListener posPropertyChangeListener = new PosPropertyChangeListener();
    static /* synthetic */ Class class$org$jgraph$utils$gui$PositionManager;

    public static void addComponent(Component component) {
        if (component == null) {
            return;
        }
        if (component instanceof JSplitPane) {
            JSplitPane jSplitPane = (JSplitPane)component;
            PositionManager.updateComponent(component);
            jSplitPane.addPropertyChangeListener("dividerLocation", posPropertyChangeListener);
        } else if (component instanceof JInternalFrame || component instanceof Window) {
            PositionManager.updateComponent(component);
            component.addComponentListener(posComponentListener);
        } else {
            throw new IllegalArgumentException("We have no position storage implementation for " + component.getClass());
        }
    }

    public static void updateComponent(Component component) {
        if (component == null) {
            return;
        }
        if (component instanceof JSplitPane) {
            JSplitPane jSplitPane = (JSplitPane)component;
            int n = PositionManager.getIntPos(jSplitPane, DIVIDER_LOCATION, -1);
            if (n == -1) {
                jSplitPane.setDividerLocation(100);
            } else {
                jSplitPane.setDividerLocation(n);
            }
        } else if (component instanceof JInternalFrame || component instanceof Window) {
            Cloneable cloneable;
            int n = PositionManager.getIntPos(component, FRAME_X, -1);
            int n2 = PositionManager.getIntPos(component, FRAME_Y, -1);
            int n3 = PositionManager.getIntPos(component, FRAME_WIDTH, -1);
            int n4 = PositionManager.getIntPos(component, FRAME_HEIGHT, -1);
            if (n == -1 || n2 == -1 || n3 == -1 || n4 == -1) {
                JInternalFrame jInternalFrame;
                Container container;
                cloneable = component instanceof JInternalFrame ? ((container = (jInternalFrame = (JInternalFrame)component).getParent()) == null || container.getSize().width == 0 && container.getSize().height == 0 ? new Dimension(600, 400) : container.getSize()) : component.getToolkit().getScreenSize();
                int n5 = cloneable.height;
                int n6 = cloneable.width;
                n4 = (int)((double)n5 * 0.66);
                n3 = (int)((double)n6 * 0.66);
                n = (int)((double)(n5 - n4) / 2.0);
                n2 = (int)((double)(n6 - n3) / 2.0);
            }
            cloneable = new Rectangle(n, n2, n3, n4);
            component.setBounds((Rectangle)cloneable);
            if (component instanceof JComponent) {
                ((JComponent)component).setPreferredSize(new Dimension(n3, n4));
                ((JComponent)component).setSize(new Dimension(n3, n4));
            }
        } else {
            throw new IllegalArgumentException("We have no position storage implementation for " + component.getClass());
        }
    }

    public static void removeComponent(Component component) {
        if (component == null) {
            return;
        }
        if (component instanceof JSplitPane) {
            JSplitPane jSplitPane = (JSplitPane)component;
            jSplitPane.removePropertyChangeListener("dividerLocation", posPropertyChangeListener);
        } else if (component instanceof JInternalFrame || component instanceof Window) {
            component.removeComponentListener(posComponentListener);
        } else {
            throw new IllegalArgumentException("We have no position storage implementation for " + component.getClass());
        }
    }

    public static void setIntPos(Component component, String string, int n) {
        Preferences preferences = PositionManager.getPreferences();
        preferences.putInt(PositionManager.getKey(component) + string, n);
    }

    public static String getKey(Component component) {
        String string = component.getClass().getName();
        if (component.getName() != null) {
            string = string + "." + component.getName();
        }
        return string;
    }

    public static Preferences getPreferences() {
        return Preferences.userNodeForPackage(class$org$jgraph$utils$gui$PositionManager == null ? (class$org$jgraph$utils$gui$PositionManager = PositionManager.class$("org.jgraph.utils.gui.PositionManager")) : class$org$jgraph$utils$gui$PositionManager).node("positions");
    }

    public static int getIntPos(Component component, String string, int n) {
        Preferences preferences = PositionManager.getPreferences();
        return preferences.getInt(PositionManager.getKey(component) + string, n);
    }

    public static void main(String[] stringArray) {
        GPFrame gPFrame = new GPFrame();
        gPFrame.setName("myFrame");
        JDesktopPane jDesktopPane = new JDesktopPane();
        gPFrame.getContentPane().add(jDesktopPane);
        GPInternalFrame gPInternalFrame = new GPInternalFrame();
        gPInternalFrame.setClosable(true);
        gPInternalFrame.setResizable(true);
        gPInternalFrame.setVisible(true);
        jDesktopPane.add(gPInternalFrame);
        JPanel jPanel = new JPanel(new BorderLayout());
        gPInternalFrame.getContentPane().add(jPanel);
        GPSplitPane gPSplitPane = new GPSplitPane(0, new JPanel(), new JPanel());
        gPSplitPane.setName("MyName");
        gPSplitPane.setSize(400, 400);
        jPanel.add((Component)gPSplitPane, "Center");
        JButton jButton = new JButton();
        jButton.setName("Ok");
        jPanel.add((Component)jButton, "South");
        gPFrame.setVisible(true);
        gPFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PositionManager.removeComponent((JFrame)windowEvent.getSource());
                System.exit(0);
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

