/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons."
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

/* 
 * flexible wrapper for textpart alternatives
 */

#ifndef VMIME_MAPITEXTPART_HPP_INCLUDED
#define VMIME_MAPITEXTPART_HPP_INCLUDED


#include "vmime/textPart.hpp"
#include "vmime/messageId.hpp"
#include "vmime/encoding.hpp"

#include "vmime/contentHandler.hpp"


namespace vmime
{


/** Text part of type 'text/html'.
  */

class mapiTextPart : public textPart
{
protected:

	~mapiTextPart();

public:

	mapiTextPart();

	const mediaType getType() const;

	const charset& getCharset() const;
	void setCharset(const charset& ch);

	/* plain text */
	const contentHandler& getPlainText() const;
	void setPlainText(const contentHandler& plainText);

	/* 'other' text */
	const contentHandler& getOtherText() const;
	void setOtherText(const contentHandler& otherText);
	/* extra 'other' properties */
	void setOtherContentType(const mediaType& type);
	void setOtherContentEncoding(const encoding& enc);
	void setOtherMethod(const string& method);
	void setOtherCharset(const charset& ch);

	/* html + plain + 'other' text */
	const contentHandler& getText() const;
	void setText(const contentHandler& text);

	/** Embedded object (eg: image for &lt;IMG> tag).
	  */
	class embeddedObject
	{
	public:

		embeddedObject(const contentHandler& data, const encoding& enc,
		               const string& id, const mediaType& type, const string& name);

        ~embeddedObject();
        
		/** Return data stored in this embedded object.
		  *
		  * @return stored data
		  */
		const contentHandler& getData() const;

		/** Return the encoding used for data in this
		  * embedded object.
		  *
		  * @return data encoding
		  */
		const vmime::encoding& getEncoding() const;

		/** Return the identifier of this embedded object.
		  *
		  * @return object identifier
		  */
		const string& getId() const;

		/** Return the content type of data stored in
		  * this embedded object.
		  *
		  * @return data type
		  */
		const mediaType& getType() const;

		/** Return the object name of this embedded object, if any
		  *
		  * @return object name
		  */
		const string& getName() const;

	private:

		contentHandler* m_data;
		encoding m_encoding;
		string m_id;
		mediaType m_type;
		string m_name;
	};


	/** Test the existence of an embedded object given its identifier.
	  *
	  * @param id object identifier
	  * @return true if an object with this identifier exists,
	  * false otherwise
	  */
	const bool hasObject(const string& id) const;

	/** Return the embedded object with the specified identifier.
	  *
	  * @throw exceptions::no_object_found() if no object has been found
	  * @param id object identifier
	  * @return embedded object with the specified identifier
	  */
	const embeddedObject* findObject(const string& id) const;

	/** Return the number of embedded objects.
	  *
	  * @return number of embedded objects
	  */
	const int getObjectCount() const;

	/** Return the embedded object at the specified position.
	  *
	  * @param pos position of the embedded object
	  * @return embedded object at position 'pos'
	  */
	const embeddedObject* getObjectAt(const int pos) const;

	/** Embed an object and returns a string which identifies it.
	  *
	  * \deprecated Use the addObject() methods which take a 'contentHandler'
	  * parameter type instead.
	  *
	  * @param data object data
	  * @param type data type
	  * @return an unique object identifier used to identify the new
	  * object among all other embedded objects
	  */
	const string addObject(const string& data, const mediaType& type);

	/** Embed an object and returns a string which identifies it.
	  *
	  * @param data object data
	  * @param type data type
	  * @return an unique object identifier used to identify the new
	  * object among all other embedded objects
	  */
	const string addObject(const contentHandler& data, const mediaType& type);

	/** Embed an object and returns a string which identifies it.
	  *
	  * @param data object data
	  * @param enc data encoding
	  * @param type data type
	  * @return an unique object identifier used to identify the new
	  * object among all other embedded objects
	  */
	const string addObject(const contentHandler& data, const encoding& enc, const mediaType& type);

	/** Embed an object and returns a string which identifies it.
	 *
	 * @param data object data
	 * @param enc data encoding
	 * @param type data type
	 * @param id unique object identifier
	 * @param name filename of attachment
	 * @return an unique object identifier used to identify the new
	 * object among all other embedded objects
	 */
	const string addObject(const contentHandler& data, const encoding& enc, const mediaType& type, const string& id, const string& name = string());

private:

	contentHandler* m_plainText;
	contentHandler* m_text;		/* htmlText */

	charset m_charset;

	contentHandler* m_otherText;
	mediaType m_otherMediaType;
	encoding m_otherEncoding;
	string m_otherMethod;		/* ical special */
	charset m_otherCharset;
	bool m_bHaveOtherCharset;

	std::vector <embeddedObject*> m_objects;

	void findEmbeddedParts(const bodyPart& part, std::vector <const bodyPart*>& cidParts, std::vector <const bodyPart*>& locParts);
	void addEmbeddedObject(const bodyPart& part, const string& id);

	bool findPlainTextPart(const bodyPart& part, const bodyPart& parent, const bodyPart& textPart);

	const int getPartCount() const;

	void generateIn(bodyPart& message, bodyPart& parent) const;
	void parse(const bodyPart& message, const bodyPart& parent, const bodyPart& textPart);
};


} // vmime


#endif // VMIME_HTMLTEXTPART_HPP_INCLUDED
