# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

"""
Ticker is an object used to synchronize the update of Animations. Ticker
maintains a list of animations that are updated each time the tick() method
is called.
"""

import time

class Ticker(object):
    """
    """

    def __init__(self):
        self._animations = []

    # Public methods

    def tick(self):
        """
        Call the update method of all the animations associated to the ticker.
        """
        update_time = long(time.time() * 1000)
#        print '=============== TICK ================'
#        print 'updating', len(self._animations), 'animations'
        for animation in self._animations:
            animation.update(update_time)

    def get_animations(self):
        """
        Retrieve the animation list associated to the ticker.
        """
        return self._animations

    # Protected methods

    def add_animation(self, animation):
        """
        Add a new animation to the ticker.
        """
        self._animations.append(animation)

    def remove_animation(self, animation):
        """
        Remove a animation from the ticker.
        """
        self._animations.remove(animation)
